/*
 * Decompiled with CFR 0.152.
 */
package jlhh.anim;

import java.io.DataInputStream;
import javax.microedition.lcdui.Image;
import jlhh.anim.MSpriteData;
import jlhh.anim.MSpriteImageLoader;

public class MSpriteLoader {
    public static MSpriteData loadMSprite(String spriteName, boolean splitImageClips, MSpriteImageLoader imageloader) throws Exception {
        short[] positionerRectangleClipPool;
        int[] roundedRectangleClipPool;
        int[] rectangleClipPool;
        int[] lineClipPool;
        int[] ellipseClipPool;
        short[] imageIndex;
        short[] imageClipPool;
        short[] frameTableIndex;
        short[] framePoolTable;
        short[] frameTable;
        short[] animationTable;
        if (imageloader == null) {
            throw new IllegalArgumentException("Image Loader cannot be null");
        }
        MSpriteData data = new MSpriteData(splitImageClips);
        DataInputStream dstrm = new DataInputStream(new String().getClass().getResourceAsStream(spriteName));
        try {
            try {
                dstrm.readShort();
                dstrm.readUTF();
                int noOfAnimation = dstrm.readByte();
                animationTable = new short[noOfAnimation << 1];
                int i = 0;
                while (i < noOfAnimation) {
                    animationTable[2 * i] = dstrm.readShort();
                    animationTable[2 * i + 1] = dstrm.readShort();
                    ++i;
                }
                int totalNoOfFrame = dstrm.readShort();
                frameTable = new short[totalNoOfFrame * 4];
                int i2 = 0;
                while (i2 < totalNoOfFrame) {
                    frameTable[4 * i2] = dstrm.readShort();
                    frameTable[4 * i2 + 1] = dstrm.readByte();
                    frameTable[4 * i2 + 2] = dstrm.readShort();
                    frameTable[4 * i2 + 3] = dstrm.readShort();
                    ++i2;
                }
                short length = dstrm.readShort();
                int totalNumberOfClips = length >> 2;
                framePoolTable = new short[length];
                int noOfFrameInPool = dstrm.readShort();
                short index = 0;
                frameTableIndex = new short[noOfFrameInPool << 1];
                int i3 = 0;
                while (i3 < noOfFrameInPool) {
                    frameTableIndex[2 * i3] = index;
                    int noOfClips = dstrm.readShort();
                    int j = 0;
                    while (j < noOfClips) {
                        short s = index;
                        index = (short)(s + 1);
                        framePoolTable[s] = dstrm.readShort();
                        short s2 = index;
                        index = (short)(s2 + 1);
                        framePoolTable[s2] = dstrm.readShort();
                        short s3 = index;
                        index = (short)(s3 + 1);
                        framePoolTable[s3] = dstrm.readShort();
                        short s4 = index;
                        index = (short)(s4 + 1);
                        framePoolTable[s4] = dstrm.readByte();
                        ++j;
                    }
                    frameTableIndex[2 * i3 + 1] = (short)(index - 1);
                    ++i3;
                }
                short noOfImagesClips = dstrm.readShort();
                int noOfImages = dstrm.readByte();
                imageClipPool = new short[noOfImagesClips << 2];
                index = 0;
                imageIndex = new short[noOfImages];
                short noOfClipsRead = 0;
                int i4 = 0;
                while (i4 < noOfImages) {
                    imageIndex[i4] = noOfClipsRead;
                    int noOfClipsInThisImage = dstrm.readShort();
                    Image[][] imageArrayForClips = new Image[noOfClipsInThisImage][];
                    int j = 0;
                    while (j < noOfClipsInThisImage) {
                        short s = index;
                        index = (short)(s + 1);
                        short s5 = dstrm.readShort();
                        imageClipPool[s] = s5;
                        short x = s5;
                        short s6 = index;
                        index = (short)(s6 + 1);
                        short s7 = dstrm.readShort();
                        imageClipPool[s6] = s7;
                        short y = s7;
                        short s8 = index;
                        index = (short)(s8 + 1);
                        short s9 = dstrm.readShort();
                        imageClipPool[s8] = s9;
                        short w = s9;
                        short s10 = index;
                        index = (short)(s10 + 1);
                        short s11 = dstrm.readShort();
                        imageClipPool[s10] = s11;
                        short h2 = s11;
                        if (splitImageClips) {
                            byte orientationUsedInStudio = 0;
                            int k = 0;
                            while (k < totalNumberOfClips) {
                                int pos = k << 2;
                                int clipIndex = framePoolTable[pos];
                                short flag = framePoolTable[pos + 3];
                                byte imageId = (byte)((flag & 0xF8) >> 3);
                                if ((clipIndex -= imageIndex[imageId]) == j && (flag & 1) == 0 && imageId == i4) {
                                    orientationUsedInStudio = (byte)(orientationUsedInStudio | (byte)(flag & 7));
                                }
                                ++k;
                            }
                            imageArrayForClips[j] = imageloader.loadImageClip(spriteName, i4, x, y, w, h2);
                        }
                        ++j;
                    }
                    noOfClipsRead = (short)(noOfClipsRead + noOfClipsInThisImage);
                    if (splitImageClips) {
                        data.imageVector.addElement(imageArrayForClips);
                    } else {
                        int orientationUsedInStudio = 0;
                        int k = 0;
                        while (k < totalNumberOfClips) {
                            short flag = framePoolTable[(k << 2) + 3];
                            byte imageId = (byte)((flag & 0xF8) >> 3);
                            if ((flag & 1) == 0 && imageId == i4) {
                                orientationUsedInStudio = (byte)(orientationUsedInStudio | (byte)(flag & 7));
                            }
                            ++k;
                        }
                        Image a = imageloader.loadImage(spriteName, i4, (byte)(orientationUsedInStudio >> 1));
                        data.imageVector.addElement(a);
                    }
                    ++i4;
                }
                int noOfEllipseClip = dstrm.readShort();
                ellipseClipPool = new int[noOfEllipseClip * 5];
                int i5 = 0;
                while (i5 < noOfEllipseClip) {
                    ellipseClipPool[5 * i5] = dstrm.readShort();
                    ellipseClipPool[5 * i5 + 1] = dstrm.readShort();
                    ellipseClipPool[5 * i5 + 2] = dstrm.readShort();
                    ellipseClipPool[5 * i5 + 3] = dstrm.readShort();
                    ellipseClipPool[5 * i5 + 4] = dstrm.readInt();
                    ++i5;
                }
                int noOfLineClip = dstrm.readShort();
                lineClipPool = new int[noOfLineClip * 3];
                int i6 = 0;
                while (i6 < noOfLineClip) {
                    lineClipPool[3 * i6] = dstrm.readShort();
                    lineClipPool[3 * i6 + 1] = dstrm.readShort();
                    lineClipPool[3 * i6 + 2] = dstrm.readInt();
                    ++i6;
                }
                int noOfRectangleClip = dstrm.readShort();
                rectangleClipPool = new int[noOfRectangleClip * 3];
                int i7 = 0;
                while (i7 < noOfRectangleClip) {
                    rectangleClipPool[3 * i7] = dstrm.readShort();
                    rectangleClipPool[3 * i7 + 1] = dstrm.readShort();
                    rectangleClipPool[3 * i7 + 2] = dstrm.readInt();
                    ++i7;
                }
                int noOfRoundedRectangleClip = dstrm.readShort();
                roundedRectangleClipPool = new int[noOfRoundedRectangleClip * 5];
                int i8 = 0;
                while (i8 < noOfRoundedRectangleClip) {
                    roundedRectangleClipPool[5 * i8] = dstrm.readShort();
                    roundedRectangleClipPool[5 * i8 + 1] = dstrm.readShort();
                    roundedRectangleClipPool[5 * i8 + 2] = dstrm.readShort();
                    roundedRectangleClipPool[5 * i8 + 3] = dstrm.readShort();
                    roundedRectangleClipPool[5 * i8 + 4] = dstrm.readInt();
                    ++i8;
                }
                int noOfPositionerRectangleClip = dstrm.readShort();
                positionerRectangleClipPool = new short[noOfPositionerRectangleClip << 1];
                int i9 = 0;
                while (i9 < noOfPositionerRectangleClip) {
                    positionerRectangleClipPool[2 * i9] = dstrm.readShort();
                    positionerRectangleClipPool[2 * i9 + 1] = dstrm.readShort();
                    ++i9;
                }
            }
            catch (Exception e) {
                System.out.println("load error on:" + spriteName);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (dstrm != null) {
                dstrm.close();
            }
        }
        data.animationTable = animationTable;
        data.frameTable = frameTable;
        data.frameTableIndex = frameTableIndex;
        data.framePoolTable = framePoolTable;
        data.imageClipPool = imageClipPool;
        data.ellipseClipPool = ellipseClipPool;
        data.lineClipPool = lineClipPool;
        data.rectangleClipPool = rectangleClipPool;
        data.roundedRectangleClipPool = roundedRectangleClipPool;
        data.positionerRectangleClipPool = positionerRectangleClipPool;
        data.imageIndexTable = imageIndex;
        return data;
    }
}

