/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

class THiscore {
    protected String m_Title;
    protected StringBuffer[] m_Names;
    protected String[] S_Names;
    protected int[] m_Scores;
    protected byte[] m_Record;
    protected int m_Entries;
    protected int m_NameLength;
    private boolean isRecordOpened;
    protected boolean isInit;
    protected RecordStore m_HiscoreStore;

    protected int recordLength() {
        return this.m_NameLength + 4;
    }

    protected int tableLength() {
        return this.recordLength() * this.m_Entries;
    }

    protected void OpenHiscores() {
        try {
            this.m_HiscoreStore = RecordStore.openRecordStore((String)this.m_Title, (boolean)true);
            this.isRecordOpened = true;
            System.out.println("open record " + this.m_Title);
        }
        catch (Exception exception) {
            System.out.println("open record " + exception);
        }
    }

    protected void CloseHiscores() {
        try {
            this.m_HiscoreStore.closeRecordStore();
            this.isRecordOpened = false;
            System.out.println("close " + this.m_HiscoreStore.getName());
        }
        catch (Exception exception) {
            System.out.println("close " + exception);
        }
    }

    protected boolean IsEmpty() {
        try {
            return this.m_HiscoreStore.getNumRecords() == 0;
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            System.out.println("isEmp : " + (Object)((Object)recordStoreNotOpenException));
            return false;
        }
    }

    public int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    protected int BytesToInt(byte by, byte by2, byte by3, byte by4) {
        int n = this.unsignedByteToInt(by);
        n |= this.unsignedByteToInt(by2) << 8;
        n |= this.unsignedByteToInt(by3) << 16;
        return n |= this.unsignedByteToInt(by4) << 24;
    }

    protected String ParseName(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8");
            System.out.println("parse name: " + string);
            return string;
        }
        catch (Exception exception) {
            return "error";
        }
    }

    protected int ParseScore(int n) {
        int n2 = n * 4;
        int n3 = this.BytesToInt(this.m_Record[n2], this.m_Record[n2 + 1], this.m_Record[n2 + 2], this.m_Record[n2 + 3]);
        return n3;
    }

    protected void LoadHiscores() {
        try {
            this.m_HiscoreStore.getRecord(1, this.m_Record, 0);
            for (int i = 0; i < this.m_Entries; ++i) {
                this.S_Names[i] = this.ParseName(this.m_HiscoreStore.getRecord(i + 2));
                System.out.println("load name : " + this.S_Names[i]);
                this.m_Scores[i] = this.ParseScore(i);
            }
            this.Close();
            System.out.println("load data :" + this.m_HiscoreStore.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void EncodeName(String string, int n) {
    }

    protected void EncodeScore(int n, int n2) {
        int n3 = n2 * 4;
        this.m_Record[n3] = (byte)(n & 0xFF);
        this.m_Record[n3 + 1] = (byte)(n >> 8 & 0xFF);
        this.m_Record[n3 + 2] = (byte)(n >> 16 & 0xFF);
        this.m_Record[n3 + 3] = (byte)(n >> 24 & 0xFF);
    }

    protected void SaveHiscores() {
        int n;
        for (n = 0; n < this.m_Entries; ++n) {
            this.EncodeName(this.S_Names[n], n);
            this.EncodeScore(this.m_Scores[n], n);
        }
        try {
            if (!this.isRecordOpened) {
                this.OpenHiscores();
            }
            if (this.IsEmpty()) {
                this.m_HiscoreStore.addRecord(this.m_Record, 0, this.m_Record.length);
                for (n = 0; n < this.m_Entries; ++n) {
                    byte[] byArray = this.S_Names[n].getBytes("UTF-8");
                    System.out.println("Save name :" + this.S_Names[n]);
                    System.out.println("Save name :" + n);
                    this.m_HiscoreStore.addRecord(byArray, 0, byArray.length);
                }
                System.out.println("init record--------------------------:" + this.m_HiscoreStore.getName());
                System.out.println("init record=============" + this.m_HiscoreStore.getNumRecords());
            } else {
                this.Close();
                this.deleteTable();
                this.OpenHiscores();
                this.m_HiscoreStore.addRecord(this.m_Record, 0, this.m_Record.length);
                for (n = 0; n < this.m_Entries; ++n) {
                    System.out.println("Set name :" + this.S_Names[n] + ":" + this.m_HiscoreStore.getNumRecords());
                    byte[] byArray = this.S_Names[n].getBytes("UTF-8");
                    this.m_HiscoreStore.addRecord(byArray, 0, byArray.length);
                }
                System.out.println("Set data --------------------------:" + this.m_HiscoreStore.getNumRecords());
                System.out.println("Set name --------------------------:" + this.m_HiscoreStore.getName());
            }
        }
        catch (Exception exception) {
            System.out.println("Save data :" + exception);
        }
    }

    protected String CopyName(String string) {
        return string;
    }

    public String StandStr(String string) {
        int n = this.m_NameLength - string.length();
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        return string;
    }

    public THiscore(String string, int n, int n2) {
        this.m_Title = string;
        this.m_Entries = n;
        this.m_NameLength = n2;
        this.m_Record = new byte[this.tableLength()];
        this.m_Names = new StringBuffer[this.m_Entries];
        this.S_Names = new String[this.m_Entries];
        this.m_Scores = new int[this.m_Entries];
        for (int i = 0; i < this.m_Entries; ++i) {
            this.m_Names[i] = new StringBuffer(this.m_NameLength);
            for (int j = 0; j < this.m_NameLength; ++j) {
                this.m_Names[i].append(' ');
            }
            this.S_Names[i] = "init";
            this.m_Scores[i] = -1;
        }
        this.OpenHiscores();
        if (this.IsEmpty()) {
            this.isInit = false;
            this.SaveHiscores();
        } else {
            this.LoadHiscores();
        }
    }

    public void Add(String string, int n) {
        for (int i = 0; i < this.m_Entries && n > this.m_Scores[i]; ++i) {
            if (i > 0) {
                this.m_Scores[i - 1] = this.m_Scores[i];
                this.S_Names[i - 1] = this.CopyName(this.S_Names[i]);
            }
            this.m_Scores[i] = n;
            this.S_Names[i] = this.CopyName(string);
        }
    }

    public void Reset(String string, int n) {
        for (int i = 0; i < this.m_Entries; ++i) {
            if (i > 0) {
                this.m_Scores[i - 1] = this.m_Scores[i];
                this.S_Names[i - 1] = this.CopyName(this.S_Names[i]);
            }
            this.m_Scores[i] = n;
            this.S_Names[i] = this.CopyName(string);
        }
    }

    public void Close() {
        this.CloseHiscores();
    }

    public int getNameLength() {
        return this.m_NameLength;
    }

    public String getName(int n) {
        return this.S_Names[n];
    }

    public int getScore(int n) {
        return this.m_Scores[n];
    }

    public void deleteTable() {
        this.deleteTable(this.m_Title);
    }

    void deleteTable(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
            System.out.println("delete:" + string);
        }
        catch (RecordStoreException recordStoreException) {
            this.Close();
            System.out.println("delete:" + (Object)((Object)recordStoreException));
        }
    }
}

