/*
 * Decompiled with CFR 0.152.
 */
public class XPng {
    private int color;
    public static final int IMG_NONE = 0;
    public static final int IMG_MIR_V = 1;
    public static final int IMG_MIR_H = 2;
    public static final int IMG_LOT_90 = 3;
    public static final int IMG_LOT_180 = 4;
    public static final int IMG_LOT_270 = 5;
    public static final int IMG_GRAY = 6;
    public static final int IMG_COLOR = 7;
    private int[] table;

    public XPng() {
        this.setTable();
    }

    private void setTable() {
        this.table = new int[256];
        int i1 = 0;
        do {
            int k = i1;
            int j1 = 0;
            do {
                if (k & true) {
                    k = 0xEDB88320 ^ k >>> 1;
                    continue;
                }
                k >>>= 1;
            } while (++j1 < 8);
            this.table[i1] = k;
        } while (++i1 < 256);
    }

    private int get_IntCRC(byte[] data, int start, int num) {
        int rtn = -1;
        for (int l1 = 0; l1 < num; ++l1) {
            rtn = this.table[(rtn ^ data[l1 + start]) & 0xFF] ^ rtn >>> 8;
        }
        return ~rtn;
    }

    public byte[] get_ByteCRC(byte[] data, int start, int num) {
        int value = this.get_IntCRC(data, start, num);
        return this.int2byte(value);
    }

    private byte[] int2byte(int value) {
        byte[] rtn = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return rtn;
    }

    private int byte2int(byte[] value) {
        int rtn = value[0] << 24 & 0xFF000000 | value[1] << 16 & 0xFF0000 | value[2] << 8 & 0xFF00 | value[3] & 0xFF;
        return rtn;
    }

    private int b2i(byte[] ary, int start) {
        return ary[start] << 24 & 0xFF000000 | ary[start + 1] << 16 & 0xFF0000 | ary[start + 2] << 8 & 0xFF00 | ary[start + 3] & 0xFF;
    }

    public byte[] get_Image(byte[] data, int type) {
        if (type == 0) {
            return data;
        }
        switch (type) {
            case 1: 
            case 2: {
                return this.get_ImageMirror(data, type);
            }
            case 3: 
            case 4: 
            case 5: {
                return this.get_Image_Rotate(data, type);
            }
            case 6: {
                return this.get_ImageGray(data);
            }
            case 7: {
                return this.get_ColorImage(data);
            }
        }
        return null;
    }

    public byte[] get_ImageRate(byte[] data, int x_rate, int y_rate) {
        int[] info = this.get_Idat_Info(data);
        int xx = Math.max(1, info[0] * x_rate / 100);
        int yy = Math.max(1, info[1] * y_rate / 100);
        return this.get_ImageSize(info, data, xx, yy);
    }

    public byte[] get_ImageFix(byte[] data, int x, int y) {
        int[] info = this.get_Idat_Info(data);
        return this.get_ImageSize(info, data, x, y);
    }

    private byte[] get_ImageSize(int[] info, byte[] data, int x, int y) {
        if (x <= 0 || y <= 0) {
            return null;
        }
        int[] wid_hei = new int[]{x, y};
        int idat_len = 23 + (wid_hei[0] + 1) * wid_hei[1];
        byte[] rtn = new byte[info[2] + idat_len + 12];
        this.set_IHDR(data, rtn, info, wid_hei, idat_len);
        this.set_Size(data, rtn, info[2] + 15, info, wid_hei);
        this.set_IDAT(data, rtn, info, wid_hei, idat_len);
        return rtn;
    }

    private void set_Size(byte[] input, byte[] output, int start, int[] wh, int[] wh2) {
        int i_in = 0;
        int i_out = 0;
        for (int yy = 0; yy < wh2[1]; ++yy) {
            i_out = start + (wh2[0] + 1) * yy;
            i_in = start + (wh[0] + 1) * (yy * wh[1] / wh2[1]);
            for (int xx = 0; xx < wh2[0]; ++xx) {
                output[1 + i_out + xx] = input[1 + i_in + xx * wh[0] / wh2[0]];
            }
        }
    }

    private byte[] get_Image_Rotate(byte[] data, int type) {
        int[] info = this.get_Idat_Info(data);
        int[] wid_hei = null;
        switch (type) {
            case 3: 
            case 5: {
                wid_hei = new int[]{info[1], info[0]};
                break;
            }
            default: {
                wid_hei = new int[]{info[0], info[1]};
            }
        }
        int idat_len = 23 + (wid_hei[0] + 1) * wid_hei[1];
        byte[] rtn = new byte[info[2] + idat_len + 12];
        this.set_IHDR(data, rtn, info, wid_hei, idat_len);
        this.set_Lotate(data, rtn, info[2] + 15, info, wid_hei, type);
        this.set_IDAT(data, rtn, info, wid_hei, idat_len);
        return rtn;
    }

    private void set_Lotate(byte[] input, byte[] output, int start, int[] info, int[] wh2, int type) {
        int max_o = (info[0] + 1) * info[1];
        switch (type) {
            case 3: 
            case 5: {
                int X = 0;
                X = type == 3 ? start + max_o - info[0] : start + info[0];
                for (int t = info[1]; t < max_o; ++t) {
                    if (t < info[1]) continue;
                    int xcnt = t / info[1] - 1;
                    int ycnt = t % info[1];
                    int index = xcnt - ycnt * (info[0] + 1);
                    output[start + ycnt + 1 + xcnt * (wh2[0] + 1)] = type == 3 ? input[X + index] : input[X - index];
                }
                break;
            }
            case 4: {
                for (int t = 0; t < max_o - 1; ++t) {
                    output[start + max_o - 1 - t] = input[start + 1 + t];
                }
                break;
            }
        }
    }

    private byte[] get_ImageMirror(byte[] data, int MIRROR_TYPE) {
        if (MIRROR_TYPE != 2 && MIRROR_TYPE != 1) {
            return null;
        }
        int[] info = this.get_Idat_Info(data);
        byte[] rtn = new byte[data.length];
        System.arraycopy(data, 0, rtn, 0, info[2] + 15);
        if ((MIRROR_TYPE & 1) == 1) {
            for (int ttt = 0; ttt < info[1]; ++ttt) {
                int start = info[4] + 1 + ttt * (info[0] + 1);
                for (int tem = 0; tem < info[0]; ++tem) {
                    rtn[start + tem] = data[start + info[0] - tem - 1];
                }
            }
        } else if ((MIRROR_TYPE & 2) == 2) {
            int t_point = (info[1] - 1) * (info[0] + 1);
            for (int tem = 0; tem < info[1]; ++tem) {
                int gap = tem * (info[0] + 1);
                System.arraycopy(data, info[4] + gap, rtn, info[4] + t_point - gap, info[0] + 1);
            }
        }
        this.set_IDAT(data, rtn, info, info, info[3] + 12);
        return rtn;
    }

    private void set_IHDR(byte[] src, byte[] tgt, int[] isrc, int[] itgt, int size) {
        System.arraycopy(src, 0, tgt, 0, isrc[2] + 15);
        System.arraycopy(this.int2byte(itgt[0]), 0, tgt, 16, 4);
        System.arraycopy(this.int2byte(itgt[1]), 0, tgt, 20, 4);
        byte[] ihdr_crc = this.get_ByteCRC(tgt, 12, 17);
        System.arraycopy(ihdr_crc, 0, tgt, 29, 4);
        int size_chunk = size - 12;
        System.arraycopy(this.int2byte(size_chunk), 0, tgt, isrc[2], 4);
    }

    private void set_IDAT(byte[] src, byte[] tgt, int[] isrc, int[] itgt, int size) {
        this.set_Idat_First(tgt, isrc[2], size - 12);
        this.set_Idat_Second(tgt, isrc[2], size - 12);
        int ind = isrc[2] + size - 4;
        System.arraycopy(this.get_ByteCRC(tgt, isrc[2] + 4, size - 8), 0, tgt, ind, 4);
        System.arraycopy(src, src.length - 12, tgt, isrc[2] + size, 12);
    }

    private int[] get_Idat_Info(byte[] data) {
        int[] rtn;
        rtn = new int[]{this.b2i(data, 16), this.b2i(data, 20), this.get_IDAT_Chunk(data), this.b2i(data, rtn[2]), rtn[2] + 15, rtn[3] - 11};
        return rtn;
    }

    private void set_Idat_First(byte[] data, int index_chunk, int value_chunk) {
        int datanum = value_chunk - 11;
        data[index_chunk + 11] = (byte)(datanum & 0xFF);
        data[index_chunk + 12] = (byte)(datanum >> 8 & 0xFF);
        data[index_chunk + 13] = (byte)(255 - (datanum & 0xFF));
        data[index_chunk + 14] = (byte)(255 - (datanum >> 8 & 0xFF));
    }

    private void set_Idat_Second(byte[] data, int index_chunk, int value_chunk) {
        int add = 1;
        int comp = 0;
        for (int tem = index_chunk + 15; tem < index_chunk + 15 + value_chunk - 11; ++tem) {
            comp += (add += data[tem]);
            add %= 65521;
            comp %= 65521;
        }
        byte[] b_check = this.int2byte(comp << 16 | add);
        System.arraycopy(b_check, 0, data, index_chunk + value_chunk + 4, 4);
    }

    private int get_IDAT_Chunk(byte[] data) {
        for (int tem = 48; tem < data.length; ++tem) {
            if (data[tem] != 73 || data[tem + 1] != 68 || data[tem + 2] != 65 || data[tem + 3] != 84) continue;
            return tem - 4;
        }
        return -1;
    }

    public void set_Color(int color) {
        this.color = color;
    }

    public byte[] get_ColorImage(byte[] data) {
        int[] pal = this.get_Plte_Int(data);
        for (int t = 0; t < pal.length; ++t) {
            pal[t] = this.color;
        }
        byte[] rtn = new byte[data.length];
        System.arraycopy(data, 0, rtn, 0, rtn.length);
        return this.get_ImagePal(rtn, pal);
    }

    public int get_PlteNum(byte[] data) {
        int num = data[35] * 256 + (data[36] + 256) % 256;
        return num / 3;
    }

    public byte[] get_Plte_Byte(byte[] img) {
        int num = this.get_PlteNum(img);
        byte[] pal = new byte[3 * num];
        System.arraycopy(img, 41, pal, 0, pal.length);
        return pal;
    }

    public int[] get_Plte_Int(byte[] img) {
        int num = this.get_PlteNum(img);
        int[] pal = new int[num];
        for (int tem = 0; tem < num; ++tem) {
            byte[] val = new byte[]{0, img[41 + 3 * tem], img[42 + 3 * tem], img[43 + 3 * tem]};
            pal[tem] = this.byte2int(val);
        }
        return pal;
    }

    public byte[] get_ImagePal(byte[] data, int[] pal) {
        if (this.get_PlteNum(data) == pal.length) {
            for (int index = 0; index < pal.length; ++index) {
                byte[] b_color = this.int2byte(pal[index]);
                System.arraycopy(b_color, 1, data, 41 + index * 3, 3);
            }
            return this.set_PlteCrc(data);
        }
        return null;
    }

    public byte[] get_ImagePal(byte[] data, byte[] pal) {
        if (this.get_PlteNum(data) == pal.length / 3) {
            System.arraycopy(pal, 0, data, 41, pal.length);
            return this.set_PlteCrc(data);
        }
        return null;
    }

    private byte[] set_PlteCrc(byte[] data) {
        int num = this.get_PlteNum(data);
        byte[] crc = this.get_ByteCRC(data, 37, 4 + num * 3);
        System.arraycopy(crc, 0, data, 41 + num * 3, 4);
        return data;
    }

    public byte[] get_ImageGamma(byte[] data, int per) {
        byte[] pal = this.get_Plte_Byte(data);
        pal = this.gamma(pal, per);
        byte[] rtn = new byte[data.length];
        System.arraycopy(data, 0, rtn, 0, rtn.length);
        return this.get_ImagePal(rtn, pal);
    }

    private byte[] gamma(byte[] data, int per) {
        if (per > 10) {
            per = 10;
        }
        if (per < -10) {
            per = -10;
        }
        for (int tem = 0; tem < data.length; ++tem) {
            int h_int = (data[tem] + 256) % 256;
            if (per > 0) {
                int n = tem;
                data[n] = (byte)(data[n] + (255 - h_int) / 10 * per);
                continue;
            }
            if (per >= 0) continue;
            int n = tem;
            data[n] = (byte)(data[n] - h_int / 10 * -per);
        }
        return data;
    }

    private byte[] get_ImageGray(byte[] data) {
        byte[] pal = this.get_Plte_Byte(data);
        pal = this.gray(pal);
        byte[] rtn = new byte[data.length];
        System.arraycopy(data, 0, rtn, 0, rtn.length);
        return this.get_ImagePal(rtn, pal);
    }

    private byte[] gray(byte[] data) {
        for (int tem = 0; tem < data.length / 3; ++tem) {
            int a = Math.max(data[tem * 3], data[tem * 3 + 1]);
            int b = Math.max(data[tem * 3 + 1], data[tem * 3 + 2]);
            int value = a + b;
            data[tem * 3] = (byte)value;
            data[tem * 3 + 1] = (byte)value;
            data[tem * 3 + 2] = (byte)value;
        }
        return data;
    }
}

