/*
 * Decompiled with CFR 0.152.
 */
package de.exitgames.neutron.client;

import de.exitgames.neutron.client.GpOperation;
import de.exitgames.neutron.client.Neutron;
import de.exitgames.neutron.client.NeutronGame;
import de.exitgames.neutron.client.NeutronListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.midlet.MIDlet;

public class NeutronSession {
    private final String footprint;
    public static boolean billingPSMSDisabled;
    public static String psmsNumber;
    public static String psmsText;
    String serial = "";
    public String username;
    public String password;
    public String msisdn;
    public String subscriberID;
    public String handsetID;
    public static String userCulture;
    public String scoreTableId = "";
    public static boolean loadSubscription;
    public NeutronGame activeGame;
    public boolean firstConnect;
    byte[] sid;
    static byte[] chActions;
    String serverUrl = "http://neutron.exitgames.com/router/";
    String billingUrl;
    String customUrl;
    String connectionString;
    String subscriptionId = "";
    private String appKey;
    public String gameVersion;
    static final int S_BYTES = 1850;

    public NeutronSession(MIDlet mIDlet, String string, String string2, NeutronListener neutronListener) {
        this.footprint = "{Footprint.Client.Session}";
        Neutron.activeSession = this;
        Neutron.callbackListener = neutronListener;
        if (mIDlet.getAppProperty("Serial") != null) {
            this.serial = mIDlet.getAppProperty("Serial");
        }
        if (mIDlet.getAppProperty("MIDlet-Version") != null) {
            this.gameVersion = mIDlet.getAppProperty("MIDlet-Version");
        }
        if (this.subscriberID == null) {
            this.subscriberID = mIDlet.getAppProperty("UPSUBID");
        }
        this.subscriptionId = Neutron.getSubscriptionId();
        this.firstConnect = this.subscriptionId == "";
        Neutron.invocID = (short)new Random().nextInt();
        Neutron.evop = new GpOperation(this.serverUrl, this.sid, 22);
        this.appKey = string2;
        this.connectionString = string;
    }

    public byte[] getSid() {
        return this.sid;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String string) {
        this.serverUrl = string;
        if (Neutron.evop != null) {
            Neutron.evop._url = string;
        }
    }

    public boolean isSubscribed() {
        return this.subscriptionId != "";
    }

    public boolean isExecutingEvents() {
        return Neutron.eventExecution;
    }

    public boolean isPolling() {
        return Neutron.enableAutoPolling;
    }

    public void channelChange(byte by, byte by2, byte by3) {
        byte[] byArray = new byte[chActions.length + 3];
        System.arraycopy(chActions, 0, byArray, 0, chActions.length);
        byArray[byArray.length - 3] = by;
        byArray[byArray.length - 2] = by2;
        byArray[byArray.length - 1] = by3;
        chActions = byArray;
    }

    public void raiseEventInChannel(byte by, Hashtable hashtable, int n, byte by2, boolean bl, byte by3) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, bl ? (byte)52 : 51);
        if (bl) {
            gpOperation.addParameter(Neutron.P_ASID, this.activeGame.getASID());
        }
        gpOperation.addParameter(Neutron.P_DATA, hashtable);
        gpOperation.addParameter(Neutron.P_CODE, new Byte(by));
        gpOperation.addParameter(Neutron.P_COUNT, new Byte(by2));
        gpOperation.addParameter(Neutron.P_LEASETIME, new Integer(n));
        gpOperation.addParameter(Neutron.P_CHANNEL, new Byte(by3));
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void sendSMS(String string, String string2) {
        psmsText = string2;
        psmsNumber = string;
        GpOperation gpOperation = new GpOperation("sms://" + string, null, 103);
        gpOperation._opType = (byte)3;
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void setEventExecution(boolean bl) {
        Neutron.eventExecution = bl;
        if (bl) {
            Neutron.waitMultiplier = 1;
            Neutron.emptyPolls = 0;
            Neutron.processEvents(null);
        }
    }

    public void clearEventQueue() {
        Neutron.eventQueue.removeAllElements();
    }

    public void resumeCommunication(boolean bl) {
        if (bl) {
            Neutron.sendQueue.removeAllElements();
        }
        Neutron.networkLoss = false;
    }

    public void ping() {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 0);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public boolean isUserValid(String string) {
        return string.length() >= 3 && string.length() <= 15;
    }

    public boolean isPassValid(String string, String string2) {
        return string2.length() >= 4 && string2.length() <= 10 && !string2.toLowerCase().equals(string.toLowerCase());
    }

    public final void login(String string, String string2, String string3) {
        this.username = string;
        this.password = string2;
        userCulture = string3 == null ? "-" : string3;
        Neutron.m7_clientID = null;
        Neutron.m7_status = (byte)-1;
        this.loginAndRegister((byte)47);
    }

    public void register(String string, String string2, String string3) {
        this.username = string;
        this.password = string2;
        userCulture = string3 == null ? "-" : string3;
        this.loginAndRegister((byte)62);
    }

    public void setWebPassword(String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 69);
        if (string != null) {
            gpOperation.addParameter(Neutron.P_PASSWORD, string);
        }
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void renameUser(String string, String string2) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 63);
        gpOperation.addParameter(Neutron.P_USERNAME, string);
        gpOperation.addParameter(Neutron.P_PASSWORD, string2);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void raiseEventForActor(String string, byte by, byte by2, Hashtable hashtable, int n, byte by3) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 54);
        gpOperation.addParameter(Neutron.P_USERNAME, string);
        gpOperation.addParameter(Neutron.P_DATA, hashtable);
        gpOperation.addParameter(Neutron.P_CODE, new Byte(by));
        gpOperation.addParameter(Neutron.P_COUNT, new Byte(by2));
        gpOperation.addParameter(Neutron.P_LEASETIME, new Integer(n));
        gpOperation.addParameter(Neutron.P_CHANNEL, new Byte(by3));
        Neutron.sendQueue.addElement(gpOperation);
    }

    void loginAndRegister(byte by) {
        this.activeGame = null;
        String string = System.getProperty("microedition.platform");
        GpOperation gpOperation = new GpOperation(this.serverUrl, null, by);
        gpOperation.addParameter(Neutron.P_CNS, this.connectionString);
        gpOperation.addParameter(Neutron.P_SUBSID, this.subscriptionId);
        gpOperation.addParameter(Neutron.P_APPPW, this.appKey);
        gpOperation.addParameter(Neutron.P_SERIALNO, this.serial);
        gpOperation.addParameter(Neutron.P_LIBVERSION, "4.0.1.J2ME");
        gpOperation.addParameter(Neutron.P_COUNTRY, userCulture);
        gpOperation.addParameter(Neutron.P_USERNAME, this.username);
        gpOperation.addParameter(Neutron.P_PASSWORD, this.password);
        if (this.msisdn != null) {
            gpOperation.addParameter(Neutron.P_MSISDN, this.msisdn);
        }
        if (this.subscriberID != null) {
            gpOperation.addParameter(Neutron.P_SUBSCRIBERID, this.subscriberID);
        }
        if (this.handsetID != null) {
            gpOperation.addParameter(Neutron.P_HANDSETID, this.handsetID);
        }
        if (string != null) {
            gpOperation.addParameter(Neutron.P_PLATFORM_ID, string);
        }
        if (this.gameVersion != null) {
            gpOperation.addParameter(Neutron.P_GAMEVERSION, this.gameVersion);
        }
        Neutron.sendQueue.addElement(gpOperation);
    }

    void loginReturn(GpOperation gpOperation) {
        Integer n = (Integer)gpOperation.getRetVal(Neutron.P_ERR);
        if (n == null || n != 0) {
            return;
        }
        String string = (String)gpOperation.getRetVal(Neutron.P_SUBSID);
        if (!this.subscriptionId.equals(string)) {
            this.subscriptionId = string;
            Neutron.setSubscriptionId(this.subscriptionId);
            this.firstConnect = false;
        }
    }

    public void logout() {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 20);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void buddyGetList() {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 44);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void buddySet(String string, Byte by) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 45);
        gpOperation.addParameter(Neutron.P_USERNAME, string);
        gpOperation.addParameter(Neutron.P_STATUS, by);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void gameListInvitations(String string) {
        this.getAsOrInv((byte)16, string);
    }

    public void gameListOpen(String string) {
        this.getAsOrInv((byte)15, string);
    }

    private void getAsOrInv(byte by, String string) {
        if (string == null || string == "") {
            string = "{a}$${n}$${d}$${p}";
        }
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, by);
        gpOperation.addParameter(Neutron.P_VALUES, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void gameQuitByAsid(String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 31);
        gpOperation.addParameter(Neutron.P_ASID, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void gameActivate(String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 18);
        gpOperation.addParameter(Neutron.P_ASID, string);
        gpOperation.addParameter(Neutron.P_VALUES, "{n}$${un}$${s}$${k}$${ui}$${ul}");
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void gameCreate(String[] stringArray, int n, int n2, String string, int n3, byte by) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 65);
        if (stringArray != null) {
            gpOperation.addParameter(Neutron.P_ACTORS, stringArray);
        }
        gpOperation.addParameter(Neutron.P_MAXAS, new Integer(n));
        gpOperation.addParameter(Neutron.P_MINAS, new Integer(n2));
        gpOperation.addParameter(Neutron.P_NAME, string);
        gpOperation.addParameter(Neutron.P_SKILL, new Integer(n3));
        gpOperation.addParameter(Neutron.P_POOL, new Byte(by));
        gpOperation.addParameter(Neutron.P_VALUES, "{n}$${un}$${s}$${k}$${ui}$${ul}");
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void gameCreateRandom(int n, int n2, String string) {
        this.gameCreate(null, n, n2, string, 0, (byte)0);
    }

    public void gameCreateInvite(String[] stringArray, int n, int n2, String string) {
        this.gameCreate(stringArray, n, n2, string, 0, (byte)0);
    }

    public void gameCreateSkilled(int n, int n2, String string, int n3) {
        this.gameCreate(null, n, n2, string, n3, (byte)1);
    }

    public void gameCreateNamed(int n, int n2, String string) {
        this.gameCreate(null, n, n2, string, 0, (byte)2);
    }

    public void gameAbortMatchmaking() {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 38);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public NeutronGame gameGetActive() {
        return this.activeGame;
    }

    public void setActorInfo(String[] stringArray) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 41);
        gpOperation.addParameter(Neutron.P_INFO, stringArray);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void skillSet(int n) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 36);
        gpOperation.addParameter(Neutron.P_SKILL, new Integer(n));
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void skillGet() {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 37);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void setScoreTableId(String string) {
        this.scoreTableId = string;
    }

    public void getScorePosition(String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 11);
        gpOperation.addParameter(Neutron.P_SCOREID, string);
        gpOperation.addParameter(Neutron.P_TIMEFRAME, "");
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void setScore(long l, byte by, String[] stringArray, String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 2);
        gpOperation.addParameter(Neutron.P_SCORE, new Long(l));
        gpOperation.addParameter(Neutron.P_SCORETABLE, this.scoreTableId);
        gpOperation.addParameter(Neutron.P_PARAMS, new Byte(by));
        gpOperation.addParameter(Neutron.P_INFO, stringArray);
        gpOperation.addParameter(Neutron.P_VALUES, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void setScore(String[] stringArray, long l, byte by, String[] stringArray2, String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 53);
        gpOperation.addParameter(Neutron.P_SCORE, new Long(l));
        gpOperation.addParameter(Neutron.P_SCORETABLE, stringArray);
        gpOperation.addParameter(Neutron.P_PARAMS, new Byte(by));
        gpOperation.addParameter(Neutron.P_INFO, stringArray2);
        gpOperation.addParameter(Neutron.P_VALUES, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void getScoresByPos(int n, int n2, String string, String string2, String string3) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 8);
        gpOperation.addParameter(Neutron.P_POS, new Integer(n));
        gpOperation.addParameter(Neutron.P_SCORETABLE, this.scoreTableId);
        this.getScoresAddParam(gpOperation, n2, string, string2, string3);
    }

    public void getScoresById(String string, int n, int n2, String string2, String string3, String string4) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 9);
        gpOperation.addParameter(Neutron.P_SCOREID, string);
        gpOperation.addParameter(Neutron.P_OFFSET, new Integer(n));
        this.getScoresAddParam(gpOperation, n2, string2, string3, string4);
    }

    public void getScoresByUserID(String string, int n, int n2, String string2, String string3, String string4) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 10);
        gpOperation.addParameter(Neutron.P_USERNAME, string);
        gpOperation.addParameter(Neutron.P_SCORETABLE, this.scoreTableId);
        gpOperation.addParameter(Neutron.P_OFFSET, new Integer(n));
        this.getScoresAddParam(gpOperation, n2, string2, string3, string4);
    }

    private void getScoresAddParam(GpOperation gpOperation, int n, String string, String string2, String string3) {
        if (string == null || string == "") {
            string = "{i}$${p,2}. {un} ({s})$${ui}";
        }
        if (string3 == null) {
            string3 = "";
        }
        gpOperation.addParameter(Neutron.P_COUNT, new Integer(n));
        gpOperation.addParameter(Neutron.P_VALUES, string);
        gpOperation.addParameter(Neutron.P_TIMEFRAME, string2);
        gpOperation.addParameter(Neutron.P_FILTER, string3);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void setShadow(long l, byte[] byArray, byte by, String[] stringArray, String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 6);
        gpOperation.addParameter(Neutron.P_SCORE, new Long(l));
        gpOperation.addParameter(Neutron.P_SCORETABLE, this.scoreTableId);
        gpOperation.addParameter(Neutron.P_SHADOW, byArray);
        gpOperation.addParameter(Neutron.P_TOTALBYTES, new Integer(byArray.length));
        gpOperation.addParameter(Neutron.P_PARAMS, new Byte(by));
        gpOperation.addParameter(Neutron.P_INFO, stringArray);
        gpOperation.addParameter(Neutron.P_VALUES, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void getShadow(String string) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 5);
        gpOperation.addParameter(Neutron.P_SCOREID, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public String getCustomServerUrl() {
        return this.customUrl;
    }

    public void setCustomServerUrl(String string) {
        this.customUrl = string;
    }

    public void customOperation(byte by, Hashtable hashtable) {
        GpOperation gpOperation = new GpOperation(this.customUrl, null, by);
        gpOperation._opType = (byte)6;
        gpOperation._parameters.put(Neutron.P_SID, this.sid);
        if (hashtable != null && hashtable.keys() != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                gpOperation._parameters.put(k, hashtable.get(k));
            }
        }
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void billingInitPayment(byte[] byArray, String string, String string2, String string3) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 72);
        if (byArray != null) {
            gpOperation.addParameter(Neutron.P_ASSETSERVER, byArray);
        }
        gpOperation.addParameter(Neutron.P_METAPRICE, string3);
        gpOperation.addParameter(Neutron.P_PRICEPOINT, string2);
        gpOperation.addParameter(Neutron.P_ASSET, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void billingProcessPayment(Hashtable hashtable) {
        Byte by = (Byte)hashtable.get("Status");
        Byte by2 = (Byte)hashtable.get("BillingAction");
        if (by == null) {
            return;
        }
        if (by != 1) {
            return;
        }
        if (by2 != 0 && by2 == 1) {
            psmsText = (String)hashtable.get("SmsTxt");
            psmsNumber = (String)hashtable.get("SmsTo");
            this.sendSMS(psmsNumber, psmsText);
        }
        Neutron.callbackListener.billingProcessPaymentReturn(0);
    }

    public void getPackages(String string, String string2) {
        if (string == null) {
            string = "{i}$${pp}$${mp}$${t} {p:0.00} {d}";
        }
        userCulture = string2 == null ? "-" : string2;
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 48);
        gpOperation.addParameter(Neutron.P_CNS, this.connectionString);
        gpOperation.addParameter(Neutron.P_APPPW, this.appKey);
        gpOperation.addParameter(Neutron.P_SUBSID, this.subscriptionId);
        gpOperation.addParameter(Neutron.P_VALUES, string);
        gpOperation.addParameter(Neutron.P_SERIALNO, this.serial);
        gpOperation.addParameter(Neutron.P_COUNTRY, userCulture);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void autoLogin(String string) {
        this.username = Neutron.m7_name == null ? "" : Neutron.m7_name;
        this.password = Neutron.m7_pass == null ? "" : Neutron.m7_pass;
        userCulture = string == null ? "-" : string;
        this.loginAndRegister((byte)68);
    }

    public void anonymousLogin(String string) {
        this.activeGame = null;
        this.username = Neutron.m7_name == null ? "" : Neutron.m7_name;
        this.password = Neutron.m7_pass == null ? "" : Neutron.m7_pass;
        userCulture = string == null ? "-" : string;
        String string2 = System.getProperty("microedition.platform");
        Neutron.callbackListener.debugReturn("PlatformID: " + string2);
        GpOperation gpOperation = new GpOperation(this.serverUrl, null, 70);
        gpOperation.addParameter(Neutron.P_CNS, this.connectionString);
        gpOperation.addParameter(Neutron.P_APPPW, this.appKey);
        gpOperation.addParameter(Neutron.P_SERIALNO, this.serial);
        gpOperation.addParameter(Neutron.P_SUBSID, this.subscriptionId);
        gpOperation.addParameter(Neutron.P_COUNTRY, userCulture);
        gpOperation.addParameter(Neutron.P_LIBVERSION, "4.0.1.J2ME");
        if (string2 != null) {
            gpOperation.addParameter(Neutron.P_PLATFORM_ID, string2);
        }
        if (this.msisdn != null) {
            gpOperation.addParameter(Neutron.P_MSISDN, this.msisdn);
        }
        if (this.subscriberID != null) {
            gpOperation.addParameter(Neutron.P_SUBSCRIBERID, this.subscriberID);
        }
        if (this.gameVersion != null) {
            gpOperation.addParameter(Neutron.P_GAMEVERSION, this.gameVersion);
        }
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void getStatsForUserID(String string, String string2) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 58);
        gpOperation.addParameter(Neutron.P_VALUES, string2);
        gpOperation.addParameter(Neutron.P_USERNAME, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void rateGame(byte by) {
        GpOperation gpOperation = new GpOperation(this.serverUrl, this.sid, 59);
        gpOperation.addParameter(Neutron.P_SCORE, new Byte(by));
        Neutron.sendQueue.addElement(gpOperation);
    }

    static {
        loadSubscription = true;
        chActions = new byte[0];
    }
}

