/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class ASpriteInstance {
    public int _posX;
    public int _posY;
    private int _pos_ox;
    private int _pos_oy;
    private int _flags;
    public ASprite _sprite;
    private int _nCrtAnim;
    private int _nCrtAFrame;
    private int _nCrtTime;
    private int[] _rect;
    private ASpriteInstance _parent;
    private static final boolean DRAW_DEBUG_FRAMES = false;
    private int _vis;

    public ASpriteInstance() {
    }

    public ASpriteInstance(ASprite spr, int posX, int posY, ASpriteInstance parent) {
        this._posX = posX << 8;
        this._posY = posY << 8;
        this._sprite = spr;
        this._rect = new int[4];
        this._parent = parent;
    }

    public void SetAnim(int id) {
        if (id != this._nCrtAnim) {
            this._nCrtAnim = id;
            this._nCrtAFrame = 0;
            this._nCrtTime = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
        }
    }

    public int getAnim() {
        return this._nCrtAnim;
    }

    public void ApplyAnimOff() {
        this._posX -= this._pos_ox;
        this._posY -= this._pos_oy;
        int off = (this._sprite._anims_af_start[this._nCrtAnim] + this._nCrtAFrame) * 5;
        this._pos_ox = (this._sprite.bs_flags & 0x40000) != 0 ? (this._sprite._aframesForShort[off + 2] << 8) * 1 / 1 : (this._sprite._aframesForByte[off + 2] << 8) * 1 / 1;
        if ((this._flags & 1) != 0) {
            this._pos_ox = -this._pos_ox;
        }
        this._pos_oy = (this._sprite.bs_flags & 0x40000) != 0 ? (this._sprite._aframesForShort[off + 3] << 8) * 1 / 1 : (this._sprite._aframesForByte[off + 3] << 8) * 1 / 1;
        if ((this._flags & 2) != 0) {
            this._pos_oy = -this._pos_oy;
        }
        this._posX += this._pos_ox;
        this._posY += this._pos_oy;
    }

    public boolean IsAnimEnded(int frameIndex) {
        if (frameIndex != this._sprite.GetAFrames(this._nCrtAnim) - 1) {
            return false;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        return time == 0 || this._nCrtTime == time - 1;
    }

    public boolean IsAnimEnded() {
        if (this._nCrtAFrame != this._sprite.GetAFrames(this._nCrtAnim) - 1) {
            return false;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        return time == 0 || this._nCrtTime == time - 1;
    }

    public void PaintSprite(Graphics g, float xScale, float yScale) {
        if (this._sprite == null) {
            return;
        }
        int posX = this._posX;
        int posY = this._posY;
        ASpriteInstance o = this._parent;
        while (o != null) {
            posX += o._posX;
            posY += o._posY;
            o = o._parent;
        }
        posX = ASpriteInstance.ZOOM_IN_FIXED_X(posX) + 0;
        posY = ASpriteInstance.ZOOM_IN_FIXED_Y(posY) + 0;
        if (this._nCrtTime >= 0) {
            this._sprite.PaintAFrame(g, this._nCrtAnim, this._nCrtAFrame, posX, posY, this._flags, 0, 0, xScale, yScale);
        } else if (this._nCrtAnim >= 0) {
            this._sprite.PaintModule(g, this._nCrtAnim, posX, posY, this._flags, xScale, yScale);
        } else if (this._nCrtAFrame >= 0) {
            this._sprite.PaintFrame(g, this._nCrtAFrame, posX, posY, this._flags, 0, 0, xScale, yScale);
        }
    }

    public void paintSprite(Graphics g, int frameIndex) {
        if (this._sprite == null) {
            return;
        }
        int posX = this._posX;
        int posY = this._posY;
        ASpriteInstance o = this._parent;
        while (o != null) {
            posX += o._posX;
            posY += o._posY;
            o = o._parent;
        }
        posX = ASpriteInstance.ZOOM_IN_FIXED_X(posX) + 0;
        posY = ASpriteInstance.ZOOM_IN_FIXED_Y(posY) + 0;
        if (this._nCrtTime >= 0) {
            this._sprite.PaintAFrame(g, this._nCrtAnim, frameIndex, posX, posY, this._flags, 0, 0);
        } else if (this._nCrtAnim >= 0) {
            this._sprite.PaintModule(g, this._nCrtAnim, posX, posY, this._flags);
        } else if (frameIndex >= 0) {
            this._sprite.PaintFrame(g, frameIndex, posX, posY, this._flags, 0, 0);
        }
    }

    public void PaintSprite(Graphics g) {
        if (this._sprite == null) {
            return;
        }
        int posX = this._posX;
        int posY = this._posY;
        ASpriteInstance o = this._parent;
        while (o != null) {
            posX += o._posX;
            posY += o._posY;
            o = o._parent;
        }
        posX = ASpriteInstance.ZOOM_IN_FIXED_X(posX) + 0;
        posY = ASpriteInstance.ZOOM_IN_FIXED_Y(posY) + 0;
        if (this._nCrtTime >= 0) {
            this._sprite.PaintAFrame(g, this._nCrtAnim, this._nCrtAFrame, posX, posY, this._flags, 0, 0);
        } else if (this._nCrtAnim >= 0) {
            this._sprite.PaintModule(g, this._nCrtAnim, posX, posY, this._flags);
        } else if (this._nCrtAFrame >= 0) {
            this._sprite.PaintFrame(g, this._nCrtAFrame, posX, posY, this._flags, 0, 0);
        }
    }

    public void UpdateSpriteAnim() {
        if (this._sprite == null) {
            return;
        }
        if (this._nCrtTime < 0) {
            return;
        }
        int time = this._sprite.GetAFrameTime(this._nCrtAnim, this._nCrtAFrame);
        if (time == 0) {
            return;
        }
        ++this._nCrtTime;
        if (time > this._nCrtTime) {
            return;
        }
        this._nCrtTime = 0;
        ++this._nCrtAFrame;
        if (this._nCrtAFrame >= this._sprite.GetAFrames(this._nCrtAnim)) {
            this._nCrtAFrame = 0;
            this._pos_ox = 0;
            this._pos_oy = 0;
        }
    }

    public void setFrame(int frameIndex) {
        this._nCrtAFrame = frameIndex;
    }

    public int getFrame() {
        return this._nCrtAFrame;
    }

    public int[] GetRect() {
        if (this._rect == null) {
            this._rect = new int[4];
        }
        if (this._sprite != null) {
            if (this._nCrtTime >= 0) {
                this._sprite.GetAFrameRect(this._rect, this._nCrtAnim, this._nCrtAFrame, this._posX, this._posY, this._flags, 0, 0);
            } else if (this._nCrtAnim >= 0) {
                this._sprite.GetModuleRect(this._rect, this._nCrtAnim, this._posX, this._posY, this._flags);
            } else if (this._nCrtAFrame >= 0) {
                this._sprite.GetFrameRect(this._rect, this._nCrtAFrame, this._posX, this._posY, this._flags, 0, 0);
            }
        }
        return this._rect;
    }

    public static boolean IsRectCrossing(int[] rect1, int[] rect2) {
        if (rect1[0] > rect2[2]) {
            return false;
        }
        if (rect1[2] < rect2[0]) {
            return false;
        }
        if (rect1[1] > rect2[3]) {
            return false;
        }
        return rect1[3] >= rect2[1];
    }

    public static boolean IsPointInRect(int x, int y, int[] rect) {
        if (x < rect[0]) {
            return false;
        }
        if (x > rect[2]) {
            return false;
        }
        if (y < rect[1]) {
            return false;
        }
        return y <= rect[3];
    }

    public void OnScreenTest() {
        int ox = 0;
        int oy = 0;
        ASpriteInstance o = this._parent;
        while (o != null) {
            ox += o._posX;
            oy += o._posY;
            o = o._parent;
        }
        int[] rect = this.GetRect();
        rect[0] = rect[0] + (ox - 61440);
        rect[1] = rect[1] + (oy - 81920);
        rect[2] = rect[2] + ox;
        rect[3] = rect[3] + oy;
        this._vis = 0;
        if (rect[0] < 0 && rect[2] >= 0 && rect[1] < 0 && rect[3] >= 0) {
            this._vis = 15;
        }
    }

    public boolean IsOnScreen(int style) {
        return (this._vis & style) != 0;
    }

    private static int ZOOM_IN_FIXED_X(int x) {
        return (x >> 8) * 1 / 1;
    }

    private static int ZOOM_IN_FIXED_Y(int y) {
        return (y >> 8) * 1 / 1;
    }
}

