/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectUtils;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tools {
    public static final int ASC = 0;
    public static final int DESC = 1;
    private static final int MATH_DATA_FRACTION_BITS = 12;
    private static final short[] TABLE_TAN = new short[]{0, 100, 201, 302, 403, 505, 607, 710, 814, 919, 1025, 1133, 1242, 1353, 1465, 1580, 1696, 1815, 1937, 2061, 2189, 2320, 2455, 2593, 2736, 2884, 3037, 3196, 3361, 3533, 3712, 3899, 4095};
    private static final short[] TABLE_SIN = new short[]{0, 100, 200, 301, 401, 501, 601, 700, 799, 897, 995, 1092, 1189, 1284, 1379, 1474, 1567, 1659, 1751, 1841, 1930, 2018, 2105, 2191, 2275, 2358, 2439, 2519, 2598, 2675, 2750, 2824, 2896, 2966, 3034, 3101, 3166, 3229, 3289, 3348, 3405, 3460, 3513, 3563, 3612, 3658, 3702, 3744, 3784, 3821, 3856, 3889, 3919, 3947, 3973, 3996, 4017, 4035, 4051, 4065, 4076, 4084, 4091, 4094, 4096};
    private static final short[] TABLE_COS = new short[]{4096, 4094, 4091, 4084, 4076, 4065, 4051, 4035, 4017, 3996, 3973, 3947, 3919, 3889, 3856, 3821, 3784, 3744, 3702, 3658, 3612, 3563, 3513, 3460, 3405, 3348, 3289, 3229, 3166, 3101, 3034, 2966, 2896, 2824, 2750, 2675, 2598, 2519, 2439, 2358, 2275, 2191, 2105, 2018, 1930, 1841, 1751, 1659, 1567, 1474, 1379, 1284, 1189, 1092, 995, 897, 799, 700, 601, 501, 401, 301, 200, 100, 0};
    public static final Random rdm = new Random();
    private static final int RAIN_COLOR = 0xFFFFFF;
    private static final int DISTANCE_BUTTOM_FROM_UI = 40;
    private static byte[] rainPoint = null;
    private static int[][] rainPointCoordinate = null;
    private static byte long_axis = 0;
    private static byte short_axis = 0;
    private static int areaCount = 3;
    private static int rainCountPerArea = 0;
    private static int[][] rainMaxCoordinate = null;
    private static int rain_length = 0;
    private static int distance = 0;
    private static int[][][] coordinateArray = null;
    public static int currentRainType = 0;
    private static final int RAIN_LIGHT_MODE = 0;
    private static final int RAIN_NORMAL_MODE = 1;
    private static final int RAIN_HEAVY_MODE = 2;
    private static final int MIN_X_COOR = 0;
    private static final int MAX_X_COOR = 1;
    private static final int MIN_Y_COOR = 2;
    private static final int MAX_Y_COOR = 3;
    private static int MIN_LENGTH_LIGHT_RAIN = 15;
    private static int MAX_LENGTH_LIGHT_RAIN = 23;
    private static int MIN_LENGTH_NOMAL_RAIN = 23;
    private static int MAX_LENGTH_NOMAL_RAIN = 35;
    private static int MIN_LENGTH_HEAVY_RAIN = 37;
    private static int MAX_LENGTH_HEAVY_RAIN = 55;
    private static int currentRainMinLength = 0;
    private static int currentRainMaxLength = 0;
    public static int cloudy_alpha_value = 0;
    public static int currentCloudyType = 0;
    public static int thunder_counter = 0;
    public static int thunder_alpha_value = 255;
    public static boolean isThunder = false;
    private static boolean isLightNing = false;
    private static int lightning_counter = 0;
    private static int lightning_tyte = -1;
    private static final int common_lightning = 0;
    private static final int furcation_lightning = 1;
    private static int light_startX = 0;
    private static int light_startY = 0;
    private static int light_endX = 0;
    private static int light_endY = 0;
    private static int light_furcation_startX1 = 0;
    private static int light_furcation_startY1 = 0;
    private static int light_furcation_startX2 = 0;
    private static int light_furcation_startY2 = 0;
    private static int light_furcation_endX1 = 0;
    private static int light_furcation_endY1 = 0;
    private static int light_furcation_endX2 = 0;
    private static int light_furcation_endY2 = 0;
    private static int lingt_length = 240;
    private static int length_per_light = 10;
    private static int lingt_count = 0;
    private static int distance_from_screen_left = 20;
    private static int light_angle = 0;
    private static int light_max_angle = 60;
    private static int two_snow_counter = 1;
    private static int snow_counter = 0;
    public static int currentSnowType = 1;
    private static double sonw_transform_angle = 0.0;
    private static int snow_endX = 0;
    private static int snow_endY = 0;
    private static int[][] snow_coordinate = null;
    private static int snow_count = 0;
    private static int scrollPos = 0;
    private static String strPrevious = "";
    public static int posY = 0;
    public static int cgPosY = 0;

    public static final void fillPolygon(Graphics g, int x, int y, int w, int h, int alphaColor) {
        int[] a = new int[]{x, x + w, x + w, x};
        int[] b = new int[]{y, y, y + h, y + h};
        DirectUtils.getDirectGraphics((Graphics)g).fillPolygon(a, 0, b, 0, 4, alphaColor);
    }

    public static short CombineShort(byte a, byte b) {
        return (short)(a << 8 | b & 0xFF);
    }

    public static void translate2MapCoordinate(short[] rect, int relativeX, int relativeY) {
        if (rect == null) {
            return;
        }
        rect[0] = (short)(rect[0] + relativeX);
        rect[1] = (short)(rect[1] + relativeY);
    }

    public static final int readFromByteArray(byte[] data, int offset, int length) {
        int param = 0;
        int mbit = 0;
        for (int i = length - 1; i >= 0; --i) {
            mbit = length - i - 1 << 3;
            param |= data[offset + i] << mbit & 255 << mbit;
        }
        switch (length) {
            case 1: {
                param = (byte)param;
                break;
            }
            case 2: {
                param = (short)param;
                break;
            }
            case 4: 
        }
        return param;
    }

    public static void sortArray(int[] array, int style) {
        block5: {
            int len;
            block4: {
                len = array.length;
                if (style != 0) break block4;
                for (int i = 0; i < len; ++i) {
                    for (int j = i + 1; j < len; ++j) {
                        if (array[i] <= array[j]) continue;
                        int temp = array[j];
                        array[j] = array[i];
                        array[i] = temp;
                    }
                }
                break block5;
            }
            if (style != 1) break block5;
            for (int i = 0; i < len; ++i) {
                for (int j = i + 1; j < len; ++j) {
                    if (array[i] >= array[j]) continue;
                    int temp = array[j];
                    array[j] = array[i];
                    array[i] = temp;
                }
            }
        }
    }

    public static final boolean isPointInRect(int x, int y, int x1, int y1, int x2, int y2) {
        if (x1 > x2 ? x > x1 || x < x2 : x < x1 || x > x2) {
            return false;
        }
        return !(y1 > y2 ? y > y1 || y < y2 : y < y1 || y > y2);
    }

    public static boolean isCollisionByRect(short[] rect1, short[] rect2) {
        return rect1[1] < rect2[1] + rect2[3] && rect1[1] + rect1[3] > rect2[1] && rect1[0] < rect2[0] + rect2[2] && rect1[0] + rect1[2] > rect2[0];
    }

    public static byte[] shortToByteArray(short number) {
        byte[] result = new byte[]{(byte)(number >> 8 & 0xFF), (byte)number};
        return result;
    }

    public static byte[] intToByteArray(int number) {
        byte[] result = new byte[]{(byte)(number >> 24), (byte)(number >> 16), (byte)(number >> 8), (byte)number};
        return result;
    }

    public static short byteArrayToShort(byte[] byteArray) {
        short result = 0;
        result = (short)((byteArray[0] & 0xFF) << 8 | byteArray[1] & 0xFF);
        return result;
    }

    public static int byteArrayToInt(byte[] byteArray) {
        int result = 0;
        result = (byteArray[0] & 0xFF) << 24 | (byteArray[1] & 0xFF) << 16 | (byteArray[2] & 0xFF) << 8 | byteArray[3] & 0xFF;
        return result;
    }

    public static final int arcTan(int x, int y) {
        int angle;
        int abs_y;
        if (x == 0 && y == 0) {
            return 0;
        }
        int abs_x = x >= 0 ? x : -x;
        int n = abs_y = y >= 0 ? y : -y;
        if (abs_x >= abs_y) {
            int tan = (abs_y << 12) / abs_x;
            angle = Tools.findAngle(tan);
        } else {
            int ctan = (abs_x << 12) / abs_y;
            angle = Tools.findAngle(ctan);
            angle = 64 - angle;
        }
        return x >= 0 ? (y >= 0 ? angle : 256 - angle) : (y >= 0 ? 128 - angle : 128 + angle);
    }

    private static final int findAngle(int tanValue) {
        int front = 0;
        int end = 32;
        int half = 16;
        for (int half_len = 16; half_len > 0; half_len >>= 1) {
            if (TABLE_TAN[half] > tanValue) {
                end = half;
                half -= half_len;
                continue;
            }
            front = half;
            half += half_len;
        }
        return TABLE_TAN[end] - tanValue < tanValue - TABLE_TAN[front] ? end : front;
    }

    public static final int lenCos(int len, int angle) {
        int a = angle;
        if (a >= 128) {
            a = 256 - a;
        }
        if (a > 64) {
            a = 128 - a;
        }
        int len_cos = len * TABLE_COS[a] >> 12;
        return angle <= 64 || angle >= 192 ? len_cos : -len_cos;
    }

    public static final int lenSin(int len, int angle) {
        int a = angle;
        if (a >= 128) {
            a = 256 - a;
        }
        if (a > 64) {
            a = 128 - a;
        }
        int len_sin = len * TABLE_SIN[a] >> 12;
        return angle <= 128 ? len_sin : -len_sin;
    }

    public static void setFlag(int src, int flag) {
        src |= flag;
    }

    public static void clearFlag(int src, int flag) {
        src &= ~flag;
    }

    public static boolean checkFlag(int src, int flag) {
        return (src & flag) != 0;
    }

    public static final int getRandomInt(int data) {
        if (data == 0) {
            return 0;
        }
        return Math.abs(rdm.nextInt()) % data;
    }

    public static void initRain() {
        int currentRain;
        int currentArea;
        coordinateArray = new int[areaCount][][];
        int rainPointCount = 0;
        switch (currentRainType) {
            case 0: {
                int i;
                rainPointCount = 1;
                rainCountPerArea = 2;
                currentRainMinLength = MIN_LENGTH_LIGHT_RAIN;
                currentRainMaxLength = MAX_LENGTH_LIGHT_RAIN;
                long_axis = (byte)4;
                short_axis = (byte)2;
                rainPoint = new byte[rainPointCount];
                rainPointCoordinate = new int[rainPointCount][];
                distance = 7;
                for (i = 0; i < rainPointCoordinate.length; ++i) {
                    Tools.rainPointCoordinate[i] = new int[2];
                }
                break;
            }
            case 1: {
                int i;
                rainPointCount = 2;
                rainCountPerArea = 3;
                currentRainMinLength = MIN_LENGTH_NOMAL_RAIN;
                currentRainMaxLength = MAX_LENGTH_NOMAL_RAIN;
                long_axis = (byte)6;
                short_axis = (byte)4;
                rainPoint = new byte[rainPointCount];
                rainPointCoordinate = new int[rainPointCount][];
                distance = 13;
                for (i = 0; i < rainPointCoordinate.length; ++i) {
                    Tools.rainPointCoordinate[i] = new int[2];
                }
                break;
            }
            case 2: {
                int i;
                rainPointCount = 4;
                rainCountPerArea = 4;
                currentRainMinLength = MIN_LENGTH_HEAVY_RAIN;
                currentRainMaxLength = MAX_LENGTH_HEAVY_RAIN;
                long_axis = (byte)8;
                short_axis = (byte)6;
                rainPoint = new byte[rainPointCount];
                rainPointCoordinate = new int[rainPointCount][];
                distance = 25;
                for (i = 0; i < rainPointCoordinate.length; ++i) {
                    Tools.rainPointCoordinate[i] = new int[2];
                }
                break;
            }
        }
        for (currentArea = 0; currentArea < coordinateArray.length; ++currentArea) {
            Tools.coordinateArray[currentArea] = new int[rainCountPerArea][];
            for (currentRain = 0; currentRain < coordinateArray[currentArea].length; ++currentRain) {
                Tools.coordinateArray[currentArea][currentRain] = new int[4];
            }
        }
        rainMaxCoordinate = new int[areaCount][];
        for (currentArea = 0; currentArea < areaCount; ++currentArea) {
            Tools.rainMaxCoordinate[currentArea] = new int[4];
            Tools.rainMaxCoordinate[currentArea][0] = 20;
            Tools.rainMaxCoordinate[currentArea][1] = 280;
            if (currentArea == 0) {
                Tools.rainMaxCoordinate[currentArea][2] = -160;
                Tools.rainMaxCoordinate[currentArea][3] = 320 / (areaCount - 1) * currentArea;
                continue;
            }
            if (currentArea == areaCount - 1) {
                Tools.rainMaxCoordinate[currentArea][2] = rainMaxCoordinate[currentArea - 1][3];
                Tools.rainMaxCoordinate[currentArea][3] = 320 / (areaCount - 1) * currentArea - 40 - (currentRainMaxLength - currentRainMinLength);
                continue;
            }
            Tools.rainMaxCoordinate[currentArea][2] = rainMaxCoordinate[currentArea - 1][3];
            Tools.rainMaxCoordinate[currentArea][3] = 320 / (areaCount - 1) * currentArea;
        }
        for (currentArea = 0; currentArea < areaCount; ++currentArea) {
            for (currentRain = 0; currentRain < rainCountPerArea; ++currentRain) {
                Tools.coordinateArray[currentArea][currentRain][0] = Tools.getRandomInt(rainMaxCoordinate[currentArea][1] - rainMaxCoordinate[currentArea][0]) + rainMaxCoordinate[currentArea][0];
                Tools.coordinateArray[currentArea][currentRain][1] = Tools.getRandomInt(rainMaxCoordinate[currentArea][3] - rainMaxCoordinate[currentArea][2]) + rainMaxCoordinate[currentArea][2];
                rain_length = Tools.getRandomInt(currentRainMaxLength - currentRainMinLength) + currentRainMinLength;
                Tools.coordinateArray[currentArea][currentRain][2] = (int)((float)coordinateArray[currentArea][currentRain][0] - (float)rain_length * 0.5f);
                Tools.coordinateArray[currentArea][currentRain][3] = (int)((float)coordinateArray[currentArea][currentRain][1] + (float)rain_length * 0.866025f);
            }
        }
    }

    public static void drawRainLine(Graphics g) {
        g.setColor(0xFFFFFF);
        for (int i = 0; i < rainPoint.length; ++i) {
            if (rainPoint[i] == 0) continue;
            Tools.drawRainPoint(g, rainPointCoordinate[i][0], rainPointCoordinate[i][1], rainPoint[i]);
            int n = i;
            rainPoint[n] = (byte)(rainPoint[n] + 1);
            if (rainPoint[i] <= 3) continue;
            Tools.rainPoint[i] = 0;
        }
        for (int currentArea = 0; currentArea < areaCount; ++currentArea) {
            for (int currentRain = 0; currentRain < rainCountPerArea; ++currentRain) {
                int[] nArray = coordinateArray[currentArea][currentRain];
                nArray[0] = nArray[0] - distance;
                int[] nArray2 = coordinateArray[currentArea][currentRain];
                nArray2[1] = nArray2[1] + (int)((float)distance * 1.73f);
                int[] nArray3 = coordinateArray[currentArea][currentRain];
                nArray3[2] = nArray3[2] - distance;
                int[] nArray4 = coordinateArray[currentArea][currentRain];
                nArray4[3] = nArray4[3] + (int)((float)distance * 1.73f);
                for (int i = 0; i < rainPoint.length; ++i) {
                    if (rainPoint[i] != 0 || coordinateArray[currentArea][currentRain][3] <= 160 || coordinateArray[currentArea][currentRain][3] >= 280) continue;
                    Tools.rainPointCoordinate[i][0] = coordinateArray[currentArea][currentRain][2];
                    Tools.rainPointCoordinate[i][1] = coordinateArray[currentArea][currentRain][3];
                    int n = i;
                    rainPoint[n] = (byte)(rainPoint[n] + 1);
                    break;
                }
                if (coordinateArray[currentArea][currentRain][3] > 160 && coordinateArray[currentArea][currentRain][3] < 280) {
                    Tools.generateRandomRainLine(currentArea, currentRain);
                } else if (coordinateArray[currentArea][currentRain][1] < 20 || coordinateArray[currentArea][currentRain][3] > 280) {
                    Tools.generateRandomRainLine(currentArea, currentRain);
                }
                g.drawLine(coordinateArray[currentArea][currentRain][0], coordinateArray[currentArea][currentRain][1], coordinateArray[currentArea][currentRain][2], coordinateArray[currentArea][currentRain][3]);
            }
        }
    }

    private static void drawRainPoint(Graphics g, int x, int y, int counter) {
        switch (counter) {
            case 0: {
                break;
            }
            case 1: {
                g.drawArc(x - (long_axis >> 1), y - (short_axis >> 1), (int)long_axis, (int)short_axis, 0, 360);
                break;
            }
            case 2: {
                g.drawArc(x - (long_axis >> 1), y - (short_axis >> 1), (int)long_axis, (int)short_axis, 0, 360);
                g.drawArc(x - long_axis, y - short_axis, long_axis << 1, short_axis << 1, 0, 360);
                break;
            }
            case 3: {
                g.drawArc(x - long_axis, y - short_axis, long_axis << 1, short_axis << 1, 0, 360);
            }
        }
    }

    private static void generateRandomRainLine(int currentArea, int currentRain) {
        Tools.coordinateArray[currentArea][currentRain][0] = Tools.getRandomInt(rainMaxCoordinate[currentArea][1] - rainMaxCoordinate[currentArea][0]) + rainMaxCoordinate[currentArea][0];
        Tools.coordinateArray[currentArea][currentRain][2] = (int)((float)coordinateArray[currentArea][currentRain][0] - (float)rain_length * 0.5f);
        Tools.coordinateArray[currentArea][currentRain][1] = Tools.getRandomInt(rainMaxCoordinate[currentArea][3] - rainMaxCoordinate[currentArea][2]) + rainMaxCoordinate[currentArea][2];
        Tools.coordinateArray[currentArea][currentRain][3] = (int)((float)coordinateArray[currentArea][currentRain][1] + (float)rain_length * 0.866025f);
    }

    public static void drawCloudyDay(Graphics g) {
        switch (currentCloudyType) {
            case 0: {
                if ((cloudy_alpha_value += 3) > 64) {
                    cloudy_alpha_value = 64;
                }
                Tools.fillPolygon(g, 0, 0, 240, 320, cloudy_alpha_value << 24);
                break;
            }
            case 1: {
                if ((cloudy_alpha_value += 3) > 96) {
                    cloudy_alpha_value = 96;
                }
                Tools.fillPolygon(g, 0, 0, 240, 320, cloudy_alpha_value << 24);
                break;
            }
            case 2: {
                if ((cloudy_alpha_value += 3) > 127) {
                    cloudy_alpha_value = 127;
                }
                Tools.fillPolygon(g, 0, 0, 240, 320, cloudy_alpha_value << 24);
            }
        }
    }

    public static void drawThunder(Graphics g) {
        if (GameEngine.gameTime % 70 == 0) {
            isThunder = true;
        }
        if (isThunder) {
            if (thunder_counter == 3) {
                thunder_alpha_value = 255;
            }
            if (thunder_counter == 6) {
                thunder_alpha_value = 255;
            }
            if (thunder_counter < 3) {
                Tools.fillPolygon(g, 0, 0, 240, 320, thunder_alpha_value << 24 | 0xFFFFFF);
                thunder_alpha_value -= 80;
                ++thunder_counter;
            } else if (thunder_counter < 6) {
                Tools.fillPolygon(g, 0, 0, 240, 320, thunder_alpha_value << 24 | 0xFFFFFF);
                thunder_alpha_value -= 80;
                ++thunder_counter;
            } else {
                Tools.fillPolygon(g, 0, 0, 240, 320, thunder_alpha_value << 24 | 0xFFFFFF);
                thunder_alpha_value -= 80;
                ++thunder_counter;
            }
            if (thunder_alpha_value < 0) {
                thunder_alpha_value = 255;
                isThunder = false;
                thunder_counter = 0;
            }
        }
    }

    public static void drawLightning(Graphics g) {
        lingt_count = lingt_length / length_per_light;
        if (GameEngine.gameTime % 50 < 2) {
            isLightNing = true;
        }
        if (isLightNing) {
            lightning_tyte = Tools.getRandomInt(2);
            switch (lightning_tyte) {
                case 0: {
                    light_startX = Tools.getRandomInt(240 - (distance_from_screen_left << 1)) + distance_from_screen_left;
                    light_startY = 0;
                    light_angle = (Tools.getRandomInt(light_max_angle << 1) - light_max_angle) * 256 / 360;
                    for (int i = 0; i < lingt_count; ++i) {
                        if (i != 0) {
                            light_startX = light_endX;
                            light_startY = light_endY;
                        }
                        if (light_angle >= 0) {
                            light_angle = Tools.getRandomInt(light_max_angle) * 256 / 360;
                            light_endX = light_startX + Tools.lenSin(length_per_light, light_angle);
                            light_endY = light_startY + Tools.lenCos(length_per_light, light_angle);
                        } else {
                            light_angle = (Tools.getRandomInt(light_max_angle) - light_max_angle) * 256 / 360;
                            light_endX = light_startX - Tools.lenSin(length_per_light, -light_angle);
                            light_endY = light_startY + Tools.lenCos(length_per_light, -light_angle);
                        }
                        g.setColor(0xCCFFFF);
                        g.drawLine(light_startX, light_startY, light_endX, light_endY);
                        g.setColor(0x33CCFF);
                        g.drawLine(light_startX - 1, light_startY, light_endX - 1, light_endY);
                        g.drawLine(light_startX + 1, light_startY, light_endX + 1, light_endY);
                    }
                    isLightNing = false;
                    break;
                }
                case 1: {
                    light_startX = Tools.getRandomInt(240 - (distance_from_screen_left << 1)) + distance_from_screen_left;
                    light_startY = 0;
                    light_angle = (Tools.getRandomInt(light_max_angle << 1) - light_max_angle) * 256 / 360;
                    int number = Tools.getRandomInt(2) + 4;
                    for (int i = 0; i < lingt_count; ++i) {
                        if (i != 0) {
                            light_startX = light_endX;
                            light_startY = light_endY;
                        }
                        if (i < number) {
                            if (light_angle >= 0) {
                                light_angle = Tools.getRandomInt(light_max_angle) * 256 / 360;
                                light_endX = light_startX + Tools.lenSin(length_per_light, light_angle);
                                light_endY = light_startY + Tools.lenCos(length_per_light, light_angle);
                            } else {
                                light_angle = (Tools.getRandomInt(light_max_angle) - light_max_angle) * 256 / 360;
                                light_endX = light_startX - Tools.lenSin(length_per_light, -light_angle);
                                light_endY = light_startY + Tools.lenCos(length_per_light, -light_angle);
                            }
                            g.setColor(0xCCFFFF);
                            g.drawLine(light_startX, light_startY, light_endX, light_endY);
                            g.setColor(0x33CCFF);
                            g.drawLine(light_startX - 1, light_startY, light_endX - 1, light_endY);
                            g.drawLine(light_startX + 1, light_startY, light_endX + 1, light_endY);
                            continue;
                        }
                        if (i == number) {
                            light_furcation_startX1 = light_endX;
                            light_furcation_startY1 = light_endY;
                            light_furcation_startX2 = light_endX;
                            light_furcation_startY2 = light_endY;
                        } else {
                            light_furcation_startX1 = light_furcation_endX1;
                            light_furcation_startY1 = light_furcation_endY1;
                            light_furcation_startX2 = light_furcation_endX2;
                            light_furcation_startY2 = light_furcation_endY2;
                        }
                        light_angle = (Tools.getRandomInt(light_max_angle << 1) - light_max_angle) * 256 / 360;
                        if (light_angle > 0) {
                            light_furcation_endX1 = light_furcation_startX1 + Tools.lenSin(length_per_light, light_angle);
                            light_furcation_endY1 = light_furcation_startY1 + Tools.lenCos(length_per_light, light_angle);
                        } else {
                            light_furcation_endX1 = light_furcation_startX1 - Tools.lenSin(length_per_light, -light_angle);
                            light_furcation_endY1 = light_furcation_startY1 + Tools.lenCos(length_per_light, -light_angle);
                        }
                        g.setColor(0xCCFFFF);
                        g.drawLine(light_furcation_startX1, light_furcation_startY1, light_furcation_endX1, light_furcation_endY1);
                        g.setColor(0x33CCFF);
                        g.drawLine(light_furcation_startX1 - 1, light_furcation_startY1, light_furcation_endX1 - 1, light_furcation_endY1);
                        g.drawLine(light_furcation_startX1 + 1, light_furcation_startY1, light_furcation_endX1 + 1, light_furcation_endY1);
                        light_angle = (Tools.getRandomInt(light_max_angle << 1) - light_max_angle) * 256 / 360;
                        if (light_angle > 0) {
                            light_furcation_endX2 = light_furcation_startX2 + Tools.lenSin(length_per_light, light_angle);
                            light_furcation_endY2 = light_furcation_startY2 + Tools.lenCos(length_per_light, light_angle);
                        } else {
                            light_furcation_endX2 = light_furcation_startX2 - Tools.lenSin(length_per_light, -light_angle);
                            light_furcation_endY2 = light_furcation_startY2 + Tools.lenCos(length_per_light, -light_angle);
                        }
                        g.setColor(0xCCFFFF);
                        g.drawLine(light_furcation_startX2, light_furcation_startY2, light_furcation_endX2, light_furcation_endY2);
                        g.setColor(0x33CCFF);
                        g.drawLine(light_furcation_startX2 - 1, light_furcation_startY2, light_furcation_endX2 - 1, light_furcation_endY2);
                        g.drawLine(light_furcation_startX2 + 1, light_furcation_startY2, light_furcation_endX2 + 1, light_furcation_endY2);
                    }
                    isLightNing = false;
                }
            }
        }
    }

    public static void initSnow() {
        switch (currentSnowType) {
            case 0: {
                snow_count = 10;
                break;
            }
            case 1: {
                snow_count = 15;
                break;
            }
            case 2: {
                snow_count = 30;
            }
        }
        snow_coordinate = new int[snow_count][];
        for (int currentSnow = 0; currentSnow < snow_coordinate.length; ++currentSnow) {
            Tools.snow_coordinate[currentSnow] = new int[7];
            for (int i = 0; i < snow_coordinate[currentSnow].length; ++i) {
                Tools.snow_coordinate[currentSnow][0] = Tools.getRandomInt(260) + 20;
                Tools.snow_coordinate[currentSnow][1] = Tools.getRandomInt(20) + 20;
                Tools.snow_coordinate[currentSnow][2] = Tools.getRandomInt(41) < 39 ? Tools.getRandomInt(3) + 3 : 7;
                Tools.snow_coordinate[currentSnow][3] = snow_coordinate[currentSnow][2];
                Tools.snow_coordinate[currentSnow][4] = Tools.getRandomInt(30);
                Tools.snow_coordinate[currentSnow][5] = 360 / (snow_coordinate[currentSnow][2] << 1);
                Tools.snow_coordinate[currentSnow][6] = 360 / snow_coordinate[currentSnow][5];
            }
        }
    }

    public static void drawSnow(Graphics g) {
        ++snow_counter;
        g.setColor(0xFFFFFF);
        for (int currentSnow = 0; currentSnow < snow_coordinate.length; ++currentSnow) {
            if (currentSnow >= two_snow_counter << 1) {
                if (snow_counter <= 15) break;
                snow_counter = 0;
                ++two_snow_counter;
                break;
            }
            sonw_transform_angle -= 8.0;
            Tools.snow_coordinate[currentSnow][0] = snow_coordinate[currentSnow][0] - (int)((double)snow_coordinate[currentSnow][3] * Math.sin((double)snow_coordinate[currentSnow][4] * Math.PI / 180.0));
            Tools.snow_coordinate[currentSnow][1] = snow_coordinate[currentSnow][1] + (int)((double)snow_coordinate[currentSnow][3] * Math.cos((double)snow_coordinate[currentSnow][4] * Math.PI / 180.0));
            for (int i = 0; i < snow_coordinate[currentSnow][6]; ++i) {
                snow_endX = (int)((double)snow_coordinate[currentSnow][0] + (double)snow_coordinate[currentSnow][2] * Math.cos(((double)(i * snow_coordinate[currentSnow][5]) + sonw_transform_angle) * Math.PI / 180.0));
                snow_endY = (int)((double)snow_coordinate[currentSnow][1] - (double)snow_coordinate[currentSnow][2] * Math.sin(((double)(i * snow_coordinate[currentSnow][5]) + sonw_transform_angle) * Math.PI / 180.0));
                g.drawLine(snow_coordinate[currentSnow][0], snow_coordinate[currentSnow][1], snow_endX, snow_endY);
            }
            if (snow_coordinate[currentSnow][0] >= -5 && snow_coordinate[currentSnow][1] <= 280) continue;
            Tools.snow_coordinate[currentSnow][0] = Tools.getRandomInt(260) + 20;
            Tools.snow_coordinate[currentSnow][1] = Tools.getRandomInt(20) + 20;
            Tools.snow_coordinate[currentSnow][2] = Tools.getRandomInt(41) < 39 ? Tools.getRandomInt(3) + 3 : 7;
            Tools.snow_coordinate[currentSnow][3] = snow_coordinate[currentSnow][2];
            Tools.snow_coordinate[currentSnow][4] = Tools.getRandomInt(30);
            Tools.snow_coordinate[currentSnow][5] = 360 / (snow_coordinate[currentSnow][2] << 1);
            Tools.snow_coordinate[currentSnow][6] = 360 / snow_coordinate[currentSnow][5];
        }
    }

    public static void drawHollowString(Graphics g, String str, int x, int y, int color1, int color2, int anchor) {
        g.setFont(dConfig.F_SMALL);
        g.setColor(color1);
        g.drawString(str, x - 1, y, anchor);
        g.drawString(str, x, y - 1, anchor);
        g.drawString(str, x + 1, y, anchor);
        g.drawString(str, x, y + 1, anchor);
        g.setColor(color2);
        g.drawString(str, x, y, anchor);
    }

    public static void drawShadowString(Graphics g, String str, int x, int y, int color1, int color2, int anchor) {
        g.setFont(dConfig.F_SMALL);
        g.setColor(color1);
        g.drawString(str, x, y + 1, anchor);
        g.setColor(color2);
        g.drawString(str, x, y, anchor);
    }

    public static String getDescriptionStr(String srcStr) {
        StringBuffer sb = new StringBuffer(srcStr);
        while (true) {
            block1: for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != '[') continue;
                int j = i;
                while (true) {
                    if (j >= sb.length()) continue block1;
                    if (sb.charAt(j) == ']') {
                        sb.delete(i, j + 1);
                        continue block1;
                    }
                    ++j;
                }
            }
            break;
        }
        return sb.toString();
    }

    public static String[] split(String str, char ch) {
        Vector<Integer> indexVector = new Vector<Integer>();
        indexVector.addElement(new Integer(-1));
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            indexVector.addElement(new Integer(i));
        }
        int startIndex = 0;
        int endIndex = 0;
        String[] data = new String[indexVector.size()];
        for (int i = 0; i < data.length; ++i) {
            if (i == data.length - 1) {
                data[i] = str.substring(endIndex + 1);
                continue;
            }
            startIndex = (Integer)indexVector.elementAt(i);
            endIndex = (Integer)indexVector.elementAt(i + 1);
            data[i] = str.substring(startIndex + 1, endIndex);
        }
        return data;
    }

    public static void drawPoemStr(Graphics g) {
        g.setFont(dConfig.F_SMALL);
        g.setColor(0xFFFFFF);
        int length = GameEngine.dlgPoemStr.length;
        int baseLineCoor = 0;
        if (GameEngine.cgPicIndex != -1) {
            if (GameEngine.picCG[GameEngine.cgPicIndex] == null) {
                GameEngine.picCG[GameEngine.cgPicIndex] = Tools.loadImage("CG/" + GameEngine.cgPicIndex);
            }
            g.drawImage(GameEngine.picCG[GameEngine.cgPicIndex], 120, 4, 17);
            baseLineCoor = (320 + GameEngine.picCG[GameEngine.cgPicIndex].getHeight()) / 2 + dConfig.SF_HEIGHT / 2 - (length - 1) * dConfig.SF_HEIGHT / 2;
            for (int i = 0; i < length; ++i) {
                String str = GameEngine.dlgPoemStr[i];
                g.drawString(str, 120, baseLineCoor + i * dConfig.SF_HEIGHT, 33);
            }
        } else {
            baseLineCoor = 160 + dConfig.SF_HEIGHT / 2 - (length - 1) * dConfig.SF_HEIGHT / 2;
            for (int i = 0; i < length; ++i) {
                String str = GameEngine.dlgPoemStr[i];
                g.drawString(str, 120, baseLineCoor + i * dConfig.SF_HEIGHT, 33);
            }
        }
    }

    public static void drawObtainItem(Graphics g) {
        g.setFont(dConfig.F_SMALL);
        g.setColor(0xFFFFFF);
        int count = GameEngine.obtainGoodsV.size();
        int baseLineCoor = 160 + dConfig.SF_HEIGHT / 2 - (count - 1) * dConfig.SF_HEIGHT / 2;
        for (int i = 0; i < count; ++i) {
            String str = (String)GameEngine.obtainGoodsV.elementAt(i);
            g.drawString(str, 120, baseLineCoor + i * (dConfig.SF_HEIGHT + 2), 33);
        }
    }

    public static void drawCGContent(Graphics g, String str, int x, int y, int w, int h) {
        g.setFont(dConfig.F_SMALL);
        int widthPerChar = dConfig.SF_WIDTH;
        int heightperChar = dConfig.SF_HEIGHT;
        int charsPerLine = 0;
        int lineCount = 0;
        charsPerLine = w / widthPerChar;
        lineCount = str.length() % charsPerLine == 0 ? str.length() / charsPerLine : str.length() / charsPerLine + 1;
        if (lineCount * heightperChar > h) {
            if (++posY > heightperChar * lineCount + h) {
                posY = -h;
            }
            g.setClip(x, y, w, h);
            for (int i = 0; i < lineCount; ++i) {
                if (i != lineCount - 1) {
                    g.drawString(str.substring(i * charsPerLine, (i + 1) * charsPerLine), x, y - posY - cgPosY + i * heightperChar, 0);
                    continue;
                }
                g.drawString(str.substring(i * charsPerLine), x, y - posY - cgPosY + i * heightperChar, 0);
            }
            g.setClip(0, 0, 240, 320);
        } else {
            g.setClip(x, y, w, h);
            for (int i = 0; i < lineCount; ++i) {
                if (i != lineCount - 1) {
                    g.drawString(str.substring(i * charsPerLine, (i + 1) * charsPerLine), x, y + i * heightperChar, 0);
                    continue;
                }
                g.drawString(str.substring(i * charsPerLine), x, y + i * heightperChar, 0);
            }
            g.setClip(0, 0, 240, 320);
        }
    }

    public static void drawLoadingStr(String str, Graphics g, Font font) {
        int charsWidth = 0;
        int charsHeight = 0;
        int charsPerLine = 0;
        int lines = 0;
        charsWidth = font.charWidth('\u5bbd');
        charsHeight = font.getHeight() + 1;
        charsPerLine = (240 - charsWidth * 4) / charsWidth;
        lines = str.length() % charsPerLine == 0 ? str.length() / charsPerLine : str.length() / charsPerLine + 1;
        String subStr = "";
        for (int i = 0; i < lines; ++i) {
            if (i != lines - 1) {
                subStr = str.substring(i * charsPerLine, (i + 1) * charsPerLine);
                g.setColor(0x585252);
                g.drawString(subStr, 121, 167 - lines / 2 * charsHeight + charsHeight * i, 33);
                g.setColor(0xFFFFFF);
                g.drawString(subStr, 120, 166 - lines / 2 * charsHeight + charsHeight * i, 33);
                continue;
            }
            subStr = str.substring(i * charsPerLine);
            g.setColor(0x585252);
            g.drawString(subStr, 121, 167 - lines / 2 * charsHeight + charsHeight * i, 33);
            g.setColor(0xFFFFFF);
            g.drawString(subStr, 120, 166 - lines / 2 * charsHeight + charsHeight * i, 33);
        }
        g.setClip(0, 0, 240, 320);
    }

    public static final void scrollStringInRect(Graphics g, String str, int x, int y, int w, int h) {
        if (str == null || str == "") {
            return;
        }
        if (!strPrevious.equals(str)) {
            scrollPos = 0;
            strPrevious = str;
        }
        g.setClip(x, y, w - 3, h);
        g.drawString(str, x - scrollPos, y, 20);
        if ((scrollPos += 3) > dConfig.F_SMALL.stringWidth(str)) {
            scrollPos = -w;
        }
        g.setClip(0, 0, 300, 380);
    }

    public static final void drawStringInRect(Graphics g, String str, int x, int y, int w, int h, int lineHeight, int color) {
        int realLineCount;
        g.setFont(dConfig.F_SMALL);
        g.setColor(color);
        int strPerLine = w / dConfig.SF_WIDTH;
        int lineCount = h / lineHeight;
        if (str.length() / strPerLine < lineCount) {
            realLineCount = str.length() / strPerLine;
            if (str.length() % strPerLine != 0) {
                ++realLineCount;
            }
        } else {
            realLineCount = lineCount;
        }
        for (int i = 0; i < realLineCount; ++i) {
            if (i == realLineCount - 1) {
                g.drawString(str.substring(strPerLine * i, str.length()), x, y + lineHeight * i, 0);
                continue;
            }
            g.drawString(str.substring(strPerLine * i, strPerLine * (i + 1)), x, y + lineHeight * i, 0);
        }
    }

    public static void drawAutoLineString(Graphics g, String str, int x, int y, int width) {
        if (str != null) {
            int i;
            int length = str.length();
            int lineCount = length * dConfig.SF_WIDTH / width + 1;
            int perLineCount = width / dConfig.SF_WIDTH;
            String[] strSpilit = new String[lineCount];
            for (i = 0; i < strSpilit.length; ++i) {
                strSpilit[i] = i == strSpilit.length - 1 ? str.substring(i * perLineCount) : str.substring(i * perLineCount, (i + 1) * perLineCount);
            }
            for (i = 0; i < strSpilit.length; ++i) {
                g.drawString(strSpilit[i], x, y + i * dConfig.SF_HEIGHT, 0);
            }
        }
    }

    public static final Image loadImage(String pictureName) {
        Image img = null;
        try {
            String dir = "/";
            img = Image.createImage((String)(dir + pictureName + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public static short[] ZoomImage(Image srcImg, int desW, int desH) {
        int i;
        int srcW = srcImg.getWidth();
        int srcH = srcImg.getHeight();
        short[] srcBuf = new short[srcW * srcH];
        Image desImg = Image.createImage((int)srcW, (int)srcH);
        if (srcImg.isMutable()) {
            DirectUtils.getDirectGraphics((Graphics)srcImg.getGraphics()).getPixels(srcBuf, 0, srcW, 0, 0, srcW, srcH, 444);
        } else {
            desImg.getGraphics().drawImage(srcImg, 0, 0, 0);
            DirectUtils.getDirectGraphics((Graphics)desImg.getGraphics()).getPixels(srcBuf, 0, srcW, 0, 0, srcW, srcH, 444);
        }
        desImg = null;
        short[] tabY = new short[desH];
        short[] tabX = new short[desW];
        int sb = 0;
        int db = 0;
        int tems = 0;
        int temd = 0;
        int distance = srcH > desH ? srcH : desH;
        for (i = 0; i <= distance; ++i) {
            tabY[db] = (short)sb;
            temd += desH;
            if ((tems += srcH) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd <= distance) continue;
            temd -= distance;
            ++db;
        }
        sb = 0;
        db = 0;
        tems = 0;
        temd = 0;
        distance = srcW > desW ? srcW : desW;
        for (i = 0; i <= distance; ++i) {
            tabX[db] = (short)sb;
            temd += desW;
            if ((tems += srcW) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd <= distance) continue;
            temd -= distance;
            ++db;
        }
        short[] desBuf = new short[desW * desH];
        int dx = 0;
        int dy = 0;
        boolean sx = false;
        int sy = 0;
        short oldy = -1;
        for (int i2 = 0; i2 < desH; ++i2) {
            if (oldy == tabY[i2]) {
                System.arraycopy(desBuf, dy - desW, desBuf, dy, desW);
            } else {
                dx = 0;
                for (int j = 0; j < desW; ++j) {
                    desBuf[dy + dx] = srcBuf[sy + tabX[j]];
                    ++dx;
                }
                sy += (tabY[i2] - oldy) * srcW;
            }
            oldy = tabY[i2];
            dy += desW;
        }
        return desBuf;
    }
}

