/*
 * Decompiled with CFR 0.152.
 */
package com.unigame;

import com.unigame.GameObject;
import com.unigame.Layer;
import com.unigame.VisualObject;
import com.unigame.util.RAList;

public class State {
    private RAList _objects;
    private Layer[] _layers;

    public State(int n, Layer[] layerArray) {
        int n2 = n;
        if (layerArray != null) {
            this._layers = new Layer[layerArray.length];
            for (int i = 0; i < layerArray.length; ++i) {
                this._layers[i] = layerArray[i];
                n2 += layerArray[i].getMaxVisualObject();
            }
            this._objects = new RAList(n2);
        }
    }

    public void onMessage(int n, int n2, int n3, int n4) {
    }

    public void onFrame(long l) {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onEnter() {
    }

    public void onLeave() {
    }

    public void onDestroy() {
    }

    public int addGameObject(GameObject gameObject) {
        int n = this._objects.insert(gameObject);
        gameObject.setProperty(0, n);
        return n;
    }

    public int addVisualObject(VisualObject visualObject, int n) {
        int n2 = this._objects.insert(visualObject);
        if (n2 >= 0) {
            this._layers[n].registerVisualObject(n2);
            visualObject.setProperty(0, n2);
            visualObject.setProperty(1, n);
        } else {
            System.out.println("UniGame: addVisualObject failed.");
        }
        return n2;
    }

    public void deleteGameObject(int n) {
        GameObject gameObject = this.getGameObject(n);
        if (gameObject != null) {
            int n2 = gameObject.getProperty(1);
            if (n2 >= 0) {
                this._layers[n2].unregisterVisualObject(n);
            }
            this._objects.delete(n);
        }
    }

    public void removeAllGameObject() {
        this._objects.clear();
        for (int i = 0; i < this._layers.length; ++i) {
            for (int j = 0; j < this._layers[i]._objindex.length; ++j) {
                this._layers[i]._objindex[j] = -1;
            }
        }
    }

    public GameObject getGameObject(int n) {
        return (GameObject)this._objects.get(n);
    }

    public void update(long l) {
        this._objects.cacheOperation();
        int n = 0;
        int n2 = 0;
        while (n < this._objects.size()) {
            GameObject gameObject = (GameObject)this._objects.get(n2);
            if (gameObject != null) {
                ++n;
                gameObject.onFrame(l);
            }
            ++n2;
        }
        this._objects.flushOperation();
    }

    public void render(long l) {
        for (int i = 0; i < this._layers.length; ++i) {
            this._layers[i].onRender(l);
        }
    }
}

