/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.unigame.Layer;
import com.unigame.SortedLayer;
import com.unigame.State;
import com.unigame.UniGame;
import com.unigame.VisualObject;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import logic.Background;
import logic.Effect;
import logic.GameLogic;
import logic.Helper;
import logic.PauseButton;
import logic.Progress;
import logic.Role;
import logic.SheepButton;
import logic.SkillButton;
import logic.TouchZoneManager;
import logic.UnlockMsg;
import logic.data.Pawn;
import logic.data.Stage;
import logic.uiStuff;
import shell.Define;
import shell.GameRecord;
import shell.Utility;
import shell.cMidlet;

public class PlayState
extends State
implements Define {
    private int ui;
    private long _resadd;
    public static int _select;
    private boolean keyLeft;
    private boolean keyRight;
    public static long currTime;
    public static boolean paused;
    public static int HeroControl;
    private TouchZoneManager _tzm;
    public static int state;

    public PlayState(int n) {
        super(10, new Layer[]{new Layer(1), new SortedLayer(64), new Layer(32), new Layer(16)});
        GameLogic.level = n;
        this._tzm = new TouchZoneManager();
        this.reset();
    }

    public void reset() {
        this.removeAllGameObject();
        this._tzm.reset();
        GameLogic.initGame();
        paused = false;
        this._resadd = 0L;
        currTime = 0L;
        state = 0;
        HeroControl = 0;
        GameLogic.ID_bg = this.addVisualObject(new Background(), 0);
        GameLogic.ID_progress = this.addVisualObject(new Progress(), 3);
        this.ui = this.addVisualObject(new uiStuff(), 3);
        int n = this.addVisualObject(Pawn.createHero(), 1);
        GameLogic.regSheep(n);
        GameLogic.ID_hero = n;
        if (GameRecord.currlevel >= 16 || GameRecord.unlocks[9]) {
            this.addVisualObject(Pawn.createSheep(6), 1);
        }
        if (GameRecord.currlevel >= 14 || GameRecord.unlocks[10]) {
            this.addVisualObject(Pawn.createSheep(8), 1);
        }
        n = this.addVisualObject(new SkillButton(GameRecord.unlocks[1] ? 1 : 0, 0), 2);
        this._tzm.registerZone(n, 115, 15, 29, 29);
        n = this.addVisualObject(new SkillButton(GameRecord.unlocks[2] ? 2 : 0, 1), 2);
        this._tzm.registerZone(n, 150, 15, 29, 29);
        n = this.addVisualObject(new SkillButton(GameRecord.unlocks[3] ? 3 : 0, 2), 2);
        this._tzm.registerZone(n, 185, 15, 29, 29);
        n = this.addVisualObject(new SheepButton(GameRecord.unlocks[4] ? 1 : 0, 0), 3);
        this._tzm.registerZone(n, 58, 291, 29, 29);
        n = this.addVisualObject(new SheepButton(GameRecord.unlocks[5] ? 2 : 0, 1), 3);
        this._tzm.registerZone(n, 87, 291, 29, 29);
        n = this.addVisualObject(new SheepButton(GameRecord.unlocks[6] ? 3 : 0, 2), 3);
        this._tzm.registerZone(n, 116, 291, 29, 29);
        n = this.addVisualObject(new SheepButton(GameRecord.unlocks[7] ? 4 : 0, 3), 3);
        this._tzm.registerZone(n, 145, 291, 29, 29);
        n = this.addVisualObject(new SheepButton(GameRecord.unlocks[8] ? 5 : 0, 4), 3);
        this._tzm.registerZone(n, 174, 291, 29, 29);
        n = this.addVisualObject(new PauseButton(), 3);
        this._tzm.registerZone(n, 190, 270, 50, 50);
    }

    public void onEnter() {
        this.addVisualObject(new Helper(), 3);
        if (GameRecord.sfx) {
            Utility.stopAllSounds();
            if (GameRecord.currlevel == 20) {
                Utility.playSoundLoop(0);
            } else {
                Utility.playSoundLoop(0);
            }
        }
        this.keyLeft = false;
        this.keyRight = false;
    }

    public void onPause() {
        if (GameRecord.sfx) {
            if (GameRecord.currlevel == 20) {
                Utility.stopSound(0);
            } else {
                Utility.stopSound(0);
            }
        }
    }

    public void onResume() {
        if (GameRecord.sfx) {
            if (GameRecord.currlevel == 20) {
                Utility.playSoundLoop(0);
            } else {
                Utility.playSoundLoop(0);
            }
        }
    }

    public void onFrame(long l) {
        GameLogic.reorderRole();
        if (!paused && state == 0) {
            currTime += l;
            this._resadd += l;
            int n = (int)(this._resadd / 1500L);
            this._resadd -= (long)(n * 1500);
            if ((GameLogic.resource += GameRecord.renkou * n) > 50) {
                GameLogic.resource = 50;
            }
        }
    }

    public void onMessage(int n, int n2, int n3, int n4) {
        block0 : switch (n2) {
            case 3: {
                if (state != 0) break;
                System.out.println("MSG_GAMEOVER");
                state = 2;
                GameRecord.instance().write();
                break;
            }
            case 6: {
                if (state != 0) break;
                System.out.println("MSG_WIN");
                state = 1;
                int n5 = Stage.getUnlock(GameLogic.level);
                if (n5 >= 0 && !GameRecord.unlocks[n5]) {
                    GameRecord.unlocks[n5] = true;
                    new UnlockMsg(Stage.getUnlockIcon(GameLogic.level));
                }
                if (++GameRecord.currlevel > 20) {
                    GameRecord.currlevel = 0;
                    ++GameRecord.hardcore;
                } else {
                    GameRecord.money += GameRecord.jinbi * LEVEL_BOUNS[GameLogic.level];
                }
                GameRecord.instance().write();
                break;
            }
            case 0: {
                VisualObject visualObject;
                if (paused || state != 0) {
                    UniGame.sendObjectMessage(this.ui, -2, 0, n3, n4);
                    break;
                }
                if (this._tzm.onPressed(n3, n4) || (visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_hero)) == null) break;
                int n6 = ((VisualObject)UniGame.getGameObject((int)GameLogic.ID_bg)).x;
                int n7 = visualObject.x - n6;
                if (n3 < n7) {
                    HeroControl = 1;
                    break;
                }
                HeroControl = 2;
                break;
            }
            case 1: {
                VisualObject visualObject;
                if (paused || state != 0) {
                    UniGame.sendObjectMessage(this.ui, -2, 1, n3, n4);
                    break;
                }
                if (this._tzm.onMoved(n3, n4) || (visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_hero)) == null) break;
                int n8 = ((VisualObject)UniGame.getGameObject((int)GameLogic.ID_bg)).x;
                int n9 = visualObject.x - n8;
                if (n3 < n9) {
                    HeroControl = 1;
                    break;
                }
                HeroControl = 2;
                break;
            }
            case 2: {
                if (paused || state != 0) {
                    UniGame.sendObjectMessage(this.ui, -2, 2, n3, n4);
                    break;
                }
                if (this._tzm.onReleased(n3, n4)) break;
                HeroControl = 0;
                break;
            }
            case 7: {
                Role role = Pawn.createSheep(n3);
                if (n4 == 0) {
                    int n10 = UniGame.addVisualObject(role, 1);
                    GameLogic.regSheep(n10);
                    break;
                }
                int n11 = UniGame.addVisualObject(role, 1);
                GameLogic.regSheep(n11);
                role.x = n4;
                new Effect(0, role.x, role.y);
                break;
            }
            case 8: {
                switch (n3) {
                    case 1: {
                        UniGame.postObjectMessage(GameLogic.ID_hero, -2, 9, 0, 0);
                        break;
                    }
                    case 2: {
                        VisualObject visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_hero);
                        if (visualObject == null) break block0;
                        for (int i = 0; i < GameRecord.upgrades[2] + 1; ++i) {
                            int n12 = visualObject.x - Utility.rndInt(100);
                            UniGame.postStateMessage(-3, 7, 1, n12);
                        }
                        break block0;
                    }
                    case 3: {
                        VisualObject visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_hero);
                        if (visualObject != null) {
                            new Effect(2, visualObject.x, visualObject.y);
                            if (GameRecord.vibrate) {
                                Display.getDisplay((MIDlet)cMidlet.instance).vibrate(500);
                            }
                            int n13 = visualObject.x - 400;
                            int n14 = visualObject.x + 400;
                            for (int i = 0; i < 20; ++i) {
                                VisualObject visualObject2 = (VisualObject)UniGame.getGameObject(GameLogic.ID_wolves[i]);
                                if (visualObject2 == null || visualObject2.x <= n13 || visualObject2.x >= n14) continue;
                                UniGame.postObjectMessage(GameLogic.ID_wolves[i], GameLogic.ID_hero, 4, STONE_DMG[GameRecord.upgrades[3]], 0);
                            }
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
            case 10: {
                _select = 0;
                if (n3 == 0) {
                    paused = true;
                    break;
                }
                paused = false;
                break;
            }
            case 11: {
                this.reset();
                break;
            }
            case 12: {
                if (n3 == -3) {
                    this.keyLeft = true;
                }
                if (n3 == -4) {
                    this.keyRight = true;
                }
                if (paused) {
                    if (n3 == -1 && --_select < 0) {
                        _select = 0;
                    }
                    if (n3 == -2 && ++_select > 2) {
                        _select = 2;
                    }
                    if (n3 != -5) break;
                    switch (_select) {
                        case 0: {
                            UniGame.postStateMessage(-3, 11, 0, 0);
                            break;
                        }
                        case 1: {
                            UniGame.postStateMessage(-3, 10, 1, 0);
                            break;
                        }
                        case 2: {
                            GameLogic.allclear = true;
                            UniGame.popState();
                        }
                    }
                    break;
                }
                if (state == 0) {
                    this.checkKey();
                    if (n3 == 49 || n3 == 114) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(0), -2, 2, 0, 0);
                    }
                    if (n3 == 50 || n3 == 116) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(1), -2, 2, 0, 0);
                    }
                    if (n3 == 51 || n3 == 121) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(2), -2, 2, 0, 0);
                    }
                    if (n3 == 52 || n3 == 102) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(3), -2, 2, 0, 0);
                    }
                    if (n3 == 53 || n3 == 103) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(4), -2, 2, 0, 0);
                    }
                    if (n3 == 54 || n3 == 104) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(5), -2, 2, 0, 0);
                    }
                    if (n3 == 55 || n3 == 118) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(6), -2, 2, 0, 0);
                    }
                    if (n3 == 56 || n3 == 98) {
                        UniGame.sendObjectMessage(this._tzm.getZoneId(7), -2, 2, 0, 0);
                    }
                    if (n3 != -7) break;
                    UniGame.sendStateMessage(-3, 10, 0, 0);
                    break;
                }
                if (n3 != -6) break;
                if (state == 1 && GameRecord.currlevel == 0) {
                    GameLogic.allclear = true;
                    UniGame.popState();
                    break;
                }
                if (state == 1) {
                    GameLogic.showstage = true;
                }
                UniGame.popState();
                break;
            }
            case 13: {
                if (n3 == -3) {
                    this.keyLeft = false;
                }
                if (n3 == -4) {
                    this.keyRight = false;
                }
                if (paused || state != 0) break;
                this.checkKey();
            }
        }
    }

    private void checkKey() {
        HeroControl = this.keyRight ? 2 : (this.keyLeft ? 1 : 0);
    }
}

