/*
 * Decompiled with CFR 0.152.
 */
package logic.data;

import logic.Role;
import shell.GameRecord;
import shell.Utility;
import shell.cSprite;

public class Pawn {
    public static final int SHEEP_YANG = 10;
    public static final int SHEEP_FENG = 11;
    public static final int SHEEP_ZHUANG = 12;
    public static final int SHEEP_ZHI = 13;
    public static final int SHEEP_NAI = 14;
    public static final int SHEEP_HERO = 15;
    public static final int SHEEP_TY1 = 16;
    public static final int SHEEP_TY2 = 17;
    public static final int SHEEP_TSC = 18;
    public static final int WOLF_LANG = 0;
    public static final int WOLF_DOU = 1;
    public static final int WOLF_ZHUANG = 2;
    public static final int WOLF_BANG = 4;
    public static final int WOLF_PAO = 3;
    public static final int WOLF_HERO = 5;
    public static final int[] UpgradeHp = new int[]{30, 60, 90, 120};
    public static final int[] UpgradeDamage = new int[]{4, 8, 13, 17};
    public static final int[] UpgradeSeflHeal = new int[]{2, 4, 6, 8};

    public static Role createHero() {
        Role role = new Role();
        role.attack = 14;
        role.cd = 2;
        role.hpmax = role.hp = 100;
        role.movespeed = 172;
        role.offsetx = 0;
        role.offsety = 0;
        role.hpoffx = -14;
        role.hpoffy = -63;
        role.range = 200;
        role.sp = cSprite.createSprite("/sheephero.aspr", new int[]{56});
        role.sp.setAnimation(5, 1000L, true);
        role.type = 15;
        role.selfheal = 2;
        role.x = 200;
        role.y = 250;
        if (GameRecord.upgrades[0] > 0) {
            role.hp += UpgradeHp[GameRecord.upgrades[0] - 1];
            role.hpmax += UpgradeHp[GameRecord.upgrades[0] - 1];
            role.attack += UpgradeDamage[GameRecord.upgrades[0] - 1];
            role.selfheal += UpgradeSeflHeal[GameRecord.upgrades[0] - 1];
        }
        return role;
    }

    public static Role createSheep(int n) {
        switch (n) {
            case 1: {
                return Pawn.createYang(GameRecord.upgrades[4]);
            }
            case 2: {
                return Pawn.createFeng(GameRecord.upgrades[5]);
            }
            case 3: {
                return Pawn.createZhuang(GameRecord.upgrades[6]);
            }
            case 4: {
                return Pawn.createZhi(GameRecord.upgrades[7]);
            }
            case 5: {
                return Pawn.createNai(GameRecord.upgrades[8]);
            }
            case 6: {
                return Pawn.createTY1(GameRecord.upgrades[9]);
            }
            case 7: {
                return Pawn.createTY2(GameRecord.upgrades[9]);
            }
            case 8: {
                return Pawn.createTSC(GameRecord.upgrades[10]);
            }
        }
        return null;
    }

    public static Role createYang(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 10;
                role.cd = 0;
                role.hpmax = role.hp = 35;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 50;
                role.sp = cSprite.createSprite("/sheep1.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 10;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 12;
                role.cd = 0;
                role.hpmax = role.hp = 42;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 50;
                role.sp = cSprite.createSprite("/sheep1.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 10;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 14;
                role.cd = 0;
                role.hpmax = role.hp = 49;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 50;
                role.sp = cSprite.createSprite("/sheep1.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 10;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 16;
                role.cd = 0;
                role.hpmax = role.hp = 56;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 50;
                role.sp = cSprite.createSprite("/sheep1.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 10;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 18;
                role.cd = 0;
                role.hpmax = role.hp = 63;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 50;
                role.sp = cSprite.createSprite("/sheep1.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 10;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
        }
        return null;
    }

    public static Role createFeng(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 22;
                role.cd = 0;
                role.hpmax = role.hp = 40;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 60;
                role.sp = cSprite.createSprite("/sheep2.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 11;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 26;
                role.cd = 0;
                role.hpmax = role.hp = 48;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 60;
                role.sp = cSprite.createSprite("/sheep2.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 11;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 31;
                role.cd = 0;
                role.hpmax = role.hp = 56;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 60;
                role.sp = cSprite.createSprite("/sheep2.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 11;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 35;
                role.cd = 0;
                role.hpmax = role.hp = 64;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 60;
                role.sp = cSprite.createSprite("/sheep2.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 11;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 40;
                role.cd = 0;
                role.hpmax = role.hp = 72;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 60;
                role.sp = cSprite.createSprite("/sheep2.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 11;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
        }
        return null;
    }

    public static Role createZhuang(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 0;
                role.cd = 2;
                role.hpmax = role.hp = 200;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 40;
                role.sp = cSprite.createSprite("/sheep3.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 12;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 0;
                role.cd = 2;
                role.hpmax = role.hp = 240;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 40;
                role.sp = cSprite.createSprite("/sheep3.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 12;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 0;
                role.cd = 2;
                role.hpmax = role.hp = 280;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 40;
                role.sp = cSprite.createSprite("/sheep3.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 12;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 0;
                role.cd = 2;
                role.hpmax = role.hp = 320;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 40;
                role.sp = cSprite.createSprite("/sheep3.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 12;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 0;
                role.cd = 2;
                role.hpmax = role.hp = 360;
                role.movespeed = 45;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 40;
                role.sp = cSprite.createSprite("/sheep3.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 12;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
        }
        return null;
    }

    public static Role createZhi(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 14;
                role.cd = 0;
                role.hpmax = role.hp = 30;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 120;
                role.sp = cSprite.createSprite("/sheep4.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 13;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 17;
                role.cd = 0;
                role.hpmax = role.hp = 36;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 120;
                role.sp = cSprite.createSprite("/sheep4.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 13;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 20;
                role.cd = 0;
                role.hpmax = role.hp = 42;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 120;
                role.sp = cSprite.createSprite("/sheep4.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 13;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 22;
                role.cd = 0;
                role.hpmax = role.hp = 48;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 120;
                role.sp = cSprite.createSprite("/sheep4.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 13;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 25;
                role.cd = 0;
                role.hpmax = role.hp = 54;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 120;
                role.sp = cSprite.createSprite("/sheep4.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 13;
                role.x = -100;
                role.y = Utility.rndInt(50) + 260;
                return role;
            }
        }
        return null;
    }

    public static Role createTY1(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 35;
                role.cd = 2;
                role.hpmax = role.hp = 30;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 16;
                role.x = 125;
                role.y = 150;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 42;
                role.cd = 4;
                role.hpmax = role.hp = 36;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 16;
                role.x = 125;
                role.y = 150;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 49;
                role.cd = 4;
                role.hpmax = role.hp = 42;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 16;
                role.x = 125;
                role.y = 150;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 56;
                role.cd = 4;
                role.hpmax = role.hp = 48;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 16;
                role.x = 125;
                role.y = 150;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 63;
                role.cd = 4;
                role.hpmax = role.hp = 54;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 16;
                role.x = 125;
                role.y = 150;
                return role;
            }
        }
        return null;
    }

    public static Role createTY2(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 35;
                role.cd = 2;
                role.hpmax = role.hp = 30;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 17;
                role.x = 150;
                role.y = 117;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 42;
                role.cd = 4;
                role.hpmax = role.hp = 36;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 17;
                role.x = 150;
                role.y = 117;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 49;
                role.cd = 4;
                role.hpmax = role.hp = 42;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 17;
                role.x = 150;
                role.y = 117;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 56;
                role.cd = 4;
                role.hpmax = role.hp = 48;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 17;
                role.x = 150;
                role.y = 117;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 63;
                role.cd = 4;
                role.hpmax = role.hp = 54;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/sheep6.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 17;
                role.x = 150;
                role.y = 117;
                return role;
            }
        }
        return null;
    }

    public static Role createTSC(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 32;
                role.cd = 3;
                role.hpmax = role.hp = 30;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 200;
                role.sp = cSprite.createSprite("/stonefall.aspr", new int[]{65});
                role.sp.setAnimation(2, 1000L, false);
                role.type = 18;
                role.x = 255;
                role.y = 225;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 38;
                role.cd = 3;
                role.hpmax = role.hp = 36;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 200;
                role.sp = cSprite.createSprite("/stonefall.aspr", new int[]{65});
                role.sp.setAnimation(2, 1000L, false);
                role.type = 18;
                role.x = 255;
                role.y = 225;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 44;
                role.cd = 3;
                role.hpmax = role.hp = 42;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 250;
                role.sp = cSprite.createSprite("/stonefall.aspr", new int[]{65});
                role.sp.setAnimation(2, 1000L, false);
                role.type = 18;
                role.x = 255;
                role.y = 225;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 50;
                role.cd = 3;
                role.hpmax = role.hp = 48;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 200;
                role.sp = cSprite.createSprite("/stonefall.aspr", new int[]{65});
                role.sp.setAnimation(2, 1000L, false);
                role.type = 18;
                role.x = 255;
                role.y = 225;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 63;
                role.cd = 3;
                role.hpmax = role.hp = 57;
                role.movespeed = 36;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 200;
                role.sp = cSprite.createSprite("/stonefall.aspr", new int[]{65});
                role.sp.setAnimation(2, 1000L, false);
                role.type = 18;
                role.x = 255;
                role.y = 225;
                return role;
            }
        }
        return null;
    }

    public static Role createNai(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 25;
                role.cd = 2;
                role.hpmax = role.hp = 45;
                role.movespeed = 27;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 150;
                role.sp = cSprite.createSprite("/sheep5.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 14;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 30;
                role.cd = 2;
                role.hpmax = role.hp = 54;
                role.movespeed = 27;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 150;
                role.sp = cSprite.createSprite("/sheep5.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 14;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 35;
                role.cd = 2;
                role.hpmax = role.hp = 63;
                role.movespeed = 27;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 150;
                role.sp = cSprite.createSprite("/sheep5.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 14;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 40;
                role.cd = 2;
                role.hpmax = role.hp = 72;
                role.movespeed = 27;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 150;
                role.sp = cSprite.createSprite("/sheep5.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 14;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 45;
                role.cd = 2;
                role.hpmax = role.hp = 81;
                role.movespeed = 27;
                role.offsetx = 0;
                role.offsety = 0;
                role.hpoffx = -12;
                role.hpoffy = -62;
                role.range = 150;
                role.sp = cSprite.createSprite("/sheep5.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 14;
                role.x = -100;
                role.y = Utility.rndInt(60) + 220;
                return role;
            }
        }
        return null;
    }

    public static Role createWolf(int n) {
        switch (n) {
            case 0: {
                Role role = new Role();
                role.attack = 8;
                role.cd = 0;
                role.hpmax = role.hp = 25;
                role.movespeed = 45;
                role.offsetx = -18;
                role.offsety = 0;
                role.hpoffx = 5;
                role.hpoffy = -55;
                role.range = 50 + Utility.rndInt(10);
                role.sp = cSprite.createSprite("/wolf1.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 0;
                role.x = 500;
                role.y = Utility.rndInt(60) + 220;
                if (GameRecord.hardcore > 0) {
                    role.hp = role.hp * 15 / 10;
                    role.hpmax = role.hpmax * 15 / 10;
                }
                return role;
            }
            case 1: {
                Role role = new Role();
                role.attack = 20;
                role.cd = 0;
                role.hpmax = role.hp = 30;
                role.movespeed = 36;
                role.offsetx = -18;
                role.offsety = 0;
                role.hpoffx = 5;
                role.hpoffy = -55;
                role.range = 60 + Utility.rndInt(10);
                role.sp = cSprite.createSprite("/wolf2.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 1;
                role.x = 500;
                role.y = Utility.rndInt(60) + 220;
                if (GameRecord.hardcore > 0) {
                    role.hp = role.hp * 15 / 10;
                    role.hpmax = role.hpmax * 15 / 10;
                }
                return role;
            }
            case 2: {
                Role role = new Role();
                role.attack = 0;
                role.cd = 4;
                role.hpmax = role.hp = 180;
                role.movespeed = 45;
                role.offsetx = -18;
                role.offsety = 0;
                role.hpoffx = 5;
                role.hpoffy = -55;
                role.range = 40;
                role.sp = cSprite.createSprite("/wolf3.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 2;
                role.x = 500;
                role.y = Utility.rndInt(60) + 220;
                if (GameRecord.hardcore > 0) {
                    role.hp = role.hp * 15 / 10;
                    role.hpmax = role.hpmax * 15 / 10;
                }
                return role;
            }
            case 4: {
                Role role = new Role();
                role.attack = 18;
                role.cd = 0;
                role.hpmax = role.hp = 100;
                role.movespeed = 27;
                role.offsetx = -18;
                role.offsety = 0;
                role.hpoffx = 5;
                role.hpoffy = -55;
                role.range = 60 + Utility.rndInt(10);
                role.sp = cSprite.createSprite("/wolf5.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 4;
                role.x = 500;
                role.y = Utility.rndInt(60) + 220;
                if (GameRecord.hardcore > 0) {
                    role.hp = role.hp * 15 / 10;
                    role.hpmax = role.hpmax * 15 / 10;
                }
                return role;
            }
            case 3: {
                Role role = new Role();
                role.attack = 12;
                role.cd = 0;
                role.hpmax = role.hp = 20;
                role.movespeed = 36;
                role.offsetx = -18;
                role.offsety = 0;
                role.hpoffx = 5;
                role.hpoffy = -55;
                role.range = 120 + Utility.rndInt(10);
                role.sp = cSprite.createSprite("/wolf4.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 3;
                role.x = 500;
                role.y = Utility.rndInt(60) + 220;
                if (GameRecord.hardcore > 0) {
                    role.hp = role.hp * 15 / 10;
                    role.hpmax = role.hpmax * 15 / 10;
                }
                return role;
            }
            case 5: {
                Role role = new Role();
                role.attack = 20;
                role.cd = 0;
                role.hpmax = role.hp = 1350;
                role.movespeed = 36;
                role.offsetx = -18;
                role.offsety = 0;
                role.hpoffx = 5;
                role.hpoffy = -95;
                role.range = 120 + Utility.rndInt(10);
                role.sp = cSprite.createSprite("/wolfhero.aspr", new int[]{56});
                role.sp.setAnimation(0, 1000L, true);
                role.type = 5;
                role.x = 500;
                role.y = 250;
                if (GameRecord.hardcore > 0) {
                    role.hp = role.hp * 15 / 10;
                    role.hpmax = role.hpmax * 15 / 10;
                }
                return role;
            }
        }
        return null;
    }
}

