/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.unigame.UniGame;
import com.unigame.VisualObject;
import javax.microedition.lcdui.Image;
import logic.GameLogic;
import logic.PlayState;
import shell.Utility;

public class Bullet
extends VisualObject {
    private int _offx;
    private int _offy;
    private int _to;
    private int _from;
    private int _type;
    private int _sx;
    private int _sy;
    private int _dx;
    private int _dy;
    private int _mx;
    private int _my;
    private int _damage;
    private long _timer;
    private int _dist;
    private int _run;
    private int _ddx;
    private int _ddy;

    public Bullet(int n, int n2, int n3, int n4) {
        this._type = n;
        this._damage = n4;
        this._to = n3;
        this._from = n2;
        VisualObject visualObject = (VisualObject)UniGame.getGameObject(n2);
        VisualObject visualObject2 = (VisualObject)UniGame.getGameObject(n3);
        if (visualObject != null && visualObject2 != null) {
            this._ddx = visualObject2.x;
            this._ddy = visualObject2.y;
            this._sx = visualObject.x;
            if (this._type == 0 || this._type == 1) {
                this._sy = visualObject.y - 55;
            } else if (this._type == 2) {
                this._sy = visualObject.y - 55 + 30;
            } else if (this._type == 3) {
                this._sy = visualObject.y - 55 - 10;
                this._sx = visualObject.x + 20;
            }
            this._dx = visualObject2.x;
            this._dy = visualObject2.y - 55;
            this._mx = (this._sx + this._dx) / 2;
            this._my = (this._sy + this._dy) / 2 - Utility.rndInt(120);
            this._timer = 0L;
            this._dist = Math.abs(this._sx - this._dx);
            this._run = 0;
            Image image = Utility.getImage(61 + n);
            this._offx = image.getWidth() / 2;
            this._offy = image.getHeight() / 2;
            UniGame.addVisualObject(this, 2);
        }
    }

    public void onFrame(long l) {
        if (PlayState.paused) {
            return;
        }
        VisualObject visualObject = (VisualObject)UniGame.getGameObject(this._to);
        if (visualObject != null) {
            this._dx = visualObject.x;
            this._dy = visualObject.y - 55;
            this._ddx = visualObject.x;
            this._ddy = visualObject.y;
        } else {
            this._dx = this._ddx;
            this._dy = this._ddy - 55;
        }
        this._timer += l;
        int n = (int)(this._timer * 200L / 1000L);
        this._run += n;
        this._timer -= (long)(1000 * n / 200);
        if (this._run >= this._dist) {
            UniGame.postObjectMessage(this._to, this._from, 4, this._damage, 0);
            UniGame.deleteGameObject(this.getProperty(0));
        } else {
            int n2 = 100 * this._run / this._dist;
            int n3 = Utility.lerpInt(this._sx, this._mx, n2);
            int n4 = Utility.lerpInt(this._sy, this._my, n2);
            int n5 = Utility.lerpInt(this._mx, this._dx, n2);
            int n6 = Utility.lerpInt(this._my, this._dy, n2);
            this.x = Utility.lerpInt(n3, n5, n2);
            this.y = Utility.lerpInt(n4, n6, n2);
        }
    }

    public void onRender(long l) {
        int n = ((VisualObject)UniGame.getGameObject((int)GameLogic.ID_bg)).x;
        int n2 = this.x - n;
        Utility.drawImage(61 + this._type, n2 - this._offx, this.y - this._offy);
    }
}

