/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.unigame.UniGame;
import com.unigame.VisualObject;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import logic.Bullet;
import logic.DeathEffect;
import logic.Effect;
import logic.GameLogic;
import logic.Heal;
import logic.Item;
import logic.PlayState;
import logic.SelfHeal;
import shell.Define;
import shell.GameRecord;
import shell.MyCanvas;
import shell.Utility;
import shell.cMidlet;
import shell.cSprite;

public class Role
extends VisualObject
implements Define {
    private static final int APPROCH_DISTANCE = 300;
    public static final int PID_HP = 2;
    public static final int PID_HPMAX = 3;
    public cSprite sp;
    public int type;
    public int hpmax;
    public int hp;
    public int movespeed;
    public int attack;
    public int range;
    public int cd;
    public int offsetx;
    public int offsety;
    public int hpoffx;
    public int hpoffy;
    public int selfheal;
    private int _selfhealcd = 1000;
    private boolean _pang = false;
    private int _act = 0;
    private int _moveadd = 0;
    private int _target;
    private boolean _attacked;
    private long _cdtimer = 0L;
    private long _towercd = 4000L;

    public void onMessage(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 4: {
                if (this.type == 5 && this._act == 3) {
                    return;
                }
                this.hp -= n3;
                if (this.hp >= 0) break;
                if (this.type >= 10) {
                    GameLogic.unregSheep(this.getProperty(0));
                    if (this.type == 10) {
                        new DeathEffect(2, this.x, this.y);
                    } else if (this.type == 11) {
                        new DeathEffect(3, this.x, this.y);
                    } else if (this.type == 15) {
                        new DeathEffect(4, this.x, this.y);
                    } else {
                        new DeathEffect(1, this.x, this.y);
                    }
                } else {
                    GameLogic.unregWolf(this.getProperty(0));
                    int n5 = Utility.rndInt(100);
                    if (n5 < 25) {
                        new Item(0, this.x, this.y);
                    } else if (n5 < 51) {
                        new Item(1, this.x, this.y);
                    }
                    if (this.type == 5) {
                        new Effect(5, this.x, this.y);
                        new Effect(6, this.x, this.y);
                    } else {
                        new DeathEffect(0, this.x, this.y);
                    }
                }
                UniGame.deleteGameObject(this.getProperty(0));
                if (this.type != 15) break;
                UniGame.postStateMessage(this.getProperty(0), 3, 0, 0);
                break;
            }
            case 5: {
                this.hp += n3;
                if (this.hp <= this.hpmax) break;
                this.hp = this.hpmax;
                break;
            }
            case 9: {
                this._pang = true;
                this.sp.setAnimation(2, 500L, false);
                this._act = 3;
            }
        }
    }

    public void onFrame(long l) {
        if (PlayState.paused) {
            return;
        }
        this._selfhealcd = (int)((long)this._selfhealcd - l);
        if (this._selfhealcd <= 0) {
            new SelfHeal(this.selfheal);
            this._selfhealcd = 1000;
        }
        switch (this.type) {
            case 10: 
            case 11: 
            case 13: {
                if (PlayState.state != 0) break;
                this.aiSheepMelee(l);
                break;
            }
            case 12: {
                this.aiSheepDefend(l);
                break;
            }
            case 16: 
            case 17: {
                this.aiSheepTower(l);
                break;
            }
            case 18: {
                this.aiSheepTSC(l);
                break;
            }
            case 14: {
                this.aiSheepHealer(l);
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                this.aiWolfMelee(l);
                break;
            }
            case 2: {
                this.aiWolfDefend(l);
                break;
            }
            case 5: {
                this.aiWolfHero(l);
                break;
            }
            case 15: {
                if (PlayState.state != 0) break;
                this.aiSheepHero(l);
            }
        }
        if (this.x < 0 && this.type < 10) {
            UniGame.postStateMessage(this.getProperty(0), 3, 0, 0);
        }
    }

    public void onRender(long l) {
        int n;
        int n2;
        int n3;
        if (PlayState.paused) {
            l = 0L;
        }
        int n4 = ((VisualObject)UniGame.getGameObject((int)GameLogic.ID_bg)).x;
        int n5 = this.x - n4;
        this.sp.x = n5 + this.offsetx;
        this.sp.y = this.y + this.offsety;
        boolean bl = this.sp.playAnimation(l);
        if (!bl && this._act == 2) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 10: 
                case 11: {
                    UniGame.postObjectMessage(this._target, this.getProperty(0), 4, this.attack, 0);
                    break;
                }
                case 13: {
                    new Bullet(0, this.getProperty(0), this._target, this.attack);
                    break;
                }
                case 3: {
                    new Bullet(1, this.getProperty(0), this._target, this.attack);
                    break;
                }
                case 16: 
                case 17: {
                    new Bullet(2, this.getProperty(0), this._target, this.attack);
                    break;
                }
                case 18: {
                    new Bullet(3, this.getProperty(0), this._target, this.attack);
                }
            }
            this._attacked = true;
        } else if (!bl && this._act == 3 && this.type == 14) {
            new Heal(this._target, this.attack);
            this._attacked = true;
        } else if (!bl && this._act == 3 && this.type == 15) {
            if (this._pang) {
                new Effect(1, this.x + 80, this.y);
                if (GameRecord.vibrate) {
                    Display.getDisplay((MIDlet)cMidlet.instance).vibrate(500);
                }
                n3 = this.x + 40;
                n2 = this.x + 120;
                for (n = 0; n < 20; ++n) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_wolves[n]);
                    if (visualObject == null || visualObject.x <= n3 || visualObject.x >= n2) continue;
                    UniGame.postObjectMessage(GameLogic.ID_wolves[n], GameLogic.ID_hero, 4, PANG_DMG[GameRecord.upgrades[1]], 0);
                }
                this._pang = false;
                this._act = 0;
                this.sp.setAnimation(5, 1000L, true);
            } else {
                this._attacked = true;
            }
        }
        if (this.hp < this.hpmax) {
            n3 = this.sp.x + this.hpoffx;
            n2 = this.sp.y + this.hpoffy;
            MyCanvas.g.setColor(0);
            MyCanvas.g.drawRect(n3, n2, 26, 4);
            n = 25 * this.hp / this.hpmax;
            MyCanvas.g.setColor(39430);
            MyCanvas.g.fillRect(n3 + 1, n2 + 1, n, 3);
        }
    }

    public int getProperty(int n) {
        if (n == 2) {
            return this.hp;
        }
        if (n == 3) {
            return this.hpmax;
        }
        return super.getProperty(n);
    }

    public boolean setProperty(int n, int n2) {
        if (n == 2) {
            this.hp = n2;
            return true;
        }
        if (n == 3) {
            this.hpmax = n2;
            return true;
        }
        return super.setProperty(n, n2);
    }

    private void aiSheepMelee(long l) {
        switch (this._act) {
            case 1: {
                int n;
                this._moveadd = (int)((long)this._moveadd + l);
                int n2 = this._moveadd * this.movespeed / 1000;
                this.x += n2;
                this._moveadd -= 1000 * n2 / this.movespeed;
                if (this.x > 460) {
                    this.x = 460;
                }
                if ((n = this.sheepSeekTarget()) < 0) break;
                VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                int n3 = visualObject.x - this.x;
                if (n3 > this.range && n3 < 300) {
                    int n4 = visualObject.y - this.y;
                    if (Math.abs(n4) <= 10) break;
                    if (n4 > 0) {
                        ++this.y;
                        break;
                    }
                    --this.y;
                    break;
                }
                if (n3 > this.range) break;
                this.initAttack(n);
                break;
            }
            case 2: {
                if (!this._attacked) break;
                int n = this.sheepSeekTarget();
                if (n >= 0) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                    int n5 = visualObject.x - this.x;
                    if (n5 <= this.range) {
                        this.initAttack(n);
                        break;
                    }
                    this._act = 1;
                    this.sp.setAnimation(0, 1000L, true);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(0, 1000L, true);
                break;
            }
            default: {
                this._act = 1;
            }
        }
    }

    private void aiSheepTSC(long l) {
        switch (this._act) {
            case 1: {
                int n = this.sheepSeekTarget();
                if (n < 0) break;
                VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                int n2 = visualObject.x - this.x;
                if (n2 > this.range || n2 < 100) break;
                this._act = 2;
                this._target = n;
                this._attacked = false;
                this.sp.setAnimation(1, 1000L, false);
                break;
            }
            case 2: {
                if (!this._attacked) break;
                int n = this.sheepSeekTarget();
                if (n >= 0) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                    int n3 = visualObject.x - this.x;
                    if (n3 <= this.range && n3 >= 100) {
                        this._act = 3;
                        this._target = n;
                        this._attacked = false;
                        this.sp.setAnimation(2, 1000L, false);
                        break;
                    }
                    this._act = 1;
                    this.sp.setAnimation(2, 1000L, false);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(2, 1000L, false);
                break;
            }
            case 3: {
                if (this._towercd > 0L) {
                    this._towercd -= l;
                }
                if (this._towercd > 0L) break;
                this._towercd = this.cd * 1000;
                this._act = 1;
                break;
            }
            default: {
                this._act = 1;
            }
        }
    }

    private void aiSheepTower(long l) {
        switch (this._act) {
            case 1: {
                int n = this.sheepSeekTarget();
                if (n < 0) break;
                VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                int n2 = visualObject.x - this.x;
                if (n2 > this.range || n2 < 35) break;
                this._act = 2;
                this._target = n;
                this._attacked = false;
                this.sp.setAnimation(1, 1000L, false);
                break;
            }
            case 2: {
                if (!this._attacked) break;
                int n = this.sheepSeekTarget();
                if (n >= 0) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                    int n3 = visualObject.x - this.x;
                    if (n3 <= this.range && n3 >= 35) {
                        this._act = 3;
                        this._target = n;
                        this._attacked = false;
                        this.sp.setAnimation(0, 1000L, true);
                        break;
                    }
                    this._act = 1;
                    this.sp.setAnimation(0, 1000L, true);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(0, 1000L, true);
                break;
            }
            case 3: {
                if (this._towercd > 0L) {
                    this._towercd -= l;
                }
                if (this._towercd > 0L) break;
                this._towercd = this.cd * 1000;
                this._act = 1;
                break;
            }
            default: {
                this._act = 1;
            }
        }
    }

    private void aiSheepDefend(long l) {
        switch (this._act) {
            case 1: {
                int n;
                this._moveadd = (int)((long)this._moveadd + l);
                int n2 = this._moveadd * this.movespeed / 1000;
                this.x += n2;
                this._moveadd -= 1000 * n2 / this.movespeed;
                if (this.x > 460) {
                    this.x = 460;
                }
                if ((n = this.sheepSeekTarget()) < 0) break;
                VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                int n3 = visualObject.x - this.x;
                if (n3 > this.range && n3 < 300) {
                    int n4 = visualObject.y - this.y;
                    if (Math.abs(n4) <= 10) break;
                    if (n4 > 0) {
                        ++this.y;
                        break;
                    }
                    --this.y;
                    break;
                }
                if (n3 > this.range) break;
                this.initAttack(n);
                break;
            }
            case 2: {
                if (!this._attacked) break;
                int n = this.sheepSeekTarget();
                if (n >= 0) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                    int n5 = visualObject.x - this.x;
                    if (n5 <= this.range) {
                        this.initAttack(n);
                        break;
                    }
                    this._act = 1;
                    this.sp.setAnimation(0, 1000L, true);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(0, 1000L, true);
                break;
            }
            default: {
                this._act = 1;
            }
        }
    }

    private void aiSheepHealer(long l) {
        if (this._cdtimer > 0L) {
            this._cdtimer -= l;
        }
        switch (this._act) {
            case 1: {
                int n;
                this._moveadd = (int)((long)this._moveadd + l);
                int n2 = this._moveadd * this.movespeed / 1000;
                this.x += n2;
                this._moveadd -= 1000 * n2 / this.movespeed;
                if (this.x > 460) {
                    this.x = 460;
                }
                if ((n = this.seekHealTarget()) < 0) break;
                this._target = n;
                this._act = 2;
                this.sp.setAnimation(1, 1000L, true);
                break;
            }
            case 2: {
                if (this._cdtimer > 0L) break;
                this._act = 3;
                this._attacked = false;
                this.sp.setAnimation(2, 1000L, false);
                this._cdtimer = this.cd * 1000;
                break;
            }
            case 3: {
                if (!this._attacked) break;
                int n = this.seekHealTarget();
                if (n >= 0) {
                    this._target = n;
                    this._act = 2;
                    this.sp.setAnimation(1, 1000L, true);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(0, 1000L, true);
                break;
            }
            default: {
                this._act = 1;
            }
        }
    }

    private int wolfSeekTarget() {
        if (GameLogic.sheep_count > 0) {
            VisualObject visualObject;
            int n = -1;
            for (int i = 0; i < 20 && (visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_sheeps[i])) != null; ++i) {
                if (this.x >= visualObject.x) {
                    n = GameLogic.ID_sheeps[i];
                    break;
                }
                if (visualObject == null) break;
            }
            return n;
        }
        return -1;
    }

    private int sheepSeekTarget() {
        if (GameLogic.wolf_count > 0) {
            VisualObject visualObject;
            int n = -1;
            for (int i = 0; i < 20 && (visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_wolves[i])) != null; ++i) {
                if (this.x <= visualObject.x) {
                    n = GameLogic.ID_wolves[i];
                    break;
                }
                if (visualObject == null) break;
            }
            return n;
        }
        return -1;
    }

    private int heroSeekTarget() {
        if (GameLogic.wolf_count > 0) {
            VisualObject visualObject;
            int n = -1;
            for (int i = 0; i < 20 && (visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_wolves[i])) != null; ++i) {
                int n2;
                if (this.x <= visualObject.x && (n2 = visualObject.x - this.x) > 35 && n2 < this.range) {
                    n = GameLogic.ID_wolves[i];
                    break;
                }
                if (visualObject == null) break;
            }
            return n;
        }
        return -1;
    }

    private int seekHealTarget() {
        if (GameLogic.sheep_count > 0) {
            VisualObject visualObject;
            int n = -1;
            for (int i = 0; i < 20 && (visualObject = (VisualObject)UniGame.getGameObject(GameLogic.ID_sheeps[i])) != null; ++i) {
                int n2 = visualObject.getProperty(2);
                int n3 = visualObject.getProperty(3);
                int n4 = Math.abs(visualObject.x - this.x);
                if (n2 < n3 && n4 < this.range) {
                    n = GameLogic.ID_sheeps[i];
                    break;
                }
                if (visualObject == null) break;
            }
            return n;
        }
        return -1;
    }

    private void initAttack(int n) {
        this._act = 2;
        this._target = n;
        this._attacked = false;
        this.sp.setAnimation(1, 1000L, false);
    }

    private void initAttackTank(int n) {
        this._act = 2;
        this._target = n;
        this._attacked = false;
        this.sp.setAnimation(0, 1000L, false);
    }

    private void aiWolfMelee(long l) {
        switch (this._act) {
            case 1: {
                this._moveadd = (int)((long)this._moveadd + l);
                int n = this._moveadd * this.movespeed / 1000;
                this.x -= n;
                this._moveadd -= 1000 * n / this.movespeed;
                int n2 = this.wolfSeekTarget();
                if (n2 < 0) break;
                VisualObject visualObject = (VisualObject)UniGame.getGameObject(n2);
                int n3 = this.x - visualObject.x;
                if (n3 > this.range && n3 < 300) {
                    int n4 = visualObject.y - this.y;
                    if (Math.abs(n4) <= 10) break;
                    if (n4 > 0) {
                        ++this.y;
                        break;
                    }
                    --this.y;
                    break;
                }
                if (n3 > this.range) break;
                this.initAttack(n2);
                break;
            }
            case 2: {
                if (!this._attacked) break;
                int n = this.wolfSeekTarget();
                if (n >= 0) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                    int n5 = this.x - visualObject.x;
                    if (n5 <= this.range) {
                        this.initAttack(n);
                        break;
                    }
                    this._act = 1;
                    this.sp.setAnimation(0, 1000L, true);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(0, 1000L, true);
                break;
            }
            default: {
                this._act = 1;
            }
        }
    }

    private void aiWolfDefend(long l) {
        switch (this._act) {
            case 1: {
                this._moveadd = (int)((long)this._moveadd + l);
                int n = this._moveadd * this.movespeed / 1000;
                this.x -= n;
                this._moveadd -= 1000 * n / this.movespeed;
                int n2 = this.wolfSeekTarget();
                if (n2 < 0) break;
                VisualObject visualObject = (VisualObject)UniGame.getGameObject(n2);
                int n3 = this.x - visualObject.x;
                if (n3 > this.range && n3 < 300) {
                    int n4 = visualObject.y - this.y;
                    if (Math.abs(n4) <= 10) break;
                    if (n4 > 0) {
                        ++this.y;
                        break;
                    }
                    --this.y;
                    break;
                }
                if (n3 > this.range) break;
                this.initAttack(n2);
                break;
            }
            case 2: {
                if (!this._attacked) break;
                int n = this.wolfSeekTarget();
                if (n >= 0) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                    int n5 = this.x - visualObject.x;
                    if (n5 <= this.range) {
                        this.initAttack(n);
                        break;
                    }
                    this._act = 1;
                    this.sp.setAnimation(0, 1000L, true);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(0, 1000L, true);
                break;
            }
            default: {
                this._act = 1;
            }
        }
    }

    private void aiWolfHero(long l) {
        switch (this._act) {
            case 1: {
                this._cdtimer += l;
                if (this._cdtimer > 4000L) {
                    this._cdtimer = 0L;
                    this._act = -1;
                    return;
                }
                this._moveadd = (int)((long)this._moveadd + l);
                int n = this._moveadd * this.movespeed / 1000;
                this.x -= n;
                this._moveadd -= 1000 * n / this.movespeed;
                int n2 = this.wolfSeekTarget();
                if (n2 < 0) break;
                VisualObject visualObject = (VisualObject)UniGame.getGameObject(n2);
                int n3 = this.x - visualObject.x;
                if (n3 > this.range && n3 < 300) {
                    int n4 = visualObject.y - this.y;
                    if (Math.abs(n4) <= 10) break;
                    if (n4 > 0) {
                        ++this.y;
                        break;
                    }
                    --this.y;
                    break;
                }
                if (n3 > this.range) break;
                this.initAttackTank(n2);
                break;
            }
            case 2: {
                if (!this._attacked) break;
                int n = this.wolfSeekTarget();
                if (n >= 0) {
                    VisualObject visualObject = (VisualObject)UniGame.getGameObject(n);
                    int n5 = this.x - visualObject.x;
                    if (n5 <= this.range) {
                        this.initAttackTank(n);
                        break;
                    }
                    this._act = 1;
                    this.sp.setAnimation(1, 1000L, true);
                    break;
                }
                this._act = 1;
                this.sp.setAnimation(1, 1000L, true);
                break;
            }
            case 3: {
                this._cdtimer += l;
                if (this._cdtimer <= 4000L) break;
                this._cdtimer = 0L;
                this._act = -1;
                break;
            }
            default: {
                int n = Utility.rndInt(2);
                if (n == 0) {
                    this._act = 1;
                    this.sp.setAnimation(0, 1000L, true);
                    this._cdtimer = 0L;
                    break;
                }
                this._act = 3;
                this._cdtimer = 0L;
                this.sp.setAnimation(1, 1000L, true);
            }
        }
    }

    private void aiSheepHero(long l) {
        if (this._cdtimer > 0L) {
            this._cdtimer -= l;
        }
        if (this._pang) {
            return;
        }
        if (PlayState.state == 0) {
            switch (PlayState.HeroControl) {
                case 0: {
                    if (this._act != 1 && this._act != 2) break;
                    this._act = 0;
                    this.sp.setAnimation(5, 1000L, true);
                    break;
                }
                case 1: {
                    if (this._act == 1) break;
                    this._act = 1;
                    this.sp.setAnimation(1, 1000L, true);
                    this._moveadd = 0;
                    break;
                }
                case 2: {
                    if (this._act == 2) break;
                    this._act = 2;
                    this.sp.setAnimation(0, 1000L, true);
                    this._moveadd = 0;
                }
            }
        }
        switch (this._act) {
            case 0: {
                int n;
                if (this._cdtimer > 0L || (n = this.heroSeekTarget()) < 0) break;
                this._act = 3;
                this._attacked = false;
                this.sp.setAnimation(2, 500L, false);
                this._cdtimer = 3000L;
                this._target = n;
                break;
            }
            case 1: {
                this._moveadd = (int)((long)this._moveadd + l);
                int n = this._moveadd * this.movespeed / 1000;
                this.x -= n;
                this._moveadd -= 1000 * n / this.movespeed;
                if (this.x > 460) {
                    this.x = 460;
                }
                if (this.x >= 20) break;
                this.x = 20;
                break;
            }
            case 2: {
                this._moveadd = (int)((long)this._moveadd + l);
                int n = this._moveadd * this.movespeed / 1000;
                this.x += n;
                this._moveadd -= 1000 * n / this.movespeed;
                if (this.x <= 460) break;
                this.x = 460;
                break;
            }
            case 3: {
                if (!this._attacked) break;
                this._act = 0;
                UniGame.postObjectMessage(this._target, this.getProperty(0), 4, this.attack, 0);
                this.sp.setAnimation(5, 1000L, true);
            }
        }
    }
}

