/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.Graphics3D;

public class Gate
extends TrackObject {
    private SimpleObject gateway;
    private SimpleObject number;
    private static int numberOfGates = 0;
    private int gateId;
    Vector3D movementPlaneRot = new Vector3D();
    Vector3D leftPillarLoc = new Vector3D();
    Vector3D rightPillarLoc = new Vector3D();
    private static final float pillarDiv = 6.0f;

    public Gate() {
        this.vPosition = new Vector3D();
    }

    public void init(Vector3D location, int id) {
        this.gateway = new SimpleObject();
        this.gateway.init("/Meshes/Other/missiongate.vam", "/Meshes/Other/missiongate.png", 5.0f, false, true);
        this.number = new SimpleObject();
        this.number.init("/Meshes/Other/gatenumber.vam", "/Meshes/Other/mission_0" + (id + 1) + ".png", 5.0f, false, true);
        this.vPosition.set(location);
        this.objectInfo = "gate " + id;
        this.gateId = id;
        ++numberOfGates;
        this.updatePillars();
    }

    public int getGateId() {
        return this.gateId;
    }

    public static void clearGates() {
        numberOfGates = 0;
    }

    public void setGround(float h, Vector3D planeNorm) {
        this.gateway.setPosition(this.vPosition);
        this.gateway.setGroundLevel(h - this.gateway.getHeight());
        this.number.setPosition(this.vPosition);
        this.number.setGroundLevel(h - this.gateway.getHeight());
        this.vPosition.sety(h);
        this.movementPlaneRot.setz(-((float)mMath.toDegrees(mMath.asin(planeNorm.getx()))));
        this.movementPlaneRot.setx((float)mMath.toDegrees(mMath.asin(planeNorm.getz())));
        this.gateway.setRotation(new Vector3D(0.0f, 0.0f, 0.0f));
        this.gateway.setPlaneRotation(this.movementPlaneRot);
        this.gateway.update();
        this.number.setRotation(new Vector3D(0.0f, 0.0f, 0.0f));
        this.number.setPlaneRotation(this.movementPlaneRot);
        this.number.update();
        this.updatePillars();
    }

    public void setTrackRotation(float rot) {
        this.movementPlaneRot.sety(rot);
        this.updatePillars();
    }

    private void updatePillars() {
        Vector3D dir = new Vector3D(0.0f * (float)mMath.cos(mMath.toRadians(this.movementPlaneRot.gety())) + -1.0f * (float)mMath.sin(mMath.toRadians(this.movementPlaneRot.gety())), 0.0f, -0.0f * (float)mMath.sin(mMath.toRadians(this.movementPlaneRot.gety())) + -1.0f * (float)mMath.cos(mMath.toRadians(this.movementPlaneRot.gety())));
        dir.crossProduct(new Vector3D(0.0f, 1.0f, 0.0f));
        dir.normalize();
        this.leftPillarLoc = Vector3D.scalarMul(this.getGateWayWidth() / 2.0f, dir);
        this.leftPillarLoc.add(this.vPosition);
        this.rightPillarLoc = Vector3D.scalarMul(-this.getGateWayWidth() / 2.0f, dir);
        this.rightPillarLoc.add(this.vPosition);
    }

    public float getGateDepth() {
        return this.gateway.getLength() * 0.75f;
    }

    public float getGateHeight() {
        return this.gateway.getHeight() * 0.75f;
    }

    public float getGateTop() {
        return this.gateway.getHeight() * 1.25f;
    }

    public float getPillarWidth() {
        return 2.0f * this.gateway.getWidth() / 6.0f;
    }

    public float getGateWayWidth() {
        return this.gateway.getWidth() * 0.6666667f;
    }

    public Vector3D getLeftPillarLocation() {
        return this.leftPillarLoc;
    }

    public Vector3D getRightPillarLocation() {
        return this.rightPillarLoc;
    }

    public void update(float frame) {
    }

    public void render(Graphics3D g3d) {
        if (!this.sleeping) {
            this.gateway.render(g3d);
            this.number.render(g3d);
        }
    }
}

