/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteX {
    public static final int SPX_HEADER = 1397772888;
    public static final int SPX_VERSION = 33;
    public static final int SPX_BYTE_SEQUENCE_JAVA = 1;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int ANTICLOCKWISE_90 = 0;
    public static final int DEASIL_90 = 1;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int DIRECTION_RIGHT = 4;
    public static final int FRAME_HEADER_SIZE = 8;
    public static final int FRAME_TILE_COUNT_BIT = 1;
    public static final int FRAME_COLLISION_COUNT_BIT = 2;
    public static final int FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    public static final int FRAME_TOP_POS_BIT = 4;
    public static final int FRAME_BOTTOM_POS_BIT = 5;
    public static final int FRAME_LEFT_POS_BIT = 6;
    public static final int FRAME_RIGHT_POS_BIT = 7;
    public static final int ACTION_HEADER_SIZE = 4;
    public static final int ACTION_SEQUENCE_LENGTH_BIT = 1;
    public static final int ACTION_SEQUENCE_DELAY_BIT = 2;
    public static final int ACTION_TRANSFORM_BIT = 3;
    public static final int COLLISION_INTERSECT = 1;
    public static final int COLLISION_INCLUSION = 2;
    private static final int INVERTED_AXES = 4;
    public static final int[][] TRANSFORM_TABLE = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 0, 3, 2, 5, 4, 7, 6}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 2, 1, 0, 7, 6, 5, 4}, {4, 6, 5, 7, 0, 2, 1, 3}, {5, 7, 4, 6, 1, 3, 0, 2}, {6, 4, 7, 5, 2, 0, 3, 1}, {7, 5, 6, 4, 3, 1, 2, 0}};
    public static final int[][] ROTATE_TABLE = new int[][]{{6, 5, 2, 1}, {7, 4, 3, 0}, {4, 7, 0, 3}, {5, 6, 1, 2}, {1, 2, 5, 6}, {0, 3, 4, 7}, {3, 0, 7, 4}, {2, 1, 6, 5}};
    int[][] actionData;
    int actionCount;
    int[][] frameData;
    int frameCount;
    int[][] tileData;
    int tileCount;
    int actionIndex;
    int sequenceIndex;
    Image image;
    int x;
    int y;
    boolean visible;
    long lastTime;
    boolean firstUpdate;
    boolean disableUpdate;

    public SpriteX(String string, Image image) {
        this.loadSpx(string, image);
    }

    boolean isOver() {
        return this.sequenceIndex == this.getSequenceLength() - 1;
    }

    public SpriteX(String string, String string2) {
        Image image = null;
        try {
            image = Image.createImage((String)string2);
        }
        catch (IOException iOException) {
            System.out.println("can't load spx image\n");
        }
        this.loadSpx(string, image);
    }

    public void loadSpx(String string, Image image) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n5 = dataInputStream.readInt();
            if (n5 != 1397772888) {
                throw new Exception("invalid SpriteX format\n");
            }
            byte by = dataInputStream.readByte();
            if (by != 33) {
                throw new Exception("version no matching\n");
            }
            byte by2 = dataInputStream.readByte();
            if (by2 != 1) {
                throw new Exception("byte sequence error\n");
            }
            this.tileCount = dataInputStream.readInt();
            this.tileData = new int[this.tileCount][4];
            for (n4 = 0; n4 < this.tileCount; ++n4) {
                this.tileData[n4][0] = dataInputStream.readInt();
                this.tileData[n4][1] = dataInputStream.readInt();
                this.tileData[n4][2] = dataInputStream.readInt();
                this.tileData[n4][3] = dataInputStream.readInt();
            }
            this.frameCount = dataInputStream.readInt();
            this.frameData = new int[this.frameCount][];
            for (n4 = 0; n4 < this.frameCount; ++n4) {
                int n6 = dataInputStream.readInt();
                int n7 = dataInputStream.readInt();
                int n8 = dataInputStream.readInt();
                n3 = 8 + n6 * 4 + n7 * 4 + n8 * 2;
                this.frameData[n4] = new int[n3];
                this.frameData[n4][0] = n3;
                this.frameData[n4][1] = n6;
                this.frameData[n4][2] = n7;
                this.frameData[n4][3] = n8;
                this.frameData[n4][4] = dataInputStream.readInt();
                this.frameData[n4][5] = dataInputStream.readInt();
                this.frameData[n4][6] = dataInputStream.readInt();
                this.frameData[n4][7] = dataInputStream.readInt();
                n2 = 8;
                for (n = 0; n < n6; ++n) {
                    this.frameData[n4][0 + n2] = dataInputStream.readInt();
                    this.frameData[n4][1 + n2] = dataInputStream.readInt();
                    this.frameData[n4][2 + n2] = dataInputStream.readInt();
                    this.frameData[n4][3 + n2] = dataInputStream.readInt();
                    n2 += 4;
                }
                for (n = 0; n < n7; ++n) {
                    this.frameData[n4][0 + n2] = dataInputStream.readInt();
                    this.frameData[n4][1 + n2] = dataInputStream.readInt();
                    this.frameData[n4][2 + n2] = dataInputStream.readInt();
                    this.frameData[n4][3 + n2] = dataInputStream.readInt();
                    n2 += 4;
                }
                for (n = 0; n < n8; ++n) {
                    this.frameData[n4][0 + n2] = dataInputStream.readInt();
                    this.frameData[n4][1 + n2] = dataInputStream.readInt();
                    n2 += 2;
                }
            }
            this.actionCount = dataInputStream.readInt();
            this.actionData = new int[this.actionCount][];
            for (n4 = 0; n4 < this.actionCount; ++n4) {
                int n9 = dataInputStream.readInt();
                byte by3 = dataInputStream.readByte();
                n3 = by3 == 1 ? 4 + n9 * 2 : 4 + n9;
                this.actionData[n4] = new int[n3];
                this.actionData[n4][0] = n3;
                this.actionData[n4][1] = n9;
                this.actionData[n4][2] = by3;
                this.actionData[n4][3] = dataInputStream.readInt();
                n2 = 4;
                if (by3 == 1) {
                    for (n = 0; n < n9; ++n) {
                        this.actionData[n4][n2] = dataInputStream.readInt();
                        this.actionData[n4][n2 + 1] = dataInputStream.readInt();
                        n2 += 2;
                    }
                    continue;
                }
                for (n = 0; n < n9; ++n) {
                    this.actionData[n4][n2] = dataInputStream.readInt();
                    ++n2;
                }
            }
            this.setImage(image);
            this.visible = true;
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SpriteX(SpriteX spriteX) {
        int n;
        int n2;
        this.actionCount = spriteX.actionCount;
        this.frameCount = spriteX.frameCount;
        this.tileCount = spriteX.tileCount;
        this.actionData = new int[this.actionCount][];
        this.frameData = new int[this.frameCount][];
        this.tileData = new int[this.tileCount][];
        for (n2 = 0; n2 < this.actionCount; ++n2) {
            n = spriteX.actionData[n2][0];
            this.actionData[n2] = new int[n];
            System.arraycopy(spriteX.actionData[n2], 0, this.actionData[n2], 0, n);
        }
        for (n2 = 0; n2 < this.frameCount; ++n2) {
            n = spriteX.frameData[n2][0];
            this.frameData[n2] = new int[n];
            System.arraycopy(spriteX.frameData[n2], 0, this.frameData[n2], 0, n);
        }
        for (n2 = 0; n2 < this.tileCount; ++n2) {
            n = 4;
            this.tileData[n2] = new int[n];
            System.arraycopy(spriteX.tileData[n2], 0, this.tileData[n2], 0, n);
        }
        this.actionIndex = spriteX.actionIndex;
        this.sequenceIndex = spriteX.sequenceIndex;
        this.image = spriteX.image;
        this.x = spriteX.x;
        this.y = spriteX.y;
        this.visible = spriteX.visible;
        this.lastTime = spriteX.lastTime;
        this.firstUpdate = spriteX.firstUpdate;
        this.disableUpdate = spriteX.disableUpdate;
    }

    public void enableUpdate(boolean bl) {
        if (this.disableUpdate && bl) {
            this.lastTime = System.currentTimeMillis();
        }
        this.disableUpdate = !bl;
    }

    public boolean isEnableUpdate() {
        return !this.disableUpdate;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setAction(int n) {
        if (n < 0 || n >= this.actionCount) {
            throw new IndexOutOfBoundsException();
        }
        this.actionIndex = n;
        this.sequenceIndex = 0;
        this.firstUpdate = false;
    }

    public int getAction() {
        return this.actionIndex;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public void setFrame(int n) {
        if (n < 0 || n >= this.getSequenceLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = n;
        this.firstUpdate = false;
    }

    public int getFrame() {
        return this.sequenceIndex;
    }

    public void setTransform(int n) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException();
        }
        this.actionData[this.actionIndex][3] = n;
    }

    public int getTransform() {
        return this.actionData[this.actionIndex][3];
    }

    public void deasilRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][1]);
    }

    void anticlockwiseRotate90() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][0]);
    }

    void horizontalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][2]);
    }

    void verticalMirror() {
        this.setTransform(ROTATE_TABLE[this.getTransform()][3]);
    }

    public void nextFrame() {
        this.sequenceIndex = (this.sequenceIndex + 1) % this.getSequenceLength();
        this.firstUpdate = false;
    }

    public void prevFrame() {
        this.sequenceIndex = this.sequenceIndex == 0 ? this.getSequenceLength() - 1 : --this.sequenceIndex;
        this.firstUpdate = false;
    }

    public void update(long l) {
        if (!this.isEnableUpdate()) {
            return;
        }
        if (this.isDelay()) {
            int n;
            if (!this.firstUpdate) {
                this.firstUpdate = true;
                this.lastTime = l;
            }
            if (l - this.lastTime >= (long)(n = this.getDelayTime())) {
                this.nextFrame();
                this.lastTime = l;
            }
        }
    }

    public void update() {
        if (!this.isEnableUpdate()) {
            return;
        }
        this.update(System.currentTimeMillis());
    }

    public int getSequenceFrame(int n) {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + n * 2];
        }
        return this.actionData[this.actionIndex][4 + n];
    }

    public int getSequenceFrame() {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + this.sequenceIndex];
    }

    public int getSequenceLength() {
        return this.actionData[this.actionIndex][1];
    }

    public boolean isDelay() {
        return this.actionData[this.actionIndex][2] == 1;
    }

    public int getDelayTime() {
        return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2 + 1];
    }

    public int getReferencePointX(int n) {
        int n2 = this.getSequenceFrame();
        int n3 = this.frameData[n2][1];
        int n4 = this.frameData[n2][2];
        int n5 = 8 + n3 * 4 + n4 * 4 + n * 2;
        int n6 = this.frameData[n2][n5];
        int n7 = this.frameData[n2][n5 + 1];
        return this.getTransformedReferenceX(n6, n7, this.getTransform()) + this.x;
    }

    public int getReferencePointY(int n) {
        int n2 = this.getSequenceFrame();
        int n3 = this.frameData[n2][1];
        int n4 = this.frameData[n2][2];
        int n5 = 8 + n3 * 4 + n4 * 4 + n * 2;
        int n6 = this.frameData[n2][n5];
        int n7 = this.frameData[n2][n5 + 1];
        return this.getTransformedReferenceY(n6, n7, this.getTransform()) + this.y;
    }

    public int getReferencePointCount(int n) {
        if (n < 0 && n >= this.frameCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.frameData[n][3];
        return n2;
    }

    public int getReferencePointCount() {
        int n = this.getSequenceFrame();
        return this.getReferencePointCount(n);
    }

    int getTransformedReferenceX(int n, int n2, int n3) {
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = n;
                break;
            }
            case 2: {
                n4 = -n;
            }
        }
        return n4;
    }

    int getTransformedReferenceY(int n, int n2, int n3) {
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = n2;
                break;
            }
            case 2: {
                n4 = n2;
            }
        }
        return n4;
    }

    public int getCollidesX(int n) {
        int n2 = this.getSequenceFrame();
        if (n < 0 || n >= this.frameData[n2][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 8 + this.frameData[n2][1] * 4 + n * 4;
        return this.frameData[n2][n3] + this.x;
    }

    public int getCollidesY(int n) {
        int n2 = this.getSequenceFrame();
        if (n < 0 || n >= this.frameData[n2][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 8 + this.frameData[n2][1] * 4 + n * 4 + 1;
        return this.frameData[n2][n3] + this.y;
    }

    public int getCollidesWidth(int n) {
        int n2 = this.getSequenceFrame();
        if (n < 0 || n >= this.frameData[n2][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 8 + this.frameData[n2][1] * 4 + n * 4 + 2;
        return this.frameData[n2][n3];
    }

    public int getCollidesHeight(int n) {
        int n2 = this.getSequenceFrame();
        if (n < 0 || n >= this.frameData[n2][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 8 + this.frameData[n2][1] * 4 + n * 4 + 3;
        return this.frameData[n2][n3];
    }

    public int getCollidesCount(int n) {
        return this.frameData[n][2];
    }

    public int getCollidesCount() {
        return this.frameData[this.getSequenceFrame()][2];
    }

    public boolean collidesWith(SpriteX spriteX, int n, int n2, int n3) {
        if (!spriteX.visible || !this.visible) {
            return false;
        }
        int n4 = spriteX.getCollidesX(n);
        int n5 = spriteX.getCollidesY(n);
        int n6 = spriteX.getCollidesWidth(n);
        int n7 = spriteX.getCollidesHeight(n);
        return this.collidesWith(n4, n5, n6, n7, n2, n3);
    }

    public boolean collidesWith(Image image, int n, int n2, int n3, int n4) {
        return this.collidesWith(n, n2, image.getWidth(), image.getHeight(), n3, n4);
    }

    public boolean collidesWith(int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.visible) {
            return false;
        }
        int n7 = this.getCollidesX(n5);
        int n8 = this.getCollidesY(n5);
        int n9 = this.getCollidesWidth(n5);
        int n10 = this.getCollidesHeight(n5);
        if (n6 == 1) {
            return SpriteX.intersectRect(n7, n8, n9, n10, n, n2, n3, n4);
        }
        if (n6 == 2) {
            return SpriteX.inclusionRect(n7, n8, n9, n10, n, n2, n3, n4);
        }
        throw new ArithmeticException();
    }

    public boolean collidesWith(SpriteX spriteX) {
        if (!spriteX.visible || !this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0 || spriteX.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(spriteX, 0, 0, 1);
    }

    public boolean collidesWith(Image image, int n, int n2) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(image, n, n2, 0, 1);
    }

    public boolean collidesWith(int n, int n2, int n3, int n4) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(n, n2, n3, n4, 0, 1);
    }

    public static boolean intersectRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n6 + n8 >= n2 && n6 <= n2 + n4 && n5 + n7 >= n && n5 <= n + n3;
    }

    public static boolean inclusionRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n6 >= n2 && n6 + n8 <= n2 + n4 && n5 >= n && n5 + n7 <= n + n3;
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void move(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getFrameTopPos() {
        return this.frameData[this.getSequenceFrame()][4] + this.y;
    }

    public int getFrameBottomPos() {
        return this.frameData[this.getSequenceFrame()][5] + this.y;
    }

    public int getFrameLeftPos() {
        return this.frameData[this.getSequenceFrame()][6] + this.x;
    }

    public int getFrameRightPos() {
        return this.frameData[this.getSequenceFrame()][7] + this.x;
    }

    public int getFrameWidth() {
        return this.getFrameRightPos() - this.getFrameLeftPos();
    }

    public int getFrameHeight() {
        return this.getFrameBottomPos() - this.getFrameTopPos();
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics graphics, int n, int n2) {
        block17: {
            if (graphics == null) {
                throw new NullPointerException();
            }
            if (!this.visible) break block17;
            int n3 = graphics.getClipX();
            int n4 = graphics.getClipY();
            int n5 = graphics.getClipWidth();
            int n6 = graphics.getClipHeight();
            int n7 = this.getTransform();
            if (n7 == 0) {
                int n8 = this.getSequenceFrame();
                int n9 = this.frameData[n8][1];
                int n10 = 8;
                for (int i = 0; i < n9; ++i) {
                    int n11 = this.frameData[n8][0 + n10];
                    int n12 = this.frameData[n8][1 + n10] + n;
                    int n13 = this.frameData[n8][2 + n10] + n2;
                    int n14 = this.frameData[n8][3 + n10];
                    int n15 = this.tileData[n11][0];
                    int n16 = this.tileData[n11][1];
                    int n17 = this.tileData[n11][2];
                    int n18 = this.tileData[n11][3];
                    if (SpriteX.intersectRect(n12, n13, n17, n18, n3, n4, n5, n6)) {
                        SpriteX.drawRegion(graphics, this.image, n15, n16, n17, n18, n14, n12, n13, 20);
                    }
                    n10 += 4;
                }
            } else {
                int n19 = this.getSequenceFrame();
                int n20 = this.frameData[n19][1];
                int n21 = 8;
                for (int i = 0; i < n20; ++i) {
                    int n22 = this.frameData[n19][0 + n21];
                    int n23 = this.frameData[n19][1 + n21] + n;
                    int n24 = this.frameData[n19][2 + n21] + n2;
                    int n25 = this.frameData[n19][3 + n21];
                    int n26 = this.tileData[n22][0];
                    int n27 = this.tileData[n22][1];
                    int n28 = this.tileData[n22][2];
                    int n29 = this.tileData[n22][3];
                    int n30 = n - n23;
                    int n31 = n2 - n24;
                    n25 = TRANSFORM_TABLE[n25][n7];
                    switch (n7) {
                        case 0: {
                            break;
                        }
                        case 5: {
                            n23 = n - (n29 - n31);
                            n24 = n2 - n30;
                            break;
                        }
                        case 3: {
                            n23 = n - (n28 - n30);
                            n24 = n2 - (n29 - n31);
                            break;
                        }
                        case 6: {
                            n23 = n - n31;
                            n24 = n2 - (n28 - n30);
                            break;
                        }
                        case 2: {
                            n23 = n - (n28 - n30);
                            break;
                        }
                        case 7: {
                            n23 = n - (n29 - n31);
                            n24 = n2 - (n28 - n30);
                            break;
                        }
                        case 1: {
                            n24 = n2 - (n29 - n31);
                            break;
                        }
                        case 4: {
                            n23 = n - n31;
                            n24 = n2 - n30;
                        }
                    }
                    if (SpriteX.intersectRect(n23, n24, n28, n29, n3, n4, n5, n6)) {
                        SpriteX.drawRegion(graphics, this.image, n26, n27, n28, n29, n25, n23, n24, 20);
                    }
                    n21 += 4;
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, this.x, this.y);
    }

    public static void drawRegionMIDP1(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        if (graphics == null) {
            throw new NullPointerException();
        }
        if (image == null) {
            throw new NullPointerException();
        }
        switch (n8) {
            case 0: 
            case 3: 
            case 6: 
            case 10: 
            case 17: 
            case 20: 
            case 24: 
            case 33: 
            case 36: 
            case 40: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (n5 < 0 || n5 > 7) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n4 < 0 || n < 0 || n2 < 0 || n + n3 > image.getWidth() || n2 + n4 > image.getHeight()) {
            throw new IllegalArgumentException();
        }
        int n10 = graphics.getClipX();
        int n11 = graphics.getClipY();
        int n12 = graphics.getClipWidth();
        int n13 = graphics.getClipHeight();
        if ((4 & n5) == 0) {
            if (n8 != 0) {
                if ((n8 & 0x20) != 0) {
                    n7 -= n4;
                }
                if ((n8 & 8) != 0) {
                    n6 -= n3;
                }
                if ((n8 & 1) != 0) {
                    n6 -= n3 / 2;
                }
                if ((n8 & 2) != 0) {
                    n7 -= n4 / 2;
                }
            }
            graphics.clipRect(n6, n7, n3, n4);
        } else {
            if (n8 != 0) {
                if ((n8 & 0x20) != 0) {
                    n7 -= n3;
                }
                if ((n8 & 8) != 0) {
                    n6 -= n4;
                }
                if ((n8 & 1) != 0) {
                    n6 -= n4 / 2;
                }
                if ((n8 & 2) != 0) {
                    n7 -= n3 / 2;
                }
            }
            graphics.clipRect(n6, n7, n4, n3);
        }
        int n14 = 0;
        int n15 = 0;
        int n16 = image.getWidth();
        int n17 = image.getHeight();
        switch (n5) {
            case 0: {
                graphics.drawImage(image, n6 - n, n7 - n2, 4 | 0x10);
                graphics.setClip(n10, n11, n12, n13);
                return;
            }
            case 5: {
                n14 = n17 - (n2 + n4);
                n15 = n;
                break;
            }
            case 3: {
                n14 = n16 - (n + n3);
                n15 = n17 - (n2 + n4);
                break;
            }
            case 6: {
                n14 = n2;
                n15 = n16 - (n + n3);
                break;
            }
            case 2: {
                n14 = n16 - (n + n3);
                n15 = n2;
                break;
            }
            case 7: {
                n14 = n17 - (n2 + n4);
                n15 = n16 - (n + n3);
                break;
            }
            case 1: {
                n14 = n;
                n15 = n17 - (n2 + n4);
                break;
            }
            case 4: {
                n14 = n2;
                n15 = n;
            }
        }
        n6 -= n14;
        n7 -= n15;
        int n18 = graphics.getClipX();
        int n19 = graphics.getClipY();
        int n20 = graphics.getClipX() + graphics.getClipWidth();
        int n21 = graphics.getClipY() + graphics.getClipHeight();
        if ((4 & n5) != 0) {
            n9 = n16;
            n16 = n17;
            n17 = n9;
        }
        n9 = Math.max(0, n18 - n6);
        int n22 = Math.max(0, n19 - n7);
        int n23 = Math.max(n18, n6);
        int n24 = Math.max(n19, n7);
        int n25 = n6 + n16;
        int n26 = n7 + n17;
        int n27 = n16 - n9;
        int n28 = n17 - n22;
        n27 -= Math.max(0, n25 - n20);
        n28 -= Math.max(0, n26 - n21);
        int n29 = 0;
        int n30 = 0;
        for (int i = 0; i < n28; ++i) {
            for (int j = 0; j < n27; ++j) {
                switch (n5) {
                    case 5: {
                        n29 = n22 + i;
                        n30 = n16 - 1 - j - n9;
                        break;
                    }
                    case 3: {
                        n29 = n16 - 1 - j - n9;
                        n30 = n17 - 1 - i - n22;
                        break;
                    }
                    case 6: {
                        n29 = n17 - 1 - i - n22;
                        n30 = n9 + j;
                        break;
                    }
                    case 2: {
                        n29 = n16 - 1 - j - n9;
                        n30 = n22 + i;
                        break;
                    }
                    case 7: {
                        n29 = n17 - 1 - i - n22;
                        n30 = n16 - 1 - j - n9;
                        break;
                    }
                    case 1: {
                        n29 = n9 + j;
                        n30 = n17 - 1 - i - n22;
                        break;
                    }
                    case 4: {
                        n29 = n22 + i;
                        n30 = n9 + j;
                    }
                }
                graphics.setClip(n23 + j, n24 + i, 1, 1);
                graphics.drawImage(image, n23 + j - n29, n24 + i - n30, 4 | 0x10);
            }
        }
        graphics.setClip(n10, n11, n12, n13);
    }

    public static void drawRegion(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        graphics.drawRegion(image, n, n2, n3, n4, n5, n6, n7, n8);
    }
}

