/*
 * Decompiled with CFR 0.152.
 */
package xqwlight;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import xqwlight.Position;
import xqwlight.Search;
import xqwlight.Util;
import xqwlight.XQWLMIDlet;

class XQWLCanvas
extends Canvas {
    private static final int PHASE_LOADING = 0;
    private static final int PHASE_WAITING = 1;
    private static final int PHASE_THINKING = 2;
    private static final int PHASE_EXITTING = 3;
    private static final int RESP_CLICK = 0;
    private static final int RESP_ILLEGAL = 1;
    private static final int RESP_MOVE = 2;
    private static final int RESP_MOVE2 = 3;
    private static final int RESP_CAPTURE = 4;
    private static final int RESP_CAPTURE2 = 5;
    private static final int RESP_CHECK = 6;
    private static final int RESP_CHECK2 = 7;
    private static final int RESP_WIN = 8;
    private static final int RESP_DRAW = 9;
    private static final int RESP_LOSS = 10;
    private static Image imgBackground;
    private static Image imgXQWLight;
    private static Image imgThinking;
    private static final String[] IMAGE_NAME;
    private static int widthBackground;
    private static int heightBackground;
    private static Font fontLarge;
    private static Font fontSmall;
    XQWLMIDlet midlet;
    byte[] retractData = new byte[512];
    private Position pos = new Position();
    private Search search = new Search(this.pos, 12);
    private String message;
    private int cursorX;
    private int cursorY;
    private int sqSelected;
    private int mvLast;
    private int normalWidth = this.getWidth();
    private int normalHeight = this.getHeight();
    private Alert altAbout = new Alert("\u5173\u4e8e\"\u8c61\u68cb\u5c0f\u5deb\u5e08\"", null, imgXQWLight, AlertType.INFO);
    private Alert altBack = new Alert("\u8c61\u68cb\u5c0f\u5deb\u5e08", "\u653e\u5f03\u8fd9\u5c40\u68cb\uff1f", null, AlertType.CONFIRMATION);
    Command cmdBack = new Command("\u8fd4\u56de", 8, 1);
    Command cmdRetract = new Command("\u6094\u68cb", 8, 1);
    Command cmdAbout = new Command("\u5173\u4e8e", 8, 1);
    Command cmdBackOK = new Command("\u786e\u5b9a", 4, 1);
    Command cmdBackCancel = new Command("\u53d6\u6d88", 3, 1);
    volatile int phase = 0;
    private boolean init = false;
    private Image imgBoard;
    private Image imgSelected;
    private Image imgSelected2;
    private Image imgCursor;
    private Image imgCursor2;
    private Image[] imgPieces = new Image[24];
    private int squareSize;
    private int width;
    private int height;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private boolean bNoKeyPad = false;

    static {
        String[] stringArray = new String[24];
        stringArray[8] = "rk";
        stringArray[9] = "ra";
        stringArray[10] = "rb";
        stringArray[11] = "rn";
        stringArray[12] = "rr";
        stringArray[13] = "rc";
        stringArray[14] = "rp";
        stringArray[16] = "bk";
        stringArray[17] = "ba";
        stringArray[18] = "bb";
        stringArray[19] = "bn";
        stringArray[20] = "br";
        stringArray[21] = "bc";
        stringArray[22] = "bp";
        IMAGE_NAME = stringArray;
        fontLarge = Font.getFont((int)0, (int)3, (int)16);
        fontSmall = Font.getFont((int)0, (int)1, (int)8);
        try {
            imgBackground = Image.createImage((String)"/images/background.png");
            imgXQWLight = Image.createImage((String)"/images/xqwlight.png");
            imgThinking = Image.createImage((String)"/images/thinking.png");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        widthBackground = imgBackground.getWidth();
        heightBackground = imgBackground.getHeight();
    }

    XQWLCanvas(XQWLMIDlet midlet_) {
        this.midlet = midlet_;
        this.setFullScreenMode(true);
        this.altAbout.setTimeout(-2);
        this.altAbout.setString(String.valueOf(this.midlet.getAppProperty("MIDlet-Description")) + "\n\r\f\u8c61\u68cb\u767e\u79d1\u5168\u4e66 \u8363\u8a89\u51fa\u54c1\n\r\f\n\r\f" + "(C) 2004-2010 www.xqbase.com\n\r\f\u672c\u4ea7\u54c1\u7b26\u5408GNU\u901a\u7528\u516c\u5171\u8bb8\u53ef\u534f\u8bae\n\r\f\n\r\f" + "\u6b22\u8fce\u767b\u5f55 www.xqbase.com\n\r\f\u514d\u8d39\u4e0b\u8f7dPC\u7248 \u8c61\u68cb\u5deb\u5e08");
        this.altBack.setTimeout(-2);
        this.altBack.addCommand(this.cmdBackOK);
        this.altBack.addCommand(this.cmdBackCancel);
        this.altBack.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == XQWLCanvas.this.cmdBackOK) {
                    XQWLCanvas.this.midlet.rsData[0] = 0;
                    XQWLCanvas.this.midlet.startMusic("form");
                    Display.getDisplay((MIDlet)XQWLCanvas.this.midlet).setCurrent((Displayable)XQWLCanvas.this.midlet.form);
                } else {
                    Display.getDisplay((MIDlet)XQWLCanvas.this.midlet).setCurrent((Displayable)XQWLCanvas.this);
                    XQWLCanvas.this.phase = 0;
                    XQWLCanvas.this.setFullScreenMode(true);
                }
            }
        });
        this.addCommand(this.cmdBack);
        this.addCommand(this.cmdRetract);
        this.addCommand(this.cmdAbout);
        String noKeyPadValue = this.midlet.getAppProperty("XQWLight-NoKeyPad");
        if (noKeyPadValue != null && noKeyPadValue.toLowerCase().equals("true")) {
            this.bNoKeyPad = true;
        }
        this.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (XQWLCanvas.this.phase == 1 || XQWLCanvas.this.phase == 3) {
                    if (c == XQWLCanvas.this.cmdBack) {
                        XQWLCanvas.this.back();
                    } else if (c == XQWLCanvas.this.cmdRetract) {
                        XQWLCanvas.this.retract();
                    } else if (c == XQWLCanvas.this.cmdAbout) {
                        XQWLCanvas.this.about();
                    }
                }
            }
        });
    }

    void load() {
        this.setFullScreenMode(true);
        this.cursorY = 7;
        this.cursorX = 7;
        this.mvLast = 0;
        this.sqSelected = 0;
        if (this.midlet.rsData[0] == 0) {
            this.pos.fromFen(Position.STARTUP_FEN[this.midlet.handicap]);
        } else {
            this.pos.clearBoard();
            int sq = 0;
            while (sq < 256) {
                byte pc = this.midlet.rsData[sq + 256];
                if (pc > 0) {
                    this.pos.addPiece(sq, pc);
                }
                ++sq;
            }
            if (this.midlet.flipped) {
                this.pos.changeSide();
            }
            this.pos.setIrrev();
        }
        System.arraycopy(this.midlet.rsData, 0, this.retractData, 0, 512);
        this.phase = 0;
        if (this.pos.sdPlayer == 0 ? this.midlet.flipped : !this.midlet.flipped) {
            new Thread(){

                public void run() {
                    while (XQWLCanvas.this.phase == 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    XQWLCanvas.this.responseMove();
                }
            }.start();
        }
    }

    protected void paint(Graphics g) {
        if (this.phase == 0) {
            this.width = this.getWidth();
            this.height = this.getHeight();
            int i = 0;
            while (i < 10) {
                if (this.width != this.normalWidth || this.height != this.normalHeight) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.width = this.getWidth();
                this.height = this.getHeight();
                ++i;
            }
            if (!this.init) {
                this.init = true;
                String imagePath = "/images/";
                this.squareSize = Math.min(this.width / 9, this.height / 10);
                if (this.squareSize >= 36) {
                    this.squareSize = 36;
                    imagePath = String.valueOf(imagePath) + "large/";
                } else if (this.squareSize >= 26) {
                    this.squareSize = 26;
                    imagePath = String.valueOf(imagePath) + "medium/";
                } else if (this.squareSize >= 18) {
                    this.squareSize = 18;
                    imagePath = String.valueOf(imagePath) + "small/";
                } else {
                    this.squareSize = 13;
                    imagePath = String.valueOf(imagePath) + "tiny/";
                }
                int boardWidth = this.squareSize * 9;
                int boardHeight = this.squareSize * 10;
                try {
                    this.imgBoard = Image.createImage((String)(String.valueOf(imagePath) + "board.png"));
                    this.imgSelected = Image.createImage((String)(String.valueOf(imagePath) + "selected.png"));
                    this.imgSelected2 = Image.createImage((String)(String.valueOf(imagePath) + "selected2.png"));
                    this.imgCursor = Image.createImage((String)(String.valueOf(imagePath) + "cursor.png"));
                    this.imgCursor2 = Image.createImage((String)(String.valueOf(imagePath) + "cursor2.png"));
                    int pc = 0;
                    while (pc < 24) {
                        this.imgPieces[pc] = IMAGE_NAME[pc] == null ? null : Image.createImage((String)(String.valueOf(imagePath) + IMAGE_NAME[pc] + ".png"));
                        ++pc;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
                this.left = (this.width - boardWidth) / 2;
                this.top = (this.height - boardHeight) / 2;
                this.right = this.left + boardWidth - 32;
                this.bottom = this.top + boardHeight - 32;
            }
            this.phase = 1;
        }
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                g.drawImage(imgBackground, x, y, 20);
                y += heightBackground;
            }
            x += widthBackground;
        }
        g.drawImage(this.imgBoard, this.width / 2, this.height / 2, 3);
        int sq = 0;
        while (sq < 256) {
            byte pc;
            if (Position.IN_BOARD(sq) && (pc = this.pos.squares[sq]) > 0) {
                this.drawSquare(g, this.imgPieces[pc], sq);
            }
            ++sq;
        }
        int sqSrc = 0;
        int sqDst = 0;
        if (this.mvLast > 0) {
            sqSrc = Position.SRC(this.mvLast);
            sqDst = Position.DST(this.mvLast);
            this.drawSquare(g, (this.pos.squares[sqSrc] & 8) == 0 ? this.imgSelected : this.imgSelected2, sqSrc);
            this.drawSquare(g, (this.pos.squares[sqDst] & 8) == 0 ? this.imgSelected : this.imgSelected2, sqDst);
        } else if (this.sqSelected > 0) {
            this.drawSquare(g, (this.pos.squares[this.sqSelected] & 8) == 0 ? this.imgSelected : this.imgSelected2, this.sqSelected);
        }
        int sq2 = Position.COORD_XY(this.cursorX + 3, this.cursorY + 3);
        if (this.midlet.flipped) {
            sq2 = Position.SQUARE_FLIP(sq2);
        }
        if (sq2 == sqSrc || sq2 == sqDst || sq2 == this.sqSelected) {
            this.drawSquare(g, (this.pos.squares[sq2] & 8) == 0 ? this.imgCursor2 : this.imgCursor, sq2);
        } else {
            this.drawSquare(g, (this.pos.squares[sq2] & 8) == 0 ? this.imgCursor : this.imgCursor2, sq2);
        }
        if (this.phase == 2) {
            int y;
            int x2;
            if (this.midlet.flipped) {
                x2 = Position.FILE_X(sqDst) < 8 ? this.left : this.right;
                y = Position.RANK_Y(sqDst) < 8 ? this.top : this.bottom;
            } else {
                x2 = Position.FILE_X(sqDst) < 8 ? this.right : this.left;
                y = Position.RANK_Y(sqDst) < 8 ? this.bottom : this.top;
            }
            g.drawImage(imgThinking, x2, y, 20);
        } else if (this.phase == 3) {
            g.setFont(fontLarge);
            g.setColor(255);
            g.drawString(this.message, this.width / 2, this.height / 2, 65);
        }
        if (this.bNoKeyPad) {
            g.setFont(fontSmall);
            g.setColor(255);
            g.drawString("* - \u8fd4\u56de", 0, this.height, 68);
            g.drawString("0 - \u6094\u68cb", this.width / 2, this.height, 65);
            g.drawString("# - \u5173\u4e8e", this.width, this.height, 72);
        }
    }

    protected void keyPressed(int code) {
        if (this.phase == 3) {
            this.midlet.startMusic("form");
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.form);
            return;
        }
        if (this.phase == 2) {
            return;
        }
        if (this.bNoKeyPad) {
            switch (code) {
                case 42: {
                    this.back();
                    return;
                }
                case 48: {
                    this.retract();
                    return;
                }
                case 35: {
                    this.about();
                    return;
                }
            }
        }
        int deltaX = 0;
        int deltaY = 0;
        int action = this.getGameAction(code);
        if (action == 8 || code == 53) {
            this.clickSquare();
        } else {
            block5 : switch (action) {
                case 1: {
                    deltaY = -1;
                    break;
                }
                case 2: {
                    deltaX = -1;
                    break;
                }
                case 5: {
                    deltaX = 1;
                    break;
                }
                case 6: {
                    deltaY = 1;
                    break;
                }
                default: {
                    switch (code) {
                        case 49: {
                            deltaX = -1;
                            deltaY = -1;
                            break block5;
                        }
                        case 50: {
                            deltaY = -1;
                            break block5;
                        }
                        case 51: {
                            deltaX = 1;
                            deltaY = -1;
                            break block5;
                        }
                        case 52: {
                            deltaX = -1;
                            break block5;
                        }
                        case 54: {
                            deltaX = 1;
                            break block5;
                        }
                        case 55: {
                            deltaX = -1;
                            deltaY = 1;
                            break block5;
                        }
                        case 56: {
                            deltaY = 1;
                            break block5;
                        }
                        case 57: {
                            deltaX = 1;
                            deltaY = 1;
                        }
                    }
                }
            }
            this.cursorX = (this.cursorX + deltaX + 9) % 9;
            this.cursorY = (this.cursorY + deltaY + 10) % 10;
        }
        this.repaint();
        this.serviceRepaints();
    }

    protected void pointerPressed(int x, int y) {
        if (this.phase == 3) {
            this.midlet.startMusic("form");
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.form);
            return;
        }
        if (this.phase == 2) {
            return;
        }
        if (this.bNoKeyPad && this.height - y < fontSmall.getHeight()) {
            switch (x * 3 / this.width) {
                case 0: {
                    this.back();
                    return;
                }
                case 1: {
                    this.retract();
                    return;
                }
                case 2: {
                    this.about();
                    return;
                }
            }
        }
        this.cursorX = Util.MIN_MAX(0, (x - this.left) / this.squareSize, 8);
        this.cursorY = Util.MIN_MAX(0, (y - this.top) / this.squareSize, 9);
        this.clickSquare();
        this.repaint();
        this.serviceRepaints();
    }

    private void clickSquare() {
        byte pc;
        int sq = Position.COORD_XY(this.cursorX + 3, this.cursorY + 3);
        if (this.midlet.flipped) {
            sq = Position.SQUARE_FLIP(sq);
        }
        if (((pc = this.pos.squares[sq]) & Position.SIDE_TAG(this.pos.sdPlayer)) != 0) {
            this.midlet.playSound(0);
            this.mvLast = 0;
            this.sqSelected = sq;
        } else if (this.sqSelected > 0 && this.addMove(Position.MOVE(this.sqSelected, sq)) && !this.responseMove()) {
            this.midlet.rsData[0] = 0;
            this.phase = 3;
        }
    }

    private void drawSquare(Graphics g, Image image, int sq) {
        int sqFlipped = this.midlet.flipped ? Position.SQUARE_FLIP(sq) : sq;
        int sqX = this.left + (Position.FILE_X(sqFlipped) - 3) * this.squareSize;
        int sqY = this.top + (Position.RANK_Y(sqFlipped) - 3) * this.squareSize;
        g.drawImage(image, sqX, sqY, 20);
    }

    private boolean getResult() {
        return this.getResult(-1);
    }

    private boolean getResult(int response) {
        if (this.pos.isMate()) {
            this.midlet.playSound(response < 0 ? 8 : 10);
            this.message = response < 0 ? "\u795d\u8d3a\u4f60\u53d6\u5f97\u80dc\u5229\uff01" : "\u8bf7\u518d\u63a5\u518d\u5389\uff01";
            return true;
        }
        int vlRep = this.pos.repStatus(3);
        if (vlRep > 0) {
            int n = vlRep = response < 0 ? this.pos.repValue(vlRep) : -this.pos.repValue(vlRep);
            this.midlet.playSound(vlRep > 9800 ? 10 : (vlRep < -9800 ? 8 : 9));
            this.message = vlRep > 9800 ? "\u957f\u6253\u4f5c\u8d1f\uff0c\u8bf7\u4e0d\u8981\u6c14\u9981\uff01" : (vlRep < -9800 ? "\u7535\u8111\u957f\u6253\u4f5c\u8d1f\uff0c\u795d\u8d3a\u4f60\u53d6\u5f97\u80dc\u5229\uff01" : "\u53cc\u65b9\u4e0d\u53d8\u4f5c\u548c\uff0c\u8f9b\u82e6\u4e86\uff01");
            return true;
        }
        if (this.pos.moveNum > 100) {
            this.midlet.playSound(9);
            this.message = "\u8d85\u8fc7\u81ea\u7136\u9650\u7740\u4f5c\u548c\uff0c\u8f9b\u82e6\u4e86\uff01";
            return true;
        }
        if (response >= 0) {
            this.midlet.playSound(response);
            System.arraycopy(this.midlet.rsData, 0, this.retractData, 0, 512);
            this.midlet.rsData[0] = 1;
            System.arraycopy(this.pos.squares, 0, this.midlet.rsData, 256, 256);
        }
        return false;
    }

    private boolean addMove(int mv) {
        if (this.pos.legalMove(mv)) {
            if (this.pos.makeMove(mv)) {
                this.midlet.playSound(this.pos.inCheck() ? 6 : (this.pos.captured() ? 4 : 2));
                if (this.pos.captured()) {
                    this.pos.setIrrev();
                }
                this.sqSelected = 0;
                this.mvLast = mv;
                return true;
            }
            this.midlet.playSound(1);
        }
        return false;
    }

    boolean responseMove() {
        int response;
        if (this.getResult()) {
            return false;
        }
        this.phase = 2;
        this.repaint();
        this.serviceRepaints();
        this.mvLast = this.search.searchMain(1000 << (this.midlet.level << 1));
        this.pos.makeMove(this.mvLast);
        int n = this.pos.inCheck() ? 7 : (response = this.pos.captured() ? 5 : 3);
        if (this.pos.captured()) {
            this.pos.setIrrev();
        }
        this.phase = 1;
        this.repaint();
        this.serviceRepaints();
        return !this.getResult(response);
    }

    void back() {
        if (this.phase == 1) {
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.altBack);
        } else {
            this.midlet.rsData[0] = 0;
            this.midlet.startMusic("form");
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.form);
        }
    }

    void retract() {
        System.arraycopy(this.retractData, 0, this.midlet.rsData, 0, 512);
        this.load();
        this.repaint();
        this.serviceRepaints();
    }

    void about() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.altAbout);
        this.phase = 0;
        this.setFullScreenMode(true);
    }
}

