/*
 * Decompiled with CFR 0.152.
 */
package xqwlight;

import java.io.InputStream;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.Ticker;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import xqwlight.Util;
import xqwlight.XQWLCanvas;

public class XQWLMIDlet
extends MIDlet {
    private static final String STORE_NAME = "XQWLight";
    static final String[] SOUND_NAME = new String[]{"click", "illegal", "move", "move2", "capture", "capture2", "check", "check2", "win", "draw", "loss"};
    static final int RS_DATA_LEN = 512;
    byte[] rsData = new byte[512];
    boolean flipped;
    int handicap;
    int level;
    int sound;
    int music;
    Player midiPlayer = null;
    Form form = new Form("\u8c61\u68cb\u5c0f\u5deb\u5e08");
    XQWLCanvas canvas = new XQWLCanvas(this);
    Command cmdStart = new Command("\u5f00\u59cb", 4, 1);
    Command cmdExit = new Command("\u9000\u51fa", 2, 1);
    ChoiceGroup cgToMove = new ChoiceGroup("\u8c01\u5148\u8d70", 1, new String[]{"\u6211\u5148\u8d70", "\u7535\u8111\u5148\u8d70"}, null);
    ChoiceGroup cgHandicap = new ChoiceGroup("\u5148\u8d70\u8ba9\u5b50", 4, new String[]{"\u4e0d\u8ba9\u5b50", "\u8ba9\u5de6\u9a6c", "\u8ba9\u53cc\u9a6c", "\u8ba9\u4e5d\u5b50"}, null);
    ChoiceGroup cgLevel = new ChoiceGroup("\u7535\u8111\u6c34\u5e73", 4, new String[]{"\u5165\u95e8", "\u4e1a\u4f59", "\u4e13\u4e1a"}, null);
    Gauge gSound = new Gauge("\u97f3\u6548", true, 5, 0);
    Gauge gMusic = new Gauge("\u97f3\u4e50", true, 5, 0);
    private boolean started;

    public XQWLMIDlet() {
        this.form.append((Item)this.cgToMove);
        this.form.append((Item)this.cgHandicap);
        this.form.append((Item)this.cgLevel);
        this.form.append((Item)this.gSound);
        this.form.append((Item)this.gMusic);
        this.form.addCommand(this.cmdStart);
        this.form.addCommand(this.cmdExit);
        this.form.setTicker(new Ticker("\u6b22\u8fce\u767b\u5f55 www.xqbase.com \u514d\u8d39\u4e0b\u8f7dPC\u7248 \u8c61\u68cb\u5deb\u5e08"));
        this.form.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c == XQWLMIDlet.this.cmdStart) {
                    XQWLMIDlet.this.flipped = XQWLMIDlet.this.cgToMove.isSelected(1);
                    XQWLMIDlet.this.handicap = XQWLMIDlet.this.cgHandicap.getSelectedIndex();
                    XQWLMIDlet.this.level = XQWLMIDlet.this.cgLevel.getSelectedIndex();
                    XQWLMIDlet.this.sound = XQWLMIDlet.this.gSound.getValue();
                    XQWLMIDlet.this.music = XQWLMIDlet.this.gMusic.getValue();
                    XQWLMIDlet.this.canvas.load();
                    XQWLMIDlet.this.startMusic("canvas");
                    Display.getDisplay((MIDlet)XQWLMIDlet.this).setCurrent((Displayable)XQWLMIDlet.this.canvas);
                } else if (c == XQWLMIDlet.this.cmdExit) {
                    XQWLMIDlet.this.destroyApp(false);
                    XQWLMIDlet.this.notifyDestroyed();
                }
            }
        });
        this.form.setItemStateListener(new ItemStateListener(){

            public void itemStateChanged(Item i) {
                if (i == XQWLMIDlet.this.gSound) {
                    XQWLMIDlet.this.sound = XQWLMIDlet.this.gSound.getValue();
                    XQWLMIDlet.this.playSound(0);
                } else if (i == XQWLMIDlet.this.gMusic) {
                    int originalMusic = XQWLMIDlet.this.music;
                    XQWLMIDlet.this.music = XQWLMIDlet.this.gMusic.getValue();
                    if (XQWLMIDlet.this.music == 0) {
                        XQWLMIDlet.this.stopMusic();
                    } else if (originalMusic == 0) {
                        XQWLMIDlet.this.startMusic("form");
                    } else {
                        XQWLMIDlet.this.setMusicVolume();
                    }
                }
            }
        });
        this.started = false;
    }

    public void startApp() {
        if (this.started) {
            return;
        }
        this.started = true;
        int i = 0;
        while (i < 512) {
            this.rsData[i] = 0;
            ++i;
        }
        this.rsData[19] = 3;
        this.rsData[20] = 2;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            if (re.hasNextElement()) {
                int recordId = re.nextRecordId();
                if (rs.getRecordSize(recordId) == 512) {
                    this.rsData = rs.getRecord(recordId);
                } else {
                    rs.setRecord(recordId, this.rsData, 0, 512);
                }
            } else {
                rs.addRecord(this.rsData, 0, 512);
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flipped = this.rsData[16] != 0;
        this.handicap = Util.MIN_MAX(0, this.rsData[17], 3);
        this.level = Util.MIN_MAX(0, this.rsData[18], 2);
        this.sound = Util.MIN_MAX(0, this.rsData[19], 5);
        this.music = Util.MIN_MAX(0, this.rsData[20], 5);
        this.cgToMove.setSelectedIndex(this.flipped ? 1 : 0, true);
        this.cgLevel.setSelectedIndex(this.level, true);
        this.cgHandicap.setSelectedIndex(this.handicap, true);
        this.gSound.setValue(this.sound);
        this.gMusic.setValue(this.music);
        if (this.rsData[0] == 0) {
            this.startMusic("form");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.form);
        } else {
            this.canvas.load();
            this.startMusic("canvas");
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.canvas);
        }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unc) {
        this.stopMusic();
        this.rsData[16] = (byte)(this.flipped ? 1 : 0);
        this.rsData[17] = (byte)this.handicap;
        this.rsData[18] = (byte)this.level;
        this.rsData[19] = (byte)this.sound;
        this.rsData[20] = (byte)this.music;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            if (re.hasNextElement()) {
                int recordId = re.nextRecordId();
                rs.setRecord(recordId, this.rsData, 0, 512);
            } else {
                rs.addRecord(this.rsData, 0, 512);
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.started = false;
    }

    Player createPlayer(String name, String type) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        try {
            return Manager.createPlayer((InputStream)in, (String)type);
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    void playSound(int response) {
        if (this.sound == 0) {
            return;
        }
        final int i = response;
        new Thread(){

            public void run() {
                Player p = XQWLMIDlet.this.createPlayer("/sounds/" + SOUND_NAME[i] + ".wav", "audio/x-wav");
                if (p == null) {
                    return;
                }
                try {
                    p.realize();
                    VolumeControl vc = (VolumeControl)p.getControl("VolumeControl");
                    if (vc != null) {
                        vc.setLevel(XQWLMIDlet.this.sound * 10);
                    }
                    long t = p.getDuration();
                    p.start();
                    if (t != -1L) {
                        Thread.sleep(t / 1000L + 1L);
                    }
                    while (p.getState() == 400) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.close();
            }
        }.start();
    }

    void stopMusic() {
        if (this.midiPlayer != null) {
            this.midiPlayer.close();
            this.midiPlayer = null;
        }
    }

    void startMusic(String strMusic) {
        this.stopMusic();
        if (this.music == 0) {
            return;
        }
        this.midiPlayer = this.createPlayer("/musics/" + strMusic + ".mid", "audio/midi");
        if (this.midiPlayer == null) {
            return;
        }
        try {
            this.midiPlayer.setLoopCount(-1);
            this.midiPlayer.realize();
            this.setMusicVolume();
            this.midiPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setMusicVolume() {
        VolumeControl vc;
        if (this.midiPlayer != null && (vc = (VolumeControl)this.midiPlayer.getControl("VolumeControl")) != null) {
            vc.setLevel(this.music * 10);
        }
    }
}

