/*
 * Decompiled with CFR 0.152.
 */
import constants.Cst;

public class Level
implements Cst {
    static int[][] levelIds;
    static byte[] playingLayerId;
    static int currentLevel;
    static int tileWidth;
    static int tileHeight;
    static int tileWidthHalf;
    static int tileHeightHalf;
    static int tileWidthReciprocal;
    static int tileHeightReciprocal;
    static byte[] OVERLAY_BITS_USED;
    static int layerCount;
    static Layer[] layers;
    static Layer playLayer;
    static int playLayerIndex;
    static int currentLoadingLayerIndex;
    static int numberOfColumns;
    static int numberOfRows;
    static byte[] mapPropArray;
    static int boundLeft;
    static int boundRight;
    static int boundTop;
    static int boundBottom;
    static int tileIndex;
    static int tileX;
    static int tileY;

    public static void deallocate() {
        layers = null;
        playLayer = null;
        mapPropArray = null;
    }

    public static int getMapProperty(int x, int y) {
        if (x < 0 || x >= numberOfColumns || y < 0 || y >= numberOfRows) {
            return 1;
        }
        return mapPropArray[x + numberOfColumns * y];
    }

    public static void setMapProperty(int x, int y, int prop) {
        if (x < 0 || x >= numberOfColumns || y < 0 || y >= numberOfRows) {
            return;
        }
        int n = x + numberOfColumns * y;
        mapPropArray[n] = (byte)(mapPropArray[n] | (byte)prop);
    }

    public static int checkCollision(int startX, int startY, int deltaX, int deltaY, int tileID, boolean horizontal, int rectLength) {
        --rectLength;
        int maxDelta = Math.max(Math.abs(deltaX), Math.abs(deltaY));
        int count = 2;
        int increment = 1;
        while (maxDelta > tileWidth) {
            count += increment;
            increment <<= 1;
            maxDelta = Math.max(Math.abs(deltaX >>= 1), Math.abs(deltaY >>= 1));
        }
        int i = count;
        while (i > 0) {
            tileIndex = Level.getTileIndex(startX, startY);
            int tValue = horizontal ? tileY : tileX;
            int saveTileX = tileX;
            int saveTileY = tileY;
            int endIndex = horizontal ? Level.getTileIndex(startX + rectLength, startY) + 1 : Level.getTileIndex(startX, startY + rectLength) + numberOfColumns;
            tileX = saveTileX;
            tileY = saveTileY;
            while (tileIndex != endIndex) {
                byte tileAttribute = mapPropArray[tileIndex];
                if ((tileAttribute & tileID) > 0) {
                    return tValue;
                }
                if (horizontal) {
                    ++tileIndex;
                    tileX += tileWidth;
                } else {
                    tileIndex += numberOfColumns;
                    tileY += tileHeight;
                }
                if (tileIndex < mapPropArray.length) continue;
                return -1;
            }
            startX += deltaX;
            startY += deltaY;
            --i;
        }
        return -1;
    }

    public static int getTileIndex(int x, int y) {
        int col;
        int row = y > 0 ? y * tileHeightReciprocal >> 16 : 0;
        int index = row * numberOfColumns + (col = x > 0 ? x * tileWidthReciprocal >> 16 : 0);
        if (index >= mapPropArray.length) {
            index = 0;
        }
        tileX = col * tileWidth;
        tileY = row * tileHeight;
        return col >= numberOfColumns || row >= numberOfRows ? 0 : index;
    }
}

