/*
 * Decompiled with CFR 0.152.
 */
package anim;

import javax.microedition.lcdui.Graphics;
import jg.AnimSet;
import jg.JgCanvas;

public class MeshSet {
    private static final int POINT_ID_NORMAL = 0;
    private static final int POINT_ID_END = 1;
    private char[] frameToPointMap;
    private int[][] meshPoints;
    short beginMeshListId;
    short endMeshListId;
    short endMeshId;

    public static MeshSet load(AnimSet animSet, int beginMeshListId, int endMeshListId, int endMeshId) {
        MeshSet ms = new MeshSet();
        int frameCount = animSet.getFrameNumber();
        ms.frameToPointMap = new char[frameCount];
        ms.meshPoints = MeshSet.expand(ms.meshPoints);
        ms.beginMeshListId = (short)beginMeshListId;
        ms.endMeshListId = (short)endMeshListId;
        ms.endMeshId = (short)endMeshId;
        int gobCount = 0;
        int currentMeshList = 0;
        int[] ixyt = new int[800];
        int frame = 0;
        while (frame < frameCount) {
            gobCount = animSet.getFrameGobs(frame, 0, ixyt) * 4;
            int currentGob = 0;
            beginMeshListId = -1;
            endMeshListId = -1;
            while (currentGob < gobCount) {
                int index = ixyt[currentGob];
                if (beginMeshListId < 0 && index == ms.beginMeshListId) {
                    beginMeshListId = currentGob;
                }
                if (endMeshListId < 0 && index == ms.endMeshListId) {
                    endMeshListId = currentGob;
                }
                if (beginMeshListId >= 0 && endMeshListId >= 0) {
                    ms.meshPoints = MeshSet.expand(ms.meshPoints);
                    ms.meshPoints[++currentMeshList] = new int[endMeshListId - beginMeshListId + 4 >> 2];
                    int i = beginMeshListId + 4;
                    int currentPoint = 0;
                    while (i < endMeshListId) {
                        index = ixyt[i + 0];
                        int gobX = ixyt[i + 1];
                        int gobY = ixyt[i + 2];
                        int id = index == endMeshId ? 1 : 0;
                        int[] nArray = ms.meshPoints[currentMeshList];
                        int n = currentPoint;
                        nArray[n] = nArray[n] | (id & 3) << 30;
                        int[] nArray2 = ms.meshPoints[currentMeshList];
                        int n2 = currentPoint;
                        nArray2[n2] = nArray2[n2] | gobX << 17 >>> 2;
                        int[] nArray3 = ms.meshPoints[currentMeshList];
                        int n3 = currentPoint++;
                        nArray3[n3] = nArray3[n3] | gobY << 17 >>> 17;
                        i += 4;
                    }
                    ms.frameToPointMap[frame] = (char)currentMeshList;
                    break;
                }
                currentGob += 4;
            }
            ++frame;
        }
        return ms;
    }

    public final void paint(Graphics g, JgCanvas canvas, int frameIndex, int x, int y, int transformation, int color) {
        if (this.frameToPointMap[frameIndex] > '\u0000') {
            int index = 0;
            int[] points = this.meshPoints[this.frameToPointMap[frameIndex]];
            int point = points[index++];
            int p1x = this.getX(point, transformation);
            int p1y = this.getY(point, transformation);
            point = points[index++];
            int p2x = this.getX(point, transformation);
            int p2y = this.getY(point, transformation);
            g.setColor(color & 0xFFFFFF);
            while (index < points.length) {
                point = points[index++];
                int id = this.getId(point);
                int p3x = this.getX(point, transformation);
                int p3y = this.getY(point, transformation);
                canvas.graphicsFillTriangle(g, x + p1x, y + p1y, x + p2x, y + p2y, x + p3x, y + p3y);
                if (id == 1) {
                    point = points[index++];
                    p1x = this.getX(point, transformation);
                    p1y = this.getY(point, transformation);
                    point = points[index++];
                    p2x = this.getX(point, transformation);
                    p2y = this.getY(point, transformation);
                    continue;
                }
                p1x = p2x;
                p1y = p2y;
                p2x = p3x;
                p2y = p3y;
            }
        }
    }

    private static int[][] expand(int[][] arr) {
        if (arr == null) {
            arr = new int[0][];
        }
        int[][] returnArr = new int[((int[][])arr).length + 1][];
        System.arraycopy(arr, 0, returnArr, 0, ((int[][])arr).length);
        return returnArr;
    }

    private int getX(int point, int transformation) {
        return AnimSet.getTransformedX(point << 2 >> 17, 0, 0, 0, transformation);
    }

    private int getY(int point, int transformation) {
        return AnimSet.getTransformedY(0, point << 17 >> 17, 0, 0, transformation);
    }

    private int getId(int point) {
        return point >>> 30;
    }
}

