/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Match
extends GameInterface {
    static GameRole[] players = new GameRole[4];
    static int leftTeamNum = 0;
    static int RightTeamNum = 1;
    static GameEngine engine = GameEngine.engine;
    static int[][] areaData = new int[4][2];
    static final byte MATCH_READY = 0;
    static final byte MATCH_START = 1;
    static final byte MATCH_PLAY = 2;
    static final byte MATCH_END = 3;
    static final byte MATCH_STAT = 4;
    static final byte TEAM_MAX = 2;
    static int curRoleIndex;
    static byte matchState;
    static byte startTeam;
    static byte curOwner;
    static byte lastOwner;
    static byte lNear;
    static byte rNear;
    static short[][] basket;
    static final short[] defLine;
    static short[][] left_throwPoint;
    static short[][] right_throwPoint;
    static byte[][] teams;
    static String[] teamName;
    boolean autoRun;
    short[][] heartData = new short[][]{{320, 110}, {390, 110}};
    public static final byte TO_BALL = 0;
    public static final byte TO_POINT = 1;
    public static final byte TO_HELP_ATT = 2;
    public static final byte TO_ATTACK = 3;
    public static final byte TO_WAIT = 4;
    public static final byte TO_SHOOT = 5;
    public static final byte TO_DEFEND = 6;
    public static final byte TO_READY = 7;
    public static final byte TO_START = 8;
    public static final byte TO_ATT_NEAR = 9;
    public static final byte TO_GIRL = 10;
    public static final byte OT_NULL = 0;
    public static final byte OT_TEAM_EMY = 1;
    public static final byte OT_TEAM_SELF = 2;
    public static final byte OT_ENEMY = 3;
    public static final byte OT_SELF = 4;
    static byte[] rdmArray;
    static int matchTime;
    byte skillLeftNum = (byte)3;
    byte skillRightNum = (byte)3;
    static int scoreLeft;
    static int scoreRight;
    static int twoPointLeft;
    static int twoPointRight;
    static int twoPointInLeft;
    static int twoPointInRight;
    static int threePointLeft;
    static int threePointRight;
    static int threePointInLeft;
    static int threePointInRight;
    static int doubleLeft;
    static int doubleRight;
    static int attackLeft;
    static int attackRight;
    static int skillLeft;
    static int skillRight;
    boolean isEnd;
    public static short[][] starPos;
    public static byte[] starSpeed;
    public static final int STARNUM = 20;
    public static int speedOfScroll;
    int mapYPix = 320;
    int topScrollPos = 0;
    int gas;
    byte gasSpeed = (byte)4;

    public Match(GameEngine gameEngine) {
        engine = gameEngine;
        for (int i = 0; i < 4; ++i) {
            Match.players[i] = new GameRole(engine, 0, "kbz" + i, 50, 10, 25, 4, 10, 10, i, i, i, i, 0, 0, 30);
            Match.players[i].teamID = (byte)2;
        }
    }

    public void setTeamNum(int n, int n2) {
        leftTeamNum = n;
        RightTeamNum = n2;
    }

    public void init(int n, int n2, boolean bl) {
        int n3;
        this.gas = 0;
        this.isEnd = false;
        this.index = 0;
        matchTime = 2400;
        Match.loadTeam();
        byte[] byArray = null;
        if (bl) {
            byArray = new byte[2];
            for (n3 = 0; n3 < 2; ++n3) {
                byArray[n3] = teams[n2][n3];
            }
        } else {
            byArray = new byte[4];
            for (n3 = 0; n3 < 2; ++n3) {
                byArray[n3] = teams[n][n3];
            }
            for (n3 = 2; n3 < 4; ++n3) {
                byArray[n3] = teams[n2][n3 - 2];
            }
        }
        Match.loadProp(byArray, bl);
        for (n3 = 0; n3 < 2; ++n3) {
            Match.players[n3].teamID = (byte)2;
            Match.players[n3].roleNo = n3;
            Match.players[n3].defendNo = n3 + 2;
            Match.players[n3].curStatus = (byte)19;
            Match.players[n3].nextStatus = (byte)19;
            Match.players[n3].index = 0;
            players[n3].setStatus((byte)19);
            Match.players[n3].isAuto = false;
        }
        for (n3 = 2; n3 < 4; ++n3) {
            Match.players[n3].teamID = 0;
            Match.players[n3].roleNo = n3;
            Match.players[n3].defendNo = n3 - 2;
            Match.players[n3].curStatus = (byte)19;
            Match.players[n3].nextStatus = (byte)19;
            Match.players[n3].index = 0;
            players[n3].setStatus((byte)19);
            Match.players[n3].isAuto = false;
        }
        Match.players[0].isHasBall = true;
        Match.players[1].isHasBall = false;
        Match.players[2].isHasBall = false;
        Match.players[3].isHasBall = false;
        Match.engine.ball.isShow = false;
        Match.engine.ball.setStatus((byte)4);
        curOwner = (byte)-1;
        curRoleIndex = 0;
        startTeam = (byte)2;
        this.setStatus((byte)0);
        Match.initStar();
        try {
            Tools.imgs[98] = Tools.ChangeImage((byte)69, (byte)leftTeamNum);
            Tools.imgs[100] = Tools.ChangeImage((byte)69, (byte)RightTeamNum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        scoreLeft = 0;
        scoreRight = 0;
        twoPointLeft = 0;
        twoPointRight = 0;
        twoPointInLeft = 0;
        twoPointInRight = 0;
        threePointLeft = 0;
        threePointRight = 0;
        threePointInLeft = 0;
        threePointInRight = 0;
        doubleLeft = 0;
        doubleRight = 0;
        attackLeft = 0;
        attackRight = 0;
        skillLeft = 0;
        skillRight = 0;
    }

    public void initRound(int n) {
        startTeam = (byte)(n == 2 ? 0 : 2);
        this.setStatus((byte)0);
        for (int i = 0; i < players.length; ++i) {
            this.play(players[i]);
        }
    }

    public static void matchTime() {
    }

    public static void matchScore() {
    }

    public void play(GameRole gameRole) {
        if (gameRole.isAuto) {
            return;
        }
        block0 : switch (matchState) {
            case 0: {
                if (gameRole.orders[0] == 8) break;
                this.order(gameRole, 7);
                break;
            }
            case 2: {
                byte by = Match.sortOwner(gameRole);
                switch (by) {
                    case 0: {
                        this.order(gameRole, 0);
                        break block0;
                    }
                    case 2: {
                        this.order(gameRole, 2);
                        break block0;
                    }
                    case 1: {
                        this.order(gameRole, 6);
                        break block0;
                    }
                    case 3: {
                        this.order(gameRole, 3);
                        break block0;
                    }
                    case 4: {
                        this.order(gameRole, 1);
                    }
                }
            }
        }
    }

    public static boolean isSuccess(int n) {
        if (n > 99) {
            n = 99;
        }
        if (n < 1) {
            n = 0;
        }
        return (GameEngine.rnd.nextInt() >>> 1) % 100 < n;
    }

    public boolean checkRange(int n, int n2) {
        int n3 = Math.abs(n - basket[n2 == 2 ? 1 : 0][0]);
        if (n3 < 190) {
            return Match.isSuccess(10);
        }
        return Match.isSuccess(1);
    }

    public boolean isReady() {
        for (int i = 0; i < players.length; ++i) {
            if (Match.players[i].orders[0] == 8) continue;
            return false;
        }
        return true;
    }

    public void run() {
        int n;
        lastOwner = curOwner;
        curOwner = (byte)-1;
        for (n = 0; n < players.length; ++n) {
            if ((matchState == 3 || matchState == 4) && Match.players[n].index > 1 || !Match.players[n].isHasBall) continue;
            curOwner = (byte)n;
        }
        if (!Tools.isDraw(Match.players[Match.curRoleIndex].x - 10, Match.players[Match.curRoleIndex].y, Match.players[Match.curRoleIndex].w + 20, Match.players[Match.curRoleIndex].h, 36) && !Match.players[Match.curRoleIndex].isHasBall) {
            if (curRoleIndex == 0 && Tools.isDraw(Match.players[1].x, Match.players[1].y, Match.players[1].w, Match.players[1].h, 36)) {
                curRoleIndex = 1;
            } else if (curRoleIndex == 1 && Tools.isDraw(Match.players[0].x, Match.players[0].y, Match.players[0].w, Match.players[0].h, 36)) {
                curRoleIndex = 0;
            }
        }
        if (this.isReady() && matchState == 0) {
            this.setStatus((byte)1);
        }
        for (n = 0; n < players.length; ++n) {
            if (curOwner != lastOwner) {
                for (int i = 0; i < rdmArray.length; ++i) {
                    Match.rdmArray[i] = -1;
                }
                if (n < 2) {
                    this.play(players[n]);
                } else if (!Match.engine.isGirlShow) {
                    this.play(players[n]);
                }
            }
            if (!(this.isSkill() != -1 || curRoleIndex == n && matchState != 0 || Match.players[n].curStatus != 19 && Match.players[n].curStatus != 20)) {
                switch (Match.players[n].orders[0]) {
                    case 0: {
                        this.runToBall(players[n]);
                        break;
                    }
                    case 1: {
                        this.toRun(players[n], Match.players[n].orders[1], Match.players[n].orders[2]);
                        break;
                    }
                    case 2: {
                        this.helpAtt(players[n]);
                        break;
                    }
                    case 3: {
                        Match.attack(players[n], players[Match.players[n].defendNo]);
                        break;
                    }
                    case 4: {
                        this.waitToRun(players[n]);
                        break;
                    }
                    case 5: {
                        this.shoot(players[n]);
                        break;
                    }
                    case 6: {
                        this.defend(players[n]);
                        break;
                    }
                    case 7: {
                        this.ready(players[n]);
                        break;
                    }
                    case 8: {
                        this.waitToStart(players[n]);
                        break;
                    }
                    case 9: {
                        this.attNear(players[n]);
                        break;
                    }
                    case 10: {
                        this.callToPoint(players[n], this.heartData[n % 2][0], this.heartData[n % 2][1]);
                    }
                }
            }
            if (Match.players[n].roleNo != this.isSkill() && this.isSkill() != -1) continue;
            players[n].move();
        }
    }

    public void order(GameRole gameRole, int n) {
        short s = 0;
        short s2 = 0;
        switch (n) {
            case 0: {
                gameRole.orders[0] = (short)n;
                break;
            }
            case 1: {
                byte by = Match.getRdmNum(gameRole.roleNo, left_throwPoint.length);
                switch (gameRole.teamID) {
                    case 2: {
                        s = right_throwPoint[by][0];
                        s2 = right_throwPoint[by][1];
                        break;
                    }
                    case 0: {
                        s = left_throwPoint[by][0];
                        s2 = left_throwPoint[by][1];
                    }
                }
                gameRole.orders[0] = (short)n;
                gameRole.orders[1] = s;
                gameRole.orders[2] = s2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                gameRole.orders[0] = (short)n;
                break;
            }
            case 4: {
                gameRole.orders[0] = (short)n;
                gameRole.orders[1] = gameRole.response;
                break;
            }
            case 5: {
                gameRole.orders[0] = (short)n;
                break;
            }
            case 7: 
            case 8: {
                gameRole.orders[0] = (short)n;
                break;
            }
            case 10: {
                gameRole.orders[0] = (short)n;
            }
        }
    }

    public void ready(GameRole gameRole) {
        int n;
        int n2 = n = startTeam == 2 ? 0 : 4;
        if ((gameRole.roleNo == 0 && startTeam == 2 || gameRole.roleNo == 2 && startTeam == 0) && !gameRole.isHasBall) {
            this.runToBall(gameRole);
        } else {
            this.toWaitReady(gameRole, startPos[gameRole.roleNo + n][0], startPos[gameRole.roleNo + n][1]);
        }
    }

    public void toWaitReady(GameRole gameRole, int n, int n2) {
        if (Tools.hit(gameRole.x, gameRole.y, gameRole.w, gameRole.bh, n, n2, gameRole.w, gameRole.bh)) {
            gameRole.setStatus((byte)19);
            Match.players[gameRole.roleNo].isLeft = gameRole.roleNo == 0 && startTeam == 2 ? false : (gameRole.roleNo == 2 && startTeam == 0 ? true : startTeam == 2);
            this.order(gameRole, 8);
        } else {
            Match.runToPoint(gameRole, n, n2, gameRole.w, gameRole.bh);
        }
    }

    public void waitToStart(GameRole gameRole) {
        if (gameRole.isHasBall) {
            gameRole.ctrl(49);
        }
    }

    public void shoot(GameRole gameRole) {
        if (gameRole.curStatus == 19) {
            gameRole.ctrl(53);
        }
    }

    public void waitToRun(GameRole gameRole) {
        if (gameRole.curStatus != 19) {
            gameRole.setStatus((byte)19);
        }
        if ((gameRole.orders[1] = (short)(gameRole.orders[1] - 1)) <= 0) {
            this.play(gameRole);
        }
    }

    public static void attack(GameRole gameRole, GameRole gameRole2) {
        int n = gameRole.x + gameRole.w / 2;
        int n2 = gameRole.y - gameRole.bh / 2;
        int n3 = gameRole2.x + gameRole2.w / 2;
        int n4 = gameRole2.y - gameRole2.bh / 2;
        if (Math.abs(n - n3) < 40 && Math.abs(n2 - n4) < gameRole.bh) {
            if (n < n3) {
                gameRole.setDir((byte)3);
            } else {
                gameRole.setDir((byte)2);
            }
            if (gameRole.curStatus != 19) {
                gameRole.setStatus((byte)19);
            } else {
                gameRole.ctrl(53);
            }
        } else {
            int n5 = Math.min(Math.abs(n - n3), 35);
            int n6 = gameRole2.x + (n3 < n ? n5 : -n5);
            if (n6 < 26) {
                n6 = gameRole2.x + n5;
            } else if (n6 > 400) {
                n6 = gameRole2.x - n5;
            }
            Match.runToPoint(gameRole, n6, gameRole2.y, gameRole2.w, gameRole2.bh);
        }
    }

    public void attNear(GameRole gameRole) {
        int n = -1;
        int n2 = 2000;
        for (int i = 0; i < players.length; ++i) {
            int n3;
            if ((gameRole.teamID != 2 ? i >= 2 : i < 2) || (n3 = Math.abs(Match.players[i].x - gameRole.x) + Math.abs(Match.players[i].y - gameRole.y)) >= n2) continue;
            n2 = n3;
            n = i;
        }
        Match.attack(gameRole, players[n]);
    }

    public boolean onLine(GameRole gameRole, int n) {
        switch (n) {
            case 1: {
                return gameRole.x >= defLine[1];
            }
            case 0: {
                return gameRole.x <= defLine[0];
            }
        }
        return false;
    }

    public int getAttRole(GameRole gameRole, int n) {
        int n2;
        byte[] byArray = new byte[2];
        int n3 = 0;
        for (n2 = 0; n2 < players.length; ++n2) {
            if (gameRole.teamID != 2 ? n2 >= 2 : n2 < 2) continue;
            if (Match.players[n2].injureTime > 0 || !this.onLine(players[n2], n)) continue;
            int n4 = n3;
            n3 = (byte)(n3 + 1);
            byArray[n4] = (byte)n2;
        }
        n2 = -1;
        if (n3 > 0) {
            int n5 = 2000;
            for (int i = 0; i < n3; ++i) {
                int n6 = Math.abs(Match.players[byArray[i]].x - gameRole.x) + Math.abs(Match.players[byArray[i]].y - gameRole.y);
                if (n6 >= n5) continue;
                n5 = n6;
                n2 = byArray[i];
            }
        }
        return n2;
    }

    public void helpAtt(GameRole gameRole) {
        int n;
        int n2 = n = gameRole.teamID == 2 ? 1 : 0;
        if (this.onLine(gameRole, n)) {
            byte by = (byte)this.getAttRole(gameRole, n);
            if (by == -1) {
                gameRole.setStatus((byte)19);
            } else {
                Match.attack(gameRole, players[by]);
            }
        } else {
            Match.runToPoint(gameRole, defLine[n], gameRole.y, gameRole.w, gameRole.bh);
        }
    }

    public void defend(GameRole gameRole) {
        int n;
        int n2 = n = gameRole.teamID == 2 ? 0 : 1;
        if (this.onLine(gameRole, n)) {
            byte by = (byte)this.getAttRole(gameRole, n);
            if (by == -1) {
                gameRole.setStatus((byte)19);
            } else {
                Match.attack(gameRole, players[by]);
            }
        } else {
            Match.runToPoint(gameRole, defLine[n], gameRole.y, gameRole.w, gameRole.bh);
        }
    }

    public void toRun(GameRole gameRole, int n, int n2) {
        if (Tools.hit(gameRole.x, gameRole.y, gameRole.w, gameRole.bh, n, n2, gameRole.w, gameRole.bh)) {
            gameRole.setStatus((byte)19);
            if (gameRole.isHasBall) {
                this.order(gameRole, 5);
            } else {
                this.order(gameRole, 4);
            }
        } else {
            Match.runToPoint(gameRole, n, n2, gameRole.w, gameRole.bh);
        }
    }

    public void callToPoint(GameRole gameRole, int n, int n2) {
        gameRole.injureTime = (byte)100;
        if (gameRole.isHasBall) {
            gameRole.isHasBall = false;
            Match.engine.ball.x = gameRole.x;
            Match.engine.ball.y = gameRole.y;
            Match.engine.ball.shadowY = gameRole.y;
            Match.engine.ball.speedX = Math.abs(GameEngine.rnd.nextInt()) % 10 - 5;
            Match.engine.ball.shadowSpeedY = Match.engine.ball.speedY = Math.abs(GameEngine.rnd.nextInt()) % 8 - 4;
            Match.engine.ball.isShow = true;
            Match.engine.ball.setStatus((byte)5);
        }
        if (Tools.hit(gameRole.x, gameRole.y, gameRole.w, gameRole.bh, n, n2, gameRole.w, gameRole.bh)) {
            gameRole.setStatus((byte)-4);
            this.play(gameRole);
        } else {
            Match.runToPoint(gameRole, n, n2, gameRole.w, gameRole.bh);
        }
    }

    public byte getDanger(GameRole gameRole) {
        int n;
        for (int i = n = gameRole.teamID == 2 ? 2 : 0; i < n + 2; ++i) {
            if (Match.players[i].injureTime > 0 || !Tools.hit(Match.players[i].x, Match.players[i].y, Match.players[i].w, Match.players[i].bh, Match.engine.ball.x - 20, Match.engine.ball.shadowY + 10, Match.engine.ball.w + 40, Match.engine.ball.bh + 20)) continue;
            return (byte)i;
        }
        return -1;
    }

    public void runToBall(GameRole gameRole) {
        byte by = this.getDanger(gameRole);
        if (by == -1) {
            if (Tools.hit(gameRole.x, gameRole.y, gameRole.w, gameRole.bh, Match.engine.ball.x - 5, Match.engine.ball.shadowY + 3, Match.engine.ball.w + 10, Match.engine.ball.bh + 6) && gameRole.z == 0 && Match.engine.ball.shadowY - Match.engine.ball.y > 30 && Match.engine.ball.shadowY - Match.engine.ball.y < 50) {
                gameRole.setStatus((byte)24);
            } else if (Tools.hit(gameRole.x, gameRole.y, gameRole.w, gameRole.bh, Match.engine.ball.x, Match.engine.ball.shadowY, Match.engine.ball.w, Match.engine.ball.bh)) {
                gameRole.setStatus((byte)19);
                this.play(gameRole);
            } else {
                Match.runToPoint(gameRole, Match.engine.ball.x, Match.engine.ball.shadowY, Match.engine.ball.w, Match.engine.ball.bh);
            }
        } else {
            Match.attack(gameRole, players[by]);
        }
    }

    public static void runToPoint(GameRole gameRole, int n, int n2, int n3, int n4) {
        int n5 = gameRole.x + gameRole.w / 2;
        int n6 = gameRole.y - gameRole.bh / 2;
        int n7 = n + n3 / 2;
        int n8 = n2 - n4 / 2;
        if (gameRole.curStatus != 20) {
            gameRole.setStatus((byte)20);
        }
        if (Math.abs(n5 - n7) > Math.abs(n6 - n8)) {
            if (n5 < n7) {
                gameRole.setDir((byte)3);
            } else {
                gameRole.setDir((byte)2);
            }
        } else if (n6 < n8) {
            gameRole.setDir((byte)1);
        } else {
            gameRole.setDir((byte)0);
        }
    }

    public static byte sortOwner(GameRole gameRole) {
        for (int i = 0; i < players.length; ++i) {
            if (!Match.players[i].isHasBall) continue;
            if (Match.players[i].roleNo == gameRole.defendNo) {
                return 3;
            }
            if (Match.players[i].roleNo == gameRole.roleNo) {
                return 4;
            }
            if (Match.players[i].teamID == gameRole.teamID) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static byte getRdmNum(int n, int n2) {
        int n3;
        while (Match.isSameNum(n3 = (GameEngine.rnd.nextInt() >>> 1) % n2)) {
        }
        Match.rdmArray[n] = (byte)n3;
        return (byte)n3;
    }

    private static boolean isSameNum(int n) {
        for (int i = 0; i < rdmArray.length; ++i) {
            if (rdmArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public void addScore(int n, int n2, int n3) {
        if (n == 2) {
            scoreLeft += n2;
            if (n3 < 10) {
                if (n2 == 2) {
                    ++twoPointInLeft;
                } else {
                    ++threePointInLeft;
                }
            }
        } else {
            scoreRight += n2;
            if (n3 < 10) {
                if (n2 == 2) {
                    ++twoPointInRight;
                } else {
                    ++threePointInRight;
                }
            }
        }
    }

    public static void drawMatchScore(int n, int n2, int n3) {
        Tools.addObject(77, n, n2, 20, (byte)0, 500);
        Match.drawNumber((byte)54, n3, n3 < 10 ? n + 18 : n + 14, n2 + 4, 7, 17, 600);
    }

    public static void drawMatchTime(int n, int n2, int n3) {
        Tools.addObject(90, n, n2, 17, (byte)0, 500);
        Match.drawNumber((byte)53, n3 / 10 / 60, (n -= 20) + 9, n2 += 3, 6, 20, 600);
        Match.drawNumber((byte)53, -99999, n + 16, n2 - 1, 6, 20, 600);
        if (n3 / 10 % 60 == 0) {
            Match.drawNumber((byte)53, 0, n + 20, n2, 6, 20, 600);
            Match.drawNumber((byte)53, 0, n + 28, n2, 6, 20, 600);
        } else if (n3 / 10 % 60 < 10) {
            Match.drawNumber((byte)53, 0, n + 20, n2, 6, 20, 600);
            Match.drawNumber((byte)53, n3 / 10 % 60, n + 28, n2, 6, 20, 600);
        } else {
            Match.drawNumber((byte)53, n3 / 10 % 60, n + 20, n2, 6, 20, 600);
        }
    }

    public static void drawNumber(byte by, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 9;
        if (n == -99999) {
            Tools.addObject(by, n2, n3, n4 * 10, 0, n4, n7, n5, (byte)0, n6);
            return;
        }
        int n8 = 7;
        int n9 = 0;
        int[] nArray = new int[10];
        do {
            nArray[n9] = n % 10;
            ++n9;
        } while ((n /= 10) > 0);
        for (int i = 0; i < n9; ++i) {
            Tools.addObject(by, n2 + i * n8, n3, nArray[n9 - 1 - i] * n4, 0, n4, n7, n5, (byte)0, n6);
        }
    }

    public int isSkill() {
        for (int i = 0; i < players.length; ++i) {
            if (Match.players[i].curStatus <= 29) continue;
            if (Match.players[i].curStatus == 30 && Match.players[i].index > 6 || Match.players[i].curStatus == 41 && Match.players[i].index > 6) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    public void moveMatch() {
        this.run();
        if (matchState == 3 || matchState == 4) {
            return;
        }
        this.moveGas();
        Match.engine.ball.move();
        this.check();
        if (curOwner == -1) {
            if (Match.engine.ball.curStatus == 2) {
                Match.engine.map.AdjustSrceen(Match.engine.ball.x, Match.engine.ball.shadowY);
            } else {
                Match.engine.map.AdjustSrceen(Match.engine.ball.x, Match.engine.ball.y);
            }
        } else {
            Match.engine.map.AdjustSrceen(Match.players[Match.curOwner].x, Match.players[Match.curOwner].sy);
        }
        engine.moveGirlPicture();
        engine.checkPlayerAttack();
        engine.moveItem();
    }

    public void drawMatch(Graphics graphics) {
        switch (matchState) {
            case 3: {
                GameMap cfr_ignored_0 = Match.engine.map;
                GameMap cfr_ignored_1 = Match.engine.map;
                Match.drawMatchTime(GameMap.setOffX + 120, GameMap.setOffY + 2, matchTime);
                GameMap cfr_ignored_2 = Match.engine.map;
                GameMap cfr_ignored_3 = Match.engine.map;
                Match.drawMatchScore(GameMap.setOffX + 120 - 63, GameMap.setOffY + 2, scoreLeft);
                GameMap cfr_ignored_4 = Match.engine.map;
                GameMap cfr_ignored_5 = Match.engine.map;
                Match.drawMatchScore(GameMap.setOffX + 120 + 28, GameMap.setOffY + 2, scoreRight);
                Match.engine.map.setMap();
                if (++this.index != 50) break;
                this.setStatus((byte)4);
                GameEngine.hitEffectV.removeAllElements();
                break;
            }
            case 4: {
                GameMap cfr_ignored_6 = Match.engine.map;
                GameMap cfr_ignored_7 = Match.engine.map;
                this.drawStat(GameMap.setOffX, GameMap.setOffY + 50, "\u5df1\u961f", "\u654c\u961f");
                ++this.index;
                if (GameEngine.gameRank != 0) {
                    if (GameEngine.gameRank != 6) break;
                }
                if (this.index <= 50) break;
                if (scoreLeft > scoreRight) {
                    for (int i = 0; i < Match.engine.canvas.teamData.length; ++i) {
                        if (Match.engine.canvas.teamData[i] != 0) continue;
                        Match.engine.canvas.teamData[i] = 1;
                        break;
                    }
                    Match.engine.canvas.toTalkStatus(24);
                    MyGameCanvas cfr_ignored_8 = Match.engine.canvas;
                    MyGameCanvas cfr_ignored_9 = Match.engine.canvas;
                    MyGameCanvas.setST((byte)10);
                    break;
                }
                Match.engine.canvas.toTalkStatus(23);
                MyGameCanvas cfr_ignored_10 = Match.engine.canvas;
                MyGameCanvas cfr_ignored_11 = Match.engine.canvas;
                MyGameCanvas.setST((byte)10);
                break;
            }
            default: {
                if (matchTime > 0) {
                    int n;
                    if (matchState != 0 && matchState != 1) {
                        --matchTime;
                    }
                    GameMap cfr_ignored_12 = Match.engine.map;
                    GameMap cfr_ignored_13 = Match.engine.map;
                    Match.drawMatchTime(GameMap.setOffX + 120, GameMap.setOffY + 2, matchTime);
                    GameMap cfr_ignored_14 = Match.engine.map;
                    GameMap cfr_ignored_15 = Match.engine.map;
                    Match.drawMatchScore(GameMap.setOffX + 120 - 63, GameMap.setOffY + 2, scoreLeft);
                    GameMap cfr_ignored_16 = Match.engine.map;
                    GameMap cfr_ignored_17 = Match.engine.map;
                    Match.drawMatchScore(GameMap.setOffX + 120 + 28, GameMap.setOffY + 2, scoreRight);
                    for (n = 0; n < players.length; ++n) {
                        players[n].paint();
                    }
                    if (this.isSkill() == -1) {
                        Match.engine.map.setMap();
                    } else {
                        this.moveStar();
                        GameMap cfr_ignored_18 = Match.engine.map;
                        GameMap cfr_ignored_19 = Match.engine.map;
                        this.drawStar(graphics, GameMap.setOffX, GameMap.setOffY);
                        GameMap cfr_ignored_20 = Match.engine.map;
                        Match.engine.map.drawCarCase(-10, 103 + 83);
                    }
                    Match.engine.ball.paint();
                    for (n = 0; n < 3; ++n) {
                        Match.engine.balleff[n].paint();
                    }
                    this.drawRoleTag();
                } else {
                    int n;
                    for (n = 0; n < players.length; ++n) {
                        Match.players[n].isAuto = true;
                    }
                    if (Match.engine.ball.curStatus == 19 || !Match.engine.ball.isShow) {
                        this.setStatus((byte)3);
                        if (scoreLeft <= scoreRight) {
                            for (n = 0; n < players.length; ++n) {
                                if (Match.players[n].teamID == 2) {
                                    players[n].setStatus((byte)13);
                                    continue;
                                }
                                players[n].setStatus((byte)14);
                            }
                        } else {
                            for (n = 0; n < players.length; ++n) {
                                if (Match.players[n].roleNo < 2) {
                                    players[n].setStatus((byte)14);
                                    continue;
                                }
                                players[n].setStatus((byte)13);
                            }
                        }
                    } else {
                        if (matchState != 0 && matchState != 1) {
                            --matchTime;
                        }
                        GameMap cfr_ignored_21 = Match.engine.map;
                        GameMap cfr_ignored_22 = Match.engine.map;
                        Match.drawMatchTime(GameMap.setOffX + 120, GameMap.setOffY + 2, matchTime);
                        GameMap cfr_ignored_23 = Match.engine.map;
                        GameMap cfr_ignored_24 = Match.engine.map;
                        Match.drawMatchScore(GameMap.setOffX + 120 - 63, GameMap.setOffY + 2, scoreLeft);
                        GameMap cfr_ignored_25 = Match.engine.map;
                        GameMap cfr_ignored_26 = Match.engine.map;
                        Match.drawMatchScore(GameMap.setOffX + 120 + 28, GameMap.setOffY + 2, scoreRight);
                        for (n = 0; n < players.length; ++n) {
                            players[n].paint();
                        }
                        if (this.isSkill() == -1) {
                            Match.engine.map.setMap();
                        } else {
                            this.moveStar();
                            GameMap cfr_ignored_27 = Match.engine.map;
                            GameMap cfr_ignored_28 = Match.engine.map;
                            this.drawStar(graphics, GameMap.setOffX, GameMap.setOffY);
                            GameMap cfr_ignored_29 = Match.engine.map;
                            Match.engine.map.drawCarCase(-10, 103 + 83);
                        }
                        Match.engine.ball.paint();
                        for (n = 0; n < 3; ++n) {
                            Match.engine.balleff[n].paint();
                        }
                        this.drawRoleTag();
                    }
                }
                GameMap cfr_ignored_30 = Match.engine.map;
                GameMap cfr_ignored_31 = Match.engine.map;
                this.drawGas(GameMap.setOffX, GameMap.setOffY + 320);
                GameMap cfr_ignored_32 = Match.engine.map;
                GameMap cfr_ignored_33 = Match.engine.map;
                this.drawSingleItem(GameMap.setOffX + 240 - 27, GameMap.setOffY + 320 - 27, Match.engine.canvas.itemIndex);
                engine.drawItem(graphics);
                engine.drawSuperMan();
            }
        }
    }

    public void drawMatchRoleInterface(int n, int n2, int n3) {
        byte[][] byArrayArray = new byte[][]{{0, 0, 43, 19}, {0, 19, 8, 7}, {9, 20, 37, 5}};
        Tools.addObject(37, n, n2, byArrayArray[0], 36, (byte)0, 900);
        for (int i = 1; i <= n3; ++i) {
            Tools.addObject(37, n + 4 + (i - 1) * 9, n2 - 2, byArrayArray[1], 36, (byte)0, 900);
        }
    }

    public static void addDouble(int n) {
        if (n == 2) {
            ++doubleLeft;
        } else {
            ++doubleRight;
        }
    }

    public static void addPoint(int n, int n2) {
        if (n == 2) {
            if (n2 == 2) {
                ++twoPointLeft;
            } else {
                ++threePointLeft;
            }
        } else if (n2 == 2) {
            ++twoPointRight;
        } else {
            ++threePointRight;
        }
    }

    public static void addSkillNo(int n) {
        if (n == 2) {
            ++skillLeft;
        } else {
            ++skillRight;
        }
    }

    public void drawStat(int n, int n2, String string, String string2) {
        int n3;
        String[] stringArray = new String[]{"\u5f97    \u5206", "\u4e24\u5206\u7403", "\u4e09\u5206\u7403", "\u7bee    \u677f", "\u62a2    \u65ad", "\u5931    \u8bef"};
        Match.engine.canvas.drawBg(GameMap.setOffX, GameMap.setOffY, 800);
        Tools.addObject((byte)4, string, n + 70, n2 + 45, 20, 0xFFFFFF, 1001);
        Tools.addObject((byte)4, string2, n + 120, n2 + 45, 20, 0xFFFFFF, 1001);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            Tools.addObject(85, n + 10, n2 + 65 + 20 * n3, 0, n3 * 12, 34, 12, 20, (byte)0, 1001);
        }
        n3 = 10;
        Match.drawNumber((byte)55, scoreLeft, n + 70 + n3, n2 + 65, 7, 17, 1001);
        Match.drawNumber((byte)55, scoreRight, n + 120 + n3, n2 + 65, 7, 17, 1001);
        int n4 = 0;
        Match.drawNumber((byte)55, twoPointInLeft, n + 70 + n4, n2 + 85, 7, 17, 1001);
        Match.drawNumber((byte)55, -99999, n + 80 + n4, n2 + 85, 7, 17, 1001);
        Match.drawNumber((byte)55, twoPointLeft, n + 90 + n4, n2 + 85, 7, 17, 1001);
        Match.drawNumber((byte)55, twoPointInRight, n + 120 + n4, n2 + 85, 7, 17, 1001);
        Match.drawNumber((byte)55, -99999, n + 130 + n4, n2 + 85, 7, 17, 1001);
        Match.drawNumber((byte)55, twoPointRight, n + 140 + n4, n2 + 85, 7, 17, 1001);
        Match.drawNumber((byte)55, threePointInLeft, n + 70 + n4, n2 + 105, 7, 17, 1001);
        Match.drawNumber((byte)55, -99999, n + 80 + n4, n2 + 105, 7, 17, 1001);
        Match.drawNumber((byte)55, threePointLeft, n + 90 + n4, n2 + 105, 7, 17, 1001);
        Match.drawNumber((byte)55, threePointInRight, n + 120 + n4, n2 + 105, 7, 17, 1001);
        Match.drawNumber((byte)55, -99999, n + 130 + n4, n2 + 105, 7, 17, 1001);
        Match.drawNumber((byte)55, threePointRight, n + 140 + n4, n2 + 105, 7, 17, 1001);
        Match.drawNumber((byte)55, doubleLeft, n + 70 + n3, n2 + 125, 7, 17, 1001);
        Match.drawNumber((byte)55, doubleRight, n + 120 + n3, n2 + 125, 7, 17, 1001);
        Match.drawNumber((byte)55, skillLeft, n + 70 + n3, n2 + 145, 7, 17, 1001);
        Match.drawNumber((byte)55, skillRight, n + 120 + n3, n2 + 145, 7, 17, 1001);
        Match.drawNumber((byte)55, attackLeft, n + 70 + n3, n2 + 165, 7, 17, 1001);
        Match.drawNumber((byte)55, attackRight, n + 120 + n3, n2 + 165, 7, 17, 1001);
    }

    public static void loadTeam() {
        try {
            DataInputStream dataInputStream = new DataInputStream("".getClass().getResourceAsStream("/team.dat"));
            int n = dataInputStream.readShort();
            teams = new byte[n][3];
            teamName = new String[n];
            for (int i = 0; i < n; ++i) {
                byte by = dataInputStream.readByte();
                short s = dataInputStream.readShort();
                byte[] byArray = new byte[s];
                dataInputStream.read(byArray);
                Match.teamName[i] = new String(byArray, "UTF-8");
                for (int j = 0; j < 3; ++j) {
                    Match.teams[i][j] = dataInputStream.readByte();
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadProp(byte[] byArray, boolean bl) {
        try {
            DataInputStream dataInputStream = new DataInputStream("".getClass().getResourceAsStream("/property.dat"));
            int n = dataInputStream.readShort();
            int n2 = bl ? 2 : 0;
            for (int i = 0; i < n; ++i) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                byte[] byArray2 = new byte[s2];
                dataInputStream.read(byArray2);
                String string = new String(byArray2, "UTF-8");
                byte by = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                byte by3 = dataInputStream.readByte();
                byte by4 = dataInputStream.readByte();
                byte by5 = dataInputStream.readByte();
                byte by6 = dataInputStream.readByte();
                byte by7 = dataInputStream.readByte();
                byte by8 = dataInputStream.readByte();
                byte by9 = dataInputStream.readByte();
                byte by10 = dataInputStream.readByte();
                byte by11 = dataInputStream.readByte();
                byte by12 = dataInputStream.readByte();
                byte by13 = dataInputStream.readByte();
                byte by14 = Match.isInclude((byte)i, byArray);
                if (by14 == -1) continue;
                Match.players[by14 + n2] = new GameRole(engine, s, string, by, by2, by3, by4, by5, by6, by7, by8, by9, by10, by11, by12, by13);
                System.out.println("name=" + Match.players[by14 + n2].name);
                System.out.println("speed=" + Match.players[by14 + n2].speedX);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte isInclude(byte by, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (by != byArray[i]) continue;
            return (byte)i;
        }
        return -1;
    }

    public void ctrl(int n) {
        players[curRoleIndex].ctrl(n);
        if (matchTime > 0 || this.index < 5) {
            return;
        }
        switch (n) {
            case -6: 
            case -5: {
                this.isEnd = true;
                if (GameEngine.gameRank != 0 || matchState != 4) break;
                if (scoreLeft > scoreRight) {
                    for (int i = 0; i < Match.engine.canvas.teamData.length; ++i) {
                        if (Match.engine.canvas.teamData[i] != 0) continue;
                        Match.engine.canvas.teamData[i] = 1;
                        break;
                    }
                    Match.engine.canvas.toTalkStatus(24);
                    MyGameCanvas cfr_ignored_0 = Match.engine.canvas;
                    MyGameCanvas cfr_ignored_1 = Match.engine.canvas;
                    MyGameCanvas.setST((byte)10);
                    break;
                }
                Match.engine.canvas.toTalkStatus(23);
                MyGameCanvas cfr_ignored_2 = Match.engine.canvas;
                MyGameCanvas cfr_ignored_3 = Match.engine.canvas;
                MyGameCanvas.setST((byte)10);
                break;
            }
        }
    }

    public boolean matchEnd() {
        return matchTime < 1 && this.isEnd;
    }

    public void ctrlRelease() {
        players[curRoleIndex].ctrlReleased();
    }

    public void move() {
    }

    public void paint() {
    }

    public void setDir(byte by) {
    }

    public void setStatus(byte by) {
        matchState = by;
    }

    public void check() {
        this.checkItem();
        for (int i = 0; i < players.length && Match.engine.ball.isShow; ++i) {
            if (matchState == 0 && (startTeam == 2 && i != 0 || startTeam == 0 && i != 2) || Match.players[i].isHasBall || Match.engine.ball.curStatus != 19 && Match.engine.ball.curStatus != 2 && Match.engine.ball.curStatus != 22 && Match.engine.ball.curStatus != 21 || Match.players[i].curStatus != 19 && Match.players[i].curStatus != 18 && Match.players[i].curStatus != 20 && Match.players[i].curStatus != 24 && Match.players[i].curStatus != 25 || !Tools.hit(Match.players[i].x - (Match.players[i].isLeft ? Match.players[i].rx : Match.players[i].lx), Match.players[i].y, Match.players[i].w + Match.players[i].rx + Match.players[i].lx, 30, Match.engine.ball.x, Match.engine.ball.y, 13, 13) || !Tools.hit(Match.players[i].sx, Match.players[i].sy + Match.players[i].z, Match.players[i].w + Match.players[i].rx + Match.players[i].lx, Match.players[i].bh, Match.engine.ball.x, Match.engine.ball.shadowY, Match.engine.ball.w, Match.engine.ball.bh)) continue;
            Match.players[i].isHasBall = true;
            Match.engine.ball.isShow = false;
            Match.engine.ball.setStatus((byte)4);
            if (Match.players[i].curStatus != 24 && Match.players[i].curStatus != 25 && Match.players[i].curStatus != 20) {
                players[i].setStatus((byte)19);
            }
            if (i < 2) {
                curRoleIndex = i;
            }
            return;
        }
    }

    public void checkItem() {
        int n = GameEngine.item.size();
        block3: for (int i = n - 1; i >= 0; --i) {
            int[] nArray = (int[])GameEngine.item.elementAt(i);
            switch (nArray[2]) {
                case 0: {
                    for (int j = 0; j < players.length; ++j) {
                        if (nArray[3] == Match.players[j].teamID || !Tools.hit(nArray[0], nArray[1], 26, 4, Match.players[j].x, Match.players[j].y, Match.players[j].w, Match.players[j].bh)) continue;
                        this.initItemEff(2, Match.players[j].teamID, Match.players[j].isSlow, Match.players[j].isFast);
                        GameEngine.item.removeElementAt(i);
                        continue block3;
                    }
                    continue block3;
                }
            }
        }
    }

    public void initItemEff(int n, int n2, boolean bl, boolean bl2) {
        switch (n) {
            case 1: {
                System.out.println("aaaa");
                if (n2 == 2) {
                    Match.players[0].isSlow = false;
                    Match.players[1].isSlow = false;
                    Match.players[0].isFast = true;
                    Match.players[1].isFast = true;
                    Match.players[0].skillTime = 300;
                    Match.players[1].skillTime = 300;
                    return;
                }
                Match.players[2].isSlow = false;
                Match.players[3].isSlow = false;
                Match.players[2].isFast = true;
                Match.players[3].isFast = true;
                Match.players[2].skillTime = 200;
                Match.players[3].skillTime = 200;
                return;
            }
            case 2: {
                if (n2 == 2) {
                    Match.players[0].isFast = false;
                    Match.players[1].isFast = false;
                    Match.players[0].isSlow = true;
                    Match.players[1].isSlow = true;
                    Match.players[0].skillTime = 100;
                    Match.players[1].skillTime = 100;
                    break;
                }
                Match.players[3].isFast = false;
                Match.players[2].isFast = false;
                Match.players[3].isSlow = true;
                Match.players[2].isSlow = true;
                Match.players[3].skillTime = 100;
                Match.players[2].skillTime = 100;
            }
        }
    }

    public void drawRoleTag() {
        for (int i = 0; i < 2; ++i) {
            if (i == curRoleIndex) {
                Tools.addObject(72, Match.players[i].x - 9, Match.players[i].y + 7, 0, 0, 32, 16, 36, (byte)0, Match.players[i].y - 1);
                continue;
            }
            if (i != this.passNo(curRoleIndex)) continue;
            Tools.addObject(72, Match.players[i].x - 10, Match.players[i].y + 7, 32, 0, 32, 16, 36, (byte)0, Match.players[i].y - 1);
        }
    }

    public int passNo(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
            }
        }
        return n2;
    }

    public void initPos(int n) {
        for (int i = 0; i < 4; ++i) {
            Match.players[i].x = startPos[i + (n == 2 ? 0 : 4)][0];
            Match.players[i].y = startPos[i + (n == 2 ? 0 : 4)][1];
            Match.players[i].sx = startPos[i + (n == 2 ? 0 : 4)][0];
            Match.players[i].sy = startPos[i + (n == 2 ? 0 : 4)][1];
            Match.players[i].isLeft = i == 0 && n == 2 ? false : (i == 2 && n == 0 ? true : n == 2);
            players[i].setStatus((byte)19);
        }
    }

    public static void initStar() {
        starPos = new short[20][2];
        starSpeed = new byte[20];
        for (int i = 0; i < 20; ++i) {
            GameMap cfr_ignored_0 = Match.engine.map;
            Match.starPos[i][0] = (short)(Math.abs(GameEngine.rnd.nextInt()) % 240 + GameMap.setOffX);
            GameMap cfr_ignored_1 = Match.engine.map;
            Match.starPos[i][1] = (short)(Math.abs(GameEngine.rnd.nextInt()) % 320 + GameMap.setOffY);
            Match.starSpeed[i] = (byte)(Math.abs(GameEngine.rnd.nextInt()) % 3 + 1 + speedOfScroll);
        }
    }

    public void moveStar() {
        for (int i = 0; i < 20; ++i) {
            short[] sArray = starPos[i];
            sArray[0] = (short)(sArray[0] - (starSpeed[i] + speedOfScroll * 2));
            if (starPos[i][0] + starSpeed[i] >= 0) continue;
            GameMap cfr_ignored_0 = Match.engine.map;
            Match.starPos[i][0] = (short)(240 + GameMap.setOffX);
            GameMap cfr_ignored_1 = Match.engine.map;
            Match.starPos[i][1] = (short)(Math.abs(GameEngine.rnd.nextInt()) % this.mapYPix + GameMap.setOffY);
            Match.starSpeed[i] = (byte)(Math.abs(GameEngine.rnd.nextInt()) % 3 + 1);
        }
    }

    public void drawStar(Graphics graphics, int n, int n2) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(n, n2, 240, 320);
        int n3 = this.topScrollPos >> 1;
        for (int i = 0; i < 20; ++i) {
            int n4 = starSpeed[i] - 1 + speedOfScroll;
            graphics.setColor(0, 128, 255);
            graphics.drawLine((int)starPos[i][0], starPos[i][1] + n3, starPos[i][0] + n4, starPos[i][1] + n3);
            if (n4 <= 0) continue;
            graphics.setColor(255, 255, 255);
            graphics.drawLine((int)starPos[i][0], starPos[i][1] + n3, starPos[i][0] + (n4 >> 1) + (n4 >> 2), starPos[i][1] + n3);
        }
    }

    public void moveGas() {
        if (Match.players[Match.curRoleIndex].curStatus == 19 && Match.players[Match.curRoleIndex].isHasBall && matchState != 0 && matchState != 1) {
            if (this.gas < 100) {
                GameMap cfr_ignored_0 = Match.engine.map;
                if (Match.players[Match.curRoleIndex].x >= GameMap.MapW / 2) {
                    this.gas = Match.players[Match.curRoleIndex].x < 340 ? (this.gas += this.gasSpeed / 2) : (this.gas += this.gasSpeed);
                }
            } else {
                this.gas = 100;
            }
        } else {
            this.gas = this.gas > 0 ? (this.gas -= 4) : 0;
        }
    }

    public void drawGas(int n, int n2) {
        block5: {
            block4: {
                if (GameRole.gasTime > 0) {
                    this.gas = 100;
                }
                Tools.addObject(63, n + 3, n2 - 10, 0, 0, 51, 12, 36, (byte)0, 800);
                if (this.gas < 100) break block4;
                if (GameEngine.gameTimes % 2 == 0) break block5;
            }
            Tools.addObject(63, n + 3, n2 - 10 - 1, 0, 12, 51 * this.gas / 100, 12, 36, (byte)0, 900);
        }
    }

    public void drawItemList(int n, int n2, int n3) {
        Tools.addObject(63, n + 3, n2 - 10 - 1, 0, 12, 51 * this.gas / 100, 12, 36, (byte)0, 900);
    }

    public void drawSingleItem(int n, int n2, int n3) {
        MyGameCanvas cfr_ignored_0 = Match.engine.canvas;
        Tools.addObject(79, n, n2, MyGameCanvas.roleItem[n3] > 0 ? 0 : 54, 0, 27, 27, 20, (byte)0, 500);
        Tools.addObject(38, n + 3, n2 + 2, n3 % 5 * 21, n3 / 5 * 23, 21, 23, 20, (byte)0, 501);
        MyGameCanvas cfr_ignored_1 = Match.engine.canvas;
        Match.drawNumber((byte)55, MyGameCanvas.roleItem[n3], n + 18, n2 + 2, 7, 20, 502);
    }

    static {
        startTeam = 0;
        basket = new short[][]{{30, 165}, {410, 165}};
        defLine = new short[]{163, 285};
        left_throwPoint = new short[][]{{51, 128}, {88, 162}, {51, 192}, {114, 121}, {85, 233}, {152, 155}, {119, 205}};
        right_throwPoint = new short[][]{{395, 128}, {360, 162}, {395, 192}, {334, 121}, {363, 233}, {296, 155}, {330, 205}};
        rdmArray = new byte[6];
        matchTime = 600;
        scoreLeft = 0;
        scoreRight = 0;
        twoPointLeft = 0;
        twoPointRight = 0;
        twoPointInLeft = 0;
        twoPointInRight = 0;
        threePointLeft = 0;
        threePointRight = 0;
        threePointInLeft = 0;
        threePointInRight = 0;
        doubleLeft = 0;
        doubleRight = 0;
        attackLeft = 0;
        attackRight = 0;
        skillLeft = 0;
        skillRight = 0;
        speedOfScroll = 8;
    }
}

