/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game;

import com.iplay.game.InterruptHandler;
import com.iplay.game.interfaces.EffectsHandlerInterface;
import java.io.InputStream;

public abstract class BaseEffectsHandler
extends InterruptHandler
implements EffectsHandlerInterface {
    protected int mEffectsEnabled = 0;

    public boolean isEnabled(int support) {
        return (this.mEffectsEnabled & support) > 0;
    }

    public void setEnabled(int support, boolean enabled) {
        int n = this.mEffectsEnabled = enabled ? (this.mEffectsEnabled = this.mEffectsEnabled | support) : this.mEffectsEnabled & ~support;
        if ((support & 1) > 0) {
            this.stopAllSounds();
        }
        if ((support & 2) > 0) {
            this.stopVibration();
        }
    }

    public void setSoundVolume(int id, int volume) {
        this.soundEffect(2, id, volume);
    }

    public long setSoundPosition(int id, long position) {
        this.soundEffect(6, id, position);
        return 1L;
    }

    public void setSoundLoopCount(int id, int loops) {
        this.soundEffect(8, id, loops);
    }

    public void setSoundEnabled(boolean enabled) {
        this.setEnabled(1, enabled);
    }

    public boolean isSoundEnabled() {
        return this.isEnabled(1);
    }

    public void setVibrationEnabled(boolean enabled) {
        this.setEnabled(2, enabled);
    }

    public boolean getVibrationEnabled() {
        return this.isEnabled(2);
    }

    public void setLightEnabled(boolean enabled) {
        this.setEnabled(4, enabled);
    }

    public boolean getLightEnabled() {
        return this.isEnabled(4);
    }

    public abstract /* synthetic */ void soundRestored();

    public abstract /* synthetic */ void soundInterrupt();

    public abstract /* synthetic */ void flashLight(long[] var1, boolean var2);

    public abstract /* synthetic */ void stopVibration();

    public abstract /* synthetic */ void startVibration(int var1);

    public abstract /* synthetic */ long soundEffect(int var1, int var2, long var3);

    public abstract /* synthetic */ void pauseSound(int var1);

    public abstract /* synthetic */ void stopAllSounds();

    public abstract /* synthetic */ void stopSound(int var1);

    public abstract /* synthetic */ void playSound(int var1, int var2);

    public abstract /* synthetic */ void disposeSound(int var1);

    public abstract /* synthetic */ void loadSounds();

    public abstract /* synthetic */ boolean loadSound(String var1, String var2, int var3);

    public abstract /* synthetic */ boolean loadSound(byte[] var1, String var2, int var3);

    public abstract /* synthetic */ boolean loadSound(InputStream var1, String var2, int var3);

    public abstract /* synthetic */ boolean isSoundLoaded(int var1);

    public abstract /* synthetic */ void initSound(int var1, int var2);
}

