/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.font;

import com.iplay.game.AbstractData;
import com.iplay.game.PackHandler;
import com.iplay.game.font.ExtendedCharHandler;
import com.iplay.game.font.FontHandlerInterface;
import com.iplay.game.interfaces.FontInterface;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Font
extends AbstractData
implements FontInterface,
FontHandlerInterface {
    private static final boolean DEBUG = false;
    private static final int DEFINITION_INT_DATA = 0;
    private static final int DEFINITION_CHARSET_STRING = 1;
    private static final int DEFINITION_CHAR_X_OFFSETS = 2;
    private static final int DEFINITION_OVERLOADED_TYPES = 3;
    private static final int DEFINITION_IMAGE = 4;
    private static final int DEFINITION_DEAD_PIXELS = 5;
    private static final int DEFINITION_FIELDS = 6;
    private static final int CELL_HEIGHT = 0;
    private static final int BASELINE = 1;
    private static final int CHAR_SPACE = 2;
    private static final int WORD_SPACE = 3;
    private static final int INSTANCE_DATA = 0;
    private static final int INSTANCE_FIELDS = 1;
    private static ExtendedCharHandler handler;
    private static Vector overloadedFonts;
    public static final char BREAK_PERMITTED_HERE_CHAR = '\u0082';
    public static final char ZERO_WIDTH_SPACE_CHAR = '\u200b';
    public static final char SOFT_HYPHEN = '\u00ad';
    private static final char HYPHEN = '-';

    public static void setExtendedCharHandler(ExtendedCharHandler extendedCharHandler) {
    }

    public static void overloadFonts(int[] nArray, String string, String string2) {
        if (overloadedFonts == null) {
            overloadedFonts = new Vector();
        }
        Object[] objectArray = Font.loadFont(string, string2);
        objectArray[3] = nArray;
        overloadedFonts.addElement(objectArray);
    }

    public static boolean clearFont(Font font) {
        return overloadedFonts.removeElement(font.getData(0));
    }

    public Font(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        block3: {
            super(1);
            int n2 = overloadedFonts.size();
            objectArray2 = null;
            for (int i = 0; i < n2; ++i) {
                objectArray = (Object[])overloadedFonts.elementAt(i);
                int[] nArray = (int[])objectArray[3];
                for (int j = 0; j < nArray.length; ++j) {
                    if (nArray[j] != n) {
                        continue;
                    }
                    break block3;
                }
            }
            throw new IllegalArgumentException("No overloaded graphical font found with id = " + n);
        }
        objectArray2 = objectArray;
        this.setData(0, objectArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object[] loadFont(String string, String string2) {
        Object[] objectArray = null;
        System.gc();
        Image image = PackHandler.createImage(string2);
        try {
            short[] sArray;
            short[] sArray2;
            String string3;
            byte by;
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = PackHandler.getResourceAsDataStream(string);
            try {
                dataInputStream.readUnsignedByte();
                n3 = dataInputStream.readUnsignedByte();
                n2 = dataInputStream.readUnsignedByte();
                n = dataInputStream.readUnsignedByte();
                by = dataInputStream.readByte();
                string3 = dataInputStream.readUTF();
                sArray2 = new short[string3.length() + 1];
                sArray = new short[image.getHeight() / n3];
                int n4 = image.getWidth();
                for (int i = 1; i < sArray2.length; ++i) {
                    int n5 = dataInputStream.readUnsignedByte();
                    sArray2[i] = (short)(sArray2[i - 1] + n5);
                    if (sArray2[i] <= n4) continue;
                    short s = (short)(n4 - sArray2[i - 1]);
                    sArray[(n4 - 1) / image.getWidth()] = s;
                    n4 += image.getWidth();
                    int n6 = i;
                    sArray2[n6] = (short)(sArray2[n6] + s);
                    int n7 = i - 1;
                    sArray2[n7] = (short)(sArray2[n7] + s);
                }
            }
            finally {
                dataInputStream.close();
            }
            objectArray = new Object[6];
            objectArray[5] = sArray;
            objectArray[0] = new int[]{n3, n2, by, n};
            objectArray[1] = string3;
            objectArray[2] = sArray2;
            objectArray[4] = image;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectArray;
    }

    public final int getHeight() {
        javax.microedition.lcdui.Font font = javax.microedition.lcdui.Font.getFont((int)64, (int)0, (int)0);
        return font.getHeight();
    }

    public final int getHeight2() {
        return ((int[])((Object[])this.datas[0])[0])[0];
    }

    public final int charsWidth(char[] cArray, int n, int n2, boolean bl) {
        return this.drawCharArray(null, cArray, n, n2, 0, 0, 0, bl);
    }

    public final int substringWidth(String string, int n, int n2, boolean bl) {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        return this.charsWidth(cArray, 0, n2, bl);
    }

    public final int charsWidth(char[] cArray, int n, int n2) {
        return this.drawCharArray(null, cArray, n, n2, 0, 0, 0, true);
    }

    public final int substringWidth(String string, int n, int n2) {
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        return this.charsWidth(cArray, 0, n2);
    }

    public final int getBaselinePosition() {
        return ((int[])((Object[])this.datas[0])[0])[1];
    }

    public final int GetAlignment(int n) {
        if (n >= 512) {
            n -= 512;
        }
        if (n >= 256) {
            n -= 256;
        }
        if (n >= 128) {
            n -= 128;
        }
        if (n == 3) {
            n = 17;
        }
        return n;
    }

    public final void drawString(Graphics graphics, String string, int n, int n2, int n3, boolean bl) {
        if (bl) {
            n3 = this.GetAlignment(n3);
            graphics.setColor(0);
            graphics.drawString(string, n, n2, n3);
        } else {
            this.drawString(graphics, string, n, n2, n3);
        }
    }

    public final void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (bl) {
            n5 = this.GetAlignment(n5);
            graphics.setColor(0);
            graphics.drawString(new String(cArray, n, n2), n3, n4, n5);
        } else {
            this.drawChars(graphics, cArray, n, n2, n3, n4, n5);
        }
    }

    public final void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        char[] cArray = string.toCharArray();
        this.drawChars(graphics, cArray, 0, cArray.length, n, n2, n3);
    }

    public final void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5) {
        this.drawCharArray(graphics, cArray, n, n2, n3, n4, n5, false);
    }

    private final int drawCharArray(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl2 = (n5 & 0x80) != 0;
        boolean bl3 = (n5 & 0x100) != 0;
        boolean bl4 = (n5 & 0x200) != 0;
        n5 &= 0xFFFFFC7F;
        Object[] objectArray = (Object[])this.datas[0];
        int[] nArray = (int[])objectArray[0];
        int n10 = nArray[2];
        int n11 = nArray[3];
        String string = (String)objectArray[1];
        short[] sArray = (short[])objectArray[2];
        Image image = (Image)objectArray[4];
        int n12 = image.getWidth();
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        if (graphics != null) {
            n13 = graphics.getClipX();
            n14 = graphics.getClipY();
            n15 = graphics.getClipWidth();
            n16 = graphics.getClipHeight();
            n17 = nArray[0];
            if ((n5 & 0x20) != 0) {
                n4 -= n17;
            } else if ((n5 & 0x40) != 0) {
                n4 -= this.getBaselinePosition();
            }
            n9 = n5 & 0xD;
            n8 = n9 != 4 || bl2 ? this.drawCharArray(null, cArray, n, n2, n3, n4, 20, bl) : -1;
            if (n9 == 1) {
                n3 -= n8 / 2;
            } else if (n9 == 8) {
                n3 -= n8;
            }
            if (bl2) {
                n7 = graphics.getColor();
                n6 = n4 + this.getBaselinePosition() + 1;
                if (bl3) {
                    graphics.setColor(n7 ^ 0xFFFFFF);
                    graphics.fillRect(n3 + 1, n6 + 1, n8, 1);
                }
                graphics.setColor(n7);
                graphics.fillRect(n3, n6, n8, 1);
            }
        }
        n8 = n + n2;
        for (n9 = n; n9 < n8; ++n9) {
            n6 = string.indexOf(cArray[n9], 0);
            if (n6 >= 0) {
                int n19 = sArray[n6 + 1];
                if (n19 % n12 == 0) {
                    short[] sArray2 = (short[])objectArray[5];
                    n19 -= sArray2[(n19 - 1) / n12];
                }
                n7 = n19 - sArray[n6] & 0xFFFF;
                if (graphics != null) {
                    int n20 = n3 + n18;
                    graphics.setClip(n13, n14, n15, n16);
                    graphics.clipRect(n20, n4, n7, n17);
                    graphics.drawImage(image, n20 - sArray[n6] % n12, n4 - sArray[n6] / n12 * n17, 20);
                }
            } else {
                n7 = n11;
            }
            n18 += n7 + n10;
        }
        if (n2 > 0) {
            n18 -= n10;
        }
        if (graphics != null) {
            graphics.setClip(n13, n14, n15, n16);
            if (bl4) {
                graphics.fillRect(n3, n4 + this.getBaselinePosition() / 2, n18, 1);
            }
        }
        if (bl) {
            String string2 = new String(cArray, n, n2);
            javax.microedition.lcdui.Font font = javax.microedition.lcdui.Font.getFont((int)64, (int)0, (int)0);
            n18 = font.stringWidth(string2);
        }
        return n18;
    }

    public static char[][] formatString(FontInterface fontInterface, char[] cArray, int n) {
        int n2;
        int n3 = cArray.length;
        Vector<char[]> vector = new Vector<char[]>();
        if (n3 == 0) {
            vector.addElement(cArray);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                char c = cArray[i];
                boolean bl = false;
                if (c != '\n' && c != '\u0082' && c != '\u200b' && c != '\u00ad') {
                    stringBuffer.append(c);
                }
                int n6 = stringBuffer.length();
                if (c == ' ') {
                    --n6;
                }
                char[] cArray2 = new char[n6];
                if (n6 != 0) {
                    stringBuffer.getChars(0, n6, cArray2, 0);
                }
                if (fontInterface.charsWidth(cArray2, 0, n6) > n) {
                    if (n4 != 0) {
                        stringBuffer.setLength(n5);
                        i = n4;
                    } else {
                        int n7;
                        boolean bl2 = false;
                        int n8 = 0;
                        for (n7 = i; n7 >= n2; --n7) {
                            if (cArray[n7] == '\u0082' || cArray[n7] == '\u200b' || cArray[n7] == '\u00ad') {
                                boolean bl3 = cArray[n7] == '\u00ad';
                                int n9 = n;
                                if (bl3) {
                                    char[] cArray3 = new char[]{'-'};
                                    int n10 = fontInterface.charsWidth(cArray3, 0, cArray3.length);
                                    n9 -= n10;
                                }
                                if (fontInterface.charsWidth(cArray2, 0, stringBuffer.length() - n8) > n9) continue;
                                stringBuffer.setLength(stringBuffer.length() - n8);
                                if (bl3) {
                                    stringBuffer.append('-');
                                }
                                i = n7;
                                bl2 = true;
                                break;
                            }
                            ++n8;
                        }
                        if (!bl2) {
                            for (n8 = 2; n8 <= stringBuffer.length(); ++n8) {
                                n7 = fontInterface.charsWidth(cArray2, 0, n8);
                                if (n7 <= n) continue;
                                stringBuffer.setLength(n8 - 1);
                                i = n2 + (n8 - 1) - 1;
                            }
                        }
                    }
                    bl = true;
                } else if (i == n3 - 1 || c == '\n') {
                    bl = true;
                }
                if (!bl) continue;
                n6 = stringBuffer.length();
                cArray2 = new char[n6];
                if (n6 != 0) {
                    stringBuffer.getChars(0, n6, cArray2, 0);
                }
                stringBuffer = new StringBuffer();
                vector.addElement(cArray2);
                n4 = 0;
                n5 = 0;
                n2 = i + 1;
            }
        }
        int n11 = vector.size();
        char[][] cArrayArray = new char[n11][];
        for (n2 = 0; n2 < n11; ++n2) {
            cArrayArray[n2] = (char[])vector.elementAt(n2);
        }
        return cArrayArray;
    }
}

