/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.image;

import com.iplay.game.math.FixedPoint12;

public class PNGUtils {
    private static int[] crcTable;
    public static final int PNGHEADER_LENGTH = 8;
    public static final int CHUNKLENGTH_LENGTH = 4;
    public static final int CHUNKNAME_LENGTH = 4;
    public static final int CHUNKCRC_LENGTH = 4;
    public static final int ZLIB_HEADER_LENGTH = 7;
    private static final int ZLIB_CRC_LENGTH = 4;
    public static final int CHUNKNAME_IHDR = 1229472850;
    public static final int CHUNKNAME_IDAT = 1229209940;
    public static final int CHUNKNAME_PLTE = 1347179589;
    public static final int CHUNKNAME_TRNS = 1951551059;
    public static final int CHUNKNAME_IEND = 1229278788;
    private static final int COLOR_TYPE_GREYSCALE_ALPHA = 4;
    private static final int COLOR_TYPE_RGB_ALPHA = 6;

    public static void releaseCRCTable() {
        crcTable = null;
    }

    private static void allocateCRCTable() {
        if (crcTable == null) {
            int[] nArray = new int[256];
            for (int i = 0; i < 256; ++i) {
                int n = i;
                for (int j = 0; j < 8; ++j) {
                    if ((n & 1) != 0) {
                        n = 0xEDB88320 ^ n >>> 1;
                        continue;
                    }
                    n >>>= 1;
                }
                nArray[i] = n;
            }
            crcTable = nArray;
        }
    }

    public static int getChunkIndex(byte[] byArray, int n, int n2) {
        int n3;
        while ((n3 = PNGUtils.getChunkName(byArray, n)) != n2 && (n = PNGUtils.getNextChunkStart(byArray, n)) != -1) {
        }
        return n;
    }

    public static int getNextChunkStart(byte[] byArray, int n) {
        int n2 = PNGUtils.getChunkLength(byArray, n);
        int n3 = n + 4 + 4 + n2 + 4;
        if (n3 >= byArray.length) {
            n3 = -1;
        }
        return n3;
    }

    public static int getChunkLength(byte[] byArray, int n) {
        int n2 = MSB.readInt(byArray, n);
        return n2;
    }

    private static int getChunkName(byte[] byArray, int n) {
        int n2 = MSB.readInt(byArray, n + 4);
        return n2;
    }

    public static byte[] injectChunkData(byte[] byArray, int n, byte[] byArray2) {
        byte[] byArray3;
        int n2 = PNGUtils.getChunkLength(byArray, n);
        int n3 = n + 4 + 4;
        if (n2 != byArray2.length) {
            byArray3 = new byte[byArray.length + byArray2.length - n2];
            System.arraycopy(byArray, 0, byArray3, 0, n3);
            System.arraycopy(byArray, n3 + n2, byArray3, n3 + byArray2.length, byArray3.length - n3 - byArray2.length);
            MSB.writeInt(byArray2.length, byArray3, n);
        } else {
            byArray3 = byArray;
        }
        System.arraycopy(byArray2, 0, byArray3, n3, byArray2.length);
        int n4 = PNGUtils.generateCRC(byArray3, n + 4, n3 + byArray2.length);
        MSB.writeInt(n4, byArray3, n3 + byArray2.length);
        return byArray3;
    }

    public static void modifyPalette(byte[] byArray, int n) {
        int n2;
        int n3 = PNGUtils.getChunkIndex(byArray, 8, 1347179589);
        int n4 = PNGUtils.getChunkLength(byArray, n3);
        int n5 = n3 + 4 + 4;
        int n6 = n5 + n4;
        for (n2 = n5; n2 < n6; ++n2) {
            int n7 = (n2 - n5) % 3;
            int n8 = (2 - n7) * 8;
            int n9 = n >> n8 & 0xFF;
            byArray[n2] = (byte)((byArray[n2] & 0xFF) * n9 / 255);
        }
        n2 = PNGUtils.generateCRC(byArray, n3 + 4, n6);
        MSB.writeInt(n2, byArray, n6);
    }

    public static void fadePalette(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = FixedPoint12.toInt(256 * n2);
        int n5 = PNGUtils.getChunkIndex(byArray, 8, 1347179589);
        int n6 = PNGUtils.getChunkLength(byArray, n5);
        int n7 = n5 + 4 + 4;
        int n8 = n7 + n6;
        for (n3 = n7; n3 < n8; n3 += 3) {
            int n9 = (n >> 16 & 0xFF) * n4;
            byArray[n3] = (byte)((n9 += (byArray[n3] & 0xFF) * (256 - n4)) >> 8);
            n9 = (n >> 8 & 0xFF) * n4;
            byArray[n3 + 1] = (byte)((n9 += (byArray[n3 + 1] & 0xFF) * (256 - n4)) >> 8);
            n9 = (n & 0xFF) * n4;
            byArray[n3 + 2] = (byte)((n9 += (byArray[n3 + 2] & 0xFF) * (256 - n4)) >> 8);
        }
        n3 = PNGUtils.generateCRC(byArray, n5 + 4, n8);
        MSB.writeInt(n3, byArray, n8);
    }

    public static byte[] rescaleUncompressedPalettized8BPP(byte[] byArray, int n, int n2) {
        int n3 = PNGUtils.getChunkIndex(byArray, 8, 1229472850);
        int n4 = n3 + 4 + 4;
        int n5 = MSB.readInt(byArray, n4);
        int n6 = MSB.readInt(byArray, n4 + 4);
        int n7 = FixedPoint12.toInt(n5 * n);
        int n8 = FixedPoint12.toInt(n6 * n2);
        if (n7 != n5 || n8 != n6) {
            if (n7 <= 0 || n8 <= 0) {
                byArray = null;
            } else {
                int n9;
                int n10;
                int n11;
                int n12 = PNGUtils.getChunkIndex(byArray, 8, 1229209940);
                int n13 = n12 + 4 + 4;
                int n14 = n13 + 7;
                int n15 = (n7 + 1) * n8 + 7 + 4;
                byte[] byArray2 = new byte[n15];
                int n16 = 0;
                byArray2[n16++] = 120;
                byArray2[n16++] = -38;
                byArray2[n16++] = 1;
                byArray2[n16++] = (byte)((n7 + 1) * n8);
                byArray2[n16++] = (byte)((n7 + 1) * n8 >> 8);
                byArray2[n16++] = (byte)(~((n7 + 1) * n8));
                byArray2[n16++] = (byte)(~((n7 + 1) * n8) >> 8);
                int n17 = FixedPoint12.divide(4096, n);
                int n18 = FixedPoint12.divide(4096, n2);
                ++n16;
                for (n11 = 0; n11 < n8; ++n11) {
                    for (n10 = 0; n10 < n7; ++n10) {
                        n9 = FixedPoint12.toInt(n10 * n17);
                        int n19 = FixedPoint12.toInt(n11 * n18);
                        int n20 = n14 + (n19 * (n5 + 1) + n9 + 1);
                        byArray2[n16] = byArray[n20];
                        ++n16;
                    }
                    ++n16;
                }
                n11 = PNGUtils.generateZlibCRC(byArray2, n7, n8);
                MSB.writeInt(n11, byArray2, byArray2.length - 4);
                byArray = PNGUtils.injectChunkData(byArray, n12, byArray2);
                MSB.writeInt(n7, byArray, n4);
                MSB.writeInt(n8, byArray, n4 + 4);
                n10 = PNGUtils.getChunkLength(byArray, n3);
                n9 = PNGUtils.generateCRC(byArray, n3 + 4, n4 + n10);
                MSB.writeInt(n9, byArray, n4 + n10);
            }
        }
        return byArray;
    }

    public static boolean hasAlpha(byte[] byArray) {
        boolean bl = false;
        int n = 8;
        block4: do {
            int n2 = PNGUtils.getChunkName(byArray, n);
            switch (n2) {
                case 1229472850: {
                    int n3 = n + 4 + 4;
                    int n4 = n3 + 4;
                    int n5 = n4 + 4;
                    int n6 = n5 + 1;
                    int n7 = MSB.readByte(byArray, n6);
                    if (n7 != 4 && n7 != 6) continue block4;
                    bl = true;
                    break;
                }
                case 1951551059: {
                    bl = true;
                }
            }
        } while ((n = PNGUtils.getNextChunkStart(byArray, n)) != -1 && !bl);
        return bl;
    }

    public static int generateCRC(byte[] byArray, int n, int n2) {
        PNGUtils.allocateCRCTable();
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            n3 = crcTable[(n3 ^ byArray[i]) & 0xFF] ^ n3 >>> 8;
        }
        return n3 ^= 0xFFFFFFFF;
    }

    public static int generateZlibCRC(byte[] byArray, int n, int n2) {
        int n3 = 7 + n2 * (n + 1);
        int n4 = 1;
        int n5 = n4 & 0xFFFF;
        int n6 = n4 >>> 16 & 0xFFFF;
        for (int i = 7; i < n3; ++i) {
            n5 = (n5 + (byArray[i] & 0xFF)) % 65521;
            n6 = (n6 + n5) % 65521;
        }
        n4 = (n6 << 16) + n5;
        return n4;
    }

    public static class MSB {
        public static int readInt(byte[] byArray, int n) {
            int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            return n2;
        }

        public static int readShort(byte[] byArray, int n) {
            int n2 = ((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF) & 0xFFFF;
            return n2;
        }

        public static int readByte(byte[] byArray, int n) {
            int n2 = byArray[n] & 0xFF;
            return n2;
        }

        public static void writeInt(int n, byte[] byArray, int n2) {
            byArray[n2] = (byte)(n >> 24);
            byArray[n2 + 1] = (byte)(n >> 16);
            byArray[n2 + 2] = (byte)(n >> 8);
            byArray[n2 + 3] = (byte)n;
        }

        public static void writeShort(int n, byte[] byArray, int n2) {
            byArray[n2] = (byte)(n >> 8);
            byArray[n2 + 1] = (byte)n;
        }

        public static void writeByte(int n, byte[] byArray, int n2) {
            byArray[n2] = (byte)n;
        }
    }

    public static class LSB {
        public static int readInt(byte[] byArray, int n) {
            int n2 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
            return n2;
        }

        public static int readShort(byte[] byArray, int n) {
            int n2 = (byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8) & 0xFFFF;
            return n2;
        }

        public static int readByte(byte[] byArray, int n) {
            int n2 = byArray[n] & 0xFF;
            return n2;
        }

        public static void writeInt(int n, byte[] byArray, int n2) {
            byArray[n2] = (byte)n;
            byArray[n2 + 1] = (byte)(n >> 8);
            byArray[n2 + 2] = (byte)(n >> 16);
            byArray[n2 + 3] = (byte)(n >> 24);
        }

        public static void writeShort(int n, byte[] byArray, int n2) {
            byArray[n2] = (byte)n;
            byArray[n2 + 1] = (byte)(n >> 8);
        }

        public static void writeByte(int n, byte[] byArray, int n2) {
            byArray[n2] = (byte)n;
        }
    }
}

