/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.jq2009;

import com.iplay.game.font.Font;
import com.iplay.game.image.TransformableImage;
import com.iplay.game.jq2009.JQ2009Game;
import com.iplay.game.jq2009.PauseMenu;
import com.iplay.game.spac.SpacFile;
import com.iplay.game.spac.SpacSprite;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class Animations
extends PauseMenu {
    public static final int PARTICLE = 0;
    public static final int FLOATING_TEXT = 1;
    public static final int SPRITE = 2;
    public static final int FALLING_FRAME = 3;
    public static final int SPRITE_SPAC_INDEX = 0;
    public static final int SPRITE_TEXT_INDEX = 1;
    public static final int SPRITE_DATA_COUNT = 2;
    public static final int SPRITE_TO_HINT_DIST_PX = 3;
    public static final int ANIMATION_ELEMENTS_COUNT = 2;
    public static final int FALLING_FRAME_DATA_COUNT = 2;
    public static final int FLOATING_DX = 0;
    public static final int FLOATING_DY = 1;
    public static final int FLOATING_POINTS = 2;
    public static final int FLOATING_FRAMES = 3;
    public static final int FLOATING_STRUCTURE_SIZE = 4;
    public static final int FLOATING_TEXT_FRAMES = 10;
    public static final int PARTICLES_MAGNITUDE = 0;
    public static final int PARTICLES_COLOR = 1;
    public static final int PARTICLES_X = 0;
    public static final int PARTICLES_Y = 1;
    public static final int PARTICLES_DX = 2;
    public static final int PARTICLES_DY = 3;
    public static final int PARTICLES_FRAMES = 4;
    public static final int PARTICLES_COLOR_INDEX = 5;
    public static final int PARTICLES_FRAME_DELAY = 6;
    public static final int PARTICLES_STRUCTURE_SIZE = 7;
    public static final int PARTICLE_FRAME_DELAY = 5;
    public static final int PARTICLE_SPEED = 6;
    public static final int PARTICLE_GRAVITY = 3;
    public static final int PARTICLE_FRAMES = 4;
    public static final int GRAVITY_FRAME = 1;
    public static final int MAX_PARTICLES = 20;
    public static final String EIGHT = "8";
    private Vector elements = new Vector();
    private TransformableImage particleImage;
    private int particlesCount;
    private int tutorialHintBoxWidth;
    private int tutorialHintBoxHeight;
    private int floatingTextCount;

    public abstract SpacFile getSpecialCursorSpac();

    protected final void initSpriteAnimation(SpacFile spacFile, int n, int n2, int n3, int n4, int n5) {
        this.initSpriteAnimation(spacFile, n, n2, n3, n4, n5, null);
    }

    protected final void initSpriteAnimation(SpacFile spacFile, int n, int n2, int n3, int n4, int n5, char[] cArray) {
        if (this.findAnimation(n5) != -1) {
            return;
        }
        Object[] objectArray = new Object[2];
        objectArray[1] = cArray;
        SpacSprite spacSprite = new SpacSprite(spacFile, 0, true);
        spacSprite.setSequence(n, n2, 0, true);
        objectArray[0] = spacSprite;
        this.initAnimation(2, n5, n3, n4, objectArray);
    }

    protected final void initAnimation(int n, int n2, int n3, SpacSprite spacSprite, int n4) {
        Object[] objectArray = new Object[]{spacSprite, new int[]{n4}};
        this.initAnimation(n, n2, n3, objectArray);
    }

    protected final void initAnimation(int n, int n2, int n3, Object object) {
        this.initAnimation(n, 0, n2, n3, object);
    }

    protected final void initAnimation(int n, int n2, int n3, int n4, Object object) {
        if (n == 0 && this.particlesCount >= 20) {
            return;
        }
        int[] nArray = new int[]{n, n3, n4, n2};
        this.elements.addElement(nArray);
        switch (n) {
            case 0: {
                object = this.initParticles(nArray, object);
                break;
            }
            case 1: {
                object = this.initFloatingText(nArray, object);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (JQ2009Game.levelData[this.getCurrentLevel() * 8 + 4] == 2) {
                    JQ2009Game.setCPUStoryCoins(JQ2009Game.getCPUCoins() + 1);
                    JQ2009Game.mRupertSpacAnimation.setSequence(5, 0, 0, true);
                    JQ2009Game.mBossSpacAnimation.setSequence(70, 0, 0, true);
                    JQ2009Game.RupertState = 3;
                    JQ2009Game.BossState = 4;
                    JQ2009Game.cpuAddJewels = -6;
                    JQ2009Game.playerAddJewels = -6;
                }
                this.playSound(15, 0);
            }
        }
        if (object == null) {
            object = new char[0];
        }
        this.elements.addElement(object);
    }

    private final Object initFloatingText(int[] nArray, Object object) {
        ++this.floatingTextCount;
        int[] nArray2 = new int[4];
        nArray2[0] = 0;
        nArray2[1] = -1;
        nArray2[3] = 10;
        nArray2[2] = (Integer)object;
        return nArray2;
    }

    private final Object initParticles(int[] nArray, Object object) {
        ++this.particlesCount;
        int n = ((int[])object)[0];
        int n2 = ((int[])object)[1];
        int[][] nArrayArray = new int[][]{new int[n], new int[n], new int[n], new int[n], new int[n], {n2}, {0}};
        for (int i = 0; i < n; ++i) {
            nArrayArray[0][i] = nArray[1] - 3;
            nArrayArray[1][i] = nArray[2] - 3;
            nArrayArray[2][i] = this.getRandom().nextInt() % 6;
            nArrayArray[3][i] = this.getRandom().nextInt() % 6;
            nArrayArray[4][i] = 0;
        }
        return nArrayArray;
    }

    protected final void clearAnimation(int n) {
        if (n == -1) {
            return;
        }
        if (((int[])this.elements.elementAt(n))[0] == 0) {
            --this.particlesCount;
        }
        this.elements.removeElementAt(n + 1);
        this.elements.removeElementAt(n);
    }

    protected final void updateAnimations(int n) {
        int[] nArray = null;
        for (int i = 0; i < this.elements.size(); i += 2) {
            boolean bl = false;
            int[] nArray2 = (int[])this.elements.elementAt(i);
            Object e = this.elements.elementAt(i + 1);
            switch (nArray2[0]) {
                case 0: {
                    bl = this.updateParticles(n, nArray2, e);
                    break;
                }
                case 1: {
                    bl = this.updateFloatingText(nArray2, e);
                    break;
                }
                case 2: {
                    Object[] objectArray = (Object[])e;
                    SpacSprite spacSprite = (SpacSprite)objectArray[0];
                    spacSprite.updateSprite(n);
                    nArray = spacSprite.getSpac().getFrameRect(spacSprite.getFrameIndex());
                    if (objectArray[1] == null) break;
                    Font font = this.getSharedFont();
                    char[] cArray = (char[])objectArray[1];
                    int n2 = font.charsWidth(cArray, 0, cArray.length, true);
                    int n3 = font.charsWidth(EIGHT.toCharArray(), 0, 1, true);
                    int n4 = this.getSpecialCursorSpac().getFrameRect(27)[2];
                    int n5 = this.getSpecialCursorSpac().getFrameRect(28)[2];
                    int n6 = this.getSpecialCursorSpac().getFrameRect(29)[2];
                    int n7 = this.getSpecialCursorSpac().getFrameRect(27)[3];
                    int n8 = n4 + n6;
                    int n9 = 0;
                    while (n8 < n2 + (n3 << 1)) {
                        n8 += n5;
                        ++n9;
                    }
                    this.tutorialHintBoxWidth = n8;
                    this.tutorialHintBoxHeight = n7;
                    break;
                }
                case 3: {
                    if (nArray2[2] < this.getHeight()) {
                        nArray2[2] = nArray2[2] + 5;
                        break;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            this.clearAnimation(i);
            i -= 2;
        }
    }

    protected final void renderAnimations(Graphics graphics) {
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        block6: for (int i = 0; i < this.elements.size(); i += 2) {
            int[] nArray = (int[])this.elements.elementAt(i);
            Object e = this.elements.elementAt(i + 1);
            switch (nArray[0]) {
                case 0: {
                    this.renderParticles(graphics, nArray, e);
                    continue block6;
                }
                case 1: {
                    this.renderFloatingText(graphics, nArray, e);
                    continue block6;
                }
                case 2: {
                    int n;
                    Object object = (Object[])e;
                    SpacSprite spacSprite = (SpacSprite)object[0];
                    spacSprite.renderSprite(graphics, nArray[1], nArray[2]);
                    if (object[1] == null) continue block6;
                    int n2 = nArray[1] - this.tutorialHintBoxWidth / 2;
                    n2 = n2 < 0 ? 0 : n2;
                    n2 = n2 + this.tutorialHintBoxWidth > this.screenWidth ? this.screenWidth - this.tutorialHintBoxWidth : n2;
                    int n3 = 0;
                    if (nArray[3] != 6 && nArray[3] != 10) {
                        n = JQ2009Game.mSpecialCursorSpac.getFrameRect(24)[3] + JQ2009Game.mSpecialCursorSpac.getFrameRect(24)[1];
                        n3 = nArray[2] + n;
                    } else {
                        n = JQ2009Game.mSpecialCursorSpac.getFrameRect(24)[3] + JQ2009Game.mSpecialCursorSpac.getFrameRect(24)[1] + JQ2009Game.mSpecialCursorSpac.getFrameRect(27)[3];
                        n3 = nArray[2] - n;
                    }
                    char[] cArray = (char[])object[1];
                    int n4 = this.getSharedFont().charsWidth(cArray, 0, cArray.length, true);
                    SpacFile spacFile = this.getSpecialCursorSpac();
                    int n5 = spacFile.getFrameRect(27)[2];
                    int n6 = spacFile.getFrameRect(28)[2];
                    int n7 = spacFile.getFrameRect(29)[2];
                    int n8 = spacFile.getFrameRect(27)[3];
                    spacFile.renderFrame(graphics, 27, -1, n2, n3);
                    int n9 = 0;
                    while (n5 + n9 * n6 + n7 < this.tutorialHintBoxWidth) {
                        spacFile.renderFrame(graphics, 28, -1, n2 + n5 + n9 * n6, n3);
                        ++n9;
                    }
                    spacFile.renderFrame(graphics, 29, -1, n2 + this.tutorialHintBoxWidth, n3);
                    this.getSharedFont().drawChars(graphics, cArray, 0, cArray.length, n2 + (this.tutorialHintBoxWidth - n4) / 2, n3 + (n8 - this.getSharedFont().getHeight()) / 2, 20, true);
                    continue block6;
                }
                case 3: {
                    graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
                    Object object = (SpacSprite)((Object[])e)[0];
                    int n = ((int[])((Object[])e)[1])[0];
                    ((SpacSprite)object).renderSprite(graphics, nArray[1], nArray[2]);
                }
            }
        }
    }

    private boolean updateFloatingText(int[] nArray, Object object) {
        boolean bl = false;
        int[] nArray2 = (int[])object;
        nArray[1] = nArray[1] + nArray2[0];
        nArray[2] = nArray[2] + nArray2[1];
        nArray2[3] = nArray2[3] - 1;
        if (nArray2[3] < 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean updateParticles(int n, int[] nArray, Object object) {
        boolean bl = true;
        int[][] nArray2 = (int[][])object;
        int[] nArray3 = nArray2[6];
        nArray3[0] = nArray3[0] + 1;
        if (nArray2[6][0] >= 5) {
            nArray2[6][0] = 0;
        }
        for (int i = 0; i < nArray2[0].length; ++i) {
            int[] nArray4 = nArray2[0];
            int n2 = i;
            nArray4[n2] = nArray4[n2] + nArray2[2][i];
            int[] nArray5 = nArray2[1];
            int n3 = i;
            nArray5[n3] = nArray5[n3] + nArray2[3][i];
            if (nArray2[4][i] >= 1) {
                int[] nArray6 = nArray2[3];
                int n4 = i;
                nArray6[n4] = nArray6[n4] + 3;
            }
            if (nArray2[6][0] == 0) {
                int[] nArray7 = nArray2[4];
                int n5 = i;
                nArray7[n5] = nArray7[n5] + 1;
            }
            if (nArray2[4][i] >= 4) continue;
            bl = false;
        }
        return bl;
    }

    public boolean isAnimFinished(int n) {
        boolean bl = true;
        block4: for (int i = 0; i < this.elements.size(); i += 2) {
            int[] nArray = (int[])this.elements.elementAt(i);
            Object e = this.elements.elementAt(i + 1);
            if (n != nArray[0]) continue;
            switch (n) {
                case 0: {
                    Object object = (int[][])e;
                    for (int j = 0; j < object[0].length; ++j) {
                        if (object[4][j] > 4) continue;
                        bl = false;
                    }
                    continue block4;
                }
                case 1: {
                    Object object = (int[])e;
                    if (object[3] >= 0) continue block4;
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected final void renderFloatingText(Graphics graphics, int[] nArray, Object object) {
        Font font = this.getDigitFont();
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        int[] nArray2 = (int[])object;
        int n = nArray[1];
        int n2 = nArray[2];
        int n3 = nArray2[2];
        char[] cArray = ("" + n3).toCharArray();
        char[][] cArray2 = Font.formatString(font, cArray, this.screenWidth);
        this.renderTextLines(graphics, cArray2, 0, cArray2.length, font, n, n2, 0, 17, false);
    }

    protected final void renderParticles(Graphics graphics, int[] nArray, Object object) {
        int[][] nArray2 = (int[][])object;
        int n = 7;
        int n2 = nArray2[5][0] * 4;
        for (int i = 0; i < nArray2[0].length; ++i) {
            int n3 = nArray2[0][i];
            int n4 = nArray2[1][i];
            int n5 = nArray2[4][i];
            if (n5 >= 4 || nArray2[0][i] + n <= 0 || nArray2[0][i] >= this.screenWidth || nArray2[1][i] + n <= 0 || nArray2[1][i] >= this.screenHeight) continue;
            graphics.setClip(n3, n4, n, n);
            this.particleImage.drawImage(graphics, n3, n4 - (n5 + n2) * n);
        }
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
    }

    protected final void loadAnimationsData() {
        if (this.particleImage == null) {
            try {
                this.particleImage = new TransformableImage("/particle.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void resetAnimations() {
        this.elements.removeAllElements();
        this.particlesCount = 0;
    }

    protected abstract Random getRandom();

    protected abstract Font getDigitFont();

    protected abstract Font getSoftkeyFont();

    public abstract int renderTextLines(Graphics var1, char[][] var2, int var3, int var4, Font var5, int var6, int var7, int var8, int var9, boolean var10);

    public abstract void setDirtyRect(int var1, int var2, int var3, int var4);

    public int findAnimation(int n) {
        for (int i = 0; i < this.elements.size(); i += 2) {
            int[] nArray = (int[])this.elements.elementAt(i);
            if (nArray[3] != n) continue;
            return i;
        }
        return -1;
    }

    public void stopSpriteAnimation(int n) {
        int n2 = this.findAnimation(n);
        if (n2 < 0) {
            return;
        }
        int[] nArray = (int[])this.elements.elementAt(n2);
        Object[] objectArray = (Object[])this.elements.elementAt(n2 + 1);
        SpacSprite spacSprite = (SpacSprite)objectArray[0];
        int[] nArray2 = spacSprite.getSpac().getFrameRect(spacSprite.getFrameIndex());
        this.clearAnimation(n2);
    }

    public void changeSpritePosition(int n, int n2, int n3) {
        int n4 = this.findAnimation(n);
        if (n4 == -1) {
            return;
        }
        int[] nArray = (int[])this.elements.elementAt(n4);
        nArray[1] = n2;
        nArray[2] = n3;
    }
}

