/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.menu;

import com.iplay.game.jq2009.InputHandlerExtensions;
import com.iplay.game.menu.TextEntry;

public abstract class ScrollManager
extends TextEntry {
    private static final int STACK_SIZE = 5;
    private static final int SCROLL_POSITION = 0;
    private static final int PAGE_ITEM_COUNT = 1;
    private static final int MAX_SCROLL_POSITION = 2;
    private static final int ITEM_LENGTH = 3;
    private static final int ITEM_COUNT = 4;
    private static final int DIRECTION = 5;
    private static final int PAGE = 6;
    private static final int DATA_COUNT = 7;
    public static final int SCROLL_DIRECTION_VERTICAL = 0;
    public static final int SCROLL_DIRECTION_HORIZONTAL = 1;
    private short[] scrollData;
    private int stackIndex;
    byte dragtime = 0;

    final void initScrollManager() {
        this.stackIndex = -1;
        this.scrollData = new short[35];
    }

    public final void pushScroll(int n, int n2, int n3, int n4, boolean bl) {
        this.stackIndex = Math.min(this.stackIndex + 1, 4);
        int n5 = this.stackIndex * 7;
        if (n3 != 0) {
            short s;
            this.scrollData[n5 + 1] = s = (short)(n / n3);
            this.scrollData[n5 + 2] = (short)(n2 - s);
        } else {
            this.scrollData[n5 + 2] = 0;
            this.scrollData[n5 + 1] = 0;
        }
        this.scrollData[n5 + 3] = (short)n3;
        this.scrollData[n5 + 4] = (short)n2;
        this.scrollData[n5 + 0] = 0;
        this.scrollData[n5 + 6] = (short)(bl ? 1 : 0);
        this.scrollData[n5 + 5] = (short)n4;
    }

    public final void popScroll() {
        this.stackIndex = Math.max(this.stackIndex - 1, 0);
    }

    public final boolean updateScrollManager(int n, int n2) {
        boolean bl = false;
        if (this.stackIndex != -1) {
            int n3 = this.stackIndex * 7;
            boolean bl2 = this.scrollData[n3 + 5] == 1;
            short s = this.scrollData[n3 + 0];
            short s2 = this.scrollData[n3 + 2];
            short s3 = this.scrollData[n3 + 4];
            short s4 = this.scrollData[n3 + 1];
            boolean bl3 = this.scrollData[n3 + 6] == 1;
            short s5 = s;
            boolean bl4 = false;
            boolean bl5 = false;
            if (bl3) {
                if ((this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5) || this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_DOWN_OR_NUM8) || this.wasKeyPressed(21)) && s5 < s3 - s4) {
                    s5 = (short)Math.min(s5 + s4, s3 - 1);
                }
                if (this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_UP_OR_NUM2)) {
                    s5 = (short)Math.max(s5 - s4, 0);
                }
            } else if (this.wasKeyPressed(bl2 ? InputHandlerExtensions.VIRTUAL_KEY_RIGHT_OR_NUM6 : InputHandlerExtensions.VIRTUAL_KEY_DOWN_OR_NUM8)) {
                if (s5 < s2) {
                    s5 = (short)Math.min(s5 + 1, s2);
                }
            } else if (this.wasKeyPressed(bl2 ? InputHandlerExtensions.VIRTUAL_KEY_LEFT_OR_NUM4 : InputHandlerExtensions.VIRTUAL_KEY_UP_OR_NUM2)) {
                s5 = (short)Math.max(s5 - 1, 0);
            }
            this.scrollData[n3 + 0] = s5;
            bl = s != s5;
        }
        return bl;
    }

    public final boolean isScrollAtBottom() {
        if (this.stackIndex != -1) {
            boolean bl = false;
            int n = this.stackIndex * 7;
            if (this.scrollData[n + 0] >= this.scrollData[n + 4] - this.scrollData[n + 1]) {
                bl = true;
            }
            return bl;
        }
        return true;
    }

    public final boolean isScrollAtTop() {
        if (this.stackIndex != -1) {
            return this.scrollData[this.stackIndex * 7 + 0] == 0;
        }
        return true;
    }

    public final void pageScroll() {
        int n = this.stackIndex * 7;
        short s = this.scrollData[n + 0];
        short s2 = this.scrollData[n + 4];
        short s3 = this.scrollData[n + 1];
        if (s < s2 - s3) {
            s = (short)Math.min(s + s3, s2 - s3);
        }
        this.scrollData[n + 0] = s;
    }

    public final int getScrollOffset() {
        int n = this.stackIndex * 7;
        return this.scrollData[n + 0] * this.scrollData[n + 3];
    }

    public final int getPageItemCount() {
        return this.scrollData[this.stackIndex * 7 + 1];
    }

    public final int getScrollItemCount() {
        return this.scrollData[this.stackIndex * 7 + 4];
    }

    public final void setScrollPosition(int n) {
        this.scrollData[this.stackIndex * 7 + 0] = (short)n;
    }

    public final int getScrollPosition() {
        int n = this.stackIndex * 7;
        return this.scrollData[n + 0];
    }
}

