/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class EnemyMgr {
    public static final int TOTALENEMY = 18;
    public GameStage m_GameStage;
    public Vector m_Enemy;
    public Vector m_ItemDrop;
    public boolean m_InCommand;
    public int m_Damage;
    public int m_Exp;
    public int m_CountItemDrop;
    public int m_GoldDrop;
    public int m_SoulDrop;
    public int m_UpDrop;
    public int m_EnemyType;

    public EnemyMgr(GameStage gameStage) {
        this.m_GameStage = gameStage;
        this.m_Enemy = new Vector();
        this.m_ItemDrop = new Vector();
        this.m_EnemyType = -1;
    }

    public void Release() {
        EnemyMgr enemyMgr = this;
        for (int i2 = 0; i2 < enemyMgr.m_Enemy.size(); ++i2) {
            EnemyUnit enemyUnit = (EnemyUnit)enemyMgr.m_Enemy.elementAt(i2);
            enemyUnit.Release();
        }
        enemyMgr.m_Enemy.removeAllElements();
        enemyMgr.m_InCommand = false;
        enemyMgr.m_ItemDrop.removeAllElements();
        System.gc();
        this.m_Enemy = null;
        this.m_ItemDrop = null;
        this.m_EnemyType = -1;
        System.gc();
    }

    public void ResetCombat() {
        this.m_InCommand = false;
        this.m_Damage = 0;
        this.m_Exp = 0;
        this.m_UpDrop = 0;
        this.m_SoulDrop = 0;
        this.m_GoldDrop = 0;
        this.m_CountItemDrop = 0;
        this.m_EnemyType = -1;
        for (int i2 = 0; i2 < this.m_Enemy.size(); ++i2) {
            EnemyUnit enemyUnit = (EnemyUnit)this.m_Enemy.elementAt(i2);
            enemyUnit.Release();
        }
        this.m_Enemy.removeAllElements();
        this.m_ItemDrop.removeAllElements();
        System.gc();
    }

    public void AddItemToDrop(int n2) {
        Object object;
        int n3;
        EItem eItem = null;
        for (n3 = 0; n3 < this.m_GameStage.m_Items.size(); ++n3) {
            object = (EItem)this.m_GameStage.m_Items.elementAt(n3);
            if (((EItem)object).id != n2) continue;
            eItem = object;
            break;
        }
        if (this.m_ItemDrop.size() == 0) {
            ItemUnit itemUnit = new ItemUnit(this.m_GameStage, eItem);
            itemUnit.SetCount(1);
            this.m_ItemDrop.addElement(itemUnit);
            return;
        }
        for (n3 = 0; n3 < this.m_ItemDrop.size(); ++n3) {
            object = (ItemUnit)this.m_ItemDrop.elementAt(n3);
            if (((ItemUnit)object).m_Item.id == n2) {
                ((ItemUnit)object).SetCount(1);
                return;
            }
            if (n3 != this.m_ItemDrop.size() - 1) continue;
            ItemUnit itemUnit = new ItemUnit(this.m_GameStage, eItem);
            itemUnit.SetCount(1);
            this.m_ItemDrop.addElement(itemUnit);
            return;
        }
    }

    public void Add(int n2, int n3) {
        int n4;
        int n5 = this.m_GameStage.m_Scence.m_EnemyRate;
        EnemyUnit enemyUnit = null;
        EEnemy eEnemy = null;
        for (n4 = 0; n4 < this.m_GameStage.m_Enemy.size(); ++n4) {
            EEnemy eEnemy2 = (EEnemy)this.m_GameStage.m_Enemy.elementAt(n4);
            if (eEnemy2.type != n2 - 5) continue;
            if (eEnemy2.id == eEnemy2.type + (n5 - 1) * 18) {
                eEnemy = eEnemy2;
                break;
            }
            n4 += 17;
        }
        switch (eEnemy.type + 5) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                enemyUnit = new EnemyMelee(this.m_GameStage, eEnemy, n3);
                ((EnemyUnit)enemyUnit).Create();
                this.m_Exp += enemyUnit.m_Exp;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 19: {
                enemyUnit = new EnemyDis(this.m_GameStage, eEnemy, n3);
                ((EnemyUnit)enemyUnit).Create();
                this.m_Exp += enemyUnit.m_Exp;
                break;
            }
            case 14: {
                enemyUnit = new EnemyGhostKing(this.m_GameStage, eEnemy, n3);
                ((EnemyUnit)enemyUnit).Create();
                this.m_Exp += enemyUnit.m_Exp;
            }
        }
        this.m_Enemy.addElement(enemyUnit);
        n4 = 1;
        if (Soul.m_EnemyGold) {
            n4 = 2;
        }
        this.m_GoldDrop += enemyUnit.m_Enemy.gold[0] * n4;
        int n6 = Soul.getRandom(0, 5);
        if (Soul.m_EnemyGold) {
            n6 = 0;
        }
        if (n6 == 0) {
            this.m_SoulDrop += enemyUnit.m_Enemy.gold[1];
        }
        n6 = Soul.getRandom(0, 5);
        if (Soul.m_EnemyGold) {
            n6 = 0;
        }
        if (n6 == 0) {
            this.m_UpDrop += enemyUnit.m_Enemy.gold[2];
        }
    }

    public void BurnEnemy() {
        int n2;
        this.m_InCommand = false;
        this.m_CountItemDrop = 0;
        int n3 = this.m_GameStage.m_GameData.EnemyInit[this.m_EnemyType].length;
        this.m_Exp = 0;
        int n4 = 0;
        block12: for (n2 = 0; n2 < n3; ++n2) {
            n4 = this.m_GameStage.m_GameData.EnemyInit[this.m_EnemyType][n2];
            if (this.m_GameStage.m_NPC.m_NPCSpx[n4] == null) {
                switch (n4) {
                    case 18: {
                        Image image = EResourceManager.loadImage("npc/5.png");
                        this.m_GameStage.m_NPC.m_NPCObject[n4] = Soul.draw.changeImageRGB(image, -30, 100, 14, 0);
                        EResourceManager.freeImage("/res/npc/5.png");
                        this.m_GameStage.m_NPC.m_NPCSpx[n4] = new SpriteX("/res/npc/enemy5.sprite", this.m_GameStage.m_NPC.m_NPCObject[n4]);
                        break;
                    }
                    case 21: {
                        Image image = EResourceManager.loadImage("npc/7.png");
                        this.m_GameStage.m_NPC.m_NPCObject[n4] = Soul.draw.changeImageRGB(image, -124, -25, 135, 0);
                        EResourceManager.freeImage("/res/npc/7.png");
                        this.m_GameStage.m_NPC.m_NPCSpx[n4] = new SpriteX("/res/npc/enemy7.sprite", this.m_GameStage.m_NPC.m_NPCObject[n4]);
                        break;
                    }
                    case 20: {
                        Image image = EResourceManager.loadImage("npc/10.png");
                        this.m_GameStage.m_NPC.m_NPCObject[n4] = Soul.draw.changeImageRGB(image, 59, -17, -35, 0);
                        EResourceManager.freeImage("/res/npc/10.png");
                        this.m_GameStage.m_NPC.m_NPCSpx[n4] = new SpriteX("/res/npc/enemy10.sprite", this.m_GameStage.m_NPC.m_NPCObject[n4]);
                        break;
                    }
                    case 22: {
                        Image image = EResourceManager.loadImage("npc/13.png");
                        this.m_GameStage.m_NPC.m_NPCObject[n4] = Soul.draw.changeImageRGB(image, 0, 0, 0, 2);
                        EResourceManager.freeImage("/res/npc/13.png");
                        this.m_GameStage.m_NPC.m_NPCSpx[n4] = new SpriteX("/res/npc/enemy13.sprite", this.m_GameStage.m_NPC.m_NPCObject[n4]);
                        break;
                    }
                    case 19: {
                        Image image = EResourceManager.loadImage("npc/9.png");
                        this.m_GameStage.m_NPC.m_NPCObject[n4] = Soul.draw.changeImageRGB(image, 41, -33, 65, 0);
                        EResourceManager.freeImage("/res/npc/9.png");
                        this.m_GameStage.m_NPC.m_NPCSpx[n4] = new SpriteX("/res/npc/enemy9.sprite", this.m_GameStage.m_NPC.m_NPCObject[n4]);
                        break;
                    }
                    default: {
                        this.m_GameStage.m_NPC.m_NPCObject[n4] = EResourceManager.loadImage("npc/" + n4 + ".png");
                        this.m_GameStage.m_NPC.m_NPCSpx[n4] = new SpriteX("/res/npc/enemy" + n4 + ".sprite", this.m_GameStage.m_NPC.m_NPCObject[n4]);
                    }
                }
            }
            switch (n3) {
                case 1: {
                    this.Add(n4, n3);
                    continue block12;
                }
                case 2: {
                    if (n2 != 0) {
                        this.Add(n4, n2 + 1);
                        continue block12;
                    }
                }
                case 3: {
                    this.Add(n4, n2);
                }
            }
        }
        n2 = 1;
        if (Soul.m_DoubleExp) {
            n2 = 2;
        }
        this.m_Exp *= n2;
    }

    public void CheckYouwin() {
        if (this.m_GameStage.m_FrameState == 1 && this.m_Enemy.size() == 0) {
            this.m_GameStage.m_Hero.m_Youwin = true;
            if (this.m_CountItemDrop == 0) {
                for (int i2 = 0; i2 < this.m_ItemDrop.size(); ++i2) {
                    ItemUnit itemUnit = (ItemUnit)this.m_ItemDrop.elementAt(i2);
                    this.m_GameStage.m_ItemMgr.AddItem(itemUnit.m_Item.id, itemUnit.m_Count);
                    this.m_GameStage.m_Hero.ChangeGold(this.m_GoldDrop);
                    this.m_GameStage.m_Hero.ChangeSoul(this.m_SoulDrop);
                    this.m_GameStage.m_Hero.ChangeUpgrade(this.m_UpDrop);
                }
                ++this.m_CountItemDrop;
            }
        }
    }

    public void Update() {
        if (this.m_InCommand) {
            for (int i2 = 0; i2 < this.m_Enemy.size(); ++i2) {
                EnemyUnit enemyUnit = (EnemyUnit)this.m_Enemy.elementAt(i2);
                if (enemyUnit.m_InCommand) {
                    enemyUnit.Update();
                    continue;
                }
                enemyUnit.m_EnemySpx.UpdateAnim();
                if (enemyUnit.m_ActionState != 4) continue;
                enemyUnit.Update();
            }
        } else {
            for (int i3 = 0; i3 < this.m_Enemy.size(); ++i3) {
                EnemyUnit enemyUnit = (EnemyUnit)this.m_Enemy.elementAt(i3);
                if (this.m_GameStage.m_Hero.m_InSkill && this.m_GameStage.m_Hero.m_SkillEffect != 1 && i3 == this.m_GameStage.m_Hero.m_ChooseIndex) {
                    enemyUnit.m_PosX = this.m_GameStage.m_GameData.m_PosEnemy[1].x;
                    enemyUnit.m_PosY = this.m_GameStage.m_GameData.m_PosEnemy[1].y + 18;
                } else {
                    enemyUnit.m_PosX = this.m_GameStage.m_GameData.m_PosEnemy[enemyUnit.m_BattlePos].x;
                    enemyUnit.m_PosY = this.m_GameStage.m_GameData.m_PosEnemy[enemyUnit.m_BattlePos].y;
                }
                enemyUnit.Update();
                if (!enemyUnit.m_Died) continue;
                this.m_GameStage.m_Quest.CheckQuest(enemyUnit.m_EnemyType, 1, -1);
                enemyUnit.Release();
                this.m_Enemy.removeElementAt(i3);
                --i3;
            }
        }
        this.CheckYouwin();
    }

    public void ShowBlood(Graphics graphics) {
        for (int i2 = this.m_Enemy.size() - 1; i2 >= 0; --i2) {
            EnemyUnit enemyUnit = (EnemyUnit)this.m_Enemy.elementAt(i2);
            enemyUnit.ShowBlood(graphics);
        }
    }

    public void Show(Graphics graphics) {
        if (!this.m_GameStage.m_Hero.m_InSkill) {
            for (int i2 = this.m_Enemy.size() - 1; i2 >= 0; --i2) {
                EnemyUnit enemyUnit = (EnemyUnit)this.m_Enemy.elementAt(i2);
                enemyUnit.Show(graphics);
            }
            return;
        }
        if (this.m_GameStage.m_Hero.m_SkillEffect == 1) {
            for (int i3 = this.m_Enemy.size() - 1; i3 >= 0; --i3) {
                EnemyUnit enemyUnit = (EnemyUnit)this.m_Enemy.elementAt(i3);
                enemyUnit.Show(graphics);
            }
            return;
        }
        ((EnemyUnit)this.m_Enemy.elementAt(this.m_GameStage.m_Hero.m_ChooseIndex)).ShowPosSkill(graphics);
    }
}

