/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.Archer;
import com.eternity.castlelords.Boss;
import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Knight;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Piker;
import com.eternity.castlelords.Rider;
import com.eternity.castlelords.Walker;
import com.eternity.castlelords.Wall;
import com.eternity.castlelords.Warlord;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Image;

public class Spell
extends GameObject {
    public static final int NONE = 0;
    public static final int CASTLE_DEFENCE = 1;
    public static final int ARMAGEDDON = 2;
    public static final int DISENCHANT = 3;
    public static final int EARTHQUAKE = 4;
    public static final int ENERGY = 5;
    public static final int FIREBREATHING = 6;
    public static final int HAND_OF_FIRE = 7;
    public static final int HAND_OF_ICE = 8;
    public static final int HASTE = 9;
    public static final int SANCTUARY = 10;
    public static final int SLAYER = 11;
    public static final int VAMPIRISM = 12;
    public static final int BLIND = 13;
    public static final int BLIND_RAGE = 14;
    public static final int CALL_HEROES = 15;
    public static final int CALL_MERCENARIES = 16;
    public static final int DYNAMITE = 17;
    public static final int MORPH_ABILITIES = 18;
    public static final int MORPH_ARMOR = 19;
    public static final int MORPH_ARROWS = 20;
    public static final int MORPH_COMBAT = 21;
    public static final int MORPH_EXPERIENCE = 22;
    public static final int MORPH_HEALTH = 23;
    public static final int SPELL_COUNT = 24;
    static final String[] SPELL_NAME_KEYS = new String[]{"NONE", "CASTLE_DEFENCE", "ARMAGEDDON", "DISENCHANT", "EARTHQUAKE", "ENERGY", "FIREBREATHING", "HAND_OF_FIRE", "HAND_OF_ICE", "HASTE", "SANCTUARY", "SLAYER", "VAMPIRISM", "BLIND", "BLIND_RAGE", "CALL_HEROES", "CALL_MERCENARIES", "DYNAMITE", "MORPH_ABILITIES", "MORPH_ARMOR", "MORPH_ARROWS", "MORPH_COMBAT", "MORPH_EXPERIENCE", "MORPH_HEALTH"};
    public static String[] DESCRIPTIONS;
    public int type;
    public int duration;
    public int level;
    public long lastCheckTime;
    int second = 1000;

    public Spell(int type, boolean ownedByPlayer, int level, GameObjects gameObjects, CLImageTracker tracker) {
        super(12, 0, ownedByPlayer, gameObjects, tracker);
        this.type = type;
        this.setAttackOver(false);
        if (level < 0) {
            level = 0;
        }
        while (level * 24 + type >= GameObjects.ALL_SPELLS_CHAR.length) {
            --level;
        }
        this.setDuration(Spell.getDurationByType(type, level));
        this.setLastCheckTime(CLGameCanvas.checkoutTime());
        this.level = level;
    }

    public int getType() {
        return this.type;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setLastCheckTime(long time) {
        this.lastCheckTime = time;
    }

    public void decreaseDuration(int amount) {
        this.duration -= amount;
    }

    public Image getImage() {
        return null;
    }

    public static int getDurationByType(int type, int level) {
        return GameObjects.ALL_SPELLS_CHAR[level * 24 + type][GameObjects.DURATION_POINTER];
    }

    public boolean tickAway() {
        this.decreaseDuration(XCanvas.DT);
        this.second -= XCanvas.DT;
        if (this.second <= 0) {
            this.second += 1000;
            return true;
        }
        return false;
    }

    public void doStep() {
        if (this.tickAway()) {
            switch (this.type) {
                case 3: {
                    break;
                }
                case 1: {
                    if (this.ownedByBlue) {
                        int i = 0;
                        while (i < this.gameObjects.getLiveObjects().size()) {
                            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                            if (temp instanceof Walker && temp.positionX < 252) {
                                ((Person)temp).addLastDamage(GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 1][GameObjects.DAMAGE_POINTER]);
                                ((Person)temp).subHitPoints(GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 1][GameObjects.DAMAGE_POINTER]);
                            }
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while (i < this.gameObjects.getLiveObjects().size()) {
                            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                            if (temp instanceof Walker && temp.positionX > 468) {
                                ((Person)temp).addLastDamage(GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 1][GameObjects.DAMAGE_POINTER]);
                                ((Person)temp).subHitPoints(GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 1][GameObjects.DAMAGE_POINTER]);
                            }
                            ++i;
                        }
                    }
                    break;
                }
            }
        }
    }

    public void finalizeSpell() {
        Warlord actualWarlord = this.ownedByBlue ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
        actualWarlord.removeEnchantment(this);
        if (!actualWarlord.hasEnchantmentType(this.type)) {
            switch (this.type) {
                case 12: {
                    if (actualWarlord.hasEnchantmentType(12)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).removeMagicAbility(2048);
                        }
                        ++i;
                    }
                    break;
                }
                case 13: {
                    if (actualWarlord.hasEnchantmentType(13)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue != this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).removeMagicAbility(16384);
                        }
                        ++i;
                    }
                    break;
                }
                case 17: {
                    if (actualWarlord.hasEnchantmentType(17)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).removeMagicAbility(32768);
                        }
                        ++i;
                    }
                    break;
                }
                case 6: {
                    if (actualWarlord.hasEnchantmentType(6)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).removeMagicAbility(1024);
                        }
                        ++i;
                    }
                    break;
                }
                case 19: {
                    if (actualWarlord.hasEnchantmentType(19)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).removeMagicAbility(65536);
                        }
                        ++i;
                    }
                    break;
                }
                case 21: {
                    if (actualWarlord.hasEnchantmentType(21)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).resetMagicPowerPoints(0);
                        }
                        ++i;
                    }
                    break;
                }
                case 23: {
                    if (actualWarlord.hasEnchantmentType(23)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).resetMagicHitPoints(0);
                        }
                        ++i;
                    }
                    break;
                }
                case 22: {
                    if (actualWarlord.hasEnchantmentType(22)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Person) {
                            ((Person)temp).setMagicLevel(0);
                        }
                        ++i;
                    }
                    break;
                }
                case 20: {
                    if (actualWarlord.hasEnchantmentType(22) || actualWarlord.hasEnchantmentType(19)) break;
                    int i = 0;
                    while (i < this.gameObjects.getLiveObjects().size()) {
                        GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                        if (temp.ownedByBlue == this.ownedByBlue && temp instanceof Archer) {
                            ((Person)temp).setMagicLevel(0);
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    public void createSpell() {
        int textType = this.ownedByBlue ? 3 : 4;
        this.performSpell();
        this.gameObjects.addCenterText(CLLocales.getString(SPELL_NAME_KEYS[this.type]), 10, textType);
    }

    public void performSpell() {
        Warlord actualWarlord = this.ownedByBlue ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
        Warlord enemyWarlord = this.ownedByBlue ? this.gameObjects.redWarlord : this.gameObjects.blueWarlord;
        int targets = 0;
        switch (this.type) {
            case 2: {
                int tempPower = enemyWarlord.castlePower;
                int armDamage = GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 2][GameObjects.TARGETS_POINTER];
                enemyWarlord.castlePower -= 5 * armDamage;
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Boss) && this.ownedByBlue != temp.isOwnedByBlue()) {
                        ((Person)temp).subHitPoints(armDamage);
                        this.gameObjects.addFlyingText("-" + armDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                    }
                    if (temp instanceof Wall && this.ownedByBlue != temp.isOwnedByBlue()) {
                        ((Person)temp).addLastDamage(((Person)temp).getHitPoints());
                        ((Person)temp).subHitPoints(((Person)temp).getHitPoints());
                    }
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Wall) && this.ownedByBlue != temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicAbility(16384);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 14: {
                actualWarlord.addEnchantment(this);
                break;
            }
            case 3: {
                enemyWarlord.resetEnchantments();
                if (enemyWarlord.personOnSpike == null || !enemyWarlord.personOnSpike.hasMagicAbility(0x400000)) break;
                enemyWarlord.personOnSpike.removeMagicAbility(0x400000);
                break;
            }
            case 17: {
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if ((temp instanceof Piker || temp instanceof Knight || temp instanceof Rider) && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicAbility(32768);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 5: {
                actualWarlord.addEnchantment(this);
                break;
            }
            case 9: {
                actualWarlord.addEnchantment(this);
                break;
            }
            case 6: {
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if ((temp instanceof Piker || temp instanceof Knight || temp instanceof Rider) && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicAbility(1024);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 10: {
                actualWarlord.addEnchantment(this);
                break;
            }
            case 4: {
                int tempDamage = GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 4][GameObjects.DAMAGE_POINTER];
                enemyWarlord.castlePower -= 2 * tempDamage;
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Wall && this.ownedByBlue != temp.isOwnedByBlue()) {
                        ((Person)temp).subHitPoints(tempDamage);
                        this.gameObjects.addFlyingText("-" + tempDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                    }
                    if (temp instanceof Archer && this.ownedByBlue != temp.isOwnedByBlue()) {
                        ((Person)temp).addLastDamage(((Person)temp).getHitPoints());
                        ((Person)temp).subHitPoints(((Person)temp).getHitPoints());
                        ((Archer)temp).lifeTime = 0;
                    }
                    ++i;
                }
                break;
            }
            case 12: {
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if ((temp instanceof Piker || temp instanceof Knight || temp instanceof Rider) && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicAbility(2048);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 7: {
                targets = GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 7][GameObjects.TARGETS_POINTER];
                int tempDamage = GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 7][GameObjects.DAMAGE_POINTER];
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Archer) && this.ownedByBlue != temp.isOwnedByBlue() && targets > 0) {
                        ((Person)temp).subHitPoints(tempDamage);
                        this.gameObjects.addFlyingText("-" + tempDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                        --targets;
                    }
                    ++i;
                }
                break;
            }
            case 8: {
                targets = GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 8][GameObjects.TARGETS_POINTER];
                int tempDamage = GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 8][GameObjects.DAMAGE_POINTER];
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Archer) && this.ownedByBlue != temp.isOwnedByBlue() && targets > 0) {
                        ((Person)temp).subHitPoints(tempDamage);
                        this.gameObjects.addFlyingText("-" + tempDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                        --targets;
                    }
                    ++i;
                }
                break;
            }
            case 21: {
                int combat = CLGameCanvas.random(6);
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Wall) && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicPowerPoints(combat);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 23: {
                int health = 0;
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    health = CLGameCanvas.random(15) - 2;
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Wall) && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicHitPoints(health);
                        this.gameObjects.addFlyingText("+" + health, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 5);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 22: {
                int mlevel = CLGameCanvas.random(5);
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Wall) && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicLevel(mlevel);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 20: {
                int mlevel = CLGameCanvas.random(5);
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Archer && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicLevel(mlevel);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 19: {
                int i = 0;
                while (i < this.gameObjects.getLiveObjects().size()) {
                    GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                    if (temp instanceof Person && !(temp instanceof Wall) && this.ownedByBlue == temp.isOwnedByBlue()) {
                        ((Person)temp).addMagicAbility(65536);
                    }
                    ++i;
                }
                actualWarlord.addEnchantment(this);
                break;
            }
            case 18: {
                actualWarlord.addEnchantment(this);
                break;
            }
            case 11: {
                if (actualWarlord.personOnSpike == null) break;
                actualWarlord.personOnSpike.addMagicAbility(0x400000);
                break;
            }
            case 16: {
                String unitStack = new Integer(GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 16][GameObjects.GROUP_POINTER]).toString();
                int i = 0;
                while (i < unitStack.length()) {
                    char unitType = unitStack.charAt(i);
                    this.callUnit(unitType);
                    ++i;
                }
                break;
            }
            case 15: {
                String unitStack = new Integer(GameObjects.ALL_SPELLS_CHAR[this.level * 24 + 15][GameObjects.GROUP_POINTER]).toString();
                int i = 0;
                while (i < unitStack.length()) {
                    char unitType = unitStack.charAt(i);
                    this.callUnit(unitType);
                    ++i;
                }
                break;
            }
        }
    }

    public void callUnit(char unitType) {
        Warlord actualWarlord = this.ownedByBlue ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
        Person unit = null;
        switch (unitType) {
            case '1': {
                unit = actualWarlord.createUnit(0, true);
                break;
            }
            case '2': {
                unit = actualWarlord.createUnit(1, true);
                break;
            }
            case '3': {
                unit = actualWarlord.createUnit(3, true);
            }
        }
        if (unit.level == 0) {
            unit.level = 1;
        }
        if (unit != null && (unitType == '1' || unitType == '2' || unitType == '3')) {
            this.gameObjects.performStackBonuses((Walker)unit);
        }
    }

    public static int getCoolDownByType(int type, int level) {
        int returnedValue = 0;
        returnedValue = GameObjects.ALL_SPELLS_CHAR[level * 24 + type][GameObjects.COOLDOWN_POINTER];
        return returnedValue;
    }

    public static String getNameOfType(int type) {
        return CLLocales.getString(SPELL_NAME_KEYS[type]);
    }

    public static byte[] getByteNameOfType(int type) {
        return CLLocales.getByteString(SPELL_NAME_KEYS[type]);
    }

    public static int getIconIdx(int type) {
        if (type >= 2 && type <= 12) {
            return type - 2;
        }
        if (type >= 13) {
            return 11 + type - 13;
        }
        return 100;
    }
}

