/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.Cannon;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Resource;
import com.eternity.castlelords.Wall;

public abstract class Walker
extends Person {
    public int[] pixelDiff = new int[1];
    byte start_hit_anim_idx;

    public Walker(int x, int y, int hp, int pp, boolean ownedByPlayer, GameObjects gameObjects, CLImageTracker tracker) {
        super(x, y, hp, pp, ownedByPlayer, gameObjects, tracker);
    }

    public void doStep() {
        super.doStep();
        int old_turn_delay = this.turnDelay;
        this.saveOldPositionXY();
        this.setAttackOver(false);
        this.moved = true;
        this.besieger = false;
        int i = 0;
        while (i < this.gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
            if (temp instanceof Resource) {
                Resource res = (Resource)temp;
                if (res.hitPoints > 0) {
                    if (this.ownedByBlue) {
                        if (this.collideWith(temp)) {
                            res.setHitPoints(0);
                            switch (res.type) {
                                case 0: {
                                    this.gameObjects.blueWarlord.addGold(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                                case 1: {
                                    this.gameObjects.blueWarlord.addStone(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("STONES")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                                case 2: {
                                    this.gameObjects.blueWarlord.addMana(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("MANA")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                                default: {
                                    this.gameObjects.blueWarlord.addGold(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                            }
                        }
                    } else if (this.collideWith(temp)) {
                        res.setHitPoints(0);
                        switch (res.type) {
                            case 0: {
                                this.gameObjects.redWarlord.addGold(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 4);
                                break;
                            }
                            case 1: {
                                this.gameObjects.redWarlord.addStone(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("STONES")) + "+" + res.powerPoints, 10, 4);
                                break;
                            }
                            case 2: {
                                this.gameObjects.redWarlord.addMana(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("MANA")) + "+" + res.powerPoints, 10, 4);
                                break;
                            }
                            default: {
                                this.gameObjects.redWarlord.addGold(res.powerPoints);
                                this.gameObjects.redWarlord.money = this.gameObjects.redWarlord.money > GameObjects.RESOURCE_CAPS[0] ? GameObjects.RESOURCE_CAPS[0] : this.gameObjects.redWarlord.money;
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 4);
                            }
                        }
                    }
                }
            }
            if (temp instanceof Person) {
                if (this.isOwnedByBlue()) {
                    if (temp.isOwnedByBlue()) {
                        if (this.getPositionX() + this.width() > temp.getPositionX() && this.getPositionX() + this.width() < temp.getPositionX() + temp.width() && (temp instanceof Walker || temp instanceof Wall || temp instanceof Cannon)) {
                            boolean stopMoving = true;
                            if (temp instanceof Cannon && ((Cannon)temp).state == 1) {
                                stopMoving = false;
                            }
                            if (stopMoving) {
                                this.setAttackOver(true);
                                this.moved = false;
                                this.setTurnDelay(this.actualTurnDelay);
                            }
                        }
                    } else if (this.isBattleWith((Person)temp) && ((Person)temp).type != 2) {
                        this.restorePositionXY();
                        if (this.actualSequence == Person.BATTLE) {
                            if (this.turnDelay < 1) {
                                this.setTurnDelay(this.actualBattleDelay);
                            }
                            if (this.getFrameIdx() == this.start_hit_anim_idx) {
                                int damage = this.gameObjects.combatTurn(this, (Person)temp);
                                ((Person)temp).subHitPoints(damage);
                                ((Person)temp).addLastDamage(damage);
                                if (this.bloodtime > 0) {
                                    --this.bloodtime;
                                } else {
                                    this.resetBloodlust();
                                }
                                damage = ((Person)temp).lastDamage;
                                if (damage == 0) {
                                    this.gameObjects.addFlyingText(CLLocales.getString("MISS"), 10, this.getPositionX(), this.getPositionY() - 5, 2);
                                } else {
                                    this.gameObjects.addFlyingText("-" + damage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                                    if (((Person)temp).hitPoints > 0) {
                                        CLGameCanvas.addHitAnim(this, (Person)temp, true);
                                    }
                                }
                                ((Person)temp).setLastDamage(0);
                            }
                            --this.turnDelay;
                        } else {
                            this.setFrameSequence(this.sequence[Person.BATTLE]);
                            this.actualSequence = Person.BATTLE;
                            this.turnDelay = this.actualBattleDelay;
                        }
                        this.setAttackOver(true);
                    }
                } else if (!temp.isOwnedByBlue()) {
                    if (this.getPositionX() - this.width() < temp.getPositionX() && this.getPositionX() - this.width() > temp.getPositionX() - temp.width() && (temp instanceof Walker || temp instanceof Wall || temp instanceof Cannon)) {
                        boolean stopMoving = true;
                        if (temp instanceof Cannon && ((Cannon)temp).state == 1) {
                            stopMoving = false;
                        }
                        if (stopMoving) {
                            this.setAttackOver(true);
                            this.moved = false;
                            this.setTurnDelay(this.actualTurnDelay);
                        }
                    }
                } else if (this.isBattleWith((Person)temp) && ((Person)temp).type != 2) {
                    this.restorePositionXY();
                    if (this.actualSequence == Person.BATTLE) {
                        if (this.turnDelay < 1) {
                            this.turnDelay = this.actualBattleDelay;
                        }
                        if (this.getFrameIdx() == this.start_hit_anim_idx) {
                            int damage = this.gameObjects.combatTurn(this, (Person)temp);
                            ((Person)temp).subHitPoints(damage);
                            ((Person)temp).addLastDamage(damage);
                            if (this.bloodtime > 0) {
                                --this.bloodtime;
                            } else {
                                this.resetBloodlust();
                            }
                            damage = ((Person)temp).lastDamage;
                            if (damage == 0) {
                                this.gameObjects.addFlyingText(CLLocales.getString("MISS"), 10, this.getPositionX(), this.getPositionY() - 5, 2);
                            } else {
                                this.gameObjects.addFlyingText("-" + damage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                                if (((Person)temp).hitPoints > 0) {
                                    CLGameCanvas.addHitAnim(this, (Person)temp, false);
                                }
                            }
                            ((Person)temp).setLastDamage(0);
                        }
                        --this.turnDelay;
                    } else {
                        this.setFrameSequence(this.sequence[Person.BATTLE]);
                        this.actualSequence = Person.BATTLE;
                        this.turnDelay = this.actualBattleDelay;
                    }
                    this.setAttackOver(true);
                }
            }
            ++i;
        }
        if (!this.isAttackOver()) {
            int damage;
            if (this.isOwnedByBlue()) {
                if (this.getPositionX() + this.width() / 2 > 698) {
                    this.restorePositionXY();
                    this.besieger = true;
                    if (this.actualSequence == Person.BATTLE) {
                        if (this.turnDelay < 1) {
                            this.turnDelay = this.actualBattleDelay;
                        }
                        if (this.getFrameIdx() == this.start_hit_anim_idx) {
                            damage = this.gameObjects.combatCastleTurn(this, false);
                            int besiegers = this.gameObjects.blueWarlord.besiegers > 3 ? 3 : this.gameObjects.blueWarlord.besiegers;
                            this.gameObjects.redWarlord.castlePower -= (damage *= besiegers);
                            if (this.gameObjects.redWarlord.archer != null) {
                                this.gameObjects.redWarlord.archer.addProportionalCastleHit(damage);
                            }
                            if (this.bloodtime > 0) {
                                --this.bloodtime;
                            } else {
                                this.resetBloodlust();
                            }
                            if (damage == 0) {
                                this.gameObjects.addFlyingText(CLLocales.getString("MISS"), 10, this.getPositionX(), this.getPositionY() - 5, 2);
                            } else {
                                this.gameObjects.addFlyingText("-" + damage, 10, 708, this.getPositionY() - 5, 1);
                            }
                            if (this.gameObjects.redWarlord.castleLevel == 0) {
                                CLGameCanvas.nextStrongHoldFrame(1);
                            } else {
                                CLGameCanvas.addHitAnim(708, 213 - CLImageTracker.hitHeights[this.race][this.type], (byte)1);
                            }
                        }
                        --this.turnDelay;
                    } else {
                        this.setFrameSequence(this.sequence[Person.BATTLE]);
                        this.actualSequence = Person.BATTLE;
                        this.turnDelay = this.actualBattleDelay;
                    }
                    this.setAttackOver(true);
                }
            } else if (this.getPositionX() - this.width() / 2 < 22) {
                this.restorePositionXY();
                this.besieger = true;
                if (this.actualSequence == Person.BATTLE) {
                    if (this.turnDelay < 1) {
                        this.turnDelay = this.actualBattleDelay;
                    }
                    if (this.getFrameIdx() == this.start_hit_anim_idx) {
                        damage = this.gameObjects.combatCastleTurn(this, true);
                        int besiegers = this.gameObjects.redWarlord.besiegers > 3 ? 3 : this.gameObjects.redWarlord.besiegers;
                        this.gameObjects.blueWarlord.castlePower -= (damage *= besiegers);
                        if (this.gameObjects.blueWarlord.archer != null) {
                            this.gameObjects.blueWarlord.archer.addProportionalCastleHit(damage);
                        }
                        if (this.bloodtime > 0) {
                            --this.bloodtime;
                        } else {
                            this.resetBloodlust();
                        }
                        if (damage == 0) {
                            this.gameObjects.addFlyingText(CLLocales.getString("MISS"), 10, this.getPositionX(), this.getPositionY() - 5, 2);
                        } else {
                            this.gameObjects.addFlyingText("-" + damage, 10, 12, this.getPositionY() - 5, 1);
                        }
                        if (this.gameObjects.blueWarlord.castleLevel == 0) {
                            CLGameCanvas.nextStrongHoldFrame(0);
                        } else {
                            CLGameCanvas.addHitAnim(12, 213 - CLImageTracker.hitHeights[this.race][this.type], (byte)1);
                        }
                    }
                    --this.turnDelay;
                } else {
                    this.setFrameSequence(this.sequence[Person.BATTLE]);
                    this.actualSequence = Person.BATTLE;
                    this.turnDelay = this.actualBattleDelay;
                }
                this.setAttackOver(true);
            }
        }
        if (!this.isAttackOver() && this.turnDelay < 1) {
            if (this.isOwnedByBlue()) {
                this.setPositionX(this.getPositionX() + this.pixelDiff[this.getFrameIdx()]);
                this.setLastDamage(0);
                this.lastAbility = "";
            } else {
                this.setPositionX(this.getPositionX() - this.pixelDiff[this.getFrameIdx()]);
                this.setLastDamage(0);
                this.lastAbility = "";
            }
            if (this.actualSequence != Person.NORMAL) {
                this.setFrameSequence(this.sequence[Person.NORMAL]);
                this.actualSequence = Person.NORMAL;
                this.lastAbility = "";
            }
            this.setTurnDelay(this.actualTurnDelay);
        }
        if (old_turn_delay == this.turnDelay) {
            this.setTurnDelay(this.getTurnDelay() - 1);
        }
        this.setRefPixelPosition(this.positionX, this.positionY);
    }
}

