/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Warlord;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Person
extends GameObject {
    public int hitPoints;
    public int maxHitPoints;
    public int magicHitPoints;
    public int maxMagicHitPoints;
    public int powerPoints;
    public int magicPowerPoints;
    public int abilities;
    public int magicAbilities = 0;
    public int stackAbility = 0;
    public int stackBonus = 0;
    public int lastDamage;
    public boolean isMortal = true;
    public boolean besieger = false;
    public int bloodtime = 0;
    public int bloodpoints = 0;
    public int diseasetime = 0;
    public int lastBurningTime;
    public int burningTime;
    public int fearHP = 0;
    public int fearPP = 0;
    public int fearLevel = 0;
    protected int actualTurnDelay = 0;
    protected int actualBattleDelay = 0;
    public static final int PERSON_WALK_SPEED_COEF = 2;
    public static final int PERSON_BATTLE_SPEED_COEF = 1;
    public static final int PERSON_WIDTH = 90;
    public static final int PERSON_HEIGHT = 70;
    public static int NORMAL = 0;
    public static int BATTLE = 1;
    private int color;
    int upgradeFrameIdx = -1;

    public Person() {
        super(0, 0, true, null, null);
        this.hitPoints = 0;
        this.powerPoints = 0;
        this.level = 1;
    }

    public Person(int x, int y, int hp, int pp, boolean ownedByBlue, GameObjects gameObjects, CLImageTracker tracker) {
        super(x, y, ownedByBlue, gameObjects, tracker);
        this.hitPoints = hp;
        this.maxHitPoints = hp;
        this.powerPoints = pp;
        this.level = 1;
        this.race = ownedByBlue ? gameObjects.blueWarlord.race : gameObjects.redWarlord.race;
    }

    public abstract Image getImage();

    public void setHitPoints(int hp) {
        this.hitPoints = hp;
    }

    public void setPowerPoints(int strength) {
        this.powerPoints = strength;
    }

    public void setAbilities(int abilities) {
        this.abilities = abilities;
    }

    public void setMagicAbilities(int abilities) {
        this.magicAbilities = abilities;
    }

    public void addAbility(int ability) {
        this.abilities |= ability;
    }

    public void removeAbility(int ability) {
        this.abilities ^= ability;
    }

    public void addMagicAbility(int ability) {
        this.magicAbilities |= ability;
    }

    public void removeMagicAbility(int ability) {
        this.magicAbilities ^= ability;
    }

    public boolean hasAbility(int ability) {
        return ((this.abilities | this.magicAbilities | this.stackAbility) & ability) == ability;
    }

    public boolean hasBasicAbility(int ability) {
        return (this.abilities & ability) == ability;
    }

    public boolean hasMagicAbility(int ability) {
        return (this.magicAbilities & ability) == ability;
    }

    public void addStackBonus(int bonus) {
        this.stackBonus |= bonus;
    }

    public boolean hasStackBonus(int bonus) {
        return (this.stackBonus & bonus) == bonus;
    }

    public void addStackAbility(int ability) {
        this.stackAbility |= ability;
    }

    public boolean hasStackAbility(int ability) {
        return (this.stackAbility & ability) == ability;
    }

    public void removeStackAbility(int ability) {
        this.stackAbility ^= ability;
    }

    public void removeStackBonus(int bonus) {
        this.stackBonus ^= bonus;
    }

    public void setLastDamage(int damage) {
        this.lastDamage = damage;
    }

    public void addLastDamage(int damage) {
        this.lastDamage += damage;
    }

    public void setLastAbility(String ability) {
        this.lastAbility = ability;
    }

    public int getHitPoints() {
        return this.hitPoints + this.magicHitPoints;
    }

    public int getHitPointsNoMagic() {
        return this.hitPoints;
    }

    public void addHitPoints(int hp) {
        this.hitPoints += hp;
        if (this.hitPoints > this.maxHitPoints) {
            this.hitPoints = this.maxHitPoints;
        }
    }

    public void subHitPoints(int hp) {
        if (!this.isMortal) {
            return;
        }
        int value = this.magicHitPoints - hp;
        if (value < 0) {
            this.hitPoints += value;
            this.magicHitPoints = 0;
        } else {
            this.magicHitPoints = value;
        }
    }

    public int getPowerPoints() {
        return this.powerPoints + this.magicPowerPoints + this.bloodpoints;
    }

    public void addPowerPoints(int pp) {
        this.powerPoints += pp;
    }

    public void subPowerPoints(int pp) {
        this.powerPoints -= pp;
    }

    public int getLastDamage() {
        return -1 * this.lastDamage;
    }

    public String getLastAbility() {
        return this.lastAbility;
    }

    public void addMagicHitPoints(int hp) {
        this.magicHitPoints += hp;
        this.maxMagicHitPoints += hp;
    }

    public void resetMagicHitPoints(int hp) {
        this.magicHitPoints = 0;
        this.maxMagicHitPoints = 0;
    }

    public void addMagicPowerPoints(int pp) {
        this.magicPowerPoints += pp;
    }

    public void resetMagicPowerPoints(int hp) {
        this.magicPowerPoints = 0;
    }

    public void modifyActualTurnDelay(int value) {
        this.actualTurnDelay += value;
    }

    public void setBloodlust() {
        this.bloodpoints = 3;
        this.bloodtime = 3;
    }

    public void setDisease() {
        this.diseasetime = 3;
    }

    public void resetBloodlust() {
        this.bloodpoints = 0;
    }

    public void resetDisease() {
        this.diseasetime = 0;
    }

    public void makeFear(int hp, int pp) {
        this.fearHP = hp;
        this.fearPP = pp;
        this.hitPoints -= this.fearHP;
        this.powerPoints -= this.fearPP;
        if (this.powerPoints < 1) {
            this.powerPoints = 1;
        }
        if (this.hitPoints < 1) {
            this.hitPoints = 1;
        }
        if (this.level > 1) {
            --this.level;
            this.fearLevel = 1;
        }
    }

    public void removeFear() {
        this.hitPoints += this.fearHP;
        this.powerPoints += this.fearPP;
        this.level += this.fearLevel;
        this.fearHP = 0;
        this.fearPP = 0;
        this.fearLevel = 0;
        this.removeStackAbility(16);
    }

    public void applyEnchantments() {
        Warlord actualWarlord;
        Warlord warlord = actualWarlord = this.isOwnedByBlue() ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
        if (actualWarlord.hasEnchantmentType(12)) {
            this.addMagicAbility(2048);
        }
        if (actualWarlord.hasEnchantmentType(17)) {
            this.addMagicAbility(32768);
        }
        if (actualWarlord.hasEnchantmentType(6)) {
            this.addMagicAbility(1024);
        }
        if (actualWarlord.hasEnchantmentType(21)) {
            this.addMagicPowerPoints(CLGameCanvas.random(6));
        }
        if (actualWarlord.hasEnchantmentType(23)) {
            this.addMagicPowerPoints(CLGameCanvas.random(15) - 2);
        }
        if (actualWarlord.hasEnchantmentType(22)) {
            this.addMagicLevel(CLGameCanvas.random(5));
        }
        if (actualWarlord.hasEnchantmentType(20) && this.type == 2) {
            this.addMagicLevel(CLGameCanvas.random(5));
        }
    }

    public final boolean isBattleWith(Person person) {
        int x1 = this.getPositionX() - this.width() / 2;
        int y1 = this.getPositionY();
        int w1 = this.width();
        int h1 = this.height();
        short xoff1 = GameObjects.UNIT_BATTLE_OFFSETS[this.race][this.type];
        int x2 = person.getPositionX() - person.width() / 2;
        int y2 = person.getPositionY();
        int w2 = person.width();
        int h2 = person.height();
        short xoff2 = GameObjects.UNIT_BATTLE_OFFSETS[person.race][person.type];
        return this.ownedByBlue ? x1 <= x2 + w2 && x1 + w1 - xoff1 >= x2 + xoff2 && y1 <= y2 + h2 && y1 + h1 >= y2 : x2 <= x1 + w1 && x2 + w2 - xoff2 >= x1 + xoff1 && y2 <= y1 + h1 && y2 + h2 >= y1;
    }

    public final boolean collideWith2(Person person) {
        if (person == this) {
            return false;
        }
        int x1 = this.getPositionX() - this.width() / 2;
        short xoff1 = GameObjects.UNIT_BATTLE_OFFSETS[this.race][this.type];
        int w1 = this.width() - xoff1;
        if (!this.ownedByBlue) {
            x1 += xoff1;
        }
        int x2 = person.getPositionX() - person.width() / 2;
        short xoff2 = GameObjects.UNIT_BATTLE_OFFSETS[person.race][person.type];
        int w2 = person.width() - xoff2;
        if (!person.ownedByBlue) {
            x2 += xoff2;
        }
        if (this.ownedByBlue == person.ownedByBlue) {
            if (this.ownedByBlue && x1 >= x2) {
                return false;
            }
            if (!this.ownedByBlue && x1 + w1 < x2 + w2) {
                return false;
            }
        }
        return x1 + w1 > x2 && x2 + w2 > x1;
    }

    public boolean abil(int i) {
        return this.hasAbility(1 << i);
    }

    public boolean isMagicAbility(int i) {
        return this.hasMagicAbility(1 << i);
    }

    public void paintSprite(Graphics g, boolean nextFrame) {
        super.paintSprite(g, nextFrame);
    }

    public void doStep() {
        if (this.upgradeFrameIdx >= 0) {
            ++this.upgradeFrameIdx;
            if (this.upgradeFrameIdx == 11) {
                this.upgradeFrameIdx = -1;
            }
        }
        if (this.burningTime > 0) {
            if (this.lastBurningTime - this.burningTime >= GameObjects.BURNING_PARAMS[1]) {
                this.lastBurningTime = this.burningTime;
                int damage = XCanvas.next_random(GameObjects.BURNING_PARAMS[2]) + 1;
                this.subHitPoints(damage);
                this.setLastDamage(damage);
                this.gameObjects.addFlyingText("-" + this.lastDamage, 10, this.getPositionX(), this.getPositionY() - 5, 1);
                this.gameObjects.addFlyingText("Burn", 10, this.getPositionX(), this.getPositionY() - 20, 2);
            }
            this.burningTime -= XCanvas.DT;
            if (this.burningTime <= 0) {
                this.removeMagicAbility(0x800000);
            }
        }
    }

    public void addBurning() {
        this.burningTime = this.lastBurningTime = GameObjects.BURNING_PARAMS[0];
        this.addMagicAbility(0x800000);
    }

    public void upgrade(Warlord w) {
        this.upgradeFrameIdx = 0;
        this.hitPoints = w.getUnitHP(this.type) * this.hitPoints / this.maxHitPoints;
        this.maxHitPoints = w.getUnitHP(this.type);
        this.powerPoints = w.getUnitPP(this.type);
        this.level = w.unitsLevel[this.type];
        if (Warlord.UPGRADE_HEAL) {
            this.hitPoints = this.maxHitPoints;
        }
    }
}

