/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class Map
implements C2S_Const {
    private Image tilesmapImage_;
    private boolean[][] collisionMap;
    private TiledLayer mapMidp2;
    public int mapx = 0;
    public int mapy = 0;
    public int tilesWidth;
    public int tilesHeight;
    private int col_tilesWidth;
    private int col_tilesHeight;
    public int obj_width;
    public int obj_height;
    public int[][] objTable;
    public int[] objImg_table_small;
    public int objImg_num;
    public Image[] objImage;
    public Action[] objAction;
    public int[][] transport;
    public int[][] road_sigh;
    Action tile_action_map;

    public void newMAP(int n) {
        try {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = new DataInputStream(this.getClass().getResourceAsStream("/map_data/1_t_changed.map"));
            this.LoadTilesmapImage(1);
            this.LoadTilesmap(dataInputStream2);
            dataInputStream2.close();
            if (n == 1 || n == 3 || n == 5) {
                dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/map_data/" + n + "_col_changed.map"));
                this.LoadCollMap(dataInputStream);
                dataInputStream.close();
            } else {
                this.LoadCollMap(null);
            }
            this.getCanvas().logic.run_load_repaint();
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/map_data/" + n + "_obj_changed.dat"));
            this.LoadObjectmap(dataInputStream, n);
            dataInputStream.close();
            this.getCanvas().logic.run_load_repaint();
        }
        catch (Exception exception) {
            System.out.println("Error while loading map = " + exception.toString());
        }
    }

    private int[] tile_action_map_stage(int n) {
        int[] nArray = new int[2];
        if (n >= 2 && n <= 8 && n != 3) {
            nArray[0] = 2;
            nArray[1] = n == 2 ? 0 : n - 3;
        }
        if (n == 1 || n == 3) {
            nArray[0] = n;
            nArray[1] = 0;
        }
        if (n >= 16 && n <= 22) {
            nArray[0] = 16;
            nArray[1] = n - 16;
        }
        return nArray;
    }

    public void Draw(Graphics graphics) throws Exception {
        graphics.fillRect(0, 0, 240, 320);
        if (this.mapMidp2 != null) {
            this.mapMidp2.setPosition(-this.mapx, -this.mapy);
            this.mapMidp2.paint(graphics);
        } else {
            graphics.setColor(46, 101, 37);
            graphics.fillRect(0, 0, 240, 320);
        }
        int n = 0;
        while (n < this.obj_height) {
            int n2 = this.objTable[n][4];
            if (n2 == 90) {
                this.getCanvas().logic.draw_img_or_ani(n, graphics);
            }
            ++n;
        }
    }

    public void draw_col_debug(Graphics graphics) {
        int n = 0;
        while (n < this.col_tilesWidth) {
            int n2 = 0;
            while (n2 < this.col_tilesHeight) {
                if (!this.collisionMap[n][n2]) {
                    // empty if block
                }
                ++n2;
            }
            ++n;
        }
        graphics.setColor(0xFF0000);
        graphics.setColor(0);
    }

    private void LoadTilesmap(DataInputStream dataInputStream) throws Exception {
        this.tilesWidth = dataInputStream.readByte();
        this.tilesHeight = dataInputStream.readByte();
        this.mapMidp2 = null;
        this.mapMidp2 = new TiledLayer(this.tilesWidth, this.tilesHeight, this.tilesmapImage_, 32, 32);
        int n = 0;
        while (n < this.tilesHeight) {
            int n2 = 0;
            while (n2 < this.tilesWidth) {
                byte by = dataInputStream.readByte();
                this.mapMidp2.setCell(n2, n, (int)by);
                ++n2;
            }
            ++n;
        }
    }

    private void LoadCollMap(DataInputStream dataInputStream) throws Exception {
        this.col_tilesWidth = 52;
        this.col_tilesHeight = 52;
        this.collisionMap = new boolean[this.col_tilesWidth][this.col_tilesHeight];
        int n = 0;
        while (n < this.col_tilesHeight) {
            int n2 = 0;
            while (n2 < this.col_tilesWidth) {
                this.collisionMap[n2][n] = dataInputStream != null ? dataInputStream.readByte() == 0 : true;
                ++n2;
            }
            ++n;
        }
    }

    public void clear_col_map() {
        int n = 0;
        while (n < this.col_tilesHeight) {
            int n2 = 0;
            while (n2 < this.col_tilesWidth) {
                this.collisionMap[n2][n] = false;
                ++n2;
            }
            ++n;
        }
    }

    private void LoadObjectmap(DataInputStream dataInputStream, int n) throws Exception {
        int n2;
        byte[] byArray = new byte[2];
        dataInputStream.read(byArray);
        this.obj_width = this.getshortzzz(byArray);
        dataInputStream.read(byArray);
        this.obj_height = this.getshortzzz(byArray);
        ++this.obj_width;
        ++this.obj_height;
        this.obj_width += 3;
        this.objTable = new int[this.obj_height + 10][this.obj_width];
        int n3 = 0;
        while (n3 < this.obj_height - 1) {
            n2 = 0;
            while (n2 < this.obj_width - 4) {
                dataInputStream.read(byArray);
                this.objTable[n3][n2] = this.getshortzzz(byArray);
                ++n2;
            }
            ++n3;
        }
        this.set_objtable(this.obj_height - 1, 0, 0, 0, 0, 0);
        this.Calculate_objTable_have_pic();
        this.LoadobjImage();
        this.transport = new int[4][6];
        this.road_sigh = new int[4][6];
        this.object_table_x_y_anchor_change();
        n2 = 0;
        while (n2 < 10) {
            this.set_objtable(this.obj_height + n2, -1, 0, 0, -1, 400);
            ++n2;
        }
        this.obj_height += 10;
    }

    public void set_objtable(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n == -1) {
            return;
        }
        this.objTable[n][0] = n2;
        this.objTable[n][1] = n3;
        this.objTable[n][2] = n4;
        this.objTable[n][5] = n5;
        this.objTable[n][4] = n6;
    }

    public int find_objtable(int n, int n2) {
        int n3 = 0;
        while (n3 < this.obj_height) {
            if (this.objTable[n3][4] == n2 && this.objTable[n3][5] == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void LoadobjImage() throws Exception {
        try {
            this.objImage = new Image[this.objImg_num];
            this.objAction = new Action[this.objImg_num];
            int n = 0;
            while (n < this.objImg_num) {
                int n2 = this.objImg_table_small[n];
                if (n2 > 60 && n2 < 300) {
                    if (this.zsw_66_obj(n2)) {
                        this.objImage[n] = Image.createImage((String)("/obj/" + n2 + ".png"));
                    }
                } else if (n2 != 0) {
                    if (n2 >= 500) {
                        if (this.zsw_66_obj_action(n2)) {
                            this.objAction[n] = new Action(n2, "/obj_action/" + n2, 0);
                        }
                    } else {
                        if (n2 == 10 || n2 == 11 || n2 == 12) {
                            n2 = 9;
                        }
                        if (n2 == 14) {
                            n2 = 31;
                        }
                        if (n2 == 16) {
                            n2 = 33;
                        }
                        this.objAction[n] = new Action(n2);
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println("load obj img and action error!!");
            iOException.printStackTrace();
        }
    }

    private boolean zsw_66_obj_action(int n) {
        return n == 860 || n == 1010 || n == 1040 || n == 740 || n == 830;
    }

    private boolean zsw_66_obj(int n) {
        return n == 93 || n == 99 || n == 118 || n == 88;
    }

    public Image find_img_from_objImg_table_small(int n) {
        Image image = null;
        int n2 = 0;
        while (n2 < this.objImg_num) {
            if (n == this.objImg_table_small[n2]) {
                return this.objImage[n2];
            }
            ++n2;
        }
        return image;
    }

    public Action find_action_from_objaction_table_small(int n) {
        Action action = null;
        n = this.Calculate_objTable_have_pic_if_500(n);
        int n2 = 0;
        while (n2 < this.objImg_num) {
            if (n == this.objImg_table_small[n2]) {
                return this.objAction[n2];
            }
            ++n2;
        }
        return action;
    }

    private void LoadTilesmapImage(int n) {
        Image image = null;
        try {
            image = Image.createImage((String)("/map_data/" + n + "_t.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("load tile img error");
        }
        this.tilesmapImage_ = image;
    }

    public boolean Check_Block(int n, int n2) {
        int n3 = n - 6;
        int n4 = n2 - 6;
        int n5 = n3 / 8;
        while (n5 <= (n3 + 12) / 8) {
            int n6 = n4 / 8;
            while (n6 <= (n4 + 9) / 8) {
                if (n5 >= this.col_tilesWidth - 1 || n6 >= this.col_tilesHeight - 1 || n6 <= 0 || n5 <= 0) {
                    return false;
                }
                if (!this.collisionMap[n5][n6]) {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return true;
    }

    private void Calculate_objTable_have_pic() {
        int[] nArray = new int[this.obj_height];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < nArray.length) {
            boolean bl = false;
            int n4 = 0;
            while (n4 < n2) {
                if (nArray[n4] == this.Calculate_objTable_have_pic_if_500(this.objTable[n][0])) {
                    ++n;
                    ++n3;
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) continue;
            nArray[n2++] = this.Calculate_objTable_have_pic_if_500(this.objTable[n++][0]);
        }
        this.objImg_num = nArray.length - n3;
        this.objImg_table_small = new int[this.objImg_num];
        System.arraycopy(nArray, 0, this.objImg_table_small, 0, this.objImg_num);
    }

    private int Calculate_objTable_have_pic_if_500(int n) {
        if (n >= 500 && (n - 500) % 30 != 0) {
            return 500 + (n - 500) / 30 * 30;
        }
        return n;
    }

    public void calculat_collisionMap(int n, int n2, boolean bl) {
        int n3 = n / 8;
        while (n3 <= (n + 12) / 8) {
            int n4 = n2 / 8;
            while (n4 <= (n2 + 9) / 8) {
                this.collisionMap[n3][n4] = bl;
                ++n4;
            }
            ++n3;
        }
    }

    public void set_player_col(Player_and_NPC player_and_NPC, boolean bl) {
        this.calculat_collisionMap(player_and_NPC.x - 6, player_and_NPC.y - 6, bl);
    }

    private int[][] object_table_x_y_anchor_change() {
        int n = 0;
        while (n < this.obj_height) {
            int n2 = this.objTable[n][4];
            int n3 = this.objTable[n][0];
            if (this.is_transport(n2)) {
                this.transport[n2 - 91][0] = n2;
                this.transport[n2 - 91][1] = this.objTable[n][1];
                this.transport[n2 - 91][2] = this.objTable[n][2];
            }
            if (this.is_road_sigh(n2)) {
                this.road_sigh[n2 - 52][0] = n2;
                this.road_sigh[n2 - 52][1] = this.objTable[n][1];
                this.road_sigh[n2 - 52][2] = this.objTable[n][2];
            }
            if (n3 >= 500) {
                this.objTable[n][6] = (n3 - 500) % 30;
            }
            ++n;
        }
        return this.objTable;
    }

    private int[][] updata(Player_and_NPC player_and_NPC, Player_and_NPC[] player_and_NPCArray, Player_and_NPC[] player_and_NPCArray2) {
        int n = 0;
        while (n < this.obj_height) {
            int n2;
            int n3 = this.objTable[n][4];
            if (this.is_player(n3)) {
                this.objTable[n][1] = player_and_NPC.x;
                this.objTable[n][2] = player_and_NPC.y;
            }
            if (this.is_npc(n3)) {
                n2 = this.objTable[n][5];
                this.objTable[n][1] = player_and_NPCArray[n2].x;
                this.objTable[n][2] = player_and_NPCArray[n2].y;
            }
            if (this.is_monster(n3)) {
                n2 = this.objTable[n][5];
                this.objTable[n][1] = player_and_NPCArray2[n2].x;
                this.objTable[n][2] = player_and_NPCArray2[n2].y;
            }
            ++n;
        }
        return this.objTable;
    }

    public void obj_table_updata_and_slect_small(Player_and_NPC player_and_NPC, Player_and_NPC[] player_and_NPCArray, Player_and_NPC[] player_and_NPCArray2) {
        this.objTable = this.updata(player_and_NPC, player_and_NPCArray, player_and_NPCArray2);
        this.objTable = this.select_small(this.objTable, this.obj_height);
    }

    private int[][] select_small(int[][] nArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            while (n3 < n) {
                if (nArray[n3][2] < nArray[n2][2]) {
                    int[] nArray2 = nArray[n3];
                    nArray[n3] = nArray[n2];
                    nArray[n2] = nArray2;
                }
                ++n3;
            }
            ++n2;
        }
        return nArray;
    }

    public boolean is_npc(int n) {
        return n <= 12 && n >= 1;
    }

    public boolean is_monster(int n) {
        return n <= 113 && n >= 101;
    }

    public boolean is_player(int n) {
        return n == 0;
    }

    public boolean is_transport(int n) {
        return n <= 94 && n >= 91;
    }

    public boolean is_bullet(int n) {
        return n <= 400 && n >= 400;
    }

    public boolean is_road_sigh(int n) {
        return n <= 55 && n >= 52;
    }

    private int getIntzzz(byte[] byArray) {
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    private int getshortzzz(byte[] byArray) {
        return byArray[0] << 8 | byArray[1] & 0xFF;
    }

    private Main getCanvas() {
        return Midlet.instance.c;
    }
}

