/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import z.CameraWaypoint;
import z.Cordic;
import z.GameEngine;
import z.Input;
import z.Math3D;
import z.SniperCanvas;

public class SniperGunCamera {
    private CameraWaypoint[][][] CAMERAPATHS = new CameraWaypoint[][][]{{{new CameraWaypoint(-104.574f, -138.219f, -100.942f, -152.0f, -17.404f, 0), new CameraWaypoint(44.613f, -151.918f, -105.991f, 153.399f, -3.0039978f, 3000)}, {new CameraWaypoint(44.613f, -151.918f, -105.991f, 153.399f, -3.0039978f, 0), new CameraWaypoint(68.994f, -111.085f, 15.87f, 66.499f, -18.403f, 3000)}, {new CameraWaypoint(68.994f, -111.085f, 15.87f, 66.499f, -18.403f, 0), new CameraWaypoint(68.994f, -111.085f, 15.87f, 66.499f, -18.403f, 3000)}, {new CameraWaypoint(68.994f, -111.085f, 15.87f, 66.499f, -18.403f, 0), new CameraWaypoint(68.994f, -111.085f, 15.87f, 66.499f, -18.403f, 3000)}}, {{new CameraWaypoint(73.667f, -150.204f, 122.051f, 26.0f, 0.69999695f, 0), new CameraWaypoint(-52.292f, -132.234f, -102.683f, -162.1f, -19.099998f, 3000)}, {new CameraWaypoint(-52.292f, -132.234f, -102.683f, -162.1f, -19.099998f, 0), new CameraWaypoint(-123.903f, -111.317f, 86.363f, -51.1f, -42.1f, 3000)}}, {{new CameraWaypoint(146.238f, 23.811f, 121.721f, 45.0f, -13.900002f, 0), new CameraWaypoint(129.343f, 94.08f, -121.731f, 144.2f, -46.6f, 3000)}, {new CameraWaypoint(129.343f, 94.08f, -121.731f, 144.2f, -46.6f, 0), new CameraWaypoint(-100.891f, 59.619f, 119.25f, -38.2f, -29.7f, 3000)}}, {{new CameraWaypoint(100.863f, 74.992f, -93.38f, 145.5f, -13.600998f, 0), new CameraWaypoint(-91.633f, 100.843f, -10.166f, -144.8f, -18.101997f, 3000)}, {new CameraWaypoint(-91.633f, 100.843f, -10.166f, -144.8f, -18.101997f, 0), new CameraWaypoint(-80.388f, 24.855f, 165.25f, -19.999f, 17.297997f, 3000)}}};
    private CameraWaypoint[][] DEMOPATH = new CameraWaypoint[][]{{new CameraWaypoint(2.64f, 0.08f, 0.4f, 66.0f, 3.0f, 0), new CameraWaypoint(2.64f, 1.14f, 0.4f, 66.0f, 28.0f, 2200), new CameraWaypoint(2.11f, 1.5f, 0.2f, 39.0f, 38.0f, 2000), new CameraWaypoint(1.64f, 1.66f, 0.28f, 4.0f, 10.0f, 2000), new CameraWaypoint(0.92f, 1.66f, 0.08f, -45.0f, -34.0f, 2000), new CameraWaypoint(1.32f, 0.58f, -0.27f, 49.0f, -38.0f, 5000), new CameraWaypoint(0.56f, 0.39f, -1.51f, 120.0f, 4.0f, 2000), new CameraWaypoint(-0.32f, 0.35f, -1.39f, 59.0f, 6.0f, 2000), new CameraWaypoint(-1.36f, 0.36f, -0.84f, -81.0f, 7.0f, 2000), new CameraWaypoint(-1.46f, 0.33f, 0.39f, -59.0f, 0.0f, 2000), new CameraWaypoint(-0.77f, 0.56f, 0.66f, -53.0f, 51.0f, 2000), new CameraWaypoint(0.43f, 2.77f, 1.29f, 17.0f, -33.0f, 2000), new CameraWaypoint(2.55f, 0.78f, 0.7f, 57.0f, -49.0f, 2000), new CameraWaypoint(2.64f, 0.08f, 0.4f, 66.0f, 3.0f, 2000)}};
    private static final float ANGLE_INCR = 1.0f;
    private static final float MOVE_INCR = 0.5f;
    private static final float SNIPER_ANGLE_INCR = 0.33200002f;
    private static final float HEAD_INCREMENT = 0.9f;
    private static final float NEAR_CLIP = 1.0f;
    private static final float FAR_CLIP = 900.0f;
    private static final float MAX_PITCH = 90.0f;
    private static final float MIN_PITCH = -90.0f;
    private static final float MAX_HEADING = 360.0f;
    private static final float MIN_HEADING = -360.0f;
    private static final long ZOOM_TIME = 800L;
    private static final float ZOOM_OUT_FOV = 90.0f;
    private static final float ZOOM_IN_FOV = 13.0f;
    private static final float CORRECTION_FACTOR_X = 0.24f;
    private static final float CORRECTION_FACTOR_Y = 0.0f;
    private static final double A = 0.9333333373069763;
    private static final double E = 0.9333333373069763 / Math.tan(Math.toRadians(45.0));
    private static final double BETHA = 2.0 * Cordic.atanCordic(0.9333333373069763 / E);
    private static final double ALPHA_MED = 45.0;
    private static final double BETHA_MED = BETHA / 2.0;
    private static final float ACCELERATION = 2.0f;
    private float speedX;
    private float speedY;
    public static final int ZOOM_OFF = 0;
    public static final int ACTIVATING_ZOOM = 1;
    public static final int ZOOM_ON = 2;
    public static final int DESACTIVATING_ZOOM = 3;
    private static final float DUCK_TIME = 800.0f;
    private static final float COVERED_TIME = 1500.0f;
    private static final float RISE_TIME = 500.0f;
    public static final float RELOAD_SEQ_TIME = 2800.0f;
    public static final long TRAVELLING_TIME = 1500L;
    private Transform trans = new Transform();
    private float[] transMat = new float[16];
    private float xCoord;
    private float yCoord;
    private float zCoord;
    private float initX;
    private float initY;
    private float initZ;
    private float initHeadingAngle;
    private float initPitchingAngle;
    private float yAngle;
    private float xAngle;
    private float headDeg;
    private float cameraFov;
    private float aspectRatio;
    private float wallCoef;
    private Transform rotTrans = new Transform();
    private Group transGroup;
    private Camera cam;
    private float zoom_In;
    private long zoomTime;
    private int zoomState;
    private boolean duck = false;
    private boolean rise = false;
    private boolean covered = false;
    private float duckYPos;
    private long duckInitTime;
    private long initCoveredTime;
    private long riseInitTime;
    private long[] initAccTime = new long[]{0L, 0L};
    private long[] initDecTime = new long[]{0L, 0L};
    private static float cursorXPos;
    private static float cursorYPos;
    private static float lastXPos;
    private static float lastYPos;
    private long initPressedTime;
    public boolean changeCameraPath = false;
    private short actualWP;
    private short nextWP;
    private boolean finalPositionReached;
    private static boolean renderSniperCrossHair;
    private long travellingTime;
    private long initTravellingTime;
    private CameraWaypoint[] waypoints;
    private int shockTick;
    private int shockDir;
    private float shockOffset;
    private float shockCoefX = 0.35f;
    private float shockCoefY = -0.2f;
    private boolean isShocking = false;

    public SniperGunCamera(int width, int height, int stage, int substage, boolean demoMode) {
        this.cam = new Camera();
        this.transGroup = new Group();
        this.aspectRatio = (float)width / (float)height;
        this.cameraFov = 90.0f;
        this.zoom_In = 13.0f;
        this.cam.setPerspective(this.cameraFov, this.aspectRatio, 1.0f, 900.0f);
        this.cam.postRotate(0.0f, 0.0f, 1.0f, 0.0f);
        this.cam.postRotate(0.0f, 1.0f, 0.0f, 0.0f);
        this.headDeg = 0.0f;
        if (demoMode) {
            this.xCoord = this.DEMOPATH[0][0].getX();
            this.yCoord = this.DEMOPATH[0][0].getY();
            this.zCoord = this.DEMOPATH[0][0].getZ();
            this.yAngle = this.DEMOPATH[0][0].getHeadingAngle();
            this.xAngle = this.DEMOPATH[0][0].getPitchingAngle();
            this.waypoints = this.DEMOPATH[0];
        } else {
            this.xCoord = this.CAMERAPATHS[stage][substage][0].getX();
            this.yCoord = this.CAMERAPATHS[stage][substage][0].getY();
            this.zCoord = this.CAMERAPATHS[stage][substage][0].getZ();
            this.yAngle = this.CAMERAPATHS[stage][substage][0].getHeadingAngle();
            this.xAngle = this.CAMERAPATHS[stage][substage][0].getPitchingAngle();
            this.waypoints = this.CAMERAPATHS[stage][substage];
        }
        lastXPos = 120.0f;
        lastYPos = 112.0f;
        this.initHeadingAngle = this.yAngle;
        this.initPitchingAngle = this.xAngle;
        this.initX = this.xCoord;
        this.initY = this.yCoord;
        this.initZ = this.zCoord;
        this.transGroup.addChild((Node)this.cam);
        this.updateRotationTransformation();
        this.transGroup.getTransform(this.trans);
        this.trans.setIdentity();
        this.trans.postTranslate(this.xCoord, this.yCoord, this.zCoord);
        this.trans.postRotate(this.yAngle, 0.0f, 1.0f, 0.0f);
        this.trans.postRotate(this.xAngle, 1.0f, 0.0f, 0.0f);
        this.transGroup.setTransform(this.trans);
        cursorXPos = 120.0f;
        cursorYPos = 160.0f;
        this.finalPositionReached = true;
        renderSniperCrossHair = false;
        this.zoomState = 0;
    }

    public final void setZoomIn(float newZoomValue) {
        this.zoom_In = newZoomValue;
    }

    public static final int getCursorXPosition() {
        return (int)cursorXPos;
    }

    public static final int getCursorYPosition() {
        return (int)cursorYPos;
    }

    public final void applyCameraTransformation() {
        this.updateRotationTransformation();
        this.transGroup.getTransform(this.trans);
        this.trans.setIdentity();
        this.trans.postTranslate(this.xCoord, this.yCoord, this.zCoord);
        this.trans.postRotate(this.yAngle + this.shockOffset * this.shockCoefY, 0.0f, 1.0f, 0.0f);
        this.trans.postRotate(this.xAngle + this.shockOffset * this.shockCoefX, 1.0f, 0.0f, 0.0f);
        this.transGroup.setTransform(this.trans);
    }

    public final void disableAllign() {
        this.transGroup.setAlignment(null, 144, null, 144);
    }

    public final void chageCameraUbication() {
        long actualT = GameEngine.getGameTime();
        long elapsedTime = actualT - this.initTravellingTime;
        float coef = (float)elapsedTime * 1.0f / ((float)this.travellingTime * 1.0f);
        if (coef >= 1.0f) {
            if (this.actualWP == this.waypoints.length - 2) {
                this.changeCameraPath = true;
                this.finalPositionReached = true;
                this.initHeadingAngle = this.yAngle;
                this.initPitchingAngle = this.xAngle;
                this.initX = this.waypoints[this.nextWP].getX();
                this.initY = this.waypoints[this.nextWP].getY();
                this.initZ = this.waypoints[this.nextWP].getZ();
                return;
            }
            this.actualWP = this.nextWP;
            this.nextWP = (short)(this.nextWP + 1);
            this.initTravellingTime = actualT;
            this.travellingTime = this.waypoints[this.nextWP].getTime();
            coef = 0.0f;
        }
        this.xCoord = Math3D.linearInterpolation(this.waypoints[this.actualWP].getX(), this.waypoints[this.nextWP].getX(), coef);
        this.yCoord = Math3D.linearInterpolation(this.waypoints[this.actualWP].getY(), this.waypoints[this.nextWP].getY(), coef);
        this.zCoord = Math3D.linearInterpolation(this.waypoints[this.actualWP].getZ(), this.waypoints[this.nextWP].getZ(), coef);
        this.yAngle = Math3D.linearInterpolation(this.waypoints[this.actualWP].getHeadingAngle(), this.waypoints[this.nextWP].getHeadingAngle(), coef);
        this.xAngle = Math3D.linearInterpolation(this.waypoints[this.actualWP].getPitchingAngle(), this.waypoints[this.nextWP].getPitchingAngle(), coef);
        this.applyCameraTransformation();
    }

    public final boolean weReachFinalPosition() {
        return this.finalPositionReached;
    }

    public final void setFinalPositionReachedValue(boolean value) {
        this.finalPositionReached = value;
    }

    public final float[] getPos() {
        float[] pos = new float[]{this.xCoord, this.yCoord, this.zCoord};
        return pos;
    }

    public final float getCameraXPos() {
        return this.xCoord;
    }

    public final float getCameraYPos() {
        return this.yCoord;
    }

    public final float getCameraZPos() {
        return this.zCoord;
    }

    public final float getCameraHeadingAngle() {
        return this.yAngle;
    }

    public final float getCameraPitchingAngle() {
        return this.xAngle;
    }

    public final float[] getAngles() {
        float[] angles = new float[]{this.xAngle, this.yAngle, 0.0f};
        return angles;
    }

    public final float getActualFOV() {
        return this.cameraFov;
    }

    public final void setCameraPath(int stage, int substage) {
        this.waypoints = this.CAMERAPATHS[stage][substage];
    }

    public final void activeDemoTravelling() {
        this.waypoints = this.DEMOPATH[0];
    }

    private final void resetCursor() {
        this.calculateNewCursorPos();
        this.speedY = 0.0f;
        this.speedX = 0.0f;
    }

    public final Transform getRotationMatrix() {
        Transform trans = new Transform();
        this.transGroup.getTransform(trans);
        return trans;
    }

    public final int getCursorXPos() {
        return (int)cursorXPos;
    }

    public final int getCursorYPos() {
        return (int)cursorYPos;
    }

    public Group getCameraGroup() {
        return this.transGroup;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public final int getZoomState() {
        return this.zoomState;
    }

    public final boolean isZoomActive() {
        switch (this.zoomState) {
            case 2: {
                return true;
            }
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    private final void updateCursorPosition() {
        float acc;
        if (Input.IsKeyHold(4) || Input.IsKeyHold(8)) {
            acc = 2.0f;
            if (Input.IsKeyHold(4)) {
                acc = -acc;
            }
            if (this.speedX * acc < 0.0f) {
                this.speedX = 0.0f;
            }
            this.speedX += acc;
            cursorXPos += this.speedX;
            this.checkAimTargetPositionLimitations();
        } else {
            this.speedX = 0.0f;
        }
        if (Input.IsKeyHold(1) || Input.IsKeyHold(2)) {
            acc = 2.0f;
            if (Input.IsKeyHold(1)) {
                acc = -acc;
            }
            if (this.speedY * acc < 0.0f) {
                this.speedY = 0.0f;
            }
            this.speedY += acc;
            cursorYPos += this.speedY;
            this.checkAimTargetPositionLimitations();
        } else {
            this.speedY = 0.0f;
        }
    }

    private final void checkAimTargetPositionLimitations() {
        if (cursorYPos <= 48.0f) {
            this.speedY = 0.0f;
            cursorYPos = 48.0f;
        }
        if (cursorYPos >= 272.0f) {
            this.speedY = 0.0f;
            cursorYPos = 272.0f;
        }
        if (cursorXPos <= 0.0f) {
            this.speedX = 0.0f;
            cursorXPos = 0.0f;
        }
        if (cursorXPos >= 240.0f) {
            this.speedX = 0.0f;
            cursorXPos = 240.0f;
        }
    }

    public void isTimeToDuck() {
        this.duck = true;
        this.rise = false;
        this.duckInitTime = GameEngine.getGameTime();
    }

    public void duckCamera() {
        float newY;
        this.duckYPos = this.initY - 20.0f;
        long elapsedTime = GameEngine.getGameTime() - this.duckInitTime;
        this.wallCoef = (float)elapsedTime / 800.0f;
        if (this.wallCoef > 1.0f) {
            newY = this.duckYPos;
            this.duck = false;
            this.covered = true;
            this.initCoveredTime = GameEngine.getGameTime();
        } else {
            newY = this.initY + this.wallCoef * (this.duckYPos - this.initY);
        }
        this.yCoord = newY;
        this.transGroup.getTransform(this.trans);
        this.trans.setIdentity();
        this.trans.postTranslate(this.xCoord, this.yCoord, this.zCoord);
        this.trans.postRotate(this.yAngle, 0.0f, 1.0f, 0.0f);
        this.trans.postRotate(this.xAngle, 1.0f, 0.0f, 0.0f);
        this.transGroup.setTransform(this.trans);
    }

    public void coveredCamera() {
        long elapsedTime = GameEngine.getGameTime() - this.initCoveredTime;
        if ((float)elapsedTime > 1500.0f) {
            this.covered = false;
            this.rise = true;
            this.riseInitTime = GameEngine.getGameTime();
        }
    }

    public void riseCamera() {
        float newY;
        this.duckYPos = this.initY - 20.0f;
        long elapsedTime = GameEngine.getGameTime() - this.riseInitTime;
        this.wallCoef = (float)elapsedTime / 500.0f;
        if (this.wallCoef > 1.0f) {
            newY = this.initY;
            this.rise = false;
        } else {
            newY = this.duckYPos + this.wallCoef * (this.initY - this.duckYPos);
        }
        this.yCoord = newY;
        this.transGroup.getTransform(this.trans);
        this.trans.setIdentity();
        this.trans.postTranslate(this.xCoord, this.yCoord, this.zCoord);
        this.trans.postRotate(this.yAngle, 0.0f, 1.0f, 0.0f);
        this.trans.postRotate(this.xAngle, 1.0f, 0.0f, 0.0f);
        this.transGroup.setTransform(this.trans);
    }

    public final float getWallCoef() {
        return this.wallCoef;
    }

    public final boolean areWeChangingTheMagazine() {
        return this.duck || this.rise || this.covered;
    }

    public final boolean areWeDucking() {
        return this.duck;
    }

    public final boolean areWeRising() {
        return this.rise;
    }

    public final boolean areWeCovered() {
        return this.covered;
    }

    public void processShock() {
        int shockFrame = 5;
        this.shockOffset += (float)this.shockDir;
        if (++this.shockTick > 5) {
            this.isShocking = false;
            this.shockTick = 0;
            this.shockOffset = 0.0f;
            return;
        }
        this.updateXRotation();
    }

    public void beginShock() {
        this.shockCoefX = (float)Math3D.getRandNumber(10, 25) * 0.01f;
        this.shockCoefY = -((float)Math3D.getRandNumber(7, 15)) * 0.01f;
        this.shockOffset = 5.0f;
        this.shockTick = 0;
        this.shockDir = -1;
        this.isShocking = true;
    }

    public final void updateCamera() {
        if (this.isShocking) {
            this.processShock();
        }
        if (this.finalPositionReached) {
            this.updateCursorPosition();
            if (Input.IsKeyHold(1) || Input.IsKeyHold(2)) {
                if (this.zoomState == 2) {
                    this.updateXRotation();
                }
            } else if ((Input.IsKeyHold(4) || Input.IsKeyHold(8)) && this.zoomState == 2) {
                this.updateYRotation();
            }
            switch (this.zoomState) {
                case 1: 
                case 3: {
                    this.updateFieldOfView();
                    break;
                }
            }
            if (this.duck) {
                this.duckCamera();
            }
            if (this.covered) {
                this.coveredCamera();
            }
            if (this.rise) {
                this.riseCamera();
            }
        } else {
            this.updateFieldOfView();
            this.chageCameraUbication();
        }
    }

    public final void breathe(float[] healthCte) {
        this.headDeg += healthCte[1];
        float yDesp = (float)Math.sin(this.headDeg) / healthCte[0];
        this.yCoord += yDesp;
        this.applyCameraTransformation();
    }

    public void resetTravellingAttributes() {
        this.finalPositionReached = false;
        this.actualWP = 0;
        this.nextWP = 1;
        this.travellingTime = this.waypoints[this.nextWP].getTime();
        this.initTravellingTime = GameEngine.getGameTime();
    }

    private float getYAngleIncrement() {
        switch (this.zoomState) {
            case 2: {
                return 0.33200002f;
            }
        }
        return 1.0f;
    }

    private final void updateYRotation() {
        float incr = this.getYAngleIncrement();
        if (Input.IsKeyHold(4)) {
            this.yAngle += incr;
        } else if (Input.IsKeyHold(8)) {
            this.yAngle -= incr;
        }
        this.updateRotationTransformation();
        if (this.yAngle >= 360.0f) {
            this.yAngle -= 360.0f;
        } else if (this.yAngle <= -360.0f) {
            this.yAngle += 360.0f;
        }
        this.storePosition();
        this.trans.setIdentity();
        this.trans.postTranslate(this.xCoord, this.yCoord, this.zCoord);
        this.trans.postRotate(this.yAngle + this.shockOffset * this.shockCoefY, 0.0f, 1.0f, 0.0f);
        this.trans.postRotate(this.xAngle + this.shockOffset * this.shockCoefX, 1.0f, 0.0f, 0.0f);
        this.transGroup.setTransform(this.trans);
    }

    private final void updateXRotation() {
        float incr = this.getYAngleIncrement();
        if (Input.IsKeyHold(1)) {
            this.xAngle += incr;
        } else if (Input.IsKeyHold(2)) {
            this.xAngle -= incr;
        }
        this.updateRotationTransformation();
        if (this.xAngle > 90.0f) {
            this.xAngle = 90.0f;
        } else if (this.xAngle < -90.0f) {
            this.xAngle = -90.0f;
        }
        this.storePosition();
        this.trans.setIdentity();
        this.trans.postTranslate(this.xCoord, this.yCoord, this.zCoord);
        this.trans.postRotate(this.yAngle + this.shockOffset * this.shockCoefY, 0.0f, 1.0f, 0.0f);
        this.trans.postRotate(this.xAngle + this.shockOffset * this.shockCoefX, 1.0f, 0.0f, 0.0f);
        this.transGroup.setTransform(this.trans);
    }

    private final void updateRotationTransformation() {
        this.rotTrans.setIdentity();
        this.rotTrans.postRotate(this.yAngle + this.shockOffset * this.shockCoefY, 0.0f, 1.0f, 0.0f);
        this.rotTrans.postRotate(this.xAngle + this.shockOffset * this.shockCoefX, 1.0f, 0.0f, 0.0f);
    }

    private final void calculateAngles() {
        float difX = cursorXPos - 120.0f;
        float gapx = Math.abs(difX) * 0.24f;
        difX = difX < 0.0f ? (difX -= gapx) : (difX += gapx);
        float difY = cursorYPos - 160.0f;
        float gapy = Math.abs(difY) * 0.0f;
        difY = difY < 0.0f ? (difY -= gapy) : (difY += gapy);
        float coefX = difX * 1.0f / 120.0f;
        float coefY = difY * 1.0f / 112.0f;
        float angleDifX = Math3D.linearInterpolation(0.0f, (float)BETHA_MED, Math.abs(coefX));
        float angleDifY = Math3D.linearInterpolation(0.0f, 45.0f, Math.abs(coefY));
        this.yAngle = difX < 0.0f ? (this.yAngle += angleDifX) : (this.yAngle -= angleDifX);
        this.xAngle = difY < 0.0f ? (this.xAngle += angleDifY) : (this.xAngle -= angleDifY);
    }

    private final void calculateNewCursorPos() {
        float yAngleDif = this.yAngle - this.initHeadingAngle;
        float xAngleDif = this.xAngle - this.initPitchingAngle;
        float coefY = Math.abs(yAngleDif) / (float)BETHA_MED;
        float coefX = Math.abs(xAngleDif) / 45.0f;
        int incrY = Math3D.linearInterpolation(0, 120, coefY);
        int incrX = Math3D.linearInterpolation(0, 112, coefX);
        cursorYPos = xAngleDif < 0.0f ? (float)(160 + incrX) : (float)(160 - incrX);
        cursorXPos = yAngleDif < 0.0f ? (float)(120 + incrY) : (float)(120 - incrY);
    }

    private final void zoomToZone() {
        this.calculateAngles();
        this.updateRotationTransformation();
        this.storePosition();
        this.trans.setIdentity();
        this.trans.postTranslate(this.xCoord, this.yCoord, this.zCoord);
        this.trans.postRotate(this.yAngle, 0.0f, 1.0f, 0.0f);
        this.trans.postRotate(this.xAngle, 1.0f, 0.0f, 0.0f);
        this.transGroup.setTransform(this.trans);
    }

    private final void updateZoomState() {
        switch (this.zoomState) {
            case 2: {
                this.zoomState = 3;
                SniperCanvas.aimTick = 0;
                break;
            }
            case 0: {
                this.zoomState = 1;
                SniperCanvas.aimTick = 0;
                break;
            }
            case 1: {
                this.zoomState = 2;
                break;
            }
            case 3: {
                this.zoomState = 0;
            }
        }
    }

    public final void switchZoomSate() {
        switch (this.zoomState) {
            case 2: {
                this.resetCursor();
                this.xAngle = this.initPitchingAngle;
                this.yAngle = this.initHeadingAngle;
                this.applyCameraTransformation();
                renderSniperCrossHair = false;
                this.updateZoomState();
                this.zoomTime = GameEngine.getGameTime();
                this.speedY = 0.0f;
                this.speedX = 0.0f;
                break;
            }
            case 0: {
                lastXPos = cursorXPos;
                lastYPos = cursorYPos;
                renderSniperCrossHair = true;
                this.zoomToZone();
                this.zoomTime = GameEngine.getGameTime();
                this.updateZoomState();
                this.speedY = 0.0f;
                this.speedX = 0.0f;
                break;
            }
        }
    }

    public final void disableZoom() {
        this.resetCursor();
        this.zoomState = 0;
        this.cam.setPerspective(90.0f, this.aspectRatio, 1.0f, 900.0f);
        this.xAngle = this.initPitchingAngle;
        this.yAngle = this.initHeadingAngle;
        this.applyCameraTransformation();
        renderSniperCrossHair = false;
    }

    public float[] getPosition() {
        this.storePosition();
        return new float[]{this.xCoord, this.yCoord, this.zCoord};
    }

    private void storePosition() {
        this.transGroup.getCompositeTransform(this.trans);
        this.trans.get(this.transMat);
        this.xCoord = this.transMat[3];
        this.yCoord = this.transMat[7];
        this.zCoord = this.transMat[11];
    }

    public float[] getDirection() {
        float[] zVec = new float[]{0.0f, 0.0f, -1.0f, 0.0f};
        this.rotTrans.transform(zVec);
        return new float[]{zVec[0], zVec[1], zVec[2]};
    }

    private final void updateFieldOfView() {
        switch (this.zoomState) {
            case 1: {
                long elapsedTime = GameEngine.getGameTime() - this.zoomTime;
                float f = (float)elapsedTime * 1.0f / 800.0f;
                if (f >= 1.0f) {
                    this.zoomState = 2;
                    this.cameraFov = this.zoom_In;
                    break;
                }
                this.cameraFov = Math3D.linearInterpolation(90.0f, this.zoom_In, f);
                break;
            }
            case 3: {
                long elapsedTime = GameEngine.getGameTime() - this.zoomTime;
                float f = (float)elapsedTime * 1.0f / 800.0f;
                if (f >= 1.0f) {
                    this.zoomState = 0;
                    this.cameraFov = 90.0f;
                    break;
                }
                this.cameraFov = Math3D.linearInterpolation(this.zoom_In, 90.0f, f);
                break;
            }
        }
        try {
            this.cam.setPerspective(this.cameraFov, this.aspectRatio, 1.0f, 900.0f);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

