/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import z.SniperMIDlet;

public class SoundManager {
    public static final int _Type_MIDI_ = 10;
    public static final int _Type_AMR_ = 11;
    private static final int _Default_Volumen_ = 10;
    private static final int _First_Valid_Sound_ = 0;
    private static final int _Sound_OST_ = 0;
    private static final int _Sound_ReloadFX_ = 1;
    private static final int _Sound_ShotFX_ = 2;
    private static final int _Last_Valid_Sound_ = 2;
    private static final String[] _Music_Files_ = new String[]{"music_ost.mid", "fx_reload.amr", "fx_shot.amr"};
    private static final int[] _Music_Types_ = new int[]{10, 11, 11};
    private static SoundManager instance;
    private Player[] sounds;
    private int nSounds = 3;
    private int volumen = SniperMIDlet.getPreviousSoundLevel();
    private boolean musicActive = false;

    public SoundManager() {
        this.sounds = new Player[this.nSounds];
        for (int i = 0; i < this.nSounds; ++i) {
            this.sounds[i] = this.loadSound("/x/" + _Music_Files_[i], _Music_Types_[i]);
            try {
                VolumeControl c = (VolumeControl)this.sounds[i].getControl("javax.microedition.media.control.VolumeControl");
                c.setLevel(this.volumen);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void updateVolumen(int volumenLevel) {
        this.volumen = volumenLevel;
        for (int i = 0; i < this.nSounds; ++i) {
            try {
                ((VolumeControl)this.sounds[i].getControl("javax.microedition.media.control.VolumeControl")).setLevel(this.volumen);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final int getCurrentVolumen() {
        return this.volumen;
    }

    private Player loadSound(String fn, int musicType) {
        Player p = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(fn);
            switch (musicType) {
                case 10: {
                    p = Manager.createPlayer((InputStream)in, (String)"audio/midi");
                    break;
                }
                case 11: {
                    p = Manager.createPlayer((InputStream)in, (String)"audio/amr");
                    break;
                }
                default: {
                    p = Manager.createPlayer((InputStream)in, (String)"audio/midi");
                }
            }
            p.realize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return p;
    }

    public final void disableMusic() {
        this.musicActive = false;
    }

    public final void enableMusic() {
        this.musicActive = true;
    }

    public final boolean isMusicEnable() {
        return this.musicActive;
    }

    public final void playMainTheme() {
        this.playSound(this.sounds[0]);
    }

    public final void stopMainTheme() {
        this.stopSound(this.sounds[0]);
    }

    public final void playReloadFX() {
        this.playSound(this.sounds[1]);
    }

    public final void playShotFX() {
        this.playSound(this.sounds[2]);
    }

    private final void playSound(Player p) {
        if (this.musicActive && p != null) {
            try {
                p.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void stopSound(Player p) {
        if (this.musicActive && p != null && p.getState() == 400) {
            try {
                p.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void closeSounds() {
        for (int i = 0; i < this.nSounds; ++i) {
            this.sounds[i].close();
        }
    }
}

