/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;
import z.Math3D;
import z.Vector3D;

public class AABB {
    private static final float BIGNUMBER = 1.0E37f;
    private Vector3D center;
    private Vector3D min = new Vector3D(1.0E37f, 1.0E37f, 1.0E37f);
    private Vector3D max = new Vector3D(-1.0E37f, -1.0E37f, -1.0E37f);

    public final Vector3D getMin() {
        return this.min;
    }

    public final Vector3D getMax() {
        return this.max;
    }

    public final void empty() {
        if (this.min != null && this.max != null) {
            this.min.setX(1.0E37f);
            this.min.setY(1.0E37f);
            this.min.setZ(1.0E37f);
            this.max.setX(-1.0E37f);
            this.max.setY(-1.0E37f);
            this.max.setZ(-1.0E37f);
        }
    }

    public final void generateBoundingSphere() {
        this.center = this.getCenter();
    }

    public final Vector3D getNewCenter(Transform t) {
        float[] matrix = new float[16];
        float[] point = new float[]{this.center.getX(), this.center.getY(), this.center.getZ(), 1.0f};
        t.get(matrix);
        float[] res = Math3D.multiplyMatrices(matrix, point, 4, 4, 4, 1);
        Vector3D newCenter = new Vector3D(res[0], res[1], res[2]);
        return newCenter;
    }

    public final Vector3D getCenter() {
        return Vector3D.scalarDiv(Vector3D.add(this.min, this.max), 2.0f);
    }

    public void add(Vector3D aPoint) {
        if (aPoint != null) {
            if (aPoint.getX() < this.min.getX()) {
                this.min.setX(aPoint.getX());
            }
            if (aPoint.getX() > this.max.getX()) {
                this.max.setX(aPoint.getX());
            }
            if (aPoint.getY() < this.min.getY()) {
                this.min.setY(aPoint.getY());
            }
            if (aPoint.getY() > this.max.getY()) {
                this.max.setY(aPoint.getY());
            }
            if (aPoint.getZ() < this.min.getZ()) {
                this.min.setZ(aPoint.getZ());
            }
            if (aPoint.getZ() > this.max.getZ()) {
                this.max.setZ(aPoint.getZ());
            }
        }
    }

    public void add(float x, float y, float z) {
        if (x < this.min.getX()) {
            this.min.setX(x);
        }
        if (x > this.max.getX()) {
            this.max.setX(x);
        }
        if (y < this.min.getY()) {
            this.min.setY(y);
        }
        if (y > this.max.getY()) {
            this.max.setY(y);
        }
        if (z < this.min.getZ()) {
            this.min.setZ(z);
        }
        if (z > this.max.getZ()) {
            this.max.setZ(z);
        }
    }

    public static final AABB generateAABB(Mesh aMesh, float x, float y, float z, float heading) {
        float[] scale = new float[3];
        if (aMesh != null) {
            aMesh.getScale(scale);
            AABB box = AABB.calculateAABB(aMesh.getVertexBuffer(), scale, x, y, z, heading);
            return box;
        }
        return null;
    }

    private static final AABB calculateAABB(VertexBuffer vb, float[] scale, float xInit, float yInit, float zInit, float heading) {
        float[] scaleBias = new float[4];
        VertexArray va = vb.getPositions(scaleBias);
        Transform t = new Transform();
        t.setIdentity();
        t.postTranslate(scaleBias[1] * scale[0] + xInit, scaleBias[2] * scale[1] + yInit, scaleBias[3] * scale[2] + zInit);
        t.postRotate(heading, 0.0f, 1.0f, 0.0f);
        t.postScale(scaleBias[0] * scale[0], scaleBias[0] * scale[1], scaleBias[0] * scale[2]);
        float[] out = new float[vb.getVertexCount() * 4];
        t.transform(va, out, true);
        AABB box = new AABB();
        box.empty();
        float z = 0.0f;
        float y = 0.0f;
        float x = 0.0f;
        block5: for (int i = 0; i < out.length; ++i) {
            int mod = i % 4;
            switch (mod) {
                case 0: {
                    x = out[i];
                    continue block5;
                }
                case 1: {
                    y = out[i];
                    continue block5;
                }
                case 2: {
                    z = out[i];
                    continue block5;
                }
                default: {
                    box.add(x, y, z);
                }
            }
        }
        box.generateBoundingSphere();
        return box;
    }
}

