/*
 * Decompiled with CFR 0.152.
 */
package z;

import z.AdvanceSceneObject;

public class AdvanceSceneObjectPool {
    private static final int MIN_POOL_SIZE = 2;
    private AdvanceSceneObject firstFree;
    private AdvanceSceneObject lastFree;
    private AdvanceSceneObject firstUsed;
    private AdvanceSceneObject lastUsed;

    public AdvanceSceneObjectPool(AdvanceSceneObject[] initObjects) {
        if (initObjects == null || initObjects.length < 2) {
            return;
        }
        this.firstFree = initObjects[0];
        this.lastFree = initObjects[initObjects.length - 1];
        for (int i = 0; i < initObjects.length; ++i) {
            if (i < initObjects.length - 1) {
                initObjects[i].setNextLinked(initObjects[i + 1]);
            } else {
                initObjects[i].setNextLinked(null);
            }
            if (i > 0) {
                initObjects[i].setPrevLinked(initObjects[i - 1]);
                continue;
            }
            initObjects[i].setPrevLinked(null);
        }
    }

    public final AdvanceSceneObject getNextFree() {
        if (this.firstFree != null) {
            if (this.firstFree.getNextLinked() != null) {
                this.firstFree.getNextLinked().setPrevLinked(null);
            }
            AdvanceSceneObject newFirstFree = this.firstFree.getNextLinked();
            this.firstFree.setNextLinked(null);
            if (this.lastUsed != null) {
                this.firstFree.setPrevLinked(this.lastUsed);
                this.lastUsed.setNextLinked(this.firstFree);
            }
            this.lastUsed = this.firstFree;
            if (this.firstUsed == null) {
                this.firstUsed = this.firstFree;
            }
            if (this.lastFree == this.firstFree) {
                this.lastFree = null;
            }
            AdvanceSceneObject actorToReturn = this.firstFree;
            this.firstFree = newFirstFree;
            return actorToReturn;
        }
        return null;
    }

    public final void release(AdvanceSceneObject sceneObjectToRelease) {
        if (sceneObjectToRelease.getPrevLinked() != null) {
            sceneObjectToRelease.getPrevLinked().setNextLinked(sceneObjectToRelease.getNextLinked());
        }
        if (sceneObjectToRelease.getNextLinked() != null) {
            sceneObjectToRelease.getNextLinked().setPrevLinked(sceneObjectToRelease.getPrevLinked());
        }
        if (this.firstUsed == sceneObjectToRelease) {
            this.firstUsed = sceneObjectToRelease.getNextLinked();
        }
        if (this.lastUsed == sceneObjectToRelease) {
            this.lastUsed = sceneObjectToRelease.getPrevLinked();
        }
        sceneObjectToRelease.setNextLinked(null);
        if (this.firstFree == null) {
            this.firstFree = sceneObjectToRelease;
            sceneObjectToRelease.setPrevLinked(null);
        }
        if (this.lastFree != null) {
            sceneObjectToRelease.setPrevLinked(this.lastFree);
            this.lastFree.setNextLinked(sceneObjectToRelease);
        } else {
            sceneObjectToRelease.setPrevLinked(null);
        }
        this.lastFree = sceneObjectToRelease;
    }

    public final AdvanceSceneObject getFirstUsed() {
        return this.firstUsed;
    }
}

