/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.World;
import z.AVPartInfo;
import z.AdvanceBB;
import z.AdvanceSceneObject;
import z.AdvanceSceneObjectPool;
import z.CameraWaypoint;
import z.Console;
import z.HumanInfo;
import z.Input;
import z.LoadingCanvas;
import z.Math3D;
import z.PWTokenizer;
import z.PowerUpInfo;
import z.Resources;
import z.ShootableObject;
import z.SniperCanvas;
import z.SniperGunCamera;
import z.SniperMIDlet;
import z.Vector3D;

public class GameEngine {
    public Mesh skyBox;
    private static final int TIME_TO_DARK = 6000;
    public static final int MSG_DEFAULT_DURATION = 1500;
    private static final int IMMORTAL_TIME = 2000;
    private static final int TIME_TO_SHOW_IZ = 1500;
    private static final int HOLD_BREATHE_DURATION = 2000;
    private static final int TIME_TO_WAIT = 4000;
    private static final byte _Prob_PWRUP_ = 2;
    public static final byte _TxtUnit_Size = 13;
    public static final byte _TxtUnt_Innocent_ = 0;
    public static final byte _TxtUnt_Terrorist1_ = 1;
    public static final byte _TxtUnt_Terrorist2_ = 2;
    public static final byte _TxtUnt_Terrorist3_ = 3;
    public static final byte _TxtUnt_Explosion_ = 4;
    public static final byte _TxtUnt_Tree_ = 5;
    public static final byte _TxtUnt_StreetLamp_ = 6;
    public static final byte _TxtUnt_PwrLife_ = 7;
    public static final byte _TxtUnt_PwrBullets_ = 8;
    public static final byte _TxtUnt_PwrBoom_ = 9;
    public static final byte _TxtUnt_PwrBulleProofVest_ = 10;
    public static final byte _TxtUnt_EnemyFire_ = 11;
    public static final byte _TxtUnt_Spark_ = 12;
    public static final int MIN_ANGLE = 0;
    public static final int MAX_ANGLE = 359;
    public static final int SUBSTAGES_PER_LEVEL = 3;
    public static final int LAST_STAGE = 3;
    private static final float BASEY = 0.0f;
    private static final int[] CYCLE = new int[]{2, 1, 1, 2};
    private CameraWaypoint[][][] TRAFFICPATHS = new CameraWaypoint[][][]{{{new CameraWaypoint(2.81f, 0.0f, -2.34f, 90.0f, 0.0f, 0), new CameraWaypoint(-2.89f, 0.0f, -2.34f, 90.0f, 0.0f, 3000)}, {new CameraWaypoint(0.72f, 0.0f, -2.75f, 0.0f, 0.0f, 0), new CameraWaypoint(0.82f, 0.0f, 3.5f, 0.0f, 0.0f, 6000)}}, {{new CameraWaypoint(1.55f, 0.0f, 1.82f, -180.0f, 0.0f, 0), new CameraWaypoint(1.55f, 0.0f, 0.35f, -180.0f, 0.0f, 3000), new CameraWaypoint(1.72f, 0.0f, -0.05f, -225.0f, 0.0f, 3000), new CameraWaypoint(2.16f, 0.0f, -0.09f, -270.0f, 0.0f, 3000), new CameraWaypoint(4.56f, 0.0f, -0.09f, -270.0f, 0.0f, 3000)}, {new CameraWaypoint(-0.4f, 0.0f, -1.21f, 90.0f, 0.0f, 0), new CameraWaypoint(0.68f, 0.0f, -1.21f, 90.0f, 0.0f, 3000), new CameraWaypoint(1.04f, 0.0f, -1.06f, 45.0f, 0.0f, 3000), new CameraWaypoint(1.04f, 0.0f, -0.92f, 0.0f, 0.0f, 3000), new CameraWaypoint(1.04f, 0.0f, 1.14f, 0.0f, 0.0f, 3000)}}, {{new CameraWaypoint(-1.71f, 0.0f, -2.55f, 270.0f, 0.0f, 0), new CameraWaypoint(2.45f, 0.0f, -2.55f, 270.0f, 0.0f, 3000)}, {new CameraWaypoint(2.53f, 0.0f, -2.91f, 90.0f, 0.0f, 0), new CameraWaypoint(-1.86f, 0.0f, -2.91f, 90.0f, 0.0f, 6000)}}, {{new CameraWaypoint(-0.97f, 0.0f, 0.63f, 0.0f, 0.0f, 0), new CameraWaypoint(-0.86f, 0.0f, -3.87f, 0.0f, 0.0f, 4000)}, {new CameraWaypoint(-1.12f, 0.0f, -3.91f, 270.0f, 0.0f, 0), new CameraWaypoint(-1.12f, 0.0f, -3.91f, 270.0f, 0.0f, 0)}}};
    public static Vector3D[][][] DISTRICT_SOBJ_UBICATION = new Vector3D[][][]{{{new Vector3D(-62.0f, -68.352f, -171.892f), new Vector3D(11.523f, -47.795f, -172.699f), new Vector3D(60.049f, -26.802f, -135.092f), new Vector3D(39.99f, -47.795f, -173.456f), new Vector3D(-10.44f, -47.795f, -173.456f), new Vector3D(-42.873f, -47.795f, -173.456f), new Vector3D(-62.804f, -92.834f, -130.716f), new Vector3D(-27.685f, -63.539f, -114.871f), new Vector3D(49.302f, -18.234f, -197.814f), new Vector3D(-97.755f, -25.026f, -169.993f)}, {new Vector3D(-62.0f, -68.352f, -171.892f), new Vector3D(11.523f, -47.795f, -172.699f), new Vector3D(60.049f, -26.802f, -135.092f), new Vector3D(39.99f, -47.795f, -173.456f), new Vector3D(-10.44f, -47.795f, -173.456f), new Vector3D(-47.248f, -47.795f, -173.456f), new Vector3D(-27.685f, -63.539f, -114.871f), new Vector3D(49.302f, -18.234f, -197.814f), new Vector3D(-97.755f, -25.026f, -169.993f), new Vector3D(-105.137f, 19.083f, -171.892f)}, {new Vector3D(11.523f, -47.795f, -172.699f), new Vector3D(-10.44f, -47.795f, -173.456f), new Vector3D(-42.873f, -47.795f, -173.456f), new Vector3D(-97.755f, -25.026f, -169.993f), new Vector3D(-105.137f, 19.083f, -171.892f), new Vector3D(-25.104f, 103.867f, -171.892f), new Vector3D(-101.459f, 96.329f, -171.892f), new Vector3D(-5.816f, 40.662f, -198.891f), new Vector3D(-35.847f, -1.202f, -192.695f), new Vector3D(-26.77f, 52.487f, -172.315f)}}, {{new Vector3D(-110.789f, 5.205f, -192.958f), new Vector3D(-43.873f, 94.257f, -178.197f), new Vector3D(-74.341f, 59.265f, -124.229f), new Vector3D(-17.671f, -65.43f, -192.082f), new Vector3D(28.084f, 14.66f, -192.082f), new Vector3D(88.629f, -32.382f, -192.213f), new Vector3D(-26.2f, 69.437f, -192.923f), new Vector3D(47.465f, 22.04f, -119.835f), new Vector3D(-67.85f, 38.363f, -192.082f), new Vector3D(-96.001f, 12.916f, -192.082f)}, {new Vector3D(-17.671f, -65.43f, -192.082f), new Vector3D(28.084f, 14.66f, -192.082f), new Vector3D(35.841f, -116.009f, -177.756f), new Vector3D(-26.2f, 69.437f, -192.923f), new Vector3D(-18.08f, -34.111f, -192.082f), new Vector3D(47.465f, 22.04f, -119.835f), new Vector3D(-18.08f, -91.476f, -126.323f), new Vector3D(-67.85f, 38.363f, -192.082f), new Vector3D(-85.633f, -66.592f, -192.082f), new Vector3D(84.467f, -103.663f, -178.264f)}, {new Vector3D(-43.873f, 94.257f, -178.197f), new Vector3D(-74.341f, 59.265f, -124.229f), new Vector3D(-17.671f, -65.43f, -192.082f), new Vector3D(28.084f, 14.66f, -192.082f), new Vector3D(88.629f, -32.382f, -192.213f), new Vector3D(-26.2f, 69.437f, -192.923f), new Vector3D(-18.08f, -34.111f, -192.082f), new Vector3D(47.465f, 22.04f, -119.835f), new Vector3D(-67.85f, 38.363f, -192.082f), new Vector3D(25.275f, 90.48f, -179.081f)}}, {{new Vector3D(60.892f, -98.418f, -2.09f), new Vector3D(80.973f, 91.029f, 2.986f), new Vector3D(40.322f, -47.381f, 42.471f), new Vector3D(102.951f, 43.652f, 3.501f), new Vector3D(44.149f, 86.846f, 42.198f), new Vector3D(133.137f, 117.332f, 3.098f), new Vector3D(82.475f, 135.856f, 38.83f), new Vector3D(-125.769f, -30.027f, 13.492f), new Vector3D(-52.76f, -95.814f, -6.279f), new Vector3D(-15.109f, -45.325f, 42.383f)}, {new Vector3D(54.78f, 47.039f, -27.699f), new Vector3D(60.892f, -98.418f, -2.09f), new Vector3D(80.973f, 91.029f, 2.986f), new Vector3D(40.322f, -47.381f, 42.471f), new Vector3D(-122.74f, 31.736f, 42.496f), new Vector3D(102.951f, 43.652f, 3.501f), new Vector3D(44.149f, 86.846f, 42.198f), new Vector3D(111.018f, -114.842f, -2.09f), new Vector3D(-125.769f, -30.027f, 13.492f), new Vector3D(-15.109f, -45.325f, 42.383f)}, {new Vector3D(-48.992f, 52.064f, -5.625f), new Vector3D(-53.817f, 94.759f, 42.461f), new Vector3D(60.892f, -98.418f, -2.09f), new Vector3D(40.322f, -47.381f, 42.471f), new Vector3D(-80.328f, 51.778f, -6.256f), new Vector3D(44.149f, 86.846f, 42.198f), new Vector3D(-52.76f, -95.814f, -6.279f), new Vector3D(-36.722f, -7.07f, -5.889f), new Vector3D(-15.109f, -45.325f, 42.383f), new Vector3D(138.957f, -35.022f, 3.43f)}}, {{new Vector3D(41.534f, 9.007f, 2.491f), new Vector3D(-0.15f, -18.998f, 36.494f), new Vector3D(-0.15f, -203.668f, 36.791f), new Vector3D(89.895f, -188.462f, 2.126f), new Vector3D(-115.478f, -18.998f, 84.6f), new Vector3D(-64.3f, -166.05f, 88.0f), new Vector3D(18.868f, -142.424f, 0.0f), new Vector3D(7.534f, -77.569f, 36.236f), new Vector3D(-82.088f, -24.907f, 35.977f), new Vector3D(-103.035f, -108.48f, 43.661f)}, {new Vector3D(78.457f, -87.899f, 35.479f), new Vector3D(-0.15f, -18.998f, 36.494f), new Vector3D(-0.15f, -203.668f, 36.791f), new Vector3D(89.895f, -188.462f, 2.126f), new Vector3D(-64.3f, -166.05f, 88.0f), new Vector3D(-73.767f, -159.406f, 4.416f), new Vector3D(7.534f, -77.569f, 36.236f), new Vector3D(-21.227f, -87.474f, 0.0f), new Vector3D(-42.313f, -130.346f, -0.683f), new Vector3D(-21.946f, -35.428f, 0.0f)}, {new Vector3D(-0.15f, -18.998f, 36.494f), new Vector3D(-82.088f, -24.907f, 35.977f), new Vector3D(-15.134f, -87.474f, 0.0f), new Vector3D(-58.632f, 159.82f, 67.664f), new Vector3D(113.739f, 15.889f, 84.789f), new Vector3D(-0.15f, 159.356f, 67.664f), new Vector3D(-95.578f, 51.15f, 0.0f), new Vector3D(-16.404f, 91.329f, 0.0f), new Vector3D(-21.946f, -35.428f, 0.0f), new Vector3D(-0.15f, 68.895f, 35.977f)}}};
    private static final byte[][] DISTRICT_BUILDINGS_TYPES = new byte[][]{{14, 11, 13, 13, 13, 13}, {10, 11, 12, 13, 13, 14}, {10, 10, 11, 12, 13, 13, 14}, {10, 10, 11, 12, 13, 13, 14}};
    private static final byte[] PEOPLE_TO_KILL = new byte[]{1, 1, 1, 1};
    public static final int[][] INNOCENT_IZ = new int[][]{{10, 10, 7, 7}, {10, 20, 10, 14}, {19, 19, 6, 20}, {3, 19, 6, 20}, {17, 38, 9, 27}, {8, 38, 9, 27}};
    public static final int[][] TERRORIST1_IZ = new int[][]{{10, 5, 8, 9}, {9, 13, 12, 18}, {19, 15, 5, 17}, {4, 12, 7, 17}, {14, 31, 10, 28}, {4, 32, 9, 25}};
    public static final int[][] TERRORIST2_IZ = new int[][]{{11, 6, 9, 10}, {7, 15, 13, 16}, {19, 15, 5, 17}, {1, 15, 7, 17}, {13, 32, 7, 32}, {5, 32, 8, 28}};
    public static final int[][] TERRORIST3_IZ = new int[][]{{10, 5, 8, 9}, {9, 13, 12, 18}, {19, 15, 5, 17}, {4, 12, 7, 17}, {14, 31, 10, 28}, {4, 32, 9, 25}};
    public static final int[][] INNOCENTT3_IZ = new int[][]{{13, 15, 2, 2}, {15, 22, 4, 22}, {15, 22, 4, 22}, {15, 22, 4, 22}, {15, 22, 4, 22}, {15, 22, 4, 22}};
    public static final int POINTS_PER_HEAD_HIT = 500;
    public static final int POINTS_PER_TRUNK_HIT = 250;
    public static final int POINTS_PER_ARM_HIT = 100;
    public static final int POINTS_PER_LEG_HIT = 100;
    public static final int POINTS_PER_WEAPON_HIT = 50;
    public static final int POINTS_PER_BOOM = 2000;
    public static final int POINTS_PER_FAIL = -500;
    public static final byte INTRO_STATE_IncomingMessage = 0;
    public static final byte INTRO_STATE_DisplayingIntroInfo = 1;
    public static final byte INTRO_STATE_DisplayingBossInfo = 2;
    public static final byte INTRO_STATE_DisplayingBlueprint = 3;
    public static final byte INTRO_STATE_TransmissionEnds = 4;
    public static final int EXPLOSION_FRAMES = 7;
    public static final int POWERUPS_PER_LEVEL = 3;
    public static final int BULLETS_PER_MAGAZINE = 6;
    public static final int ERROR = -1;
    public static final int OK = 0;
    public static final int UNDEFINED_VALUE = -2;
    public static final float ITEMS_SCALE = 1.0f;
    public static final int[][] HUMANS_IN_SCENE = new int[][]{{2, 2, 2, 2}, {2, 2, 3, 2}, {2, 3, 3, 2}, {3, 3, 4, 2}};
    public static final int[][] ENEMY_TO_KILL = new int[][]{{8, 10, 12, 1}, {14, 16, 18, 1}, {20, 22, 24, 1}, {26, 28, 30, 1}};
    public static final String LAST_GAME = "sniperOps";
    public static final String LANGUAGE_CONF = "sniperOpsLang";
    public static final String STAGERECORD = "sniperOpsRecordStage";
    public static final String STAGEUNLOCK = "sniperOpsUnlock";
    public static final String VOLUMEN = "sniperOpsVolumen";
    public static final char FIELD_SEPARATOR = '#';
    public static long gameTime;
    private SniperMIDlet midlet;
    private LoadingCanvas loadingCanvas;
    private SniperCanvas gameCanvas;
    private static int badShots;
    private static int goodShots;
    private static int headShots;
    private static float accuracy;
    private byte actualSelection = 0;
    private int remainingBullets;
    private int playerLifes;
    private int totalPoints;
    private int remainingExplosions;
    private World scene;
    private SniperGunCamera mobCam;
    private float xImpact;
    private float yImpact;
    private float zImpact;
    private float distanceToTarget;
    private int impactZone;
    private long initIZT;
    private boolean bossStage;
    private boolean armoredVehicleCreated;
    public static int stage;
    public int substage;
    public int terroristNumber;
    public int murders;
    private int badGuysInScene;
    private int bulletXHole;
    private int bulletYHole;
    private boolean stageComplete;
    private boolean gameOver;
    private boolean substageComplete;
    private boolean demoMode;
    private boolean bossExplosions;
    private boolean bulletProovVestActive;
    private boolean specialBullets;
    private boolean immortal;
    private long tLastImpact;
    private boolean processShot;
    private boolean reload;
    private boolean magazineEmpty;
    private boolean needToInitTimes;
    private boolean firstTime;
    private boolean finalBossKilled;
    private int indexPos = -1;
    private int lastFree = -1;
    private boolean[] inUse = new boolean[]{false, false, false, false, false, false, false, false, false, false};
    private ShootableObject[] shootableThings;
    private AdvanceSceneObjectPool shootableThingsPool;
    private AdvanceBB explosion;
    private AdvanceBB weaponExplosion;
    private AdvanceBB sparkBB;
    private AdvanceSceneObject[] traffic;
    private String msgText;
    private long msgInitTime;
    private long msgDuration;
    private boolean renderSpark;
    private boolean updateUpBanner = false;
    private boolean updateDownBanner = false;
    private boolean changeSubstage = false;
    public boolean wait = false;
    public long initWaitTime;
    private boolean bossIntro = false;
    private byte introState;
    private long tIntroState;
    private String info;
    public static Texture2D[][] textureUnits;
    public static Mesh[] bossModel;
    public static final int UP_KEY = 0;
    public static final int DOWN_KEY = 1;
    public static final int LEFT_KEY = 2;
    public static final int RIGHT_KEY = 3;
    public static final int FIRE_KEY = 4;
    public static final int RELOAD_KEY = 5;
    public static final int SCOPE_KEY = 6;
    private boolean[] keys = new boolean[]{false, false, false, false, false, false, false, false};
    int[] centerPos = new int[2];
    private static boolean isStageMeshLoaded;
    private static boolean isCamAdded;
    public static boolean isResourceLoaded;
    public int aimedObjType;
    final int AIMED_OTHERS;
    final int AIMED_HUMAN;
    final int AIMED_ITEM;
    final int AIMED_VEHICLE;

    public GameEngine(SniperMIDlet aMidlet, LoadingCanvas loadCanvas, boolean demo) {
        this.AIMED_OTHERS = -1;
        this.AIMED_HUMAN = 0;
        this.AIMED_ITEM = 1;
        this.AIMED_VEHICLE = 2;
        this.midlet = aMidlet;
        this.loadingCanvas = loadCanvas;
        this.scene = new World();
        this.demoMode = demo;
        if (!SniperMIDlet.isStaticResLoaded) {
            this.loadStaticRes();
            SniperMIDlet.isStaticResLoaded = true;
        }
        if (this.demoMode) {
            this.buildDemoMode(2);
        } else if (SniperMIDlet.playingArcadeMode) {
            this.buildStage(SniperMIDlet.getStageToLoad(), 0, SniperMIDlet.getInitPlayerLife(), SniperMIDlet.getActualPoints());
        } else {
            this.buildStage(SniperMIDlet.getStageToLoad(), 0, 100, 0);
        }
        Input.InitKey();
    }

    public void drawBG2D(Graphics g) {
        float[] pos = new float[4];
        float[] camDir = this.mobCam.getDirection();
        pos[0] = 0.0f;
        pos[1] = 0.0f;
        pos[2] = 350.0f;
        pos[3] = 1.0f;
        this.centerPos = Math3D.point3Dto2D(pos, this.mobCam.getCamera(), this.mobCam.getRotationMatrix());
        int x = this.centerPos[0] % 240;
        int y = this.centerPos[1] % 224;
        g.setColor(82, 106, 182);
        g.fillRect(0, 0, 240, 224);
    }

    public final void pressedKey(int index) {
        if (index >= 0 && index < this.keys.length) {
            this.keys[index] = true;
        }
    }

    public final void setGameCanvas(SniperCanvas aGameCanvas) {
        this.gameCanvas = aGameCanvas;
    }

    public final void releaseKey(int index) {
        if (index >= 0 && index < this.keys.length) {
            this.keys[index] = false;
        }
    }

    public final byte getActualSelection() {
        return this.actualSelection;
    }

    private final void processKeysInPause() {
        if (this.gameCanvas.pauseMenuStatus == 0) {
            if (this.keys[4] || Input.IsKeyPressed(65536)) {
                switch (this.actualSelection) {
                    case 0: {
                        SniperMIDlet.inPause = false;
                        this.gameCanvas.setCanvasMode((byte)3);
                        SniperMIDlet.calculateTimeInPause();
                        break;
                    }
                    case 1: {
                        this.gameCanvas.pauseMenuStatus = 1;
                        break;
                    }
                    case 2: {
                        if (SniperMIDlet.instance.soundEngine.isMusicEnable()) {
                            SniperMIDlet.instance.soundEngine.disableMusic();
                            break;
                        }
                        SniperMIDlet.instance.soundEngine.enableMusic();
                        break;
                    }
                    case 3: {
                        SniperMIDlet.inPause = false;
                        this.gameCanvas.setRunningValue(false);
                        this.saveCurrentGame(stage);
                        this.midlet.setNewMode((short)0);
                        this.midlet.setNextMenuToLoad((short)0);
                        break;
                    }
                    case 4: {
                        SniperMIDlet.inPause = false;
                        this.gameCanvas.pauseMenuStatus = (byte)2;
                        break;
                    }
                }
                this.releaseKey(4);
            } else if (this.keys[0]) {
                this.actualSelection = (byte)(this.actualSelection - 1);
                if (this.actualSelection < 0) {
                    this.actualSelection = (byte)4;
                }
                this.releaseKey(0);
            } else if (this.keys[1]) {
                this.actualSelection = (byte)((this.actualSelection + 1) % 5);
                this.releaseKey(1);
            }
            if (Input.IsKeyPressed(131072)) {
                SniperMIDlet.inPause = false;
                this.gameCanvas.setCanvasMode((byte)3);
                SniperMIDlet.calculateTimeInPause();
            }
        } else if (this.gameCanvas.pauseMenuStatus == 1) {
            if (Input.IsKeyPressed(65536)) {
                this.gameCanvas.pauseMenuStatus = 0;
            } else if (this.keys[0]) {
                if (++this.gameCanvas.helpTextScroll > 0) {
                    this.gameCanvas.helpTextScroll = 0;
                }
            } else if (this.keys[1] && --this.gameCanvas.helpTextScroll < -68) {
                this.gameCanvas.helpTextScroll = -68;
            }
        } else if (this.gameCanvas.pauseMenuStatus == 2) {
            if (Input.IsKeyPressed(131072)) {
                this.gameCanvas.pauseMenuStatus = 0;
            } else if (Input.IsKeyPressed(65536)) {
                this.midlet.exit();
            }
        }
    }

    private final void processKeysDuringTheGame() {
        if (this.keys[6]) {
            if (!this.areWeChangingTheMagazine()) {
                this.setUpdateDownBanner(true);
                this.setUpdateUpBanner(true);
                this.mobCam.switchZoomSate();
            }
            this.releaseKey(6);
        } else if (this.keys[4]) {
            if (this.mobCam.getZoomState() == 2) {
                this.setUpdateDownBanner(true);
                if (!this.isMagazineEmpty()) {
                    this.gameCanvas.resetShootingProcess(gameTime);
                    this.triggerPressed();
                } else {
                    this.setMessageToRender(Resources.getString(26), 1500L);
                }
            } else if (!this.areWeChangingTheMagazine()) {
                this.mobCam.switchZoomSate();
                this.setUpdateDownBanner(true);
                this.setUpdateUpBanner(true);
            }
            this.releaseKey(4);
        } else if (this.keys[5]) {
            if (this.wait || !this.mobCam.weReachFinalPosition() || this.mobCam.areWeChangingTheMagazine()) {
                this.releaseKey(5);
                return;
            }
            this.midlet.soundEngine.playReloadFX();
            if (this.mobCam.isZoomActive()) {
                this.mobCam.switchZoomSate();
            }
            this.setUpdateDownBanner(true);
            this.setUpdateUpBanner(true);
            this.changeMagazine();
        }
        if (Input.IsKeyPressed(65536) && this.mobCam.weReachFinalPosition()) {
            this.gameCanvas.pauseGame();
        }
    }

    public final void processKeys() {
        switch (this.gameCanvas.getActualCanvasMode()) {
            case 0: {
                this.processKeysInPause();
                break;
            }
            case 3: {
                this.processKeysDuringTheGame();
            }
        }
    }

    private final int getActionCode() {
        if (this.keys[0]) {
            return 1;
        }
        if (this.keys[1]) {
            return 6;
        }
        if (this.keys[2]) {
            return 2;
        }
        if (this.keys[3]) {
            return 5;
        }
        return -1;
    }

    private final Texture2D[] makeTextures(Image2D[] ims, int num) {
        Texture2D[] textures = new Texture2D[num];
        for (int i = 0; i < num; ++i) {
            if (ims[i] == null) continue;
            textures[i] = new Texture2D(ims[i]);
            textures[i].setBlending(228);
            textures[i].setWrapping(240, 240);
            textures[i].setFiltering(208, 210);
        }
        return textures;
    }

    private final void loadStaticRes() {
        Image2D image2D = new Image2D(99, 128, 128);
        Resources.stageSceneTexture = new Texture2D(image2D);
        Image2D img = new Image2D(99, 128, 128);
        Resources.skyBoxTexture = new Texture2D(img);
        textureUnits = new Texture2D[13][];
        block15: for (int i = 0; i < textureUnits.length; ++i) {
            switch (i) {
                case 0: {
                    int w = 32;
                    int h = 64;
                    int number = 4;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/innocent.png", number, w, h), number);
                    continue block15;
                }
                case 1: {
                    int w = 32;
                    int h = 64;
                    int number = 9;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/terrorist1.png", number, w, h), number);
                    continue block15;
                }
                case 2: {
                    int w = 32;
                    int h = 64;
                    int number = 8;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/terrorist2.png", number, w, h), number);
                    continue block15;
                }
                case 3: {
                    int w = 32;
                    int h = 64;
                    int number = 12;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/terrorist3.png", number, w, h), number);
                    continue block15;
                }
                case 4: {
                    int w = 64;
                    int h = 64;
                    int number = 7;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/explosion.png", number, w, h), number);
                    continue block15;
                }
                case 5: {
                    int w = 32;
                    int h = 64;
                    int number = 1;
                    continue block15;
                }
                case 6: {
                    int w = 32;
                    int h = 64;
                    int number = 1;
                    continue block15;
                }
                case 7: {
                    int w = 32;
                    int h = 32;
                    int number = 1;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/pwrupLife.png", number, w, h), number);
                    continue block15;
                }
                case 8: {
                    int w = 32;
                    int h = 32;
                    int number = 1;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/pwrupBullets.png", number, w, h), number);
                    continue block15;
                }
                case 10: {
                    int w = 32;
                    int h = 32;
                    int number = 1;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/pwrupBulletProofVest.png", number, w, h), number);
                    continue block15;
                }
                case 9: {
                    int w = 32;
                    int h = 32;
                    int number = 1;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/pwrupBoom.png", number, w, h), number);
                    continue block15;
                }
                case 11: {
                    int w = 16;
                    int h = 16;
                    int number = 3;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/enemyfire.png", number, w, h), number);
                    continue block15;
                }
                case 12: {
                    int w = 16;
                    int h = 16;
                    int number = 3;
                    GameEngine.textureUnits[i] = this.makeTextures(Resources.loadImage2D("/x/sparkTexture.png", number, w, h), number);
                    continue block15;
                }
            }
        }
    }

    private static byte[] convertRGBtoByteArray(int integer) {
        byte[] bytes = new byte[]{(byte)(integer << 8 >> 24), (byte)(integer << 16 >> 24), (byte)(integer << 24 >> 24)};
        return bytes;
    }

    private static byte[] convertRGBtoByteArray(int[] integers) {
        byte[] bytes = new byte[integers.length * 3];
        for (int index = 0; index < integers.length; ++index) {
            byte[] integerBytes = GameEngine.convertRGBtoByteArray(integers[index]);
            bytes[index * 3] = integerBytes[0];
            bytes[1 + index * 3] = integerBytes[1];
            bytes[2 + index * 3] = integerBytes[2];
        }
        return bytes;
    }

    private void setStageTexture(Texture2D tex, String fileName) {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(fileName));
        try {
            Image img = Image.createImage((InputStream)dis);
            int[] buf = new int[img.getWidth() * img.getHeight()];
            img.getRGB(buf, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
            tex.getImage().set(0, 0, img.getWidth(), img.getHeight(), GameEngine.convertRGBtoByteArray(buf));
            dis.close();
        }
        catch (Exception e) {
            try {
                dis.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            System.out.println("Failed to create texture. Error: " + e);
            e.printStackTrace();
        }
    }

    public void saveCurrentGame(int nextStage) {
        if (!SniperMIDlet.playingArcadeMode) {
            return;
        }
        String s = Integer.toString(nextStage) + '#' + Integer.toString(this.playerLifes) + '#' + Integer.toString(this.totalPoints);
        SniperMIDlet.store(LAST_GAME, s);
    }

    public final void saveTheCurrentStageRecord(int stageIndex) {
        String previousStageRecord = SniperMIDlet.load(STAGERECORD + stageIndex);
        if (previousStageRecord.equals("")) {
            this.updateTheCurrentStageRecord(stageIndex);
        } else {
            try {
                PWTokenizer tok = new PWTokenizer(previousStageRecord, '#');
                int prevPoints = Integer.parseInt(tok.nextToken());
                float prevAccuracy = Float.parseFloat(tok.nextToken());
                if (GameEngine.getAccuracy() > prevAccuracy) {
                    this.updateTheCurrentStageRecord(stageIndex);
                }
            }
            catch (Exception e) {
                Console.output("->" + e.toString());
            }
        }
    }

    private final void updateTheCurrentStageRecord(int stageToUpdate) {
        String newRecord = Integer.toString(this.totalPoints) + '#' + Float.toString(GameEngine.getAccuracy());
        SniperMIDlet.store(STAGERECORD + stageToUpdate, newRecord);
    }

    public final boolean isDemoModeActive() {
        return this.demoMode;
    }

    public final boolean haveToUpdateUpBanner() {
        return true;
    }

    public final boolean haveToUpdateDownBanner() {
        return this.updateDownBanner;
    }

    public final void setUpdateUpBanner(boolean aValue) {
        if (aValue) {
            if (!this.updateUpBanner) {
                this.updateUpBanner = aValue;
            }
        } else {
            this.updateUpBanner = aValue;
        }
    }

    public final void setUpdateDownBanner(boolean aValue) {
        if (aValue) {
            if (!this.updateDownBanner) {
                this.updateDownBanner = aValue;
            }
        } else {
            this.updateDownBanner = aValue;
        }
    }

    public final boolean specialBulletsActive() {
        return this.specialBullets || SniperMIDlet.specialBullets;
    }

    public final boolean renderSparks() {
        return this.renderSpark;
    }

    public final void setRenderSparkValues(boolean value) {
        this.renderSpark = value;
    }

    public final boolean bulletProovVestActive() {
        return this.bulletProovVestActive;
    }

    public final void loadStageEnemy() {
        block10: {
            block11: {
                if (stage >= 3) break block10;
                int nMesh = this.getNumberOfMeshes();
                if (nMesh <= 0) break block11;
                bossModel = new Mesh[nMesh];
                switch (stage) {
                    case 0: {
                        int[] meshesId = new int[]{47, 53, 55, 49, 51};
                        for (int i = 0; i < nMesh; ++i) {
                            GameEngine.bossModel[i] = SniperMIDlet.loadComplexModel("/x/mesh_hummer.m3g", meshesId[i]);
                            SniperMIDlet.adjustModelPosition(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, bossModel[i]);
                            SniperMIDlet.setOtherAttributes(false, false, bossModel[i]);
                            this.scene.addChild((Node)bossModel[i]);
                        }
                        break block10;
                    }
                    case 1: {
                        int[] meshesId = new int[]{54, 56, 58, 60, 62, 64};
                        for (int i = 0; i < nMesh; ++i) {
                            GameEngine.bossModel[i] = SniperMIDlet.loadComplexModel("/x/mesh_tank.m3g", meshesId[i]);
                            SniperMIDlet.adjustModelPosition(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, bossModel[i]);
                            SniperMIDlet.setOtherAttributes(false, false, bossModel[i]);
                            this.scene.addChild((Node)bossModel[i]);
                        }
                        break block10;
                    }
                    case 2: {
                        int[] meshesId = new int[]{54, 60, 58, 56, 62, 64};
                        for (int i = 0; i < nMesh; ++i) {
                            GameEngine.bossModel[i] = SniperMIDlet.loadComplexModel("/x/mesh_hovercraft2.m3g", meshesId[i]);
                            SniperMIDlet.adjustModelPosition(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, bossModel[i]);
                            SniperMIDlet.setOtherAttributes(false, false, bossModel[i]);
                            this.scene.addChild((Node)bossModel[i]);
                        }
                        break block10;
                    }
                    case 3: {
                        int[] meshesId = new int[]{54, 56, 58, 60, 62, 64};
                        for (int i = 0; i < nMesh; ++i) {
                            GameEngine.bossModel[i] = SniperMIDlet.loadComplexModel("/x/mesh_robot.m3g", meshesId[i]);
                            SniperMIDlet.adjustModelPosition(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, bossModel[i]);
                            SniperMIDlet.setOtherAttributes(false, false, bossModel[i]);
                            this.scene.addChild((Node)bossModel[i]);
                        }
                        break block10;
                    }
                }
                break block10;
            }
            return;
        }
    }

    private final int getNumberOfMeshes() {
        switch (stage) {
            case 0: {
                return 5;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 6;
            }
        }
        return 0;
    }

    private final void createExplosionBillBoards() {
        this.explosion = new AdvanceBB(textureUnits[4], this.mobCam.getCameraGroup(), 15.0f, 1.0f, false);
        this.scene.addChild((Node)this.explosion.getAdvanceBBMesh());
        this.resetExplosionBillBoards();
    }

    private final void resetExplosionBillBoards() {
        this.explosion.setVisible(false);
        this.explosion.setAnimationToPlay(0, 7, false, 50);
    }

    private final void createWeaponExplosionBillboard() {
        this.weaponExplosion = new AdvanceBB(textureUnits[4], this.mobCam.getCameraGroup(), 15.0f, 1.0f, false);
        this.scene.addChild((Node)this.weaponExplosion.getAdvanceBBMesh());
        this.resetWeaponExplosionBillboard();
    }

    private final void resetWeaponExplosionBillboard() {
        this.weaponExplosion.setVisible(false);
        this.weaponExplosion.setAnimationToPlay(0, 7, false, 50);
    }

    private final void createSparkBillboard() {
        this.sparkBB = new AdvanceBB(textureUnits[12], this.mobCam.getCameraGroup(), 3.0f, 1.0f, false);
        this.scene.addChild((Node)this.sparkBB.getAdvanceBBMesh());
        this.resetSparkBillboard();
    }

    private final void resetSparkBillboard() {
        this.sparkBB.setVisible(false);
        this.sparkBB.setAnimationToPlay(0, 3, false, 50);
    }

    public final void generateBulletHolePositions() {
        int angle = Math3D.getRandNumber(0, 359);
        int r = Math3D.getRandNumber(0, 30);
        this.bulletXHole = (int)(Math.cos(Math.toRadians(angle)) * (double)r + 120.0);
        this.bulletYHole = (int)(Math.sin(Math.toRadians(angle)) * (double)r + 112.0);
    }

    public final int getBulletHoleXPos() {
        return this.bulletXHole;
    }

    public final int getBulletHoleYPos() {
        return this.bulletYHole;
    }

    public void reserveMemory() {
        int count = HUMANS_IN_SCENE[stage][this.substage];
        this.shootableThings = new ShootableObject[count];
        for (int i = 0; i < count; ++i) {
            this.shootableThings[i] = new ShootableObject(i, this);
        }
        this.shootableThingsPool = new AdvanceSceneObjectPool(this.shootableThings);
    }

    public final boolean amIImmortal() {
        return this.immortal;
    }

    public final void shutdown() {
        ShootableObject aux;
        this.mobCam = null;
        this.shootableThings = null;
        bossModel = null;
        this.weaponExplosion = null;
        this.sparkBB = null;
        this.traffic = null;
        this.scene = null;
        this.msgText = null;
        this.info = null;
        this.midlet = null;
        this.loadingCanvas = null;
        this.gameCanvas = null;
        for (aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            aux.dropElement();
        }
        this.shootableThingsPool = null;
        aux = null;
        SniperMIDlet.cleanMemory();
    }

    private final int determineImpactZone(float x, float y, float width, float height, float xLC, float yLC, int humanSubcategory, int index) {
        int i;
        int[][] impactZones2;
        float absX = Math.abs(x - xLC);
        float absY = Math.abs(yLC - y);
        int impactX = (int)(absX * 32.0f / width);
        int impactY = (int)(absY * 64.0f / height);
        switch (humanSubcategory) {
            case 50: {
                impactZones2 = INNOCENT_IZ;
                break;
            }
            case 51: {
                impactZones2 = TERRORIST1_IZ;
                break;
            }
            case 52: {
                impactZones2 = TERRORIST2_IZ;
                break;
            }
            case 53: {
                impactZones2 = TERRORIST3_IZ;
                break;
            }
            default: {
                int[][] impactZones2 = null;
                return -1;
            }
        }
        if (this.shootableThings[index].isHostageAlive() && humanSubcategory == 53) {
            for (i = 0; i < 6; ++i) {
                if (!GameEngine.isIntersectingRec(impactX, impactY, 1, 1, INNOCENTT3_IZ[i][0], INNOCENTT3_IZ[i][1], INNOCENTT3_IZ[i][2], INNOCENTT3_IZ[i][3])) continue;
                return i + 10;
            }
        }
        for (i = 0; i < 6; ++i) {
            if (!GameEngine.isIntersectingRec(impactX, impactY, 1, 1, impactZones2[i][0], impactZones2[i][1], impactZones2[i][2], impactZones2[i][3])) continue;
            return i;
        }
        return -1;
    }

    public final boolean weNeedToInitTimes() {
        return this.needToInitTimes;
    }

    public final void setNeedToInitTimes(boolean value) {
        this.needToInitTimes = value;
    }

    public final boolean renderImpactZone() {
        if (gameTime - this.initIZT >= 1500L) {
            this.updateDownBanner = true;
            return false;
        }
        return true;
    }

    public final boolean changingCameraUbication() {
        return !this.mobCam.weReachFinalPosition();
    }

    public final int getImpactZone() {
        return this.impactZone;
    }

    private final void setIZRenderingInitTime() {
        this.initIZT = gameTime;
    }

    public final float[] calculateBreatheConstants() {
        float[] constants = new float[2];
        float coef = (float)this.playerLifes * 1.0f / 100.0f;
        constants[0] = Math3D.linearInterpolation(2000.0f, 2000.0f, coef);
        constants[1] = Math3D.linearInterpolation(0.05f, 0.05f, coef);
        return constants;
    }

    public void buildStage(int actualStage, int actualSubstage, int playerLife, int points) {
        this.resetStageInfo(actualStage, actualSubstage, playerLife, points);
        this.loadingCanvas.udpateActualStep();
        this.addSkybox((Group)this.scene);
        this.loadingCanvas.udpateActualStep();
        this.addCamera();
        this.loadingCanvas.udpateActualStep();
        this.reserveMemory();
        this.loadingCanvas.udpateActualStep();
        this.loadingCanvas.udpateActualStep();
        this.loadingCanvas.udpateActualStep();
        this.setStageTexture(Resources.stageSceneTexture, "/x/00" + (stage / 2 + 1) + ".png");
        this.getCameraAndBuildings((Group)this.scene, "/x/mesh_level_" + (actualStage + 1) + ".m3g");
        this.loadingCanvas.udpateActualStep();
        this.loadingCanvas.udpateActualStep();
        this.loadSpecialEffectsBillBoards();
        System.gc();
    }

    private void loadSpecialEffectsBillBoards() {
        this.createExplosionBillBoards();
        this.createWeaponExplosionBillboard();
        this.createSparkBillboard();
    }

    public final void buildDemoMode(int demoStage) {
        this.resetStageInfo(demoStage, 0, 0, 0);
        this.loadingCanvas.udpateActualStep();
        this.loadingCanvas.udpateActualStep();
        this.addSkyBox();
        this.loadingCanvas.udpateActualStep();
        this.loadingCanvas.udpateActualStep();
        this.addCamera();
        this.loadingCanvas.udpateActualStep();
        this.reserveMemory();
        this.addSkybox(null);
        this.loadingCanvas.udpateActualStep();
        this.loadingCanvas.udpateActualStep();
        this.loadingCanvas.udpateActualStep();
    }

    private void resetStageInfo(int actualstage, int sublevel, int life, int points) {
        this.playerLifes = life;
        this.totalPoints = 0;
        stage = actualstage;
        this.remainingExplosions = 2;
        this.substage = sublevel;
        this.indexPos = -1;
        this.stageComplete = false;
        this.gameOver = false;
        this.bossStage = false;
        this.firstTime = true;
        this.immortal = false;
        this.needToInitTimes = true;
        this.bulletProovVestActive = false;
        this.armoredVehicleCreated = false;
        this.finalBossKilled = false;
        this.bossExplosions = false;
        this.bossIntro = false;
        this.remainingBullets = 6;
        this.resetAccuracyVariables();
        this.resetSubstageInfo();
    }

    private final void resetSubstageInfo() {
        this.terroristNumber = ENEMY_TO_KILL[stage][this.substage];
        this.murders = 0;
        this.badGuysInScene = 0;
        this.changeSubstage = false;
        this.wait = false;
    }

    public final String getInfo() {
        return this.info;
    }

    private final void updateIntroState() {
        long tElapsed = gameTime - this.tIntroState;
        switch (this.introState) {
            case 0: {
                if (tElapsed <= 3000L) break;
                this.tIntroState = gameTime;
                this.introState = 1;
                this.info = Resources.getString(78);
                break;
            }
            case 1: {
                if (tElapsed <= 3000L) break;
                this.tIntroState = gameTime;
                this.introState = (byte)2;
                this.info = Resources.getString(74 + stage);
                break;
            }
            case 2: {
                if (tElapsed <= 6000L) break;
                this.tIntroState = gameTime;
                this.introState = (byte)3;
                this.info = null;
                break;
            }
            case 3: {
                if (tElapsed <= 3000L) break;
                this.tIntroState = gameTime;
                this.introState = (byte)4;
                this.setMessageToRender(Resources.getString(80), 3000L);
                break;
            }
            case 4: {
                if (tElapsed <= 3000L) break;
                this.bossIntro = false;
            }
        }
    }

    public final boolean isBossIntro() {
        return this.bossIntro;
    }

    public final byte getIntroState() {
        return this.introState;
    }

    public final boolean isBoosStage() {
        return this.bossStage;
    }

    private final void updateTheStage() {
        if (this.substage < 3) {
            if (this.mobCam.isZoomActive()) {
                this.mobCam.switchZoomSate();
            }
            this.mobCam.resetTravellingAttributes();
            this.mobCam.setCameraPath(stage, this.substage - 1);
            this.resetSubstageInfo();
            this.updateUpBanner = true;
            this.updateDownBanner = true;
        } else if (this.substage == 3) {
            this.mobCam.disableZoom();
            this.saveTheCurrentStageRecord(stage);
            int nextStage = (stage + 1) % 4;
            if (SniperMIDlet.playingArcadeMode) {
                SniperMIDlet.setStageToLoad(nextStage);
                SniperMIDlet.updatePlayerLife(this.playerLifes);
                SniperMIDlet.updatePlayerPoints(this.totalPoints);
                if (nextStage == 0) {
                    String s = Integer.toString(nextStage) + '#' + Integer.toString(100) + '#' + Integer.toString(0);
                    SniperMIDlet.store(LAST_GAME, s);
                } else {
                    this.saveCurrentGame(nextStage);
                }
                SniperMIDlet.updateTheNumberOfUnlockedStages();
            }
            this.setMessageToRender(Resources.getString(30), this.msgDuration);
            this.stageComplete = true;
            this.updateUpBanner = true;
            this.updateDownBanner = true;
        }
        Console.output("updateTheStage()");
    }

    private final void incrementMurders() {
        if (!this.wait && this.mobCam.weReachFinalPosition() && !this.changeSubstage) {
            ++this.murders;
            this.updateBadGuysInScene(-1);
        }
    }

    public final boolean isStageComplete() {
        return this.stageComplete;
    }

    public final boolean isGameOver() {
        return this.gameOver;
    }

    public final boolean isMagazineEmpty() {
        return this.magazineEmpty;
    }

    public void resetAccuracyVariables() {
        badShots = 0;
        goodShots = 0;
        headShots = 0;
        accuracy = 0.0f;
    }

    public final void updateBadShots() {
        ++badShots;
    }

    public final void updateGoodShots() {
        ++goodShots;
    }

    public final void updateNumberOfHeadShots() {
        ++headShots;
    }

    public final void calculateAccuracy() {
        accuracy = (float)goodShots * 1.0f / ((float)(goodShots + badShots) * 1.0f) * 100.0f;
    }

    public void incrementTotalPoints(int anAmount) {
        this.totalPoints += anAmount;
        if (this.totalPoints < 0) {
            this.totalPoints = 0;
        }
        this.setUpdateUpBanner(true);
    }

    public final World getWorld() {
        return this.scene;
    }

    public final int getBulletsInsideMagazine() {
        return this.remainingBullets;
    }

    public final int getTotalPoints() {
        return this.totalPoints;
    }

    public final int getPlayerLife() {
        return this.playerLifes;
    }

    private final void moveTraffic() {
        if (!this.bossStage) {
            // empty if block
        }
    }

    private final void removeTraffic() {
        for (int i = 0; i < 2; ++i) {
            this.traffic[i].removeTrafficFromScene();
        }
        this.traffic = null;
    }

    public final String getMessageToRender() {
        long elapsedTime = gameTime - this.msgInitTime;
        if (elapsedTime <= this.msgDuration) {
            return this.msgText;
        }
        return null;
    }

    public void setMessageToRender(String msg, long duration) {
        this.msgInitTime = gameTime;
        this.msgDuration = duration;
        this.msgText = msg;
    }

    public SniperGunCamera getCamera() {
        return this.mobCam;
    }

    private void addCamera() {
        this.mobCam = new SniperGunCamera(240, 224, stage, this.substage, this.demoMode);
        this.scene.addChild((Node)this.mobCam.getCameraGroup());
        this.scene.setActiveCamera(this.mobCam.getCamera());
    }

    private final void addSkybox(Group group) {
        this.skyBox = this.getMesh("/x/skybox.m3g", 16);
        this.skyBox.postRotate(-90.0f, 1.0f, 0.0f, 0.0f);
        this.setStageTexture(Resources.skyBoxTexture, "/x/yg2.png");
        this.skyBox.getAppearance(0).setTexture(0, Resources.skyBoxTexture);
        this.skyBox.getAppearance(0).getCompositingMode().setBlending(68);
        this.skyBox.getAppearance(0).getCompositingMode().setAlphaWriteEnable(false);
        group.addChild((Node)this.skyBox);
        Light li = new Light();
        li.setMode(128);
        li.setIntensity(1.0f);
        li.setColor(-1);
        group.addChild((Node)li);
        System.gc();
    }

    public void getCameraAndBuildings(Group group, String worldFile) {
        Object3D[] objects = null;
        try {
            objects = Loader.load((String)worldFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int j = objects.length - 1; j >= 0; --j) {
            if (!(objects[j] instanceof World)) continue;
            for (int bi = 0; bi < ((World)objects[j]).getChildCount(); ++bi) {
                Appearance app;
                int i;
                Node obj = ((World)objects[j]).getChild(bi);
                if (obj instanceof Mesh) {
                    i = 0;
                    try {
                        while (true) {
                            if ((app = ((Mesh)obj).getAppearance(i++)) == null) {
                                continue;
                            }
                            PolygonMode plgmode = app.getPolygonMode();
                            plgmode.setPerspectiveCorrectionEnable(true);
                            plgmode.setCulling(160);
                            app.getCompositingMode().setBlending(68);
                            app.setTexture(0, Resources.stageSceneTexture);
                        }
                    }
                    catch (Exception e) {
                        Mesh mesh = (Mesh)obj.duplicate();
                        group.addChild((Node)mesh);
                        continue;
                    }
                }
                if (!(obj instanceof Group)) continue;
                i = 0;
                try {
                    while (true) {
                        if ((app = ((Mesh)((Group)obj).getChild(0)).getAppearance(i++)) == null) {
                            continue;
                        }
                        PolygonMode plgmode = app.getPolygonMode();
                        plgmode.setPerspectiveCorrectionEnable(true);
                        plgmode.setCulling(160);
                        app.getCompositingMode().setBlending(68);
                        app.setTexture(0, Resources.stageSceneTexture);
                    }
                }
                catch (Exception e) {
                    Group newGroup = (Group)obj.duplicate();
                    group.addChild((Node)newGroup);
                }
            }
        }
    }

    public Mesh getMesh(String fileName, int meshID) {
        Object3D[] objects = null;
        try {
            objects = Loader.load((String)fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int j = objects.length - 1; j >= 0; --j) {
            if (!(objects[j] instanceof World)) continue;
            Object3D obj = ((World)objects[j]).find(meshID);
            if (obj instanceof Mesh) {
                return (Mesh)obj.duplicate();
            }
            return null;
        }
        return null;
    }

    private void addSkyBox() {
    }

    private final void processShot(SniperGunCamera mobCam) {
        mobCam.beginShock();
        RayIntersection ri = new RayIntersection();
        float[] camPos = mobCam.getPosition();
        float[] camDir = mobCam.getDirection();
        if (this.scene.pick(-1, camPos[0], camPos[1], camPos[2], camDir[0], camDir[1], camDir[2], ri)) {
            this.checkBulletImpact(ri);
        }
    }

    public int checkIfAimed(SniperGunCamera mobCam) {
        float[] camDir;
        RayIntersection ri = new RayIntersection();
        float[] camPos = mobCam.getPosition();
        if (this.scene.pick(-1, camPos[0], camPos[1], camPos[2], (camDir = mobCam.getDirection())[0], camDir[1], camDir[2], ri)) {
            return this.aimedObjType(ri);
        }
        return -1;
    }

    private final void updateNumberOfLifes(int anAmount) {
        this.setUpdateUpBanner(true);
        this.playerLifes += anAmount;
        if (this.playerLifes <= 0) {
            if (this.mobCam.isZoomActive()) {
                this.mobCam.disableZoom();
            }
            this.gameOver = true;
        }
    }

    private final void reloadMagazine() {
        this.remainingBullets = 6;
        if (this.specialBullets) {
            this.specialBullets = false;
        }
        this.magazineEmpty = false;
        this.setUpdateDownBanner(true);
    }

    private void updateRemainigBullets() {
        if (!SniperMIDlet.unlimitedAmmo) {
            if (this.remainingBullets > 0) {
                --this.remainingBullets;
            }
            if (this.remainingBullets == 0) {
                if (SniperMIDlet.autoReload) {
                    this.remainingBullets = 6;
                } else {
                    this.magazineEmpty = true;
                    if (this.specialBullets && !SniperMIDlet.specialBullets) {
                        this.specialBullets = false;
                    }
                }
            } else {
                this.magazineEmpty = false;
            }
            this.setUpdateUpBanner(true);
        }
    }

    public void changeMagazine() {
        this.reload = true;
        this.mobCam.isTimeToDuck();
    }

    public final void configureExplosions(ShootableObject aux) {
        this.explosion.setPosition(aux.getPos().getX(), aux.getPos().getY(), aux.getPos().getZ());
        this.explosion.setVisible(true);
        this.explosion.validateAnimation(true);
        this.bossExplosions = true;
    }

    public boolean areWeChangingTheMagazine() {
        return this.mobCam.areWeChangingTheMagazine();
    }

    public final int getWallXCoordinate() {
        return 0;
    }

    public final int getWallYCoordinate() {
        int y = 0;
        int offset_y = 44;
        if (this.mobCam.areWeDucking()) {
            int initPos = 272;
            int finalPos = 48 + offset_y;
            y = initPos + (int)(this.mobCam.getWallCoef() * (float)(finalPos - initPos));
        } else if (this.mobCam.areWeRising()) {
            int finalPos = 272;
            int initPos = 48 + offset_y;
            y = initPos + (int)(this.mobCam.getWallCoef() * (float)(finalPos - initPos));
        } else if (this.mobCam.areWeCovered()) {
            int finalPos = 48 + offset_y;
            int initPos = 48 + offset_y;
            y = initPos + (int)(this.mobCam.getWallCoef() * (float)(finalPos - initPos));
        }
        return y;
    }

    public void triggerPressed() {
        this.processShot = true;
    }

    private final int generateMortalObjectUbication() {
        int nPositions = this.inUse.length;
        this.indexPos = Math3D.getRandNumber(0, nPositions - 1);
        while (this.inUse[this.indexPos] || nPositions != HUMANS_IN_SCENE[stage][this.substage] && this.lastFree == this.indexPos) {
            this.indexPos = Math3D.getRandNumber(0, nPositions - 1);
        }
        this.inUse[this.indexPos] = true;
        return this.indexPos;
    }

    private final int determineObjectCategory() {
        int n = Math3D.getRandNumber(1, 10);
        int objectType = n <= 2 ? 2 : 1;
        return objectType;
    }

    private final int determineObjectSubcategory(int category) {
        switch (category) {
            case 1: {
                return Math3D.getRandNumber(50, 53);
            }
            case 2: {
                return Math3D.getRandNumber(60, 63);
            }
        }
        return -1;
    }

    private final boolean isATerrorist(int type, int subtype) {
        if (type == 1) {
            switch (subtype) {
                case 51: 
                case 52: 
                case 53: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static void convertCoords() {
        for (int stageId = 0; stageId < DISTRICT_SOBJ_UBICATION.length; ++stageId) {
            for (int subStageId = 0; subStageId < DISTRICT_SOBJ_UBICATION[stageId].length; ++subStageId) {
                for (int i = 0; i < DISTRICT_SOBJ_UBICATION[stageId][subStageId].length; ++i) {
                    float old_y = DISTRICT_SOBJ_UBICATION[stageId][subStageId][i].getY();
                    float old_z = DISTRICT_SOBJ_UBICATION[stageId][subStageId][i].getZ();
                    DISTRICT_SOBJ_UBICATION[stageId][subStageId][i].setY(old_z);
                    DISTRICT_SOBJ_UBICATION[stageId][subStageId][i].setZ(-old_y);
                }
            }
        }
    }

    private final void updateBadGuysInScene(int increment) {
        this.badGuysInScene += increment;
        if (this.badGuysInScene < 0) {
            this.badGuysInScene = 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void addShootableObjectToScene() {
        ShootableObject aux = this.getShootableObjectFromPool();
        while (aux != null) {
            if (this.bossStage) {
                if (this.armoredVehicleCreated) return;
                aux.initShootableObject(3, 30 + stage, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this.mobCam.getCameraGroup(), this.scene, 0);
                aux.setTrafficMovementAttributes(AdvanceSceneObject.FINALBOSSESPATH[stage], CYCLE[stage]);
                aux.initWeaponsTimes(gameTime);
                if (stage == 2) {
                    aux.setSpecialRoute(true);
                } else {
                    aux.setSpecialRoute(false);
                }
                this.armoredVehicleCreated = true;
                return;
            }
            int index = this.generateMortalObjectUbication();
            Vector3D position = DISTRICT_SOBJ_UBICATION[stage][this.substage][index];
            int category = this.determineObjectCategory();
            float yOffset = category == 2 ? 1.5f : 0.0f;
            int subcategory = this.determineObjectSubcategory(category);
            if (this.firstTime) {
                aux.initShootableObject(category, subcategory, position.getX(), position.getY() + yOffset, position.getZ(), 1.0f, 0.0f, this.mobCam.getCameraGroup(), this.scene, index);
                aux.initTimes(gameTime);
                if (this.isATerrorist(category, subcategory)) {
                    this.updateBadGuysInScene(1);
                }
            } else if (this.isATerrorist(category, subcategory)) {
                if (!this.checkEnemyNum()) return;
                aux.initShootableObject(category, subcategory, position.getX(), position.getY() + yOffset, position.getZ(), 1.0f, 0.0f, this.mobCam.getCameraGroup(), this.scene, index);
                aux.initTimes(gameTime);
                this.updateBadGuysInScene(1);
            } else {
                aux.initShootableObject(category, subcategory, position.getX(), position.getY() + yOffset, position.getZ(), 1.0f, 0.0f, this.mobCam.getCameraGroup(), this.scene, index);
                aux.initTimes(gameTime);
            }
            aux.setPositionIndex(index);
            aux = this.getShootableObjectFromPool();
        }
        if (!this.firstTime) return;
        this.firstTime = false;
    }

    public final void removeCorpses() {
        for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            int index;
            if (aux.isAlive()) continue;
            this.lastFree = index = aux.getPositionIndex();
            this.inUse[index] = false;
            aux.removeObjectFromScene();
            switch (aux.getObjectCategory()) {
                case 1: 
                case 2: {
                    aux.desactivateBillBoard();
                    break;
                }
            }
            this.releaseShootableObject(aux);
        }
    }

    public final void updateSceneElements() {
        if (!this.stageComplete) {
            this.removeCorpses();
            if (this.checkEnemyNum() && !this.wait && this.mobCam.weReachFinalPosition() && !this.changeSubstage) {
                this.addShootableObjectToScene();
            }
            this.updateShootableSceneObjects();
            if (this.bossStage && !this.finalBossKilled) {
                this.moveShootableObjects();
            }
            this.updateAnimations();
        } else {
            this.setMessageToRender(Resources.getString(30), 1500L);
        }
    }

    private boolean checkEnemyNum() {
        return this.badGuysInScene < this.terroristNumber - this.murders;
    }

    private final void updateAnimations() {
        block9: for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            block0 : switch (aux.getObjectCategory()) {
                case 1: {
                    aux.getAnimatedBillboard().update(gameTime);
                    if (!aux.getAnimatedBillboard().animationEnd()) continue block9;
                    switch (aux.getAnimationState()) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            break block0;
                        }
                        case 2: {
                            aux.initShootingAnimation();
                            break block0;
                        }
                        case 3: {
                            aux.setDyingValue(true);
                        }
                    }
                }
            }
        }
    }

    private final void moveShootableObjects() {
        block3: for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            switch (aux.getObjectCategory()) {
                case 3: {
                    aux.move();
                    continue block3;
                }
            }
        }
    }

    private final void updateShootableSceneObjects() {
        long elapsedTime;
        for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            if (!aux.updateShootableObject(this.mobCam.getCamera(), this.mobCam.getRotationMatrix())) continue;
            if (!(this.immortal || this.areWeChangingTheMagazine() || this.bulletProovVestActive || SniperMIDlet.godMode)) {
                this.updateNumberOfLifes(-Math3D.getRandNumber(7, 12));
                this.generateBulletHolePositions();
                this.tLastImpact = gameTime;
                this.immortal = true;
                continue;
            }
            if (!this.bulletProovVestActive || this.areWeChangingTheMagazine()) continue;
            this.setMessageToRender(Resources.getString(64), 1500L);
            this.bulletProovVestActive = false;
            this.updateUpBanner = true;
        }
        if (this.immortal && (elapsedTime = gameTime - this.tLastImpact) > 2000L) {
            this.immortal = false;
        }
    }

    public final void renderWarningHUDS(Graphics g) {
        boolean zoomOn = this.mobCam.isZoomActive();
        for (ShootableObject aShootableObject = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aShootableObject != null; aShootableObject = (ShootableObject)aShootableObject.getNextLinked()) {
            aShootableObject.renderWarningMarks(g, this.mobCam.getCamera(), this.mobCam.getRotationMatrix(), zoomOn);
        }
    }

    private final void totalDestrucction(float xPos, float yPos, float zPos) {
        this.explosion.setPosition(xPos, yPos, zPos);
        this.explosion.setVisible(true);
        this.explosion.validateAnimation(true);
        for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            if (!aux.isAnEnemy()) continue;
            aux.kill();
            this.incrementMurders();
            this.incrementTotalPoints(100);
        }
    }

    private final void cleanShootableObjectPool() {
        for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            if (!aux.isAnEnemy()) continue;
            aux.kill();
            if (aux.getObjectCategory() != 3) continue;
            aux.removeFinalBossFromScene();
        }
    }

    private final void updateExplosions() {
        this.explosion.update(GameEngine.getGameTime());
        if (this.explosion.animationEnd()) {
            if (this.finalBossKilled && this.bossExplosions) {
                if (this.remainingExplosions > 0) {
                    this.explosion.setVisible(true);
                    --this.remainingExplosions;
                } else {
                    this.bossExplosions = false;
                    this.explosion.setVisible(false);
                    this.explosion.setAnimationToPlay(0, 7, false, 100);
                    this.cleanShootableObjectPool();
                }
            } else {
                this.explosion.setVisible(false);
                this.explosion.setAnimationToPlay(0, 7, false, 100);
            }
        }
    }

    private final void updateWeaponExplosions() {
        this.weaponExplosion.update(gameTime);
        if (this.weaponExplosion.animationEnd()) {
            this.weaponExplosion.setVisible(false);
        }
    }

    private final void updateSparks() {
        this.sparkBB.update(gameTime);
        if (this.sparkBB.animationEnd()) {
            this.sparkBB.setVisible(false);
        }
    }

    private final void activatePowerUp(int typeOfPowerUp, float xpos, float ypos, float zpos) {
        this.setUpdateDownBanner(true);
        switch (typeOfPowerUp) {
            case 61: {
                this.setMessageToRender(Resources.getString(60), 1500L);
                this.totalDestrucction(xpos, ypos, zpos);
                break;
            }
            case 62: {
                this.bulletProovVestActive = true;
                this.setMessageToRender(Resources.getString(63), 1500L);
                break;
            }
            case 60: {
                this.setMessageToRender(Resources.getString(62), 1500L);
                this.updateNumberOfLifes(20);
                break;
            }
            case 63: {
                this.specialBullets = true;
                this.remainingBullets = 6;
                this.setMessageToRender(Resources.getString(61), 1500L);
                break;
            }
        }
    }

    public int aimedObjType(RayIntersection ri) {
        float[] pos = new float[4];
        Node node = ri.getIntersected();
        boolean isAlive = true;
        if (node instanceof Mesh) {
            Mesh m = (Mesh)node;
            Object aux = node.getUserObject();
            this.distanceToTarget = ri.getDistance();
            float[] camPos = this.mobCam.getPosition();
            float[] camDir = this.mobCam.getDirection();
            this.xImpact = camPos[0] + camDir[0] * this.distanceToTarget;
            this.yImpact = camPos[1] + camDir[1] * this.distanceToTarget;
            this.zImpact = camPos[2] + camDir[2] * this.distanceToTarget;
            if (aux instanceof HumanInfo) {
                return 0;
            }
            if (aux instanceof PowerUpInfo) {
                return 1;
            }
            if (aux instanceof AVPartInfo) {
                return 2;
            }
            return -1;
        }
        return -1;
    }

    private final void checkBulletImpact(RayIntersection ri) {
        float[] pos = new float[4];
        Node node = ri.getIntersected();
        boolean isAlive = true;
        if (node instanceof Mesh) {
            Mesh m = (Mesh)node;
            Object aux = node.getUserObject();
            this.distanceToTarget = ri.getDistance();
            float[] camPos = this.mobCam.getPosition();
            float[] camDir = this.mobCam.getDirection();
            this.xImpact = camPos[0] + camDir[0] * this.distanceToTarget;
            this.yImpact = camPos[1] + camDir[1] * this.distanceToTarget;
            this.zImpact = camPos[2] + camDir[2] * this.distanceToTarget;
            if (aux instanceof HumanInfo) {
                HumanInfo hInfo = (HumanInfo)aux;
                int objectId = hInfo.getId();
                float h = Math.abs(this.shootableThings[objectId].getBoundingBox(0).getMax().getY() - this.shootableThings[objectId].getBoundingBox(0).getMin().getY());
                float w = Math.abs(this.shootableThings[objectId].getBoundingBox(0).getMax().getX() - this.shootableThings[objectId].getBoundingBox(0).getMin().getX());
                float xLC = this.shootableThings[objectId].getBoundingBox(0).getMin().getX();
                float yLC = this.shootableThings[objectId].getBoundingBox(0).getMax().getY();
                int humanZone = this.determineImpactZone(this.xImpact, this.yImpact, w, h, xLC, yLC, this.shootableThings[objectId].getObjectSubCategory(), objectId);
                if (this.shootableThings[objectId].getAnimationState() != 3) {
                    if (this.shootableThings[objectId].isAnEnemy()) {
                        switch (humanZone) {
                            case 0: {
                                this.impactZone = humanZone;
                                this.incrementTotalPoints(500);
                                this.updateNumberOfHeadShots();
                                isAlive = this.specialBullets || SniperMIDlet.specialBullets ? false : hInfo.updateLife(this.impactZone);
                                this.setMessageToRender(Resources.getString(27), 1500L);
                                this.setIZRenderingInitTime();
                                this.updateGoodShots();
                                break;
                            }
                            case 1: {
                                this.impactZone = humanZone;
                                this.incrementTotalPoints(250);
                                isAlive = this.specialBullets || SniperMIDlet.specialBullets ? false : hInfo.updateLife(this.impactZone);
                                this.setMessageToRender("250", 1500L);
                                this.setIZRenderingInitTime();
                                this.updateGoodShots();
                                break;
                            }
                            case 2: {
                                this.impactZone = humanZone;
                                this.incrementTotalPoints(100);
                                isAlive = this.specialBullets || SniperMIDlet.specialBullets ? false : hInfo.updateLife(this.impactZone);
                                this.setMessageToRender("100", 1500L);
                                this.setIZRenderingInitTime();
                                this.updateGoodShots();
                                break;
                            }
                            case 3: {
                                this.impactZone = humanZone;
                                this.incrementTotalPoints(100);
                                isAlive = this.specialBullets || SniperMIDlet.specialBullets ? false : hInfo.updateLife(this.impactZone);
                                this.setMessageToRender("100", 1500L);
                                this.setIZRenderingInitTime();
                                this.updateGoodShots();
                                break;
                            }
                            case 4: {
                                this.impactZone = humanZone;
                                this.incrementTotalPoints(100);
                                isAlive = this.specialBullets || SniperMIDlet.specialBullets ? false : hInfo.updateLife(this.impactZone);
                                this.setMessageToRender("100", 1500L);
                                this.setIZRenderingInitTime();
                                this.updateGoodShots();
                                break;
                            }
                            case 5: {
                                this.impactZone = humanZone;
                                this.incrementTotalPoints(100);
                                isAlive = this.specialBullets || SniperMIDlet.specialBullets ? false : hInfo.updateLife(this.impactZone);
                                this.setMessageToRender("100", 1500L);
                                this.setIZRenderingInitTime();
                                this.updateGoodShots();
                                break;
                            }
                            default: {
                                if (humanZone >= 10) {
                                    isAlive = true;
                                    this.shootableThings[objectId].setHostageAlive(false);
                                    this.incrementTotalPoints(-500);
                                    this.setMessageToRender(Resources.getString(72), 1500L);
                                    this.shootableThings[objectId].getAnimatedBillboard().setFrameToShow(4);
                                } else {
                                    isAlive = true;
                                }
                                this.updateBadShots();
                            }
                        }
                        if (!isAlive) {
                            if (this.shootableThings[objectId].getAnimationState() != 3) {
                                this.shootableThings[objectId].initDyingAnimation();
                                this.incrementMurders();
                            }
                        } else if (this.shootableThings[objectId].getObjectSubCategory() == 52 && humanZone >= 0 && humanZone <= 5) {
                            this.shootableThings[objectId].initImpactAnimation();
                            this.activateSparkSequence(this.xImpact, this.yImpact, this.zImpact);
                        }
                    } else {
                        isAlive = false;
                        this.updateBadShots();
                        this.incrementTotalPoints(-500);
                        this.setMessageToRender(Resources.getString(72), 1500L);
                        this.shootableThings[objectId].initDyingAnimation();
                    }
                }
            } else if (aux instanceof PowerUpInfo) {
                PowerUpInfo pwrInfo = (PowerUpInfo)aux;
                int objectId = pwrInfo.getId();
                this.activatePowerUp(this.shootableThings[objectId].getObjectSubCategory(), this.shootableThings[objectId].getCenterPoint(-1).getX(), this.shootableThings[objectId].getCenterPoint(-1).getY() - 0.1f, this.shootableThings[objectId].getCenterPoint(-1).getZ());
                this.updateGoodShots();
                isAlive = pwrInfo.updateLife();
                if (!isAlive) {
                    this.shootableThings[objectId].desactivate(0);
                }
            } else if (aux instanceof AVPartInfo) {
                this.impactZone = -1;
                AVPartInfo avInfo = (AVPartInfo)aux;
                int objectId = avInfo.getId();
                this.activateSparkSequence(this.xImpact, this.yImpact, this.zImpact);
                switch (avInfo.getExtremityType()) {
                    case 70: {
                        this.updateBadShots();
                        break;
                    }
                    case 71: {
                        this.updateBadShots();
                        break;
                    }
                    case 72: {
                        this.updateGoodShots();
                        this.incrementTotalPoints(50);
                        isAlive = avInfo.updateLife();
                        this.setMessageToRender("50", 1500L);
                        this.setIZRenderingInitTime();
                        this.shootableThings[objectId].enableRenderWeaponLife(avInfo.getWeaponIndex());
                        if (isAlive) break;
                        this.shootableThings[objectId].desactivate(avInfo.getWeaponIndex());
                        this.activateWeaponExplosion(this.shootableThings[objectId]);
                        break;
                    }
                    case 73: {
                        this.updateGoodShots();
                        this.incrementTotalPoints(50);
                        isAlive = avInfo.updateLife();
                        this.setMessageToRender("50", 1500L);
                        this.setIZRenderingInitTime();
                        this.shootableThings[objectId].enableRenderWeaponLife(avInfo.getWeaponIndex());
                        if (isAlive) break;
                        this.shootableThings[objectId].desactivate(avInfo.getWeaponIndex());
                        this.activateWeaponExplosion(this.shootableThings[objectId]);
                    }
                }
                if (!this.shootableThings[objectId].isAlive()) {
                    this.configureExplosions(this.shootableThings[objectId]);
                    this.finalBossKilled = true;
                }
            } else {
                this.activateSparkSequence(this.xImpact, this.yImpact, this.zImpact);
                this.updateBadShots();
            }
        } else {
            this.updateBadShots();
        }
    }

    private final void activateWeaponExplosion(ShootableObject aux) {
        this.weaponExplosion.setPosition(aux.getPos().getX(), aux.getPos().getY(), aux.getPos().getZ());
        this.weaponExplosion.setVisible(true);
        this.weaponExplosion.validateAnimation(true);
    }

    private final void activateSparkSequence(float x, float y, float z) {
        this.sparkBB.setPosition(x, y, z);
        this.sparkBB.setVisible(true);
        this.sparkBB.validateAnimation(true);
    }

    private final void initAnimationTimes() {
        for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
            aux.activateAnimation(gameTime);
        }
    }

    public final void processGameWorld(long time) {
        if (Input.IsKeyCombo(SniperCanvas.Cheating_PassSubstage)) {
            for (ShootableObject aux = (ShootableObject)this.shootableThingsPool.getFirstUsed(); aux != null; aux = (ShootableObject)aux.getNextLinked()) {
                aux.setDyingValue(true);
            }
            this.changeSubstage = true;
        }
        if (!this.stageComplete && !this.gameOver) {
            gameTime = time;
            this.processKeys();
            if (this.needToInitTimes) {
                this.initAnimationTimes();
                this.needToInitTimes = false;
                this.setMessageToRender(Resources.getString(71) + (stage + 1), 1500L);
            }
            if (!this.mobCam.weReachFinalPosition()) {
                this.scene.align(null);
                if (this.mobCam.changeCameraPath) {
                    this.mobCam.changeCameraPath = false;
                }
            }
            this.mobCam.updateCamera();
            if (this.playerLifes > 0 && this.mobCam.isZoomActive()) {
                this.mobCam.breathe(this.calculateBreatheConstants());
            }
            if (this.bossIntro) {
                this.updateIntroState();
            } else if (!this.wait) {
                this.updateSceneElements();
                this.checkIsNoTerrorist();
            }
            if (this.processShot) {
                if (!this.magazineEmpty) {
                    this.midlet.soundEngine.playShotFX();
                    this.updateRemainigBullets();
                    this.processShot(this.mobCam);
                } else {
                    this.setMessageToRender(Resources.getString(26), 1500L);
                }
                this.processShot = false;
            }
            this.aimedObjType = this.checkIfAimed(this.mobCam);
            if (this.reload) {
                this.reloadMagazine();
                this.reload = false;
            }
            this.moveTraffic();
            this.updateExplosions();
            this.updateWeaponExplosions();
            this.updateSparks();
            if (this.wait && gameTime - this.initWaitTime > 500L) {
                this.changeSubstage = true;
                this.wait = false;
            }
            if (this.changeSubstage) {
                this.setMessageToRender(Resources.getString(69) + (this.substage + 1) + Resources.getString(70), this.msgDuration);
                ++this.substage;
                this.updateTheStage();
            }
            this.scene.align(null);
        }
    }

    private void checkIsNoTerrorist() {
        if (this.murders == this.terroristNumber && !this.wait) {
            this.wait = true;
            this.initWaitTime = gameTime;
        }
    }

    public final ShootableObject getShootableObjectFromPool() {
        return (ShootableObject)this.shootableThingsPool.getNextFree();
    }

    public final void releaseShootableObject(ShootableObject enemy) {
        this.shootableThingsPool.release(enemy);
    }

    public static final void updateGameTime(long time) {
        gameTime = time;
    }

    public static final long getGameTime() {
        return gameTime;
    }

    public static final int getBadShots() {
        return badShots;
    }

    public static final int getGoodShots() {
        return goodShots;
    }

    public static final float getAccuracy() {
        accuracy = (float)goodShots * 1.0f / ((float)(goodShots + badShots) * 1.0f) * 100.0f;
        return accuracy;
    }

    public static final int getHeadShots() {
        return headShots;
    }

    public static final boolean insideInterval(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static final boolean isIntersectingRec(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return by + bh >= ay && by <= ay + ah && bx + bw >= ax && bx <= ax + aw;
    }

    static {
        isStageMeshLoaded = false;
        isCamAdded = false;
        isResourceLoaded = false;
    }

    public static final class MeshType {
        public static final int Buildings = 0;
        public static final int Billboards = 1;
        public int type;

        public MeshType(int meshType) {
            this.type = meshType;
        }
    }
}

