/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PWBitMapLab {
    public static final byte STYLE_NONE = 0;
    public static final byte STYLE_OUTLINE = 1;
    public static final byte STYLE_GRADED = 2;
    public static final byte STYLE_OUTLINE_GRADED = 3;
    int[] Palette = new int[]{-256, -67072, -133632, -134656, -267776, -335104, -402176, -470272, -670720, -738304, -739584, -806399};
    int color = -1;
    int outLineColor = -16777216;
    int[] outLinePalette = new int[]{-16777216, -16777216};
    boolean drawPaletteColor = true;
    boolean drawOutLine = true;
    public static final int[] verify = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static byte[][] DotMatrixLab = null;
    public static boolean useBuf = false;
    public Image[] fontBuf;
    public short[] fontBufDate;
    public int bufOffset = 0;
    public int defFontBufSize = 80;

    PWBitMapLab(byte[][] b) {
        DotMatrixLab = b;
        this.resetFontBuf(false);
    }

    PWBitMapLab(byte[][] b, boolean use) {
        DotMatrixLab = b;
        this.resetFontBuf(use);
    }

    public void resetFontBuf(boolean use) {
        if (DotMatrixLab == null) {
            System.out.println("DMLab not find");
        }
        if (!(useBuf = use)) {
            this.fontBufDate = null;
            this.fontBuf = null;
            System.gc();
        } else {
            this.fontBufDate = null;
            this.fontBuf = null;
            this.bufOffset = 0;
            this.fontBufDate = new short[this.defFontBufSize];
            this.fontBuf = new Image[this.defFontBufSize];
            for (int i = 0; i < this.defFontBufSize; ++i) {
                this.addFont2Buf(i);
            }
        }
    }

    public void resetFontBuf(int bufSize) {
        if (DotMatrixLab == null) {
            System.out.println("DMLab not find");
        }
        this.defFontBufSize = bufSize;
        this.resetFontBuf(true);
    }

    public void addFont2Buf(int pos) {
        if (pos >= DotMatrixLab.length | pos < 0) {
            System.out.println("Add fontBuf err");
            return;
        }
        if (this.bufOffset > this.fontBuf.length - 1) {
            this.bufOffset = 0;
        }
        this.fontBufDate[this.bufOffset] = (short)pos;
        this.fontBuf[this.bufOffset] = null;
        int[] buf = this.getCharMap(DotMatrixLab[pos]);
        boolean w = false;
        this.fontBuf[this.bufOffset] = Image.createRGBImage((int[])buf, (int)14, (int)14, (boolean)true);
        ++this.bufOffset;
    }

    public boolean drawFontBuf(int pos, Graphics g, int x, int y) {
        if (pos >= DotMatrixLab.length | pos < 0) {
            System.out.println("draw fontBuf err");
            return false;
        }
        for (int i = 0; i < this.fontBuf.length; ++i) {
            if (pos != this.fontBufDate[i]) continue;
            g.drawImage(this.fontBuf[i], x, y, 20);
            return true;
        }
        return false;
    }

    public void setStyle(int style) {
        switch (style) {
            case 0: {
                this.drawPaletteColor = false;
                this.drawOutLine = false;
                break;
            }
            case 2: {
                this.drawPaletteColor = true;
                this.drawOutLine = false;
                break;
            }
            case 1: {
                this.drawPaletteColor = false;
                this.drawOutLine = true;
                break;
            }
            case 3: {
                this.drawPaletteColor = true;
                this.drawOutLine = true;
            }
        }
    }

    public void setOutLineColor(int c) {
    }

    public void setColor(int c) {
        this.color = c;
    }

    public void newPalettes(int startColor, int endColor) {
    }

    public byte[][] loadDotMatrixLab() {
        byte[][] data = null;
        return data;
    }

    public void drawChar(int pos, Graphics g, int x, int y) {
        if (x < g.getClipX() - 14 || x > g.getClipX() + g.getClipWidth() || y < g.getClipY() - 14 || y - 14 > g.getClipY() + g.getClipHeight()) {
            return;
        }
        if (useBuf) {
            if (!this.drawFontBuf(pos, g, x, y -= 14)) {
                this.addFont2Buf(pos);
                this.drawFontBuf(pos, g, x, y);
            }
        } else {
            this.drawChar(DotMatrixLab[pos], g, x, y);
        }
    }

    public void drawChar(byte[] test, Graphics g, int x, int y) {
        int[] cMap = this.getCharMap(test);
        if (x > -14 && x < 254 && y > -14 && y < 334) {
            try {
                g.drawRGB(cMap, 0, 14, x, y - 14, 14, 14, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public int[] getCharMap(byte[] test) {
        int[] cMap = new int[196];
        int i = 14;
        for (int h = 0; h < 12; ++h) {
            int w;
            ++i;
            for (w = 0; w < 8; ++w) {
                cMap[i] = (test[h * 2] & verify[w]) == verify[w] ? (this.drawPaletteColor ? this.Palette[h] : this.color) : 0;
                ++i;
            }
            for (w = 0; w < 4; ++w) {
                cMap[i] = (test[h * 2 + 1] & verify[w]) == verify[w] ? (this.drawPaletteColor ? this.Palette[h] : this.color) : 0;
                ++i;
            }
            ++i;
        }
        if (!this.drawOutLine) {
            return cMap;
        }
        for (int q = 0; q < cMap.length; ++q) {
            if (cMap[q] == 0 || cMap[q] == this.outLineColor) continue;
            if (q - 14 >= 0 && cMap[q - 14] == 0) {
                cMap[q - 14] = this.outLineColor;
            }
            if (q - 1 >= 0 && cMap[q - 1] == 0) {
                cMap[q - 1] = this.outLineColor;
            }
            if (q + 14 < cMap.length && cMap[q + 14] == 0) {
                cMap[q + 14] = this.outLineColor;
            }
            if (q + 1 >= cMap.length || cMap[q + 1] != 0) continue;
            cMap[q + 1] = this.outLineColor;
        }
        return cMap;
    }

    public void drawRGBMidp1(int[] rgb, Graphics g, int start, int offset, int x, int y, int w, int h) {
        int k = start;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                if ((rgb[k] >> 24 & 0xFF) != 0) {
                    g.setColor(rgb[k]);
                    g.drawLine(x + j, y + i, x + j, y + i);
                }
                if (k >= rgb.length) continue;
                ++k;
            }
        }
    }

    public void setPalette(int number) {
        switch (number) {
            case 0: {
                this.outLineColor = -16777216;
                break;
            }
            case 1: {
                this.outLineColor = -16777216;
            }
        }
    }
}

