/*
 * Decompiled with CFR 0.152.
 */
package z;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.World;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import z.Console;
import z.GameEngine;
import z.Input;
import z.LoadingCanvas;
import z.MenuCanvas;
import z.PWNanoFont;
import z.PWTokenizer;
import z.Resources;
import z.SniperCanvas;
import z.SoundManager;

public class SniperMIDlet
extends MIDlet
implements Runnable {
    public static SniperMIDlet instance;
    public static final boolean TRACE_ON = false;
    public static final int MISSIONS = 4;
    public static boolean drawDebug;
    public static final int INITIAL_UNLOCKED_MISSIONS = 1;
    public static boolean isStaticResLoaded;
    public static final int FIRST_STAGE = 0;
    public static final int INIT_SUB_STAGE = 0;
    public static final int INITIAL_POINTS = 0;
    public static final int INIT_PLAYER_LIFE = 100;
    public static final short _mode_EXITGAME_ = -1;
    public static final short _mode_MENU_ = 0;
    public static final short _mode_PLAYING_ = 1;
    public static final short _mode_DEMO_ = 2;
    public static final int LEFT_BUTTON = -6;
    public static final int RIGHT_BUTTON = -7;
    public static final int KEY_CODE_NUM7 = -1000;
    public static final int KEY_CODE_NUM5 = -5;
    public static final int KEY_CODE_NUM2 = -1;
    public static final int KEY_CODE_NUM8 = -2;
    public static final int KEY_CODE_NUM4 = -3;
    public static final int KEY_CODE_NUM6 = -4;
    public static final int KEY_CODE_NUM9 = -1000;
    private short mode;
    private short menuToLoad;
    private boolean screensaverEnable;
    private SniperCanvas gameCanvas;
    private LoadingCanvas loadingCanvas;
    private GameEngine gameEngine;
    private Thread gameThread;
    private Display display;
    private MenuCanvas menu;
    public SoundManager soundEngine;
    private static int stageToLoad;
    private static int initialPlayerLife;
    private static int actualPoints;
    private static int language;
    public static int unlockStages;
    public static boolean previousSavedGame;
    public static PWNanoFont gameFont;
    public static PWNanoFont messageFont;
    public static boolean playingArcadeMode;
    private static long pauseTime;
    private static long initPauseTime;
    public static boolean inPause;
    public static boolean autoReload;
    public static boolean godMode;
    public static boolean unlimitedAmmo;
    public static boolean specialBullets;
    static final int XTEA_DELTA = -1640531527;
    static int[] xteaKey;

    public SniperMIDlet() {
        Console.setSize(0, 0, 240, 10);
        instance = this;
        System.out.println("begin SniperMIDlet()");
        Input.InitKey();
        this.resetMIDletVariables();
        this.loadCommonResources();
        this.screensaverEnable = false;
        SniperMIDlet.loadLanguage();
        GameEngine.convertCoords();
        this.menuToLoad = (short)12;
        this.display = Display.getDisplay((MIDlet)this);
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    public InputStream getResource(String fn) {
        return this.getClass().getResourceAsStream(fn);
    }

    private void resetMIDletVariables() {
        stageToLoad = 0;
        actualPoints = 0;
        unlockStages = SniperMIDlet.setUnlockStages();
        initialPlayerLife = 100;
        previousSavedGame = false;
        godMode = false;
        unlimitedAmmo = false;
        specialBullets = false;
        playingArcadeMode = false;
    }

    public static final void updateTheNumberOfUnlockedStages() {
        if (unlockStages < 4) {
            SniperMIDlet.store("sniperOpsUnlock", Integer.toString(++unlockStages));
        }
    }

    private static final int setUnlockStages() {
        String data = SniperMIDlet.load("sniperOpsUnlock");
        if (data.equals("")) {
            return 1;
        }
        PWTokenizer tok = new PWTokenizer(data, '#');
        return Integer.parseInt(tok.nextToken());
    }

    public static final int getPreviousSoundLevel() {
        String data = SniperMIDlet.load("sniperOpsVolumen");
        if (data.equals("")) {
            System.out.println("getPreviousSoundLevel()  10");
            return 10;
        }
        PWTokenizer tok = new PWTokenizer(data, '#');
        System.out.println("getPreviousSoundLevel()  " + Integer.parseInt(data));
        return Integer.parseInt(data);
    }

    public static final void saveCurrentSoundLevel(int level) {
        SniperMIDlet.store("sniperOpsVolumen", Integer.toString(level));
    }

    public static final void setLanguage(int aLang) {
        language = aLang;
    }

    public static final int getUnlockStages() {
        return unlockStages;
    }

    public static final int getLanguage() {
        return language;
    }

    public final void setScreenSaverValue(boolean aValue) {
        this.screensaverEnable = aValue;
    }

    public final boolean isScreenSaverEnable() {
        return this.screensaverEnable;
    }

    public static final void calculateTimeInPause() {
        pauseTime = System.currentTimeMillis() - initPauseTime;
    }

    public static final void setInitPauseTime(long time) {
        initPauseTime = time;
    }

    public static final long getPauseTime() {
        return pauseTime;
    }

    public static final int getInitPlayerLife() {
        return initialPlayerLife;
    }

    public static final void updatePlayerLife(int life) {
        initialPlayerLife = life;
    }

    public static final void updatePlayerPoints(int points) {
        actualPoints = points;
    }

    public final void loadCommonResources() {
        messageFont = gameFont = PWNanoFont.load(Resources.get().getResource("/x/BitMap.bin"));
        this.soundEngine = new SoundManager();
        System.out.println("after SoundManager2");
    }

    public final void setNewMode(short newMode) {
        this.mode = newMode;
    }

    public final short getMode() {
        return this.mode;
    }

    public final void setNextMenuToLoad(short newMenu) {
        this.menuToLoad = newMenu;
    }

    private void play() {
        this.loadingCanvas = new LoadingCanvas();
        this.loadingCanvas.setNumberOfSteps(10);
        this.display.setCurrent((Displayable)this.loadingCanvas);
        this.gameEngine = new GameEngine(this, this.loadingCanvas, false);
        this.gameCanvas = new SniperCanvas(this, this.gameEngine, this.loadingCanvas);
        this.gameEngine.setGameCanvas(this.gameCanvas);
        if (this.loadingCanvas != null) {
            this.loadingCanvas.run();
        }
        pauseTime = 0L;
        initPauseTime = 0L;
        if (this.gameCanvas != null) {
            this.display.setCurrent((Displayable)this.gameCanvas);
            this.gameCanvas.run();
        }
        this.gameEngine.shutdown();
        this.gameEngine = null;
        this.gameCanvas = null;
        this.loadingCanvas = null;
        System.gc();
    }

    private void demoMode() {
        this.loadingCanvas = new LoadingCanvas();
        this.display.setCurrent((Displayable)this.loadingCanvas);
        this.loadingCanvas.setNumberOfSteps(10);
        this.gameEngine = new GameEngine(this, this.loadingCanvas, true);
        this.gameCanvas = new SniperCanvas(this, this.gameEngine, this.loadingCanvas);
        this.gameEngine.setGameCanvas(this.gameCanvas);
        if (this.loadingCanvas != null) {
            this.loadingCanvas.run();
        }
        pauseTime = 0L;
        initPauseTime = 0L;
        if (this.gameCanvas != null) {
            this.display.setCurrent((Displayable)this.gameCanvas);
            this.gameCanvas.run();
        }
        this.gameEngine.shutdown();
        this.gameEngine = null;
        this.gameCanvas = null;
        this.loadingCanvas = null;
        System.gc();
    }

    protected void destroyApp(boolean _boolean) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
    }

    public void exit() {
        try {
            this.destroyApp(true);
            this.notifyDestroyed();
        }
        catch (MIDletStateChangeException e) {
            e.printStackTrace();
        }
    }

    protected void startApp() throws MIDletStateChangeException {
    }

    private final void activeMenu() {
        if (this.menu == null) {
            this.menu = new MenuCanvas(this);
        }
        this.menu.initMenu(this.menuToLoad);
        this.initCanvas(this.menu);
        if (this.menuToLoad == 0) {
            this.soundEngine.playMainTheme();
        }
        this.menu.run();
        if (this.mode == 2 || this.mode == 1) {
            this.soundEngine.stopMainTheme();
            this.menu = null;
            SniperMIDlet.cleanMemory();
        }
    }

    private final void initCanvas(Canvas canvas) {
        this.display.setCurrent((Displayable)canvas);
        canvas.repaint();
    }

    public final void run() {
        try {
            while (this.mode != -1) {
                switch (this.mode) {
                    case 0: {
                        this.activeMenu();
                        break;
                    }
                    case 1: {
                        this.play();
                        break;
                    }
                    case 2: {
                        this.demoMode();
                    }
                }
            }
            this.exit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void loadLastGame() {
        String data = SniperMIDlet.load("sniperOps");
        if (data.equals("")) {
            previousSavedGame = false;
        } else {
            previousSavedGame = true;
            SniperMIDlet.fromString(data);
        }
    }

    public static final boolean loadLanguage() {
        language = 5;
        Resources.loadLangData("/x/" + Resources.LANGS[language]);
        if (Resources.lang[0].length() > 4) {
            Resources.lang[0] = Resources.lang[0].substring(1);
        }
        for (int i = 0; i < Resources.lang.length; ++i) {
            Resources.lang[i] = Resources.replace(Resources.lang[i], "\\\\N", "\n");
        }
        return true;
    }

    public static final void saveLanguage() {
        String s = Integer.toString(language);
        SniperMIDlet.store("sniperOpsLang", s);
    }

    private static final void fromString(String s) {
        PWTokenizer tok = new PWTokenizer(s, '#');
        stageToLoad = Integer.parseInt(tok.nextToken());
        initialPlayerLife = Integer.parseInt(tok.nextToken());
    }

    public static final void setStageToLoad(int stageIndex) {
        stageToLoad = stageIndex;
    }

    public static final int getStageToLoad() {
        return stageToLoad;
    }

    public static final int getActualPoints() {
        return actualPoints;
    }

    public static void store(String recordStoreName, String content) {
        Console.output("store() : " + recordStoreName + ", " + content);
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(content);
            byte[] b = baos.toByteArray();
            db.addRecord(b, 0, b.length);
            db.closeRecordStore();
            System.out.println("store(" + recordStoreName + ", " + recordStoreName + ")");
        }
        catch (Exception e) {
            Console.output("->store:" + e.toString().substring(e.toString().lastIndexOf(46)));
            e.printStackTrace();
        }
    }

    public static void delete(String recordStoreName) {
        try {
            Console.output("deleteRecordStore() : " + recordStoreName);
            RecordStore.deleteRecordStore((String)recordStoreName);
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.output("->" + e.toString().substring(e.toString().lastIndexOf(46)));
        }
        Console.output("delete() : " + recordStoreName);
    }

    public static String load(String recordStoreName) {
        Console.output("load() : " + recordStoreName);
        String result = "";
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(re.nextRecord());
            DataInputStream dis = new DataInputStream(bais);
            result = dis.readUTF();
            db.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("!!!!!  can't find record: " + recordStoreName);
            Console.output("->load:" + e.toString().substring(e.toString().lastIndexOf(46)));
            result = "";
            return result;
        }
        return result;
    }

    public static void store(String recordStoreName, ByteArrayOutputStream baos) {
        SniperMIDlet.store(recordStoreName, baos.toByteArray());
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void store(String recordStoreName, byte[] data) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                db.deleteRecord(re.nextRecordId());
            }
            byte[] b = SniperMIDlet.xteaEncrypt(data);
            db.addRecord(b, 0, b.length);
            db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DataInputStream load2(String recordStoreName) {
        try {
            RecordStore db = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            RecordEnumeration re = db.enumerateRecords(null, null, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(SniperMIDlet.xteaDecrypt(re.nextRecord()));
            DataInputStream dis = new DataInputStream(bais);
            db.closeRecordStore();
            return dis;
        }
        catch (Exception e) {
            return null;
        }
    }

    static final byte[] xteaEncrypt(byte[] in) {
        int blocks = in.length / 8;
        int rest = in.length % 8;
        if (rest > 0) {
            ++blocks;
        }
        byte[] source = new byte[blocks * 8];
        byte[] result = new byte[source.length];
        System.arraycopy(in, 0, source, 0, in.length);
        for (int i = 0; i < blocks; ++i) {
            System.arraycopy(SniperMIDlet.engineCrypt(source, i * 8, false), 0, result, i * 8, 8);
        }
        return result;
    }

    static final byte[] engineCrypt(byte[] source, int offset, boolean decrypt) {
        int v0 = source[offset++] & 0xFF | (source[offset++] & 0xFF) << 8 | (source[offset++] & 0xFF) << 16 | source[offset++] << 24;
        int v1 = source[offset++] & 0xFF | (source[offset++] & 0xFF) << 8 | (source[offset++] & 0xFF) << 16 | source[offset++] << 24;
        int n = 32;
        if (!decrypt) {
            int sum = 0;
            while (n-- > 0) {
                v1 += ((v0 += (v1 << 4 ^ v1 >> 5) + v1 ^ sum + xteaKey[sum & 3]) << 4 ^ v0 >> 5) + v0 ^ (sum -= 1640531527) + xteaKey[sum >> 11 & 3];
            }
        } else {
            int sum = -957401312;
            while (n-- > 0) {
                v0 -= ((v1 -= (v0 << 4 ^ v0 >> 5) + v0 ^ sum + xteaKey[sum >> 11 & 3]) << 4 ^ v1 >> 5) + v1 ^ (sum += 1640531527) + xteaKey[sum & 3];
            }
        }
        byte[] result = new byte[8];
        int desp = 0;
        result[desp++] = (byte)v0;
        result[desp++] = (byte)(v0 >>> 8);
        result[desp++] = (byte)(v0 >>> 16);
        result[desp++] = (byte)(v0 >>> 24);
        result[desp++] = (byte)v1;
        result[desp++] = (byte)(v1 >>> 8);
        result[desp++] = (byte)(v1 >>> 16);
        result[desp++] = (byte)(v1 >>> 24);
        return result;
    }

    public static byte[] xteaDecrypt(byte[] in) {
        byte[] result = new byte[in.length];
        int blocks = in.length / 8;
        for (int i = 0; i < blocks; ++i) {
            System.arraycopy(SniperMIDlet.engineCrypt(in, i * 8, true), 0, result, i * 8, 8);
        }
        return result;
    }

    public static final void adjustModelPosition(float x, float y, float z, float scale, float heading, Mesh modelMesh) {
        if (modelMesh != null) {
            try {
                modelMesh.scale(scale, scale, scale);
                modelMesh.setOrientation(heading, 0.0f, 1.0f, 0.0f);
                modelMesh.setTranslation(x, y, z);
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
    }

    public static final void setOtherAttributes(boolean pickValue, boolean render, Mesh modelMesh) {
        if (modelMesh != null) {
            modelMesh.setRenderingEnable(render);
            modelMesh.setPickingEnable(pickValue);
            return;
        }
    }

    public static final Mesh loadComplexModel(String meshFile, int meshId) {
        World world = null;
        int groupId = meshId - 1;
        try {
            Object3D[] buffer = Loader.load((String)meshFile);
            for (int i = 0; i < buffer.length; ++i) {
                if (!(buffer[i] instanceof World)) continue;
                world = (World)buffer[i];
                break;
            }
            buffer = null;
            Group aGroup = (Group)world.find(groupId);
            world.removeChild((Node)aGroup);
            Mesh meshToLoad = (Mesh)aGroup.find(meshId);
            Appearance app = meshToLoad.getAppearance(0);
            PolygonMode plgmode = app.getPolygonMode();
            plgmode.setPerspectiveCorrectionEnable(true);
            plgmode.setCulling(160);
            aGroup.removeChild((Node)meshToLoad);
            System.gc();
            return meshToLoad;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void cleanMemory() {
        System.gc();
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final Mesh loadGenericMesh(String modelFile, int meshId) {
        World world = null;
        try {
            boolean maxExporter = false;
            Object3D[] buffer = Loader.load((String)modelFile);
            for (int i = 0; i < buffer.length; ++i) {
                if (!(buffer[i] instanceof World)) continue;
                world = (World)buffer[i];
                if (i != 0) break;
                maxExporter = true;
                break;
            }
            buffer = null;
            Mesh aMesh = (Mesh)world.find(meshId);
            if (maxExporter) {
                aMesh.setOrientation(-90.0f, 1.0f, 0.0f, 0.0f);
            }
            Appearance app = aMesh.getAppearance(0);
            PolygonMode plgmode = app.getPolygonMode();
            plgmode.setPerspectiveCorrectionEnable(true);
            plgmode.setCulling(160);
            world.removeChild((Node)aMesh);
            aMesh.setPickingEnable(false);
            System.gc();
            return aMesh;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        drawDebug = false;
        isStaticResLoaded = false;
        pauseTime = 0L;
        autoReload = true;
        xteaKey = new int[]{1264675176, 1635021685, 543255413, 1936225653};
    }
}

