/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game;

import com.iplay.game.ScreenSizeHandler;
import com.iplay.game.interfaces.RecordStoreHandlerInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;

public abstract class RecordStoreHandler
extends ScreenSizeHandler
implements RecordStoreHandlerInterface {
    private boolean loadedGameState;
    private boolean loadedOptions;

    protected RecordStoreHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveGameState(int priority) {
        boolean success = false;
        if (priority <= 4) {
            if (!this.loadedGameState) {
                return false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                try {
                    if (this.saveGameStateToRMS(dos)) {
                        dos.flush();
                        success = this.writeData(baos.toByteArray(), "a");
                    }
                }
                finally {
                    dos.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveOptions(int priority) {
        boolean success = false;
        if (priority <= 4) {
            if (!this.loadedOptions) {
                return false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                try {
                    if (this.saveOptionsToRMS(dos)) {
                        dos.flush();
                        success = this.writeData(baos.toByteArray(), "b");
                    }
                }
                finally {
                    dos.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return success;
    }

    abstract void printToConsole(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadGameState() {
        byte[] data = this.loadData("a");
        if (data != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            try {
                try {
                    this.loadGameStateFromRMS(dis);
                }
                finally {
                    dis.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.loadedGameState = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadOptions() {
        byte[] data = this.loadData("b");
        if (data != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            try {
                try {
                    this.loadOptionsFromRMS(dis);
                }
                finally {
                    dis.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.loadedOptions = true;
    }

    public abstract void loadGameStateFromRMS(DataInputStream var1) throws IOException;

    public abstract boolean saveGameStateToRMS(DataOutputStream var1) throws IOException;

    public abstract void loadOptionsFromRMS(DataInputStream var1) throws IOException;

    public abstract boolean saveOptionsToRMS(DataOutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeData(byte[] data, String recordStoreName) {
        boolean success = true;
        try {
            RecordStore rs = null;
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                    rs = null;
                }
                RecordStore.deleteRecordStore((String)recordStoreName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (rs == null) {
                rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            }
            try {
                if (rs.getNumRecords() == 0) {
                    rs.addRecord(data, 0, data.length);
                } else {
                    rs.setRecord(1, data, 0, data.length);
                }
            }
            finally {
                rs.closeRecordStore();
            }
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] loadData(String recordStoreName) {
        byte[] rmsData;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            try {
                rmsData = rs.getRecord(1);
            }
            finally {
                rs.closeRecordStore();
            }
        }
        catch (Exception e) {
            rmsData = null;
        }
        return rmsData;
    }
}

