/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game;

import com.iplay.game.IOHandler;
import com.iplay.game.interfaces.FontInterface;
import java.io.DataInputStream;
import java.util.Vector;

public final class TextHandler {
    public static final char BREAK_PERMITTED_HERE_CHAR = '\u0082';
    public static final char ZERO_WIDTH_SPACE_CHAR = '\u200b';
    public static final char SOFT_HYPHEN = '\u00ad';
    private static final char HYPHEN = '-';
    public static final int LANGUAGE_UNSELECTED = -1;
    private static final int COUNTRY_CODE_LENGTH = 2;
    private static final String LANGUAGE_MANIFEST_FILE_NAME = "/langs.utf8";
    private static int[] sectionBaseOffset;
    private static int language;
    private static char[][] languageNames;
    private static char[] countryCodes;
    private static char[][][] loadedTextSections;

    private TextHandler() {
    }

    public static void loadTextSection(int section, String textFilename) {
        if (countryCodes != null) {
            int languageIndex = language == -1 ? 0 : language;
            textFilename = new StringBuffer(textFilename).insert(textFilename.lastIndexOf(46), TextHandler.getCountryCode(languageIndex)).toString();
        }
        char[][] text = TextHandler.loadText(textFilename, section);
        if (loadedTextSections == null) {
            loadedTextSections = new char[TextHandler.getTextSectionCount()][][];
        }
        TextHandler.loadedTextSections[section] = text;
    }

    public static boolean isTextSectionLoaded(int section) {
        return loadedTextSections != null && loadedTextSections[section] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[][] loadText(String file, int section) {
        Object text = null;
        try {
            DataInputStream dis = IOHandler.getResourceAsDataStream(file);
            try {
                String line;
                int sectionCount = dis.readUnsignedByte();
                sectionBaseOffset = new int[sectionCount + 1];
                int sectionEnd = 0;
                for (int i = 0; i < sectionCount; ++i) {
                    TextHandler.sectionBaseOffset[i + 1] = sectionEnd += dis.readShort();
                }
                int startIndex = sectionBaseOffset[section];
                int endIndex = sectionBaseOffset[section + 1];
                text = new char[endIndex - startIndex][];
                int storeIndex = 0;
                for (int readIndex = 0; readIndex < endIndex && (line = dis.readUTF()) != null; ++readIndex) {
                    if (readIndex < startIndex) continue;
                    text[storeIndex++] = line.toCharArray();
                }
            }
            finally {
                dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public static void unloadTextSection(int section) {
        if (TextHandler.isTextSectionLoaded(section)) {
            TextHandler.loadedTextSections[section] = null;
        }
    }

    public static int getTextSectionCount() {
        return sectionBaseOffset == null ? 0 : sectionBaseOffset.length - 1;
    }

    public static char[] getText(int textIdAndSection) {
        char[] textItem = null;
        if (textIdAndSection >= 0) {
            int textId = textIdAndSection & 0xFFFF;
            int section = textIdAndSection >>> 16;
            int sectionIndex = textId - sectionBaseOffset[section];
            char[][] text = loadedTextSections[section];
            if (sectionIndex >= 0 && sectionIndex < text.length) {
                textItem = text[sectionIndex];
            }
        }
        return textItem;
    }

    public static int getLanguage() {
        return language;
    }

    public static void setLanguage(int languageIndex) {
        language = languageIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLanguageManifest() {
        try {
            DataInputStream dis = IOHandler.getResourceAsDataStream(LANGUAGE_MANIFEST_FILE_NAME);
            try {
                short recordsInManifest = dis.readShort();
                languageNames = new char[recordsInManifest / 2][];
                countryCodes = new char[recordsInManifest];
                for (int i = 0; i < languageNames.length; ++i) {
                    TextHandler.languageNames[i] = dis.readUTF().toCharArray();
                    char[] langCode = dis.readUTF().toCharArray();
                    System.arraycopy(langCode, 0, countryCodes, i * 2, 2);
                }
            }
            finally {
                dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static char[] getLanguageName(int index) {
        return languageNames[index];
    }

    public static char[] getCountryCode(int index) {
        char[] cArray;
        if (countryCodes != null) {
            char[] cArray2 = new char[2];
            cArray2[0] = countryCodes[index * 2];
            cArray = cArray2;
            cArray2[1] = countryCodes[index * 2 + 1];
        } else {
            cArray = null;
        }
        return cArray;
    }

    public static int getLanguageCount() {
        return languageNames == null ? 1 : languageNames.length;
    }

    public static char[] tokenizeString(char[] text, char[][] tokens) {
        if (tokens != null && tokens.length > 0) {
            int textLength = text.length;
            boolean escaped = false;
            StringBuffer buff = new StringBuffer();
            int prevTokenEndOffset = 0;
            for (int i = 0; i < textLength; ++i) {
                int textPartLength;
                char c = text[i];
                if (c == '$') {
                    if (escaped) {
                        textPartLength = i - prevTokenEndOffset;
                        if (textPartLength != 0) {
                            buff.append(text, prevTokenEndOffset, textPartLength);
                        }
                        prevTokenEndOffset = i + 1;
                    }
                    escaped = !escaped;
                    continue;
                }
                if (escaped && c >= '0' && c <= '9') {
                    textPartLength = i - 1 - prevTokenEndOffset;
                    if (textPartLength != 0) {
                        buff.append(text, prevTokenEndOffset, textPartLength);
                    }
                    buff.append(tokens[c - 48]);
                    prevTokenEndOffset = i + 1;
                }
                escaped = false;
            }
            if (prevTokenEndOffset != 0) {
                int textPartLength = textLength - prevTokenEndOffset;
                if (textPartLength != 0) {
                    buff.append(text, prevTokenEndOffset, textPartLength);
                }
                text = new char[buff.length()];
                buff.getChars(0, buff.length(), text, 0);
            }
        }
        return text;
    }

    public static char[][] formatString(FontInterface font, char[] text, int pixelsMaxWidth) {
        int textLength = text.length;
        Vector<char[]> lines = new Vector<char[]>();
        if (textLength == 0) {
            lines.addElement(text);
        } else {
            StringBuffer lineBuffer = new StringBuffer();
            int lineStartOffset = 0;
            int previousWordEndOffset = 0;
            int buffWordOffset = 0;
            for (int i = 0; i < textLength; ++i) {
                char[] line;
                char c = text[i];
                boolean forceBreak = false;
                if (c != '\n' && c != '\u0082' && c != '\u200b' && c != '\u00ad') {
                    lineBuffer.append(c);
                }
                if (c == ' ' || i == textLength - 1 || c == '\n') {
                    int bufferLength = lineBuffer.length();
                    if (c == ' ') {
                        --bufferLength;
                    }
                    line = new char[bufferLength];
                    if (bufferLength != 0) {
                        lineBuffer.getChars(0, bufferLength, line, 0);
                    }
                    if (font.charsWidth(line, 0, bufferLength) > pixelsMaxWidth) {
                        if (previousWordEndOffset != 0) {
                            lineBuffer.setLength(buffWordOffset);
                            i = previousWordEndOffset;
                        } else {
                            boolean breakMade = false;
                            int numberOfCharactersToDelete = 0;
                            for (int j = i; j >= lineStartOffset; --j) {
                                if (text[j] == '\u0082' || text[j] == '\u200b' || text[j] == '\u00ad') {
                                    boolean isSoftHyphen = text[j] == '\u00ad';
                                    int maxWidth = pixelsMaxWidth;
                                    if (isSoftHyphen) {
                                        char[] hyphen = new char[]{'-'};
                                        int hyphenWidth = font.charsWidth(hyphen, 0, hyphen.length);
                                        maxWidth -= hyphenWidth;
                                    }
                                    if (font.charsWidth(line, 0, lineBuffer.length() - numberOfCharactersToDelete) > maxWidth) continue;
                                    lineBuffer.setLength(lineBuffer.length() - numberOfCharactersToDelete);
                                    if (isSoftHyphen) {
                                        lineBuffer.append('-');
                                    }
                                    i = j;
                                    breakMade = true;
                                    break;
                                }
                                ++numberOfCharactersToDelete;
                            }
                            if (!breakMade) {
                                for (int charsToKeep = 2; charsToKeep <= lineBuffer.length(); ++charsToKeep) {
                                    int width = font.charsWidth(line, 0, charsToKeep);
                                    if (width <= pixelsMaxWidth) continue;
                                    lineBuffer.setLength(charsToKeep - 1);
                                    i = lineStartOffset + (charsToKeep - 1) - 1;
                                }
                            }
                        }
                        forceBreak = true;
                    } else if (i == textLength - 1 || c == '\n') {
                        forceBreak = true;
                    } else {
                        previousWordEndOffset = i;
                        buffWordOffset = lineBuffer.length() - 1;
                    }
                }
                if (!forceBreak) continue;
                int buffLength = lineBuffer.length();
                line = new char[buffLength];
                if (buffLength != 0) {
                    lineBuffer.getChars(0, buffLength, line, 0);
                }
                lineBuffer = new StringBuffer();
                lines.addElement(line);
                previousWordEndOffset = 0;
                buffWordOffset = 0;
                lineStartOffset = i + 1;
            }
        }
        int lineCount = lines.size();
        char[][] formattedText = new char[lineCount][];
        for (int i = 0; i < lineCount; ++i) {
            formattedText[i] = (char[])lines.elementAt(i);
        }
        return formattedText;
    }

    static {
        language = -1;
    }
}

