/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.menu;

import com.iplay.game.jq2009.InputHandlerExtensions;
import com.iplay.game.menu.MenuPage;
import com.iplay.game.menu.ScrollManager;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class MenuManager
extends ScrollManager {
    private static final int ITEM_DATA_TEXT = 0;
    private static final int ITEM_DATA_ID_AND_TRANSITION = 1;
    private static final int ITEM_DATA_COUNT = 2;
    private MenuPage activeMenuPage;
    private MenuPage tempMenuPage;
    private int activeMenuPageId;
    private long elapsedTime;
    private long timerElapsedTime;
    private Vector menuItems;
    byte dragtime = 0;

    protected abstract char[] getSelectSoftKey();

    public final void createMenu() {
        this.activeMenuPage = new MenuPage();
        this.initMenuRenderer();
        this.initScrollManager();
    }

    public final void resetActiveMenuPage() {
        this.menuItems = null;
        this.activeMenuPageId = 0;
        this.activeMenuPage.setMenuPageType(0);
        this.activeMenuPage.setTitle(null);
        this.activeMenuPage.setPositiveSoftkey(null, -3);
        this.activeMenuPage.setNegativeSoftkey(null, -3);
        this.activeMenuPage.setTimeOut(-1);
        this.activeMenuPage.setTimer(-1);
        this.activeMenuPage.resetScroll();
    }

    public final void setMenuPage(int n, int n2, char[] cArray, char[] cArray2, int n3, char[] cArray3, int n4) {
        this.tempMenuPage = new MenuPage();
        int[] nArray = this.tempMenuPage.getAttributes();
        nArray[0] = n;
        nArray[1] = n2;
        nArray[5] = -1;
        nArray[6] = -1;
        this.tempMenuPage.resetScroll();
        char[][] cArray4 = cArray == null ? (char[][])null : this.wrapMenuText(cArray, null, n2, n, -1);
        this.tempMenuPage.setTitle(cArray4);
        this.tempMenuPage.setPositiveSoftkey(cArray2, n3);
        this.tempMenuPage.setNegativeSoftkey(cArray3, n4);
        this.tempMenuPage.setUserData(null);
    }

    public final MenuPage getMenuPage() {
        return this.activeMenuPage;
    }

    public final void addMenuPageItem(int n, int n2, char[] cArray, char[][] cArray2, int n3) {
        char[][] cArray3 = this.wrapMenuText(cArray, cArray2 == null ? (char[][])null : cArray2, this.tempMenuPage.getMenuPageTypeFull(), n, n2);
        if (this.menuItems == null) {
            this.menuItems = new Vector(2);
        }
        this.menuItems.addElement(cArray3);
        this.menuItems.addElement(new int[]{n2, n3});
    }

    public final MenuPage finalizeMenuPage() {
        MenuPage menuPage = this.tempMenuPage;
        this.tempMenuPage = null;
        if (this.menuItems != null) {
            menuPage.setItemCount(this.menuItems.size() / 2);
            for (int i = 0; i < this.menuItems.size(); i += 2) {
                int[] nArray = (int[])this.menuItems.elementAt(i + 1);
                menuPage.setItem(i / 2, (char[][])this.menuItems.elementAt(i + 0), nArray[0]);
                menuPage.setTransition(i / 2, nArray[1]);
            }
            this.menuItems = null;
        }
        return menuPage;
    }

    public final void setActiveMenuPage(int n) {
        int n2 = this.activeMenuPageId;
        this.activeMenuPageId = n;
        this.elapsedTime = System.currentTimeMillis();
        this.timerElapsedTime = 0L;
        this.activeMenuPage = this.menuPageChanged(n, n2);
        this.setPositiveSoftkey(this.activeMenuPage.getPositiveSoftkey());
        this.setNegativeSoftkey(this.activeMenuPage.getNegativeSoftkey());
        if (n != n2) {
            this.menuPageScrolled(this.activeMenuPage, n);
        }
    }

    public final void renderMenu(Graphics graphics) {
        this.renderMenuPage(graphics, this.activeMenuPage, this.activeMenuPageId);
    }

    public final void renderPauseMenu(Graphics graphics) {
        this.renderPauseMenuPage(graphics, this.activeMenuPage, this.activeMenuPageId);
    }

    public final void updateMenu(int n) {
        int n2;
        int n3;
        long l = this.elapsedTime;
        this.timerElapsedTime += (long)n;
        if (l > 0L) {
            char[] cArray;
            int n4;
            n3 = this.activeMenuPage.getMenuPageType();
            if (n3 != 1 && this.updateScrollManager(n, this.activeMenuPage.getPageId())) {
                this.menuPageScrolled(this.activeMenuPage, this.activeMenuPageId);
            }
            int n5 = n2 = n3 == 4 || n3 == 8 ? 1 : 0;
            if (n3 == 4) {
                this.updateKeyEntry(n);
            } else if (n3 == 8) {
                this.updateNumberEntry(n);
            } else if (n2 != 0 && this.wasKeyPressed(16) || n2 == 0 && this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_DOWN_OR_NUM8) && n3 != 512 || n3 == 512 && (this.wasKeyPressed(18) || this.wasKeyPressed(6))) {
                this.activeMenuPage.moveDown();
                if (this.activeMenuPage.getPageId() == 8) {
                    if (this.activeMenuPage.getTransitions()[this.activeMenuPage.getSelectedItemPosition()] == -3) {
                        this.activeMenuPage.setPositiveSoftkey(null, -3);
                        this.setPositiveSoftkey(this.activeMenuPage.getPositiveSoftkey());
                    } else {
                        this.activeMenuPage.setPositiveSoftkey(this.getSelectSoftKey(), 9);
                        this.setPositiveSoftkey(this.activeMenuPage.getPositiveSoftkey());
                    }
                }
            } else if (n2 != 0 && this.wasKeyPressed(15) || n2 == 0 && this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_UP_OR_NUM2) && n3 != 512 || n3 == 512 && (this.wasKeyPressed(17) || this.wasKeyPressed(4))) {
                this.activeMenuPage.moveUp();
                if (this.activeMenuPage.getPageId() == 8) {
                    if (this.activeMenuPage.getTransitions()[this.activeMenuPage.getSelectedItemPosition()] == -3) {
                        this.activeMenuPage.setPositiveSoftkey(null, -3);
                        this.setPositiveSoftkey(this.activeMenuPage.getPositiveSoftkey());
                    } else {
                        this.activeMenuPage.setPositiveSoftkey(this.getSelectSoftKey(), 9);
                        this.setPositiveSoftkey(this.activeMenuPage.getPositiveSoftkey());
                    }
                }
            }
            if (n2 != 0 && this.wasKeyPressed(14) || n2 == 0 && this.wasKeyPressed(InputHandlerExtensions.VIRTUAL_KEY_FIRE_OR_NUM5)) {
                this.activateCurrentMenuItem();
            } else if (this.wasKeyPressed(21)) {
                char[] cArray2 = this.getPositiveSoftkey();
                int n6 = this.activeMenuPage.getSoftkeyTransition(cArray2);
                if (n6 != -3) {
                    if (n6 == -2) {
                        this.activateCurrentMenuItem();
                    } else if (n6 == -1) {
                        this.menuSoftkeyPressed(this.activeMenuPage, this.activeMenuPageId, cArray2);
                    } else {
                        this.setActiveMenuPage(n6);
                    }
                }
            } else if (this.wasKeyPressed(22) && (n4 = this.activeMenuPage.getSoftkeyTransition(cArray = this.getNegativeSoftkey())) != -3) {
                if (n4 == -2) {
                    this.activateCurrentMenuItem();
                } else if (n4 == -1) {
                    this.menuSoftkeyPressed(this.activeMenuPage, this.activeMenuPageId, cArray);
                } else {
                    this.setActiveMenuPage(n4);
                }
            }
        }
        if ((n3 = this.activeMenuPage.getTimeOut()) != -1 && System.currentTimeMillis() - this.elapsedTime > (long)n3) {
            this.menuPageTimedOut(this.activeMenuPage, this.activeMenuPageId);
        }
        if ((n2 = this.activeMenuPage.getTimer()) != -1 && this.timerElapsedTime > (long)n2) {
            this.timerElapsedTime -= (long)n2;
            this.menuPageTimerTicked(this.activeMenuPage, this.activeMenuPageId);
        }
    }

    private void activateCurrentMenuItem() {
        int n = this.activeMenuPage.getTransitions()[this.activeMenuPage.getSelectedItemPosition()];
        if (n != -3) {
            if (n == -1) {
                this.menuItemPressed(this.activeMenuPage, this.activeMenuPageId);
            } else {
                this.setActiveMenuPage(n);
            }
        }
    }

    public final int getActiveMenuPageId() {
        return this.activeMenuPageId;
    }

    public abstract char[][] wrapMenuText(char[] var1, char[][] var2, int var3, int var4, int var5);

    public abstract void menuItemPressed(MenuPage var1, int var2);

    public abstract void menuSoftkeyPressed(MenuPage var1, int var2, Object var3);

    public abstract void menuPageTimedOut(MenuPage var1, int var2);

    public abstract void menuPageTimerTicked(MenuPage var1, int var2);

    public abstract MenuPage menuPageChanged(int var1, int var2);

    public abstract void menuPageScrolled(MenuPage var1, int var2);

    public abstract void renderMenuPage(Graphics var1, MenuPage var2, int var3);

    public abstract void renderPauseMenuPage(Graphics var1, MenuPage var2, int var3);

    public abstract void initMenuRenderer();
}

