/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.spac;

import com.iplay.game.spac.SpacFile;
import javax.microedition.lcdui.Graphics;

public class SpacSprite {
    protected SpacFile spac;
    protected int x;
    protected int y;
    protected int frameIndex;
    protected int boundsX;
    protected int boundsY;
    protected int boundsWidth;
    protected int boundsHeight;
    protected boolean animated;
    protected boolean changed = true;
    protected int playbackMode;
    protected int nextPlaybackMode;
    protected int currentSequence;
    protected int nextSequence;
    protected int sequenceIndex;
    protected int nextStartFrame;
    protected int playbackDirection;
    private boolean animationComplete;
    public static final int SPRITE_PLAYBACK_NONE = -1;
    public static final int SPRITE_PLAYBACK_ONCE = 0;
    public static final int SPRITE_PLAYBACK_LOOP = 1;
    public static final int SPRITE_PLAYBACK_PINGPONG = 2;
    public static final int SPRITE_PLAYBACK_REVERSE_ONCE = 3;
    public static final int SPRITE_PLAYBACK_REVERSE_LOOP = 4;
    public static final int SPRITE_PLAYBACK_MODE_COUNT = 5;
    static final int SPRITE_NO_SEQUENCE = -1;
    private static final int SPRITE_PLAYBACK_FORWARD = 1;
    private static final int SPRITE_PLAYBACK_BACKWARD = -1;
    private static final int SPRITE_PLAYBACK_STOPPED = 0;
    private int currentFrameDuration;

    public SpacSprite(SpacFile spacFile, int n, boolean bl) {
        this.spac = spacFile;
        this.animated = bl;
        if (bl) {
            this.setSequence(n, 1, 0, true);
        } else {
            this.currentSequence = -1;
            this.setFrameIndex(n);
        }
        if (spacFile != null) {
            this.setPosition(0, 0);
        }
        this.animationComplete = false;
    }

    public final SpacFile getSpac() {
        return this.spac;
    }

    public final int getFrameIndex() {
        return this.frameIndex;
    }

    public final void setFrameIndex(int n) {
        this.frameIndex = n;
    }

    public final int getSequenceIndex() {
        return this.sequenceIndex;
    }

    public final int getSequence() {
        return this.currentSequence;
    }

    public final int getSpriteBoundsX() {
        return this.boundsX;
    }

    public final int getSpriteBoundsY() {
        return this.boundsY;
    }

    public final int getSpriteBoundsWidth() {
        return this.boundsWidth;
    }

    public final int getSpriteBoundsHeight() {
        return this.boundsHeight;
    }

    public final void setSpriteBoundsWidth(int n) {
        this.boundsWidth = n;
    }

    public final void setSpriteBoundsHeight(int n) {
        this.boundsHeight = n;
    }

    public final void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.updateBounds();
    }

    public final boolean hasChanged() {
        return this.changed;
    }

    public final void clearChanged() {
        this.changed = false;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final void updateBounds() {
        if (this.getSpac() != null) {
            short[] sArray = this.getSpac().getSpacData();
            int n = 3 + this.getFrameIndex() * 7;
            this.boundsX = this.x + sArray[n + 0];
            this.boundsY = this.y + sArray[n + 1];
            this.boundsWidth = sArray[n + 2];
            this.boundsHeight = sArray[n + 3];
        } else {
            this.boundsX = this.x;
            this.boundsY = this.y;
        }
    }

    public final boolean isAnimated() {
        return this.animated;
    }

    public final void setPlaybackMode(int n) {
        this.playbackMode = n;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.playbackDirection = 1;
                break;
            }
            case 3: 
            case 4: {
                this.playbackDirection = -1;
                break;
            }
            default: {
                this.playbackDirection = 0;
            }
        }
    }

    public final int getPlaybackMode() {
        return this.playbackMode;
    }

    public final void setSequence(int n, int n2, int n3, boolean bl) {
        this.setAnimationComplete(false);
        if (bl) {
            this.nextSequence = -1;
            this.currentSequence = n;
            this.sequenceIndex = n3;
            this.currentFrameDuration = 0;
            this.setPlaybackMode(n2);
            short[] sArray = this.spac.getSpacData();
            int n4 = SpacFile.getAnimationSequenceOffset(sArray);
            int n5 = n4 + this.currentSequence * 2;
            short s = sArray[n5 + 0];
            short s2 = sArray[s + n3 * 2 + 0];
            this.setFrameIndex(s2);
        } else {
            this.nextSequence = n;
            this.nextPlaybackMode = n2;
            this.nextStartFrame = n3;
        }
    }

    public final void renderSprite(Graphics graphics, int n, int n2) {
        this.spac.renderFrame(graphics, this.frameIndex, -1, n, n2);
    }

    public final void updateSprite(int n) {
        block11: {
            if (this.animated) {
                short s;
                this.currentFrameDuration += n;
                SpacFile spacFile = this.getSpac();
                short[] sArray = spacFile.getSpacData();
                int n2 = SpacFile.getAnimationSequenceOffset(sArray);
                int n3 = n2 + this.currentSequence * 2;
                short s2 = sArray[n3 + 1];
                short s3 = sArray[n3 + 0];
                int n4 = this.sequenceIndex;
                while (this.currentFrameDuration >= (s = sArray[s3 + n4 * 2 + 1])) {
                    n4 += this.playbackDirection;
                    boolean bl = false;
                    switch (this.playbackMode) {
                        case 0: {
                            if (n4 < s2) break;
                            n4 = s2 - 1;
                            bl = true;
                            this.setAnimationComplete(true);
                            break;
                        }
                        case 1: {
                            if (n4 < s2) break;
                            n4 = 0;
                            bl = true;
                            break;
                        }
                        case 2: {
                            if (n4 <= 0) {
                                n4 = 0;
                                this.playbackDirection = 1;
                                bl = true;
                                break;
                            }
                            if (n4 < s2 - 1) break;
                            n4 = s2 - 1;
                            this.playbackDirection = -1;
                            bl = true;
                            break;
                        }
                        case 3: {
                            if (n4 >= 0) break;
                            n4 = 0;
                            bl = true;
                            this.setAnimationComplete(true);
                            break;
                        }
                        case 4: {
                            if (n4 >= 0) break;
                            n4 = s2 - 1;
                            bl = true;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                    if (bl && this.nextSequence != -1) {
                        this.setSequence(this.nextSequence, this.nextPlaybackMode, this.nextStartFrame, true);
                        break block11;
                    }
                    this.currentFrameDuration -= s;
                }
                this.sequenceIndex = n4;
                s = sArray[sArray[n2 + this.currentSequence * 2 + 0] + n4 * 2 + 0];
                this.setFrameIndex(s);
                this.updateBounds();
            }
        }
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    private void setAnimationComplete(boolean bl) {
        this.animationComplete = bl;
    }

    public boolean isAnimationComplete() {
        return this.animationComplete;
    }

    public void reverseAnimation() {
        short[] sArray = this.getSpac().getSpacData();
        int n = SpacFile.getAnimationSequenceOffset(sArray);
        int n2 = n + this.currentSequence * 2;
        short s = sArray[n2 + 1];
        this.playbackDirection = -this.playbackDirection;
        switch (this.playbackMode) {
            case 0: {
                this.playbackMode = 3;
                this.frameIndex = s - 1;
                break;
            }
            case 1: {
                this.playbackMode = 4;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.playbackMode = 0;
                this.frameIndex = 0;
                break;
            }
            case 4: {
                this.playbackMode = 1;
                break;
            }
        }
    }
}

