/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.math;

public abstract class FixedPoint12 {
    public static final int PRECISION = 12;
    public static final int ZERO = 0;
    public static final int ONE = 4096;
    public static final int TWO = 8192;
    public static final int HALF = 2048;
    public static final int QUARTER = 1024;
    public static final int PI = 12867;
    public static final int E = 11134;
    public static final int PI_TIMES_2 = 25735;
    public static final int PI_OVER_2 = 6433;
    public static final int PI_OVER_4 = 3216;
    static final int SK1 = 31;
    static final int SK2 = 680;
    static final int CK1 = 145;
    static final int CK2 = 2034;
    static final int TK1 = 832;
    static final int TK2 = 1300;
    static final int AT1 = 85;
    static final int AT2 = 348;
    static final int AT3 = 737;
    static final int AT4 = 1352;
    static final int AT5 = 4095;
    static final int AS1 = -76;
    static final int AS2 = 304;
    static final int AS3 = 868;
    static final int AS4 = 6433;

    public static int toInt(int n) {
        return n >> 12;
    }

    public static String toString(int n) {
        return (n >> 12) + " + 0." + ((long)n << 20 >>> 12);
    }

    public static int toFixedPoint(int n) {
        return n << 12;
    }

    public static int toFixedPoint(String string) {
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        int n = 1;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (bl) {
                        n *= 10;
                        l2 *= 10L;
                        l2 += (long)(string.charAt(i) - 48);
                        continue block5;
                    }
                    l *= 10L;
                    l += (long)(string.charAt(i) - 48);
                    continue block5;
                }
                case '-': {
                    if (i != 0) {
                        return 0;
                    }
                    bl2 = true;
                    continue block5;
                }
                case ',': 
                case '.': {
                    if (bl) {
                        return 0;
                    }
                    bl = true;
                    continue block5;
                }
                default: {
                    return 0;
                }
            }
        }
        int n2 = (int)(l << 12 | (l2 << 12) / (long)n);
        if (bl2) {
            n2 = -n2;
        }
        return n2;
    }

    public static int multiply(int n, int n2) {
        return (int)((long)n * (long)n2 >> 12);
    }

    public static int divide(int n, int n2) {
        long l = (long)n << 24;
        return (int)(l / (long)n2 >> 12);
    }

    public static int modulus(int n, int n2) {
        int n3 = FixedPoint12.divide(n, n2);
        n3 >>= 12;
        n3 <<= 12;
        n3 = FixedPoint12.multiply(n3, n2);
        n3 = n - n3;
        return n3;
    }

    public static int sqrt(int n) {
        int n2 = n + 4096 >> 1;
        for (int i = 0; i < 8; ++i) {
            n2 = n2 + FixedPoint12.divide(n, n2) >> 1;
        }
        return n2;
    }

    public static int round(int n) {
        if (n > 0) {
            if ((n & 0x800) != 0) {
                return n + 4096 >> 12 << 12;
            }
            return n >> 12 << 12;
        }
        int n2 = ((n = -n) & 0x800) != 0 ? n + 12 >> 12 << 12 : n >> 12 << 12;
        return -n2;
    }

    public static int sin(int n) {
        n = FixedPoint12.modulus(n, 25734);
        int n2 = 1;
        if (n > 6433 && n <= 12867) {
            n = 12867 - n;
        } else if (n > 12867 && n <= 19300) {
            n -= 12867;
            n2 = -1;
        } else if (n > 19300) {
            n = 25734 - n;
            n2 = -1;
        }
        int n3 = FixedPoint12.multiply(n, n);
        int n4 = 31;
        n4 = FixedPoint12.multiply(n4, n3);
        n4 -= 680;
        n4 = FixedPoint12.multiply(n4, n3);
        n4 += 4096;
        n4 = FixedPoint12.multiply(n4, n);
        return n2 * n4;
    }

    public static int cos(int n) {
        n = FixedPoint12.modulus(n, 25734);
        int n2 = 1;
        if (n > 6433 && n <= 12867) {
            n = 12867 - n;
            n2 = -1;
        } else if (n > 6433 && n <= 19300) {
            n -= 12867;
            n2 = -1;
        } else if (n > 19300) {
            n = 25734 - n;
        }
        int n3 = FixedPoint12.multiply(n, n);
        int n4 = 145;
        n4 = FixedPoint12.multiply(n4, n3);
        n4 -= 2034;
        n4 = FixedPoint12.multiply(n4, n3);
        return (n4 += 4096) * n2;
    }

    public static int tan(int n) {
        int n2 = FixedPoint12.multiply(n, n);
        int n3 = 832;
        n3 = FixedPoint12.multiply(n3, n2);
        n3 += 1300;
        n3 = FixedPoint12.multiply(n3, n2);
        n3 += 4096;
        n3 = FixedPoint12.multiply(n3, n);
        return n3;
    }

    public static int arcTan(int n) {
        int n2 = FixedPoint12.multiply(n, n);
        int n3 = 85;
        n3 = FixedPoint12.multiply(n3, n2);
        n3 -= 348;
        n3 = FixedPoint12.multiply(n3, n2);
        n3 += 737;
        n3 = FixedPoint12.multiply(n3, n2);
        n3 -= 1352;
        n3 = FixedPoint12.multiply(n3, n2);
        n3 += 4095;
        n3 = FixedPoint12.multiply(n3, n);
        return n3;
    }

    public static int arcSin(int n) {
        int n2 = FixedPoint12.sqrt(4096 - n);
        int n3 = -76;
        n3 = FixedPoint12.multiply(n3, n);
        n3 += 304;
        n3 = FixedPoint12.multiply(n3, n);
        n3 -= 868;
        n3 = FixedPoint12.multiply(n3, n);
        n3 += 6433;
        n3 = 6433 - FixedPoint12.multiply(n2, n3);
        return n3;
    }

    public static int arcCos(int n) {
        int n2 = FixedPoint12.sqrt(4096 - n);
        int n3 = -76;
        n3 = FixedPoint12.multiply(n3, n);
        n3 += 304;
        n3 = FixedPoint12.multiply(n3, n);
        n3 -= 868;
        n3 = FixedPoint12.multiply(n3, n);
        n3 += 6433;
        n3 = FixedPoint12.multiply(n2, n3);
        return n3;
    }
}

