/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.spac;

import com.iplay.game.AbstractData;
import com.iplay.game.PackHandler;
import com.iplay.game.image.TransformableImage;
import com.iplay.game.spac.SpacUtils;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public final class SpacFile
extends AbstractData {
    private static final int NUM_SECTIONS_FLAG_OFFSET = 0;
    private static final int SECTION_POSITION_FLAG_OFFSET = 2;
    private static final int SECTION_DIMENSION_FLAG_OFFSET = 4;
    private static final int NUM_FRAMES_FLAG_OFFSET = 6;
    private static final int FRAME_BOUNDS_POSITION_FLAG_OFFSET = 8;
    private static final int FRAME_BOUNDS_DIMENSION_FLAG_OFFSET = 10;
    private static final int FRAME_SECTION_COUNT_FLAG_OFFSET = 12;
    private static final int FRAME_SECTION_POSITION_FLAG_OFFSET = 14;
    public static final int HINT_TRANS_NONE = 1;
    public static final int HINT_TRANS_ROT90 = 2;
    public static final int HINT_TRANS_ROT180 = 4;
    public static final int HINT_TRANS_ROT270 = 8;
    public static final int HINT_TRANS_MIRROR = 16;
    public static final int HINT_TRANS_MIRROR_ROT90 = 32;
    public static final int HINT_TRANS_MIRROR_ROT180 = 64;
    public static final int HINT_TRANS_MIRROR_ROT270 = 128;
    public static final int HINT_TRANS_ALL = 255;
    public static final int STRUCT_ANIMATION_SEQUENCE_INDEX_SHIFT = 0;
    public static final int STRUCT_ANIMATION_SEQUENCE_FRAMEID_SHIFT = 32;
    public static final int RENDER_NONE = 0;
    public static final int RENDER_SUCCESS = 1;
    public static final int RENDER_FAILED = 2;
    public static final int RENDER_PARTIAL = 3;
    private static final boolean NEW_SPAC_VERSION = true;
    public static final int RECT_SIZE = 4;
    public static final int RECT_X = 0;
    public static final int RECT_Y = 1;
    public static final int RECT_W = 2;
    public static final int RECT_H = 3;

    SpacFile(short[] sArray, int[] nArray, TransformableImage[] transformableImageArray) {
        super(3);
        this.setData(0, sArray);
        this.setData(1, nArray);
        this.setData(2, transformableImageArray);
    }

    public static int getAnimationFrameOffset(short[] sArray) {
        return 3;
    }

    public static int getAnimationSequenceOffset(short[] sArray) {
        return 3 + sArray[1] * 7;
    }

    public static int getImageSectionOffset(short[] sArray) {
        return 3 + sArray[1] * 7 + sArray[2] * 2;
    }

    public static long getAnimationSequenceIndexAndFrame(short[] sArray, int n, int n2) {
        int n3 = SpacFile.getAnimationSequenceOffset(sArray) + n * 2;
        short s = sArray[n3 + 1];
        n2 = (n2 % s + s) % s;
        short s2 = sArray[sArray[n3 + 0] + n2 * 2 + 0];
        return (long)n2 | (long)s2 << 32;
    }

    public short[] getSpacData() {
        return (short[])this.getData(0);
    }

    public TransformableImage[] getSourceImages() {
        return (TransformableImage[])this.getData(2);
    }

    public int[] getSourceImageTransforms() {
        return (int[])this.getData(1);
    }

    public int renderFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        short s;
        short[] sArray = this.getSpacData();
        int n7 = 0;
        if (n2 == -1) {
            n2 = n;
        }
        if ((s = sArray[(n6 = (n5 = SpacFile.getAnimationFrameOffset(sArray)) + n * 7) + 4]) != -1) {
            n7 |= this.renderFrame(graphics, s, n2, n3, n4);
        }
        short s2 = sArray[n6 + 5];
        int n8 = sArray[n6 + 6];
        TransformableImage[] transformableImageArray = this.getSourceImages();
        int n9 = SpacFile.getImageSectionOffset(sArray);
        for (int i = 0; i < n8; ++i) {
            int n10 = s2 + i * 4;
            short s3 = sArray[n10 + 3];
            short s4 = sArray[n10 + 0];
            int n11 = n9 + s4 * 5;
            short s5 = sArray[n11 + 1];
            short s6 = sArray[n11 + 2];
            short s7 = sArray[n11 + 3];
            short s8 = sArray[n11 + 4];
            short s9 = sArray[n11 + 0];
            TransformableImage transformableImage = transformableImageArray[s9];
            int n12 = sArray[n10 + 1] + n3;
            int n13 = sArray[n10 + 2] + n4;
            if (transformableImage != null) {
                n7 |= 1;
                transformableImage.drawImage(graphics, s5, s6, s7, s8, s3, n12, n13);
                continue;
            }
            n7 |= 2;
        }
        return n7;
    }

    public static SpacFile loadSpac(String string, String string2, short[] sArray) {
        return SpacFile.loadSpac(string, string2, sArray, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpacFile loadSpac(String string, String string2, short[] sArray, int n, int[] nArray) {
        SpacFile spacFile = null;
        try {
            int n2;
            int n3 = 0;
            if (string2 != null && string2.length() != 0) {
                n3 = 1;
                int n4 = -1;
                while ((n4 = string2.indexOf(44, n4 + 1)) != -1) {
                    ++n3;
                }
            }
            TransformableImage[] transformableImageArray = n > 0 ? (n > 0 ? new TransformableImage[n] : null) : (n3 != 0 ? new TransformableImage[n3] : null);
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                n2 = string2.indexOf(44, n5);
                if (n2 == -1) {
                    n2 = string2.length();
                }
                String string3 = string2.substring(n5, n2);
                n5 = n2 + 1;
                try {
                    System.gc();
                    if (n > 0 && nArray != null) {
                        if (n == n3) {
                            if (nArray[n6] != i) continue;
                            transformableImageArray[nArray[n6++]] = new TransformableImage(string3);
                            if (n6 < nArray.length) continue;
                            break;
                        }
                        transformableImageArray[nArray[i]] = new TransformableImage(string3);
                        continue;
                    }
                    transformableImageArray[i] = new TransformableImage(string3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DataInputStream dataInputStream = PackHandler.getResourceAsDataStream(string);
            try {
                short s;
                short s2;
                int n7;
                int n8;
                int n9;
                n2 = SpacUtils.read(dataInputStream, 1);
                if (sArray == null) {
                    sArray = new short[3 + n2];
                }
                short s3 = SpacUtils.read(dataInputStream, 1);
                int[] nArray2 = n > 0 ? (n != 0 ? new int[n] : null) : (n3 != 0 ? new int[n3] : null);
                int n10 = s3 >>> 0 & 3;
                int n11 = SpacUtils.read(dataInputStream, n10);
                sArray[0] = (short)n11;
                int n12 = s3 >>> 6 & 3;
                int n13 = SpacUtils.read(dataInputStream, n12);
                sArray[1] = (short)n13;
                int n14 = dataInputStream.readUnsignedShort();
                sArray[2] = (short)n14;
                int n15 = s3 >>> 2 & 3;
                int n16 = s3 >>> 4 & 3;
                int n17 = n9 = 3 + 7 * n13 + 2 * n14;
                for (n8 = 0; n8 < n11; ++n8) {
                    sArray[n9++] = SpacUtils.read(dataInputStream, 0);
                    sArray[n9++] = SpacUtils.read(dataInputStream, n15);
                    sArray[n9++] = SpacUtils.read(dataInputStream, n15);
                    sArray[n9++] = SpacUtils.read(dataInputStream, n16);
                    sArray[n9++] = SpacUtils.read(dataInputStream, n16);
                }
                n8 = s3 >>> 12 & 3;
                int n18 = s3 >>> 8 & 3;
                int n19 = s3 >>> 10 & 3;
                int n20 = s3 >>> 14 & 3;
                int n21 = 3;
                boolean bl = dataInputStream.readBoolean();
                for (n7 = 0; n7 < n13; ++n7) {
                    s2 = SpacUtils.read(dataInputStream, n8);
                    sArray[n21++] = bl ? SpacUtils.read(dataInputStream, n18) : (short)0;
                    sArray[n21++] = bl ? SpacUtils.read(dataInputStream, n18) : (short)0;
                    sArray[n21++] = bl ? SpacUtils.read(dataInputStream, n19) : (short)0;
                    sArray[n21++] = bl ? SpacUtils.read(dataInputStream, n19) : (short)0;
                    sArray[n21++] = (short)(SpacUtils.read(dataInputStream, n12) - 1);
                    sArray[n21++] = (short)n9;
                    sArray[n21++] = s2;
                    for (s = 0; s < s2; s = (short)(s + 1)) {
                        short s4 = SpacUtils.read(dataInputStream, n10);
                        sArray[n9++] = s4;
                        sArray[n9++] = SpacUtils.read(dataInputStream, n20);
                        sArray[n9++] = SpacUtils.read(dataInputStream, n20);
                        short s5 = SpacUtils.read(dataInputStream, 0);
                        short s6 = sArray[n17 + s4 * 5 + 0];
                        if (nArray2 != null) {
                            short s7 = s6;
                            nArray2[s7] = nArray2[s7] | s5;
                        }
                        short s8 = (short)SpacFile.convertFlagToTransform(s5);
                        sArray[n9++] = s8;
                    }
                }
                for (n7 = 0; n7 < n14; ++n7) {
                    s2 = SpacUtils.read(dataInputStream, 1);
                    sArray[n21++] = (short)n9;
                    sArray[n21++] = s2;
                    for (s = 0; s < s2; s = (short)(s + 1)) {
                        sArray[n9++] = (short)(SpacUtils.read(dataInputStream, n12) - 1);
                        sArray[n9++] = SpacUtils.read(dataInputStream, 1);
                    }
                }
                nArray2 = null;
                spacFile = new SpacFile(sArray, nArray2, transformableImageArray);
            }
            finally {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return spacFile;
    }

    public static final int convertFlagToTransform(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 2: {
                return 5;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 6;
            }
            case 16: {
                return 2;
            }
            case 32: {
                return 7;
            }
            case 64: {
                return 1;
            }
            case 128: 
        }
        return 4;
    }

    public final int[] getFrameRect(int n) {
        int[] nArray = new int[4];
        short[] sArray = this.getSpacData();
        int n2 = SpacFile.getAnimationFrameOffset(sArray);
        int n3 = n2 + n * 7;
        nArray[0] = sArray[n3 + 0];
        nArray[1] = sArray[n3 + 1];
        nArray[2] = sArray[n3 + 2];
        nArray[3] = sArray[n3 + 3];
        return nArray;
    }

    public static final class Field {
        private static final int COUNT = 3;

        public static final class SourceImages {
            private static final int OFFSET = 2;
        }

        public static final class SpriteTransforms {
            public static final int OFFSET = 1;
        }

        public static final class Data {
            public static final int OFFSET = 0;

            public static final class HeaderInfo {
                public static final int IMAGE_SECTION_COUNT = 0;
                public static final int ANIMATION_FRAME_COUNT = 1;
                public static final int ANIMATION_SEQUENCE_COUNT = 2;
                public static final int SIZEOF = 3;
            }
        }
    }
}

