/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.game.util;

public final class TimerHandler {
    private static long[] timerOffsets;
    private static long[] timerPause;

    public static void initTimers(int n) {
        timerOffsets = new long[n];
        timerPause = new long[n];
    }

    public static final long getTimer(int n) {
        if (timerPause[n] == 0L) {
            return System.currentTimeMillis() - timerOffsets[n];
        }
        return timerPause[n] - timerOffsets[n];
    }

    public static final void setTimer(int n, long l) {
        TimerHandler.timerOffsets[n] = System.currentTimeMillis() - l;
    }

    public static final void pauseTimer(int n) {
        if (timerPause != null && timerPause[n] == 0L) {
            TimerHandler.timerPause[n] = System.currentTimeMillis();
        }
    }

    public static final void resumeTimer(int n) {
        if (timerPause != null && timerPause[n] != 0L) {
            long l = System.currentTimeMillis() - timerPause[n];
            int n2 = n;
            timerOffsets[n2] = timerOffsets[n2] + l;
            TimerHandler.timerPause[n] = 0L;
        }
    }

    public static final void resetTimer(int n) {
        TimerHandler.timerOffsets[n] = System.currentTimeMillis();
        TimerHandler.timerPause[n] = 0L;
    }

    public static final void interrupt(long l, long l2) {
        if (timerOffsets != null) {
            for (int i = 0; i < timerOffsets.length; ++i) {
                int n = i;
                timerOffsets[n] = timerOffsets[n] + l2;
                if (timerPause[i] == 0L) continue;
                if (l < timerPause[i]) {
                    TimerHandler.timerPause[i] = l + l2;
                    continue;
                }
                int n2 = i;
                timerPause[n2] = timerPause[n2] + l2;
            }
        }
    }
}

