/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.framework;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestResult;
import java.util.Enumeration;
import java.util.Vector;

public class TestSuite
implements Test {
    private String fName;
    private Vector fTests = new Vector(10);

    public TestSuite() {
    }

    public TestSuite(String string) {
        this.fName = string;
    }

    public TestSuite(Test test) {
        this.addTest(test);
    }

    public TestSuite(Test[] testArray) {
        for (int i = 0; i < testArray.length; ++i) {
            this.addTest(testArray[i]);
        }
    }

    public TestSuite(Class clazz, String[] stringArray) {
        this(clazz.getName());
        for (int i = 0; i < stringArray.length; ++i) {
            TestCase testCase = null;
            try {
                testCase = (TestCase)clazz.newInstance();
            }
            catch (Exception exception) {
                String string = "Need to have public default constructor in " + clazz.getName();
                System.out.println(string);
                throw new RuntimeException(string);
            }
            testCase.setName(stringArray[i]);
            this.addTest(testCase);
        }
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    public int countTestCases() {
        int n = 0;
        int n2 = this.fTests.size();
        for (int i = 0; i < n2; ++i) {
            n += ((Test)this.fTests.elementAt(i)).countTestCases();
        }
        return n;
    }

    public int countTestSteps() {
        int n = 0;
        int n2 = this.fTests.size();
        for (int i = 0; i < n2; ++i) {
            n += ((Test)this.fTests.elementAt(i)).countTestSteps();
        }
        return n;
    }

    public void run(TestResult testResult) {
        Enumeration enumeration = this.tests();
        while (enumeration.hasMoreElements() && !testResult.shouldStop()) {
            Test test = (Test)enumeration.nextElement();
            test.run(testResult);
        }
    }

    public Test testAt(int n) {
        return (Test)this.fTests.elementAt(n);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.fName != null) {
            return this.fName;
        }
        return super.toString();
    }

    private Test warning(final String string) {
        return new TestCase("warning"){

            protected void runTest() {
                this.fail(string);
            }
        };
    }
}

