/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;

public class GUtillIo {
    private static DataInputStream dis;
    private static ByteArrayOutputStream baos;
    private static DataOutputStream dos;

    public static void initRead(String fileName) throws Exception {
        dis = new DataInputStream(((Object)((Object)M.getInstance())).getClass().getResourceAsStream(fileName));
    }

    public static void initRead(byte[] bArray) {
        dis = new DataInputStream(new ByteArrayInputStream(bArray));
    }

    public static DataInputStream getInputStream() {
        return dis;
    }

    public static boolean fileExist(String fileName) {
        boolean result = false;
        try {
            InputStream is = ((Object)((Object)M.mInstance)).getClass().getResourceAsStream(fileName);
            if (is != null) {
                result = true;
                is.close();
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static void closeRead() throws Exception {
        dis.close();
    }

    public static void skip(long length) throws Exception {
        dis.skip(length);
    }

    public static boolean isEOF() throws Exception {
        return dis.available() == 0;
    }

    public static void read(byte[] array) throws Exception {
        dis.read(array, 0, array.length);
    }

    public static void read(byte[] array, int offset, int length) throws Exception {
        dis.read(array, offset, length);
    }

    public static void read(int[] array) throws Exception {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            array[i] = dis.readInt();
        }
    }

    public static void read(short[] array) throws Exception {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            array[i] = dis.readShort();
        }
    }

    public static boolean readBoolean() throws Exception {
        return dis.readBoolean();
    }

    public static byte readByte() throws Exception {
        return dis.readByte();
    }

    public static int readInt() throws Exception {
        return dis.readInt();
    }

    public static short readShort() throws Exception {
        return dis.readShort();
    }

    public static long readLong() throws Exception {
        return dis.readLong();
    }

    public static int readUnsignedShort() throws Exception {
        return dis.readUnsignedShort();
    }

    public static String readString() throws Exception {
        char[] str = new char[dis.readByte()];
        for (int i = 0; i < str.length; ++i) {
            str[i] = (char)dis.readByte();
        }
        return String.valueOf(str);
    }

    public static final String readLine() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean lineEnd = false;
        while (!lineEnd) {
            int c1 = dis.read();
            int c2 = dis.read();
            if (c1 == -1 || c2 == -1) {
                lineEnd = true;
                continue;
            }
            int code = (c2 & 0xFF) << 8 | c1 & 0xFF;
            char c = (char)code;
            buf.append(c);
            if (code == 13 || code != 10) continue;
            lineEnd = true;
        }
        return buf.toString();
    }

    public static int readUnsignedByte() throws Exception {
        return dis.readUnsignedByte();
    }

    public static boolean[] readBooleanArray() throws Exception {
        int length = dis.readInt();
        boolean[] result = new boolean[length];
        for (int i = 0; i < length; ++i) {
            result[i] = dis.readBoolean();
        }
        return result;
    }

    public static void readBooleanArray(boolean[] array) throws Exception {
        int length = dis.readInt();
        for (int i = 0; i < length; ++i) {
            array[i] = dis.readBoolean();
        }
    }

    public static byte[] readByteArray() throws Exception {
        int length = dis.readInt();
        return GUtillIo.readByteArray(length);
    }

    public static short[] readShortArray() throws Exception {
        byte length = dis.readByte();
        return GUtillIo.readShortArray(length);
    }

    public static int[] readUnsignedByteArray(int length) throws Exception {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = dis.readUnsignedByte();
        }
        return result;
    }

    public static byte[] readByteArray(int length) throws Exception {
        byte[] result = new byte[length];
        dis.read(result);
        return result;
    }

    public static short[] readShortArray(int length) throws Exception {
        short[] result = new short[length];
        for (int i = 0; i < length; ++i) {
            result[i] = dis.readShort();
        }
        return result;
    }

    public static int[] readIntArray() throws Exception {
        int length = dis.readInt();
        return GUtillIo.readIntArray(length);
    }

    public static int[] readIntArray(int length) throws Exception {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = dis.readInt();
        }
        return result;
    }

    public static long[] readLongArray() throws Exception {
        int length = dis.readByte();
        long[] result = new long[length];
        for (int i = 0; i < length; ++i) {
            result[i] = dis.readLong();
        }
        return result;
    }

    public static short[] readShiftedArray(int shift) throws Exception {
        int length = dis.readByte();
        short[] result = new short[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (short)(dis.readUnsignedByte() << shift);
        }
        return result;
    }

    public static void initWrite() {
        baos = new ByteArrayOutputStream();
        dos = new DataOutputStream(baos);
    }

    public static void closeWrite() throws Exception {
        dos.close();
        baos.close();
        System.gc();
    }

    public static void writeArray(byte[] value) throws Exception {
        dos.write(value);
    }

    public static void writeArray(int[] value) throws Exception {
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            dos.writeInt(value[i]);
        }
    }

    public static void writeArray(short[] value) throws Exception {
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            dos.writeShort(value[i]);
        }
    }

    public static void writeBoolean(boolean value) throws Exception {
        dos.writeBoolean(value);
    }

    public static void writeByte(byte value) throws Exception {
        dos.writeByte(value);
    }

    public static void writeInt(int value) throws Exception {
        dos.writeInt(value);
    }

    public static void writeShort(short value) throws Exception {
        dos.writeShort(value);
    }

    public static void writeLong(long value) throws Exception {
        dos.writeLong(value);
    }

    public static void writeBooleanArray(boolean[] array) throws Exception {
        dos.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            dos.writeBoolean(array[i]);
        }
    }

    public static void writeByteArray(byte[] array) throws Exception {
        dos.writeInt(array.length);
        dos.write(array);
    }

    public static void writeShortArray(short[] array) throws Exception {
        dos.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            dos.writeShort(array[i]);
        }
    }

    public static void writeIntArray(int[] array) throws Exception {
        dos.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            dos.writeInt(array[i]);
        }
    }

    public static void writeLongArray(long[] array) throws Exception {
        dos.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            dos.writeLong(array[i]);
        }
    }

    public static byte[] toByteArray() {
        return baos.toByteArray();
    }

    public static int getOutputSize() {
        int size = baos != null ? baos.size() : 0;
        return size;
    }

    public static int getInputSize() {
        int size;
        try {
            size = dis.available();
        }
        catch (Exception e) {
            size = 0;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getRsData(String uid) {
        RecordStore rs = null;
        byte[] result = null;
        if (GUtillIo.hasData(uid)) {
            try {
                byte[] a;
                rs = RecordStore.openRecordStore((String)uid, (boolean)false);
                result = a = rs.getRecord(1);
            }
            catch (Exception e) {
            }
            finally {
                if (rs != null) {
                    try {
                        rs.closeRecordStore();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveRsData(String uid, byte[] data) {
        GUtillIo.deleteData(uid);
        RecordStore rs = null;
        if (data != null) {
            try {
                rs = RecordStore.openRecordStore((String)uid, (boolean)true);
                rs.addRecord(data, 0, data.length);
            }
            catch (Exception e) {
            }
            finally {
                if (rs != null) {
                    try {
                        rs.closeRecordStore();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private static void deleteData(String uid) {
        if (GUtillIo.hasData(uid)) {
            try {
                RecordStore.deleteRecordStore((String)uid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean hasData(String uid) {
        boolean result = false;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)uid, (boolean)false);
            rs.closeRecordStore();
            result = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

