/*
 * Decompiled with CFR 0.152.
 */
package xqwlight;

import xqwlight.Position;

public class Search {
    public static final int[] SHELL_STEP;
    public static final int HASH_SIZE = 4096;
    public static final int HASH_ALPHA = 1;
    public static final int HASH_BETA = 2;
    public static final int HASH_PV = 3;
    public static final int LIMIT_DEPTH = 64;
    public static final int NULL_DEPTH = 2;
    public static final int MAX_GEN_MOVES = 128;
    public static final int MATE_VALUE = 1000;
    public static final int WIN_VALUE = 900;
    public static final int UNKNOWN_VALUE = 1001;
    public Position pos;
    public int allNodes;
    public int mvResult;
    public int[] historyTable = new int[4096];
    public int[][] mvKiller = new int[64][2];
    public HashItem[] hashTable = new HashItem[4096];

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 13;
        nArray[4] = 40;
        nArray[5] = 121;
        nArray[6] = 364;
        nArray[7] = 1093;
        SHELL_STEP = nArray;
    }

    public Search() {
        int i = 0;
        while (i < 4096) {
            this.hashTable[i] = new HashItem();
            ++i;
        }
    }

    public static void shellSort(int[] mvs, int[] vls, int from, int to) {
        int stepLevel = 1;
        while (SHELL_STEP[stepLevel] < to - from) {
            ++stepLevel;
        }
        --stepLevel;
        while (stepLevel > 0) {
            int step = SHELL_STEP[stepLevel];
            int i = from + step;
            while (i < to) {
                int mvBest = mvs[i];
                int vlBest = vls[i];
                int j = i - step;
                while (j >= from && vlBest > vls[j]) {
                    mvs[j + step] = mvs[j];
                    vls[j + step] = vls[j];
                    j -= step;
                }
                mvs[j + step] = mvBest;
                vls[j + step] = vlBest;
                ++i;
            }
            --stepLevel;
        }
    }

    public HashItem getHashItem() {
        return this.hashTable[this.pos.zobristKey & 0xFFF];
    }

    public int probeHash(int vlAlpha, int vlBeta, int depth, int[] mv) {
        HashItem hash = this.getHashItem();
        if (hash.zobristLock != this.pos.zobristLock) {
            return 1001;
        }
        mv[0] = hash.mv;
        boolean mate = false;
        if (hash.vl > 900) {
            hash.vl = (short)(hash.vl - this.pos.distance);
            mate = true;
        } else if (hash.vl < -900) {
            hash.vl = (short)(hash.vl + this.pos.distance);
            mate = true;
        }
        if (hash.depth >= depth || mate) {
            if (hash.flag == 2) {
                return hash.vl >= vlBeta ? (int)hash.vl : 1001;
            }
            if (hash.flag == 1) {
                return hash.vl <= vlAlpha ? (int)hash.vl : 1001;
            }
            return hash.vl;
        }
        return 1001;
    }

    public void recordHash(int flag, int vl, int depth, int mv) {
        HashItem hash = this.getHashItem();
        if (hash.depth > depth) {
            return;
        }
        hash.flag = (byte)flag;
        hash.depth = (byte)depth;
        hash.vl = vl > 900 ? (short)(vl + this.pos.distance) : (vl < -900 ? (short)(vl - this.pos.distance) : (short)vl);
        hash.mv = mv;
        hash.zobristLock = this.pos.zobristLock;
    }

    public int searchQuiesc(int vlAlpha, int vlBeta) {
        int i;
        int[] vls;
        int genMoves;
        ++this.allNodes;
        int vl = this.pos.mateValue();
        if (vl >= vlBeta) {
            return vl;
        }
        int vlRep = this.pos.repStatus();
        if (vlRep > 0) {
            return this.pos.repValue(vlRep);
        }
        if (this.pos.distance == 64) {
            return this.pos.evaluate();
        }
        int vlBest = -1000;
        int vlAlphaLocal = vlAlpha;
        int[] mvs = new int[128];
        if (this.pos.inCheck()) {
            genMoves = this.pos.generateAllMoves(mvs);
            vls = new int[128];
            i = 0;
            while (i < genMoves) {
                vls[i] = this.historyTable[this.pos.historyIndex(mvs[i])];
                ++i;
            }
            Search.shellSort(mvs, vls, 0, genMoves);
        } else {
            vl = this.pos.evaluate();
            if (vl > vlBest) {
                if (vl >= vlBeta) {
                    return vl;
                }
                vlBest = vl;
                vlAlphaLocal = Math.max(vl, vlAlphaLocal);
            }
            vls = new int[128];
            genMoves = this.pos.generateMoves(mvs, vls);
            Search.shellSort(mvs, vls, 0, genMoves);
            i = 0;
            while (i < genMoves) {
                if (vls[i] < 10 || vls[i] < 20 && Position.HOME_HALF(Position.DST(mvs[i]), this.pos.sdPlayer)) {
                    genMoves = i;
                    break;
                }
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < genMoves) {
            if (this.pos.makeMove(mvs[i2])) {
                vl = -this.searchQuiesc(-vlBeta, -vlAlphaLocal);
                this.pos.undoMakeMove();
                if (vl > vlBest) {
                    if (vl >= vlBeta) {
                        return vl;
                    }
                    vlBest = vl;
                    vlAlphaLocal = Math.max(vl, vlAlphaLocal);
                }
            }
            ++i2;
        }
        return vlBest == -1000 ? this.pos.mateValue() : vlBest;
    }

    public int searchNoNull(int vlAlpha, int vlBeta, int depth) {
        return this.searchFull(vlAlpha, vlBeta, depth, true);
    }

    public int searchFull(int vlAlpha, int vlBeta, int depth) {
        return this.searchFull(vlAlpha, vlBeta, depth, false);
    }

    public int searchFull(int vlAlpha, int vlBeta, int depth, boolean noNull) {
        int mv;
        int vl;
        int[] mvHash = new int[1];
        if (this.pos.distance > 0) {
            if (depth <= 0) {
                return this.searchQuiesc(vlAlpha, vlBeta);
            }
            ++this.allNodes;
            vl = this.pos.mateValue();
            if (vl >= vlBeta) {
                return vl;
            }
            int vlRep = this.pos.repStatus();
            if (vlRep > 0) {
                return this.pos.repValue(vlRep);
            }
            vl = this.probeHash(vlAlpha, vlBeta, depth, mvHash);
            if (vl != 1001) {
                return vl;
            }
            if (this.pos.distance == 64) {
                return this.pos.evaluate();
            }
            if (!noNull && !this.pos.inCheck() && this.pos.nullOkay()) {
                this.pos.nullMove();
                vl = -this.searchNoNull(-vlBeta, 1 - vlBeta, depth - 2 - 1);
                this.pos.undoNullMove();
                if (vl >= vlBeta && this.pos.nullSafe() && this.searchNoNull(vlAlpha, vlBeta, depth) >= vlBeta) {
                    return vl;
                }
            }
        }
        int hashFlag = 1;
        int vlBest = -1000;
        int vlAlphaLocal = vlAlpha;
        int mvBest = 0;
        SortItem sort = new SortItem(mvHash[0]);
        while ((mv = sort.next()) > 0) {
            int newDepth;
            if (!this.pos.makeMove(mv)) continue;
            int n = newDepth = this.pos.inCheck() ? depth : depth - 1;
            if (vlBest == -1000) {
                vl = -this.searchFull(-vlBeta, -vlAlphaLocal, newDepth);
            } else {
                vl = -this.searchFull(-vlAlphaLocal - 1, -vlAlphaLocal, newDepth);
                if (vl > vlAlphaLocal && vl < vlBeta) {
                    vl = -this.searchFull(-vlBeta, -vlAlphaLocal, newDepth);
                }
            }
            this.pos.undoMakeMove();
            if (vl <= vlBest) continue;
            vlBest = vl;
            if (vl >= vlBeta) {
                hashFlag = 2;
                mvBest = mv;
                break;
            }
            if (vl <= vlAlphaLocal) continue;
            vlAlphaLocal = vl;
            hashFlag = 3;
            mvBest = mv;
        }
        if (this.pos.distance == 0) {
            this.mvResult = mvBest;
        }
        if (vlBest == -1000) {
            return this.pos.mateValue();
        }
        this.recordHash(hashFlag, vlBest, depth, mvBest);
        if (mvBest > 0) {
            int n = this.pos.historyIndex(mvBest);
            this.historyTable[n] = this.historyTable[n] + depth * depth;
            int[] killers = this.mvKiller[this.pos.distance];
            if (killers[0] != mvBest) {
                killers[1] = killers[0];
                killers[0] = mvBest;
            }
        }
        return vlBest;
    }

    public void searchMain(int seconds) {
        this.mvResult = this.pos.bookMove();
        if (this.mvResult > 0) {
            this.pos.makeMove(this.mvResult);
            if (this.pos.repStatus(3) == 0) {
                this.pos.undoMakeMove();
                return;
            }
            this.pos.undoMakeMove();
        }
        int vl = 0;
        int[] mvs = new int[128];
        int genMoves = this.pos.generateAllMoves(mvs);
        int i = 0;
        while (i < genMoves) {
            if (this.pos.makeMove(mvs[i])) {
                this.pos.undoMakeMove();
                this.mvResult = mvs[i];
                ++vl;
            }
            ++i;
        }
        if (vl == 1) {
            return;
        }
        i = 0;
        while (i < 4096) {
            HashItem hash = this.hashTable[i];
            hash.flag = 0;
            hash.depth = 0;
            hash.vl = 0;
            hash.zobristLock = 0;
            hash.mv = 0;
            ++i;
        }
        i = 0;
        while (i < 64) {
            this.mvKiller[i][1] = 0;
            this.mvKiller[i][0] = 0;
            ++i;
        }
        i = 0;
        while (i < 4096) {
            this.historyTable[i] = 0;
            ++i;
        }
        this.pos.distance = 0;
        this.allNodes = 0;
        long timer = System.currentTimeMillis();
        int i2 = 1;
        while (i2 <= 64) {
            vl = this.searchFull(-1000, 1000, i2);
            if (vl > 900 || vl < -900 || System.currentTimeMillis() - timer > (long)(seconds * 1000)) break;
            ++i2;
        }
    }

    public static class HashItem {
        public byte depth;
        public byte flag;
        public short vl;
        public int mv;
        public int zobristLock;
    }

    public class SortItem {
        public static final int PHASE_HASH = 0;
        public static final int PHASE_KILLER_1 = 1;
        public static final int PHASE_KILLER_2 = 2;
        public static final int PHASE_GEN_MOVES = 3;
        public static final int PHASE_REST = 4;
        public int index;
        public int moves;
        public int phase;
        public int mvHash;
        public int mvKiller1;
        public int mvKiller2;
        public int[] mvs;
        public int[] vls;

        public SortItem(int mvHash) {
            this.mvHash = mvHash;
            this.mvKiller1 = Search.this.mvKiller[Search.this.pos.distance][0];
            this.mvKiller2 = Search.this.mvKiller[Search.this.pos.distance][1];
        }

        public int next() {
            if (this.phase == 0) {
                this.phase = 1;
                if (this.mvHash > 0) {
                    return this.mvHash;
                }
            }
            if (this.phase == 1) {
                this.phase = 2;
                if (this.mvKiller1 != this.mvHash && this.mvKiller1 > 0 && Search.this.pos.legalMove(this.mvKiller1)) {
                    return this.mvKiller1;
                }
            }
            if (this.phase == 2) {
                this.phase = 3;
                if (this.mvKiller2 != this.mvHash && this.mvKiller2 > 0 && Search.this.pos.legalMove(this.mvKiller2)) {
                    return this.mvKiller2;
                }
            }
            if (this.phase == 3) {
                this.phase = 4;
                this.mvs = new int[128];
                this.vls = new int[128];
                this.moves = Search.this.pos.generateAllMoves(this.mvs);
                int i = 0;
                while (i < this.moves) {
                    this.vls[i] = Search.this.historyTable[Search.this.pos.historyIndex(this.mvs[i])];
                    ++i;
                }
                Search.shellSort(this.mvs, this.vls, 0, this.moves);
                this.index = 0;
            }
            while (this.index < this.moves) {
                int mv = this.mvs[this.index];
                ++this.index;
                if (mv == this.mvHash || mv == this.mvKiller1 || mv == this.mvKiller2) continue;
                return mv;
            }
            return 0;
        }
    }
}

