/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends FullCanvas {
    private MSMidlet midlet;
    private final int BLOCK_COUNT;
    private int MAX_BOMBS;
    private int selX;
    private int selY;
    private int curX;
    private int curY;
    private int scale;
    private int[][] bombLocations;
    private Image[] image;
    private Block[][] block;
    private int openCount;
    private int gameOver;
    private int flagCount;

    GameCanvas(MSMidlet mSMidlet, int n) {
        this.BLOCK_COUNT = 10;
        this.midlet = mSMidlet;
        this.MAX_BOMBS = n;
        this.flagCount = n;
        this.selX = 4;
        this.selY = 4;
        this.curX = 1;
        this.curY = 1;
        this.scale = 12;
        this.gameOver = 0;
        this.openCount = 100 - this.MAX_BOMBS;
        this.bombLocations = new int[this.MAX_BOMBS + 1][2];
        this.block = new Block[12][12];
        int n2 = 0;
        while (n2 < 12) {
            int n3 = 0;
            while (n3 < 12) {
                this.block[n2][n3] = new Block();
                ++n3;
            }
            ++n2;
        }
        this.image = new Image[10];
        this.initImages();
        this.generateBombs();
        this.calcNeighbors();
    }

    private void initImages() {
        try {
            this.image[0] = Image.createImage((String)"/icons/block.png");
            this.image[1] = Image.createImage((String)"/icons/flag.png");
            this.image[2] = Image.createImage((String)"/icons/bomb.png");
            this.image[3] = Image.createImage((String)"/icons/empty.png");
            this.image[4] = Image.createImage((String)"/icons/n1.png");
            this.image[5] = Image.createImage((String)"/icons/n2.png");
            this.image[6] = Image.createImage((String)"/icons/n3.png");
            this.image[7] = Image.createImage((String)"/icons/n4.png");
            this.image[8] = Image.createImage((String)"/icons/n5.png");
            this.image[9] = Image.createImage((String)"/icons/n6.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void generateBombs() {
        Random random = new Random();
        int n = 1;
        while (n <= this.MAX_BOMBS) {
            int n2 = Math.abs(random.nextInt()) % 10 + 1;
            int n3 = Math.abs(random.nextInt()) % 10 + 1;
            while (this.block[n2][n3].isBomb()) {
                n2 = Math.abs(random.nextInt()) % 10 + 1;
                n3 = Math.abs(random.nextInt()) % 10 + 1;
            }
            this.block[n2][n3].setState(2);
            this.bombLocations[n][0] = n2;
            this.bombLocations[n][1] = n3;
            ++n;
        }
    }

    public void calcNeighbors() {
        int n = 1;
        while (n <= 10) {
            int n2 = 1;
            while (n2 <= 10) {
                int n3 = 3;
                if (!this.block[n][n2].isBomb()) {
                    int n4 = -1;
                    while (n4 <= 1) {
                        int n5 = -1;
                        while (n5 <= 1) {
                            if (this.block[n + n4][n2 + n5].isBomb()) {
                                ++n3;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    this.block[n][n2].setState(n3);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(145, 145, 145);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = 1;
        while (n <= 10) {
            int n2 = 1;
            while (n2 <= 10) {
                graphics.drawImage(this.getImage(n, n2), (n - 1) * 12 + 4, (n2 - 1) * 12 + 4, 0);
                ++n2;
            }
            ++n;
        }
        graphics.setColor(255, 0, 0);
        graphics.drawRect(this.selX, this.selY, this.scale, this.scale);
    }

    public Image getImage(int n, int n2) {
        if (this.block[n][n2].isFlagged()) {
            return this.image[1];
        }
        if (this.block[n][n2].isClosed()) {
            return this.image[0];
        }
        return this.image[this.block[n][n2].getState()];
    }

    public void keyPressed(int n) {
        if (this.gameOver == -1) {
            this.midlet.gameOver(false);
        } else if (this.gameOver == 1) {
            this.midlet.gameOver(true);
        } else if (n == -7) {
            this.midlet.mainMenu();
        } else if (n == -1 || n == 50) {
            if (this.selY > 4) {
                this.selY -= this.scale;
                --this.curY;
            } else {
                this.selY = 112;
                this.curY = 10;
            }
        } else if (n == -2 || n == 56) {
            if (this.selY < 112) {
                this.selY += this.scale;
                ++this.curY;
            } else {
                this.selY = 4;
                this.curY = 1;
            }
        } else if (n == -3 || n == 52) {
            if (this.selX > 4) {
                this.selX -= this.scale;
                --this.curX;
            } else {
                this.selX = 112;
                this.curX = 10;
            }
        } else if (n == -4 || n == 54) {
            if (this.selX < 112) {
                this.selX += this.scale;
                ++this.curX;
            } else {
                this.selX = 4;
                this.curX = 1;
            }
        } else if (n == 53) {
            this.open(this.curX, this.curY);
        } else if (n == 35) {
            if (this.block[this.curX][this.curY].isClosed() && !this.block[this.curX][this.curY].isFlagged() && this.flagCount > 0) {
                this.block[this.curX][this.curY].flag();
                --this.flagCount;
            } else if (this.block[this.curX][this.curY].isFlagged()) {
                this.block[this.curX][this.curY].flag();
                ++this.flagCount;
            }
        }
        this.repaint();
    }

    public void open(int n, int n2) {
        if (this.block[n][n2].isClosed()) {
            if (this.block[n][n2].isBomb() && !this.block[n][n2].isFlagged()) {
                this.showBombs();
                this.gameOver = -1;
            } else {
                this.openNeighbors(n, n2);
            }
        }
        if (this.openCount <= 0) {
            this.gameOver = 1;
        }
    }

    public void showBombs() {
        int n = 1;
        while (n <= this.MAX_BOMBS) {
            this.block[this.bombLocations[n][0]][this.bombLocations[n][1]].open();
            ++n;
        }
    }

    public void openNeighbors(int n, int n2) {
        if (n >= 1 && n <= 10 && n2 >= 1 && n2 <= 10) {
            if (this.block[n][n2].getState() == 3 && this.block[n][n2].isClosed()) {
                this.block[n][n2].open();
                --this.openCount;
                this.openNeighbors(n - 1, n2 - 1);
                this.openNeighbors(n, n2 - 1);
                this.openNeighbors(n + 1, n2 - 1);
                this.openNeighbors(n - 1, n2);
                this.openNeighbors(n + 1, n2);
                this.openNeighbors(n - 1, n2 + 1);
                this.openNeighbors(n, n2 + 1);
                this.openNeighbors(n + 1, n2 + 1);
            } else if (this.block[n][n2].getState() > 3 && this.block[n][n2].isClosed()) {
                this.block[n][n2].open();
                --this.openCount;
            }
        }
    }
}

