/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;

public class StreamTool {
    private DataInputStream dis = null;
    private InputStream is = null;

    public String[] loadLangUnicode(String name, int numLines) {
        this.is = this.getClass().getResourceAsStream("/txt/" + name);
        this.dis = new DataInputStream(this.is);
        String[] lang = new String[numLines];
        try {
            for (int i = 0; i < numLines; ++i) {
                lang[i] = this.dis.readUTF();
            }
            this.dis.close();
            this.is.close();
        }
        catch (IOException ioe) {
            System.out.println(lang.length);
            ioe.printStackTrace();
        }
        return lang;
    }

    public short[][] loadShort(String name, int line, int col) {
        this.is = this.getClass().getResourceAsStream("/map/" + name);
        this.dis = new DataInputStream(this.is);
        short[][] res = new short[line][col];
        for (int i = 0; i < line; ++i) {
            for (int j = 0; j < col; ++j) {
                try {
                    res[i][j] = this.dis.readShort();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("map data error");
                }
            }
        }
        return res;
    }

    public byte[][] loadByte(String name, int line, int col) {
        this.is = this.getClass().getResourceAsStream("/map/" + name);
        this.dis = new DataInputStream(this.is);
        byte[][] res = new byte[line][col];
        for (int i = 0; i < line; ++i) {
            for (int j = 0; j < col; ++j) {
                try {
                    res[i][j] = this.dis.readByte();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("map data error");
                }
            }
        }
        return res;
    }

    public byte[] loadByte(String name, int number) {
        this.is = this.getClass().getResourceAsStream("/map/" + name);
        this.dis = new DataInputStream(this.is);
        byte[] res = new byte[number];
        for (int i = 0; i < number; ++i) {
            try {
                res[i] = this.dis.readByte();
                continue;
            }
            catch (IOException e) {
                System.out.println("map data error");
            }
        }
        return res;
    }

    public void SaveGame() {
        try {
            RecordStore record = RecordStore.openRecordStore((String)"AdoreChess", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(Constant.active_mission);
            for (int i = 0; i < 5; ++i) {
                dos.writeInt(Constant.score_game[i]);
            }
            byte[] saveGame = baos.toByteArray();
            if (record.getNumRecords() == 0) {
                record.addRecord(saveGame, 0, saveGame.length);
            } else {
                record.setRecord(1, saveGame, 0, saveGame.length);
            }
            dos.close();
            baos.close();
            record.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("save store error");
        }
    }

    public int LoadGame() {
        try {
            RecordStore record = RecordStore.openRecordStore((String)"AdoreChess", (boolean)false);
            if (record.getNumRecords() == 0) {
                record.closeRecordStore();
                return 0;
            }
            byte[] loadGame = record.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(loadGame);
            this.dis = new DataInputStream(bais);
            Constant.active_mission = this.dis.readByte();
            for (int i = 0; i < 5; ++i) {
                Constant.score_game[i] = this.dis.readInt();
            }
            this.dis.close();
            bais.close();
            record.closeRecordStore();
            return 1;
        }
        catch (Exception e) {
            System.out.println("loadgame error");
            return 0;
        }
    }
}

