/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextTool {
    private int draw_x = 0;
    private int draw_y = 0;
    private int draw_width = 0;
    public static int page_showID = 0;
    private int page_maxline = 0;
    private int page_showline = 0;
    private boolean is_sequence = false;
    private boolean is_up_sequence = false;
    private String[] string = null;
    public static final byte TEXT_LEFT = 0;
    public static final byte TEXT_RIGHT = 1;
    public static final byte TEXT_CENTER = 2;
    private int char_width = 0;
    private int char_height = 0;
    private int char_space = 0;
    private int char_lineheight = 0;
    private Font font = null;
    private Vector vector = null;
    private StringBuffer buffer = null;
    private final char sign = (char)42;
    public static boolean is_page = false;

    public TextTool(Font ft) {
        this.font = ft == null ? Font.getFont((int)0, (int)0, (int)8) : ft;
        this.char_height = this.font.getHeight();
        this.char_width = this.font.charWidth('\u811a');
        this.char_space = this.char_width >> 1;
        this.char_lineheight = this.char_height >> 1;
    }

    public TextTool() {
        this(Font.getFont((int)0, (int)0, (int)8));
    }

    public void setFont(Graphics g) {
        g.setFont(this.font);
    }

    public int getCharWidth(char character) {
        return this.font.charWidth(character);
    }

    public int getCharWidth() {
        return this.char_width;
    }

    public int getCharHeight() {
        return this.char_height;
    }

    public int stringWidth(String str) {
        return this.font.stringWidth(str);
    }

    public int getCharSpace() {
        return this.char_space;
    }

    public int getCharDistance() {
        return this.char_lineheight + this.char_height;
    }

    public int getLineSpace() {
        return this.char_lineheight;
    }

    public void setSpace(int width, int height) {
        this.char_width = width;
        this.char_lineheight = height;
    }

    public int getShowLine(int height) {
        return height / (this.char_height + this.char_lineheight);
    }

    public String[] spliteString(String string) {
        int number = 0;
        char[] content = string.toCharArray();
        this.buffer = new StringBuffer();
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != '*') continue;
            ++number;
        }
        String[] dis_string = new String[number];
        number = 0;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] == '*') {
                dis_string[number] = this.buffer.toString();
                this.buffer.delete(0, this.buffer.length());
                ++number;
                continue;
            }
            this.buffer.append(content[i]);
        }
        this.buffer = null;
        content = null;
        System.gc();
        return dis_string;
    }

    public String[] spliteString(String str, int width) {
        int beginID = 0;
        int endID = 0;
        int lineWidth = 0;
        int strlen = str.length();
        boolean is_endline = false;
        this.vector = new Vector();
        for (int i = 0; i < strlen; ++i) {
            is_endline = false;
            if (i == strlen - 1 && str.charAt(i) != '*') {
                endID = i + 1;
                is_endline = true;
            } else if (str.charAt(i) == '*') {
                endID = i;
                is_endline = true;
            } else {
                lineWidth = this.font.substringWidth(str, beginID, i - beginID + 1);
                if (lineWidth >= width) {
                    endID = i;
                    is_endline = true;
                }
            }
            if (!is_endline) continue;
            this.vector.addElement(str.substring(beginID, endID));
            beginID = endID < strlen && str.charAt(endID) == '*' ? endID + 1 : endID;
        }
        Object[] dis_string = new String[this.vector.size()];
        this.vector.copyInto(dis_string);
        this.vector = null;
        System.gc();
        return dis_string;
    }

    public void initText(String str, int x, int y, int width, int line, boolean is_symbol) {
        this.draw_x = x;
        this.draw_y = y;
        this.draw_width = width;
        this.string = is_symbol ? this.spliteString(str) : this.spliteString(str, this.draw_width);
        page_showID = 0;
        this.page_maxline = this.string.length;
        this.page_showline = line >= this.string.length ? this.string.length : line;
        System.gc();
    }

    public void drawText(Graphics g, int anchor) {
        GraphicsTool.restClip(g);
        block5: for (int i = 0; i < this.page_showline; ++i) {
            if (page_showID + i >= this.page_maxline) continue;
            switch (anchor) {
                case 0: {
                    g.drawString(this.string[page_showID + i], this.draw_x, this.draw_y + (this.char_lineheight + this.char_height) * i, 20);
                    continue block5;
                }
                case 1: {
                    g.drawString(this.string[page_showID + i], this.draw_x + (this.draw_width - this.stringWidth(this.string[page_showID + i])), this.draw_y + (this.char_lineheight + this.char_height) * i, 20);
                    continue block5;
                }
                case 2: {
                    g.drawString(this.string[page_showID + i], this.draw_x + (this.draw_width - this.stringWidth(this.string[page_showID + i]) >> 1), this.draw_y + (this.char_lineheight + this.char_height) * i, 20);
                }
            }
        }
        if (this.is_sequence) {
            if (this.is_up_sequence) {
                this.keyPageUp(true);
            } else {
                this.keyPageDown(true);
            }
        }
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor) {
        if ((anchor & 8) == 8) {
            x -= this.stringWidth(str);
        } else if ((anchor & 1) == 1) {
            x -= this.stringWidth(str) >> 1;
        }
        if ((anchor & 0x20) == 32) {
            y -= this.char_height;
        } else if ((anchor & 2) == 2) {
            y -= this.char_height >> 1;
        }
        g.setClip(0, y, 240, this.char_height << 1);
        g.drawString(str, x, y, 20);
    }

    public void drawOutlineString(Graphics g, String str, int fontcolor, int bkcolor, int x, int y, int anchor) {
        if ((anchor & 8) == 8) {
            x -= this.stringWidth(str);
        } else if ((anchor & 1) == 1) {
            x -= this.stringWidth(str) >> 1;
        }
        if ((anchor & 0x20) == 32) {
            y -= this.char_height;
        } else if ((anchor & 2) == 2) {
            y -= this.char_height >> 1;
        }
        g.setClip(0, y - 2, 240, this.char_height << 1);
        g.setColor(bkcolor);
        g.drawString(str, x + 1, y, 20);
        g.drawString(str, x - 1, y, 20);
        g.drawString(str, x, y + 1, 20);
        g.drawString(str, x, y - 1, 20);
        g.setColor(fontcolor);
        g.drawString(str, x, y, 20);
    }

    public void drawTip(Graphics g, int x, int y, int distance) {
        if (this.page_showline >= this.page_maxline) {
            return;
        }
        if (distance == 0) {
            if (page_showID <= 0) {
                g.drawString(">>", x + 120 - 20, y, 17);
            } else if (page_showID + this.page_showline >= this.page_maxline) {
                g.drawString("<<", x - 120 + 20, y, 17);
            } else {
                g.drawString(">>", x + 120 - 20, y, 17);
                g.drawString("<<", x - 120 + 20, y, 17);
            }
        } else if (page_showID <= 0) {
            MainCanvas.drawPointer(g, x, y, 0, false, true, false, false);
        } else if (page_showID + this.page_showline >= this.page_maxline) {
            MainCanvas.drawPointer(g, x, y, 0, true, false, false, false);
        } else {
            MainCanvas.drawPointer(g, x, y, 4, true, true, false, false);
        }
    }

    public void keyPageUp(boolean sequence) {
        if (page_showID > 0) {
            --page_showID;
        }
        this.is_sequence = sequence;
        this.is_up_sequence = true;
    }

    public void keyPageDown(boolean sequence) {
        if (page_showID + this.page_showline < this.page_maxline) {
            ++page_showID;
        }
        this.is_sequence = sequence;
        this.is_up_sequence = false;
    }

    public void keyPageRelease() {
        this.is_sequence = false;
    }

    public boolean PageEnd() {
        return page_showID + this.page_showline >= this.page_maxline;
    }

    public void paintsign(String[] bf, int y, int height, int anchor, Graphics g, boolean kind) {
        int showline = this.getShowLine(height);
        this.page_maxline = bf.length;
        this.page_showline = showline >= bf.length ? bf.length : showline;
        g.setClip(0, 0, 240, 320);
        block10: for (int i = 0; i < this.page_showline; ++i) {
            if (page_showID >= this.page_maxline) continue;
            if (kind) {
                switch (anchor) {
                    case 0: {
                        this.drawOutlineString(g, bf[page_showID + i], 0xFFFFFF, 0xFF0000, 248, y + (this.char_lineheight + this.char_height) * i, 20);
                        break;
                    }
                    case 1: {
                        this.drawOutlineString(g, bf[page_showID + i], 0xFFFFFF, 0xFF0000, 240 - this.stringWidth(bf[page_showID + i]), y + (this.char_lineheight + this.char_height) * i, 20);
                        break;
                    }
                    case 2: {
                        this.drawOutlineString(g, bf[page_showID + i], 0xFFFFFF, 0xFF0000, 240 - this.stringWidth(bf[page_showID + i]) >> 1, y + (this.char_lineheight + this.char_height) * i, 20);
                    }
                }
                continue;
            }
            switch (anchor) {
                case 0: {
                    g.drawString(bf[page_showID + i], 248, y + (this.char_lineheight + this.char_height) * i, 20);
                    continue block10;
                }
                case 1: {
                    g.drawString(bf[page_showID + i], 240 - this.stringWidth(bf[page_showID + i]), y + (this.char_lineheight + this.char_height) * i, 20);
                    continue block10;
                }
                case 2: {
                    g.drawString(bf[page_showID + i], 240 - this.stringWidth(bf[page_showID + i]) >> 1, y + (this.char_lineheight + this.char_height) * i, 20);
                }
            }
        }
        if (this.page_showline < this.page_maxline) {
            is_page = true;
            if (page_showID <= 0) {
                MainCanvas.drawPointer(g, 110, y + height - 16, 0, false, true, false, false);
            } else if (page_showID + this.page_showline >= this.page_maxline) {
                MainCanvas.drawPointer(g, 110, y + height - 16, 0, true, false, false, false);
            } else {
                MainCanvas.drawPointer(g, 110, y + height - 16, 0, true, true, false, false);
            }
        } else {
            is_page = false;
        }
    }

    public static void rePage_showID() {
        page_showID = 0;
    }
}

