/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.ui.IFocusable;
import com.jarbull.efw.ui.ScrollBar;
import com.jarbull.efw.util.StringEx;
import javax.microedition.lcdui.Graphics;

public class Label
extends Component
implements IFocusable {
    public static final byte LEFT = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;
    public static final byte TOP = 0;
    public static final byte MIDDLE = 4;
    public static final byte BOTTOM = 8;
    private static final byte MASK_HORIZONTAL = 3;
    private static final byte MASK_VERTICAL = 12;
    private String text;
    private String textKey;
    private String[] words;
    private int textWidth;
    private int textHeight;
    private int[] posX;
    private int[] posY;
    private int alignment;
    private int verticalOffset;
    private int horizontalOffset;
    private int marginBetweenLines;
    private ScrollBar sBar;
    private int sBarWidth;
    private boolean selected;
    private boolean focused;
    private int selectedBorderColor;
    private int selectedBorderSize;
    private boolean automaticShift;
    private boolean scrollBarVisible;
    private int shiftVelocity;
    private int shiftAmount;
    private int paintCount;
    private int totalShiftAmount;

    public Label(String id, String text) {
        super(id);
        if (text == null) {
            throw new NullPointerException();
        }
        if (text.equals("")) {
            throw new IllegalArgumentException();
        }
        this.alignment = 0;
        this.sBarWidth = 0;
        this.setBgColor(0xFFFFFF);
        this.setFgColor(0);
        this.setSelectedBorderColor(0xFF0000);
        this.setText(text, true);
        this.setPosition(0, 0);
    }

    public Label(String id, String text, int shiftVelocity) {
        super(id);
        if (text == null) {
            throw new NullPointerException();
        }
        if (text.equals("")) {
            throw new IllegalArgumentException();
        }
        this.alignment = 0;
        this.sBarWidth = 0;
        this.shiftAmount = 0;
        this.setBgColor(0xFFFFFF);
        this.setFgColor(0);
        this.setSelectedBorderColor(0xFF0000);
        this.setText(text, true);
        this.setPosition(0, 0);
        this.setShiftVelocity(shiftVelocity);
        this.setScrollBarVisibility(false);
    }

    private void initializePositions() {
        int singleSpaceWidth = TextWriter.getInstance().getTextWidth(" ");
        int spaceWidth = TextWriter.getInstance().getTextWidth("  ");
        int newLineWidth = TextWriter.getInstance().getTextWidth(" \n ");
        this.textWidth = TextWriter.getInstance().getTextWidth(this.text);
        this.textHeight = TextWriter.getInstance().getTextHeight(this.text);
        if (this.height < this.textHeight) {
            this.height = this.textHeight;
        }
        if (this.textWidth * this.textHeight > this.width * this.height) {
            this.sBarWidth = 10;
        }
        this.words = StringEx.split(this.text, " ");
        this.posX = new int[this.words.length];
        this.posY = new int[this.words.length];
        int[] lineEndWords = new int[this.words.length];
        for (int i = this.words.length - 1; i >= 0; --i) {
            lineEndWords[i] = -1;
        }
        int lineCount = 1;
        for (int i = 0; i < this.words.length; ++i) {
            if (i == 0) {
                this.posX[i] = this.horizontalOffset;
                this.posY[i] = this.verticalOffset;
                continue;
            }
            this.posX[i] = this.posX[i - 1] + TextWriter.getInstance().getTextWidth(this.words[i - 1]) + singleSpaceWidth;
            this.posY[i] = this.posY[i - 1];
            if (this.posX[i] + TextWriter.getInstance().getTextWidth(this.words[i]) <= this.width - this.sBarWidth && !this.words[i].equals("\n")) continue;
            this.posX[i] = this.horizontalOffset;
            if (this.words[i].equals("\n")) {
                int n = i;
                this.posX[n] = this.posX[n] - newLineWidth;
            }
            lineEndWords[lineCount - 1] = i - 1;
            ++lineCount;
            this.posY[i] = this.posY[i - 1] + this.textHeight + this.marginBetweenLines;
        }
        lineEndWords[lineCount - 1] = this.words.length - 1;
        int shiftValue = 0;
        if ((this.alignment & 3) == 2 || (this.alignment & 3) == 1) {
            for (int i = lineCount - 1; i >= 0; --i) {
                if (lineEndWords[i] == -1) continue;
                if ((this.alignment & 3) == 2) {
                    shiftValue = this.width - (this.posX[lineEndWords[i]] + TextWriter.getInstance().getTextWidth(this.words[lineEndWords[i]])) - this.sBarWidth;
                } else {
                    int space = 0;
                    if (this.words.length != 1) {
                        space = singleSpaceWidth;
                    }
                    shiftValue = (this.width + space - (this.posX[lineEndWords[i]] + TextWriter.getInstance().getTextWidth(this.words[lineEndWords[i]]))) / 2 - this.sBarWidth;
                }
                int n = lineEndWords[i];
                this.posX[n] = this.posX[n] + shiftValue;
                int wordId = lineEndWords[i] - 1;
                if (i != 0) {
                    while (wordId != lineEndWords[i - 1]) {
                        int n2 = wordId--;
                        this.posX[n2] = this.posX[n2] + shiftValue;
                    }
                    continue;
                }
                int j = lineEndWords[0] - 1;
                while (j >= 0) {
                    int n3 = j--;
                    this.posX[n3] = this.posX[n3] + shiftValue;
                }
            }
        }
        if (this.posY[this.words.length - 1] + this.textHeight > this.height & this.height != 0) {
            this.sBar = new ScrollBar("scroll");
            if (!this.scrollBarVisible) {
                this.sBar.setVisible(false);
            }
            if (this.shiftVelocity == 0) {
                this.sBar.setVisible(true);
            }
            this.sBar.setSize(this.sBarWidth, this.height);
            this.sBar.setPosition(this.width - this.sBar.width, 0);
            this.sBar.setBgColor(0xEDEDED);
            this.sBar.setFgColor(0xBEBEBE);
            this.sBar.setFgTransColor(0xC8C8C8);
            int linesSitInToLabel = this.height / (this.textHeight + this.marginBetweenLines);
            this.sBar.setMaxValue(lineCount - linesSitInToLabel + 1);
        } else {
            this.sBar = null;
            switch (this.alignment & 0xC) {
                case 4: {
                    int offset = (this.height - lineCount * (this.textHeight + this.marginBetweenLines)) / 2;
                    int i = 0;
                    while (i < this.posY.length) {
                        int n = i++;
                        this.posY[n] = this.posY[n] + offset;
                    }
                    break;
                }
                case 8: {
                    int offset = this.height - lineCount * (this.textHeight + this.marginBetweenLines);
                    int i = 0;
                    while (i < this.posY.length) {
                        int n = i++;
                        this.posY[n] = this.posY[n] + offset;
                    }
                    break;
                }
            }
        }
    }

    void paintString(Graphics g) {
        for (int i = 0; i < this.words.length; ++i) {
            if (this.words[i].equals("\n")) continue;
            TextWriter.getInstance().drawText(g, this.words[i], this.posX[i], this.posY[i]);
        }
    }

    public int getShiftVelocity() {
        return this.shiftVelocity;
    }

    public void setShiftVelocity(int shiftVelocity) {
        this.shiftVelocity = shiftVelocity;
        if (this.posY == null) {
            return;
        }
        if (shiftVelocity > this.posY[this.words.length - 1] + TextWriter.getInstance().getTextHeight(this.words[0])) {
            this.shiftVelocity = this.posY[this.words.length - 1] + TextWriter.getInstance().getTextHeight(this.words[0]);
        }
        if (shiftVelocity != 0) {
            this.setAutomaticShift(true);
        }
    }

    public void paint(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        g.translate(this.x, this.y);
        this.saveClip(g);
        if (this.sBar != null && this.sBar.visible) {
            this.sBar.paint(g);
        }
        if (this.automaticShift && !this.selected && this.sBar != null) {
            ++this.paintCount;
            if (this.paintCount % 5 == 0) {
                this.shiftDown(true);
            }
        }
        if (this.clipRegionActivated) {
            g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
        }
        if (this.textWidth > this.width && this.height != 0 && this.width != 0) {
            if (this.sBar != null && this.sBar.visible) {
                if (this.clipRegionActivated) {
                    g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
                } else {
                    g.setClip(0, 0, this.width - this.sBarWidth + 1, this.height);
                }
            } else if (this.clipRegionActivated) {
                g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
            } else {
                g.setClip(0, 0, this.width, this.height);
            }
        }
        if (this.bg != null) {
            this.bg.paint(g);
        } else if (this.bgColor != -1) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.width, this.height);
        }
        if (this.fg != null) {
            this.fg.paint(g);
        } else {
            g.setColor(this.fgColor);
            this.paintString(g);
        }
        if (this.focused) {
            g.setStrokeStyle(1);
        }
        if (this.selected) {
            if (this.selectedBorderSize > 0) {
                g.setColor(this.selectedBorderColor);
                for (int i = 0; i < this.selectedBorderSize; ++i) {
                    g.drawRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1);
                }
            }
        } else if (this.borderSize > 0) {
            g.setColor(this.borderColor);
            for (int i = 0; i < this.borderSize; ++i) {
                g.drawRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1);
            }
        }
        this.restoreClip(g);
        g.translate(-this.x, -this.y);
    }

    public int getMarginBetweenLines() {
        return this.marginBetweenLines;
    }

    public void setMarginBetweenLines(int marginBetweenLines) {
        this.marginBetweenLines = marginBetweenLines;
    }

    public boolean isAutomaticShiftOn() {
        return this.automaticShift;
    }

    public void setAutomaticShift(boolean automaticShift) {
        this.automaticShift = automaticShift;
    }

    public void setScrollBarVisibility(boolean visible) {
        this.scrollBarVisible = visible;
        if (this.sBar != null) {
            this.sBar.setVisible(visible);
        }
    }

    public boolean getScrollBarVisibility() {
        return this.scrollBarVisible;
    }

    private void shiftToTop() {
        if (this.sBar != null) {
            int i = this.words.length - 1;
            while (i >= 0) {
                int n = i--;
                this.posY[n] = this.posY[n] + this.totalShiftAmount;
            }
            this.sBar.setValue(0);
            this.shiftAmount = 0;
            this.totalShiftAmount = 0;
        }
    }

    protected boolean shiftDown(boolean automaticCall) {
        if (this.sBar != null) {
            if (this.sBar.getValue() < this.sBar.getMaxValue() - 1) {
                if (automaticCall) {
                    this.shiftAmount += this.getShiftVelocity();
                }
                if (this.getShiftVelocity() == 0 || this.getShiftVelocity() == TextWriter.getInstance().getTextHeight(this.words[0]) || !automaticCall) {
                    this.sBar.setValue(this.sBar.getValue() + 1);
                } else if (this.shiftAmount >= TextWriter.getInstance().getTextHeight(this.words[0])) {
                    this.sBar.setValue(this.sBar.getValue() + 1);
                    this.shiftAmount = 0;
                }
                if (automaticCall && (this.sBar.getValue() == this.sBar.getMaxValue() - 1 || this.posY[this.words.length - 1] + TextWriter.getInstance().getTextHeight(this.words[this.words.length - 1]) <= this.y)) {
                    this.shiftToTop();
                    return true;
                }
                this.totalShiftAmount += this.getShiftVelocity();
                for (int i = this.words.length - 1; i >= 0; --i) {
                    this.posY[i] = this.getShiftVelocity() == 0 || !automaticCall ? this.posY[i] - TextWriter.getInstance().getTextHeight(this.words[i]) : this.posY[i] - this.getShiftVelocity();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean shiftUp(boolean automaticCall) {
        if (this.sBar != null) {
            if (this.sBar.getValue() > 0) {
                for (int i = this.words.length - 1; i >= 0; --i) {
                    this.posY[i] = this.getShiftVelocity() == 0 || !automaticCall ? this.posY[i] + TextWriter.getInstance().getTextHeight(this.words[i]) : this.posY[i] + this.getShiftVelocity();
                }
                this.shiftAmount -= TextWriter.getInstance().getTextHeight(this.words[0]);
                if (this.shiftAmount < 0) {
                    this.shiftAmount = 0;
                }
                if (this.getShiftVelocity() == 0 || this.getShiftVelocity() == TextWriter.getInstance().getTextHeight(this.words[0]) || !automaticCall) {
                    this.sBar.setValue(this.sBar.getValue() - 1);
                } else if (this.shiftAmount >= TextWriter.getInstance().getTextHeight(this.words[0])) {
                    this.sBar.setValue(this.sBar.getValue() - 1);
                    this.shiftAmount = 0;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalSpace) {
        this.horizontalOffset = horizontalSpace;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public void setVerticalOffset(int verticalSpace) {
        this.verticalOffset = verticalSpace;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.initializePositions();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (TextWriter.getInstance().getTextWidth(text) >= this.width && TextWriter.getInstance().getTextWidth(text) < ResolutionHandler.getInstance().getScreenWidth()) {
            this.setSize(TextWriter.getInstance().getTextWidth(text) + 4, this.height);
        }
        this.initializePositions();
    }

    public void setText(String text, boolean localizationSupport) {
        if (localizationSupport) {
            this.textKey = text;
            text = LocalizationSupport.getMessage(this.textKey);
        }
        this.setText(text);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.initializePositions();
    }

    public void setBg(EFLiteSprite bg) {
        super.setBg(bg);
        this.initializePositions();
    }

    public int getSelectedBorderColor() {
        return this.selectedBorderColor;
    }

    public void setSelectedBorderColor(int selectedBorderColor) {
        this.selectedBorderColor = selectedBorderColor;
    }

    public int getSelectedBorderSize() {
        return this.selectedBorderSize;
    }

    public void setSelectedBorderSize(int selectedBorderSize) {
        this.selectedBorderSize = selectedBorderSize;
    }

    public final void keyPressed(int keyCode) {
        switch (keyCode) {
            case 202: 
            case 221: {
                if (this.shiftUp(false)) break;
                this.setFocused(false);
                break;
            }
            case 208: 
            case 222: {
                if (this.shiftDown(false)) break;
                this.setFocused(false);
                break;
            }
            case 205: 
            case 225: {
                this.setFocused(false);
            }
        }
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
        if (focused && this.selected && this.actionListener != null) {
            this.actionListener.actionPerformed();
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setSelected(boolean selected) {
        if (this.sBar != null) {
            if (this.actionListener != null) {
                if (selected) {
                    this.actionListener.onSelected();
                } else {
                    this.actionListener.onDeselected();
                }
            }
            this.selected = selected;
            if (this.isAutomaticShiftOn()) {
                this.setScrollBarVisibility(selected);
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getTextKey() {
        return this.textKey;
    }
}

