package logo;

import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import javax.microedition.media.*;
import javax.microedition.media.control.VolumeControl;
import legend.MyCanvas;

public class splashCanvas
    extends Canvas
    implements Runnable {
  int screenWidth, screenHeight;
  int deviceScreenWidth,deviceScreenHeight;

  MIDlet theMidlet;
  Displayable backCanvas;
  public static boolean enableSoundEffect = false;

  public static boolean showLogoEffect = true;
  public static boolean showGameLogo = true;
  public static boolean showSoundAsk = true;
  Image gamelogo,soundask;
  public splashCanvas(MIDlet midlet, Displayable d) {
    setFullScreenMode(true);
    theMidlet = midlet;
    backCanvas = d;

    deviceScreenWidth = getWidth();
    deviceScreenHeight = getHeight();

    screenWidth = 240;//getWidth();
    screenHeight = 320;//getHeight();
    init();
    initSound();
    Display.getDisplay(theMidlet).setCurrent(this);
    sendThread = new Thread(this);
    sendThread.start();
  }

  int leftKey = -6;
  int rightKey = -7;
  public void keyPressed(int keyCode){
    if (showSoundAsk) {
      if (keyCode == leftKey){
        enableSoundEffect = true;
        showLogoEffect = true;
        showSoundAsk = false;
//        Device.setMusicEnabled(enableSoundEffect);
      }
      else if (keyCode == rightKey){
        enableSoundEffect = false;
        showLogoEffect = true;
        showSoundAsk = false;
//        Device.setMusicEnabled(enableSoundEffect);
      }
    }
  }
  public void keyReleased(int keyCode){

  }

  public void paint(Graphics g) {

   //
//   g.setClip(0, 0, deviceScreenWidth, deviceScreenHeight);
//   g.setColor(0);
//   g.fillRect(0, 0, deviceScreenWidth, deviceScreenHeight);
//   g.translate((deviceScreenWidth - screenWidth)/2 ,
//               (deviceScreenHeight - screenHeight)/2);
   g.setClip(0,0,screenWidth,screenHeight);


    if(showGameLogo){
      g.setColor(0);
      g.fillRect(0,0,screenWidth,screenHeight);
      g.drawImage(gamelogo,screenWidth/2,screenHeight/2,3);
      return;
    }
    else if(showSoundAsk){
      g.setColor(0);
      g.fillRect(0,0,screenWidth,screenHeight);
      g.drawImage(gamelogo,screenWidth/2,screenHeight/2,3);
      g.drawImage(soundask,0,screenHeight,Graphics.BOTTOM|Graphics.LEFT);
      return;
    }


    if (this.showLogoEffect) {
      this.drawLogo(g);
      return;
    }
    else{
      g.setColor(0);
      g.fillRect(0,0,g.getClipWidth(),g.getClipHeight());
    }

//    g.translate((screenWidth - deviceScreenWidth)/2 ,
//               (screenHeight - deviceScreenHeight)/2);

  }

  private volatile Thread sendThread;
  synchronized public void StopThread() {
    if (sendThread != null)
      sendThread = null;
  }

  long lastTime = 0;
  public static int sleeptime = 40;
  public void run() {
    try {

      if(showGameLogo){
//        Display.getDisplay(theMidlet).setCurrent(this);
        repaint();
        serviceRepaints();
        Thread.sleep(2000);
        showGameLogo = false;
      }
      while(showSoundAsk){
        repaint();
        serviceRepaints();
        Thread.sleep(200);
        continue;
      }

      while (showLogoEffect) {
        if (index == 0) {
          this.playSound();
       }

        repaint();
        serviceRepaints();
        Thread.sleep(logoInfo[index][6]);
        index++;

        if (lastTime == 0)
          lastTime = System.currentTimeMillis();
        else {
          long waitTime = System.currentTimeMillis() - lastTime;
          if (waitTime < sleeptime)
            Thread.sleep(sleeptime - waitTime);
          lastTime = System.currentTimeMillis();
        }

        if (index >= logoInfo.length) ///index = 0;
          showLogoEffect = false;
        continue;
      }
    }
    catch (Exception ex) {
    }
    finally {
      StopThread();
      if(backCanvas != null){
        Display.getDisplay(theMidlet).setCurrent(backCanvas);
        if(enableSoundEffect) {
          MyCanvas.inputSound(MyCanvas.KEY_LEFT_BUTTON);
        }else {
          MyCanvas.inputSound(MyCanvas.KEY_RIGHT_BUTTON);
        }
        clear();
      }
    }
  }

  Image transImg1 = null;
  Image transImg2 = null;
  public void init() {
    try {
      gamelogo = Image.createImage("/logo/gameLogo.png");
      soundask = Image.createImage("/logo/soundAsk.png");
      bg = Image.createImage("/logo/bg.png");
      logo = new Image[6];
      for (int i = 0; i < 6; i++)
        logo[i] = Image.createImage("/logo/logo" + i + ".png");
      transImg1 = Image.createImage("/logo/logo51.png");
      transImg2 = Image.createImage("/logo/logo52.png");

    }
    catch (Exception e) {
      System.out.println("there is a error when init");
    }
  }

  Player play;
  public void initSound(){
    try{
      play = Manager.createPlayer(theMidlet.getClass().getResourceAsStream("/logo/sound1.mid"),"audio/midi");
      play.realize();
      VolumeControl vc = (VolumeControl) play.getControl(
          "VolumeControl");
      if (vc != null) {
        vc.setLevel(60);
      }
//      play.prefetch();
//      play.start();
    }catch(Exception ex){}
  }
  public void playSound(){
    try{
      if(enableSoundEffect){
        if (play != null)
          play.start();
      }else {
        play.close();
        play = null;
      }
    }catch(Exception e){}
  }

  public void clear() {
    gamelogo = null;
    soundask = null;
    bg = null;
    logo = null;
    transImg1 = null;
    transImg2 = null;
    play = null;
  }

  Image bg = null;
  Image[] logo;

  public static int index = 0;

  int[] widoff = {
      35+32, 88+32, 140+32};
  int[] heioff0 = {
      16, 14, 5, 1, -3, -2, 2};
  int[] heioff2 = {
      16, 12, 2, -8, -12};
  int[] heioff1 = {
      18, 15, -2, 0};
  int hei5 = 72;
  int[][] logoInfo = {
      {
      2, heioff0[6], 0, heioff0[6], 1, heioff0[6], 500}
      , { //ȫʾ1Ļ
      2, heioff0[2], 0, heioff0[2], 1, heioff0[2], sleeptime}
      , { //1Ļʼ
      2, heioff0[1], 0, heioff0[1], 1, heioff0[1], sleeptime}
      , {
      2, heioff0[0], 0, heioff0[0], 1, heioff0[0], sleeptime, 2}
      ,

      {
      -1, heioff1[0], -1, heioff1[0], -1, heioff1[0], sleeptime}
      , { //2Ļʼ
      -1, heioff1[0], 5, heioff1[0], -1, heioff1[0], sleeptime}
      , {
      -1, heioff1[0], 5, heioff1[1], -1, heioff1[0], sleeptime}
      , {
      -1, heioff1[0], 5, heioff1[2], -1, heioff1[0], sleeptime}
      , {
      -1, heioff1[0], 5, heioff1[3], -1, heioff1[0], sleeptime}
      , {
      -1, heioff1[0], 5, heioff1[0], -1, heioff1[0], sleeptime}
      , {
      -1, heioff1[0], 5, heioff1[1], 5, heioff1[0], sleeptime, 1}
      , {
      -1, heioff1[0], 5, heioff1[2], 5, heioff1[1], sleeptime}
      , {
      5, heioff1[0], 5, heioff1[3], 5, heioff1[2], sleeptime}
      , {
      5, heioff1[1], 5, heioff1[0], 5, heioff1[3], sleeptime}
//      , { //repeat
//      5, heioff1[2], 5, heioff1[1], 5, heioff1[0], sleeptime}
//      , {
//      5, heioff1[3], 5, heioff1[2], 5, heioff1[1], sleeptime}
//      , {
//      5, heioff1[0], 5, heioff1[3], 5, heioff1[2], sleeptime}
//      ,
//
//      {
//      5, heioff1[1], 5, heioff1[0], 5, heioff1[3], sleeptime}

//      , { //repeat
//      5, heioff1[2], 5, heioff1[1], 5, heioff1[0], sleeptime}
//      , {
//      5, heioff1[3], 5, heioff1[2], 5, heioff1[1], sleeptime}
//      , {
//      5, heioff1[0], 5, heioff1[3], 5, heioff1[2], sleeptime}
//      , {
//      5, heioff1[1], 5, heioff1[0], 5, heioff1[3], sleeptime}
      , { //repeat
      5, heioff1[2], 5, heioff1[1], 5, heioff1[0], sleeptime}
      , {
      5, heioff1[3], 5, heioff1[2], 5, heioff1[1], sleeptime}
      , {
      5, heioff1[0], 5, heioff1[3], 5, heioff1[2], sleeptime}
      , {
      5, heioff1[1], 5, heioff1[0], 5, heioff1[3], sleeptime}

       //show cmcc
      , {
      5, heioff1[2], 2, heioff0[0], 5, heioff1[0], sleeptime}
      , {
      5, heioff1[3], 2, heioff0[1], 5, heioff1[1], sleeptime}
      , {
      5, heioff1[0], 2, heioff0[2], 5, heioff1[2], sleeptime}
      , {
      5, heioff1[1], 2, heioff0[3], 5, heioff1[3], sleeptime}
      , {
      5, heioff1[2], 2, heioff0[4], 5, heioff1[0], sleeptime}
      , {
      5, heioff1[3], 2, heioff0[5], 5, heioff1[1], sleeptime}
//      , {
//      5, heioff1[0], 2, heioff0[6], 5, heioff1[2], sleeptime}
//      , {
//      5, heioff1[1], 2, heioff0[6], 5, heioff1[3], sleeptime}
//      , {
//      5, heioff1[2], 2, heioff0[6], 5, heioff1[0], sleeptime}
//      , {
//      5, heioff1[3], 2, heioff0[6], 5, heioff1[1], sleeptime}

//      , {
//      5, heioff1[0], 2, heioff0[6], 5, heioff1[2], sleeptime}
//      , {
//      5, heioff1[1], 2, heioff0[6], 5, heioff1[3], sleeptime}

      //show cp
      , {
      3, heioff0[0], 2, heioff0[6], 5, heioff1[2], sleeptime}
      , {
      3, heioff0[1], 2, heioff0[6], 5, heioff1[3], sleeptime}
      , {
      3, heioff0[2], 2, heioff0[6], 5, heioff1[0], sleeptime}
      , {
      3, heioff0[3], 2, heioff0[6], 5, heioff1[1], sleeptime}
      , {
      3, heioff0[4], 2, heioff0[6], 5, heioff1[2], sleeptime}
      , {
      3, heioff0[5], 2, heioff0[6], 5, heioff1[3], sleeptime}
      , {
//      3, heioff0[6], 2, heioff0[6], 5, heioff1[0], sleeptime}
//      , {
//      3, heioff0[6], 2, heioff0[6], 5, heioff1[1], sleeptime}
//      , {
//      3, heioff0[6], 2, heioff0[6], 5, heioff1[2], sleeptime}
//      , {
//      3, heioff0[6], 2, heioff0[6], 5, heioff1[3], sleeptime}
//      , {

      //show sp
      4, heioff0[0], 2, heioff0[6], 3, heioff0[6], sleeptime}
      , {
      4, heioff0[1], 2, heioff0[6], 3, heioff0[6], sleeptime}
      , {
      4, heioff0[2], 2, heioff0[6], 3, heioff0[6], sleeptime}

      , {
      4, heioff0[6], 2, heioff0[6], 3, heioff0[6], 1000}
//      , {
//      4, heioff0[3], 2, heioff0[6], 3, heioff0[6], sleeptime}
//      , {
//      4, heioff0[4], 2, heioff0[6], 3, heioff0[6], sleeptime}
//      , {
//      4, heioff0[5], 2, heioff0[6], 3, heioff0[6], sleeptime}
//      , {
//      4, heioff0[6], 2, heioff0[6], 3, heioff0[6], 1000}

  };

  public void drawLogo(Graphics g) {

    g.setClip(0, 0, g.getClipWidth(),g.getClipHeight());
    g.setColor(0xffffff);
    g.fillRect(0, 0, g.getClipWidth(),g.getClipHeight());
    g.drawImage(bg, 0, 0, 0);
    for (int i = 0; i < 3; i++)
      if (logoInfo[index][i * 2] != -1) {
        int www = widoff[i];
        if (logoInfo[index][i * 2] == 3)
          www = widoff[0];
        else if (logoInfo[index][i * 2] == 4)
          www = widoff[2];
        if (logoInfo[index][i * 2] == 5) {

          int jiaozhengx[] = {
              0, -1, -1};
          if (logoInfo[index][i * 2 + 1] == heioff1[0])
            g.drawImage(transImg1, www + jiaozhengx[i], 73+56, g.HCENTER | g.TOP);
          else if (logoInfo[index][i * 2 + 1] == heioff1[1])
            g.drawImage(logo[logoInfo[index][i * 2]], www, 100+56, 3);
          else if (logoInfo[index][i * 2 + 1] == heioff1[2])
            g.drawImage(transImg2, www + jiaozhengx[i], 72+56, g.HCENTER | g.TOP);
        }
        else
          g.drawImage(logo[logoInfo[index][i * 2]], www,
                      logoInfo[index][i * 2 + 1] + 100+56, 3);
      }
  }

}
